/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import myUtilities.SwingAppender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import view.About;
import view.Acknowledgments;

public abstract class TemplateView
extends JFrame {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger((String)"LogHandler");
    SwingAppender logAppender = null;
    protected JTextPane textPane = null;
    protected JPanel panel;

    public TemplateView(String title) {
        super(title);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        try {
            BasicConfigurator.configure();
        }
        catch (Exception Ex) {
            logger.fatal((Object)Ex.getMessage());
        }
        this.configureUI();
        this.setJMenuBar(this.buildMenuBar());
        this.setContentPane(this.buildContentPane());
        this.locateOnScreen(this);
    }

    private void locateOnScreen(Frame frame) {
        Dimension screenSize = frame.getToolkit().getScreenSize();
        frame.setSize(screenSize);
    }

    private JComponent buildContentPane() {
        this.panel = new JPanel(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setAutoscrolls(true);
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        Dimension dim = new Dimension();
        dim.setSize(2, 140);
        scrollPane.setPreferredSize(dim);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        PropertyConfigurator.configure((URL)classLoader.getResource("log4j.properties"));
        this.logAppender = new SwingAppender();
        this.logAppender.setTextArea(this.textPane);
        this.panel.add((Component)scrollPane, "North");
        this.initialize();
        return this.wrapJComp(this.panel);
    }

    private void configureUI() {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setUseSystemFonts((boolean)true);
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        try {
            UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            System.err.println("Can't set look & feel:" + e);
        }
    }

    private JComponent wrapJComp(JComponent jCompWrapItem) {
        FormLayout layout = new FormLayout("fill:default:grow", "fill:p:grow");
        JPanel panel = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        panel.setBorder(Borders.DIALOG);
        panel.add((Component)jCompWrapItem, cc.xy(1, 1));
        JScrollPane _scrollPaneCenter = new JScrollPane(panel, 20, 30);
        _scrollPaneCenter.setBorder(BorderFactory.createEmptyBorder());
        return _scrollPaneCenter;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.putClientProperty("jgoodies.headerStyle", Boolean.TRUE);
        JMenu menu = new JMenu("Help");
        JMenuItem menuItemAck = new JMenuItem(new AbstractAction("Acknowledgments"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Acknowledgments _ackWindow = new Acknowledgments();
                _ackWindow.setVisible(true);
            }
        });
        JMenuItem menuItem = new JMenuItem(new AbstractAction("About"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                About _aboutWindow = new About();
                _aboutWindow.setVisible(true);
            }
        });
        menu.add(menuItemAck);
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    protected abstract void initialize();
}

