/*
 * Decompiled with CFR 0.152.
 */
package view;

import app.Step1App;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import myObjects.ExpansionParams;
import myObjects.MeasurementData;
import myObjects.eCrystalSystem;
import myObjects.functions.IFunctions;
import myUtilities.BuildLiteraturePanel;
import myUtilities.DynamicPanelBuilder;
import myUtilities.FitUtilities;
import myUtilities.ImportUtilities;
import myUtilities.MathExpansionCoeff;
import myUtilities.ReturnFunctionLists;
import view.CalcOverviewPresentationModel;
import view.TemplateView;

public class Step1
extends TemplateView {
    private static final long serialVersionUID = 1L;
    private int iPageCount;
    private JFileChooser fileChooser;
    private JButton btnNext;
    private JButton btnRestart;
    JPanel _mainPane;
    private JComboBox<eCrystalSystem> crystalList;
    private MeasurementData _data = null;
    private ExpansionParams _expParams = null;
    private JPanel _DataImportCardPanel;
    private JPanel _LiteratureCardPanel;
    private JTabbedPane tabbedPane;
    private JPanel _LiteratureEinsteinCardPanel;
    private JPanel _LiteratureEinstein2TermCardPanel;
    private JPanel _LiteratureDebye2TermCardPanel;
    private JPanel _LiteratureDebyeEinAnCardPanel;
    private JPanel _LiteratureDebyeCardPanel;
    private JPanel _litImportPanel;
    private JTabbedPane tabbedPaneAngles;
    private JPanel _LiteratureAnglePolyCardPanel;
    private JPanel _LiteratureAngleEinsteinPanel;
    private JPanel _literatureAngleCOSPanel;
    private JPanel _literatureAngleSatPanel;
    private JPanel _radioPanel;
    private ButtonGroup _triclinicAngle;
    private JRadioButton _radioBeta;
    private JRadioButton _radioGamma;
    private JPanel _radioPanelData;
    private ButtonGroup _chooseData;
    private JRadioButton _radioImport;
    private JRadioButton _radioLiterature;
    private JPanel _radioPanelTempUnit;
    private ButtonGroup _chooseTempUnit;
    private boolean _isCelsius = true;
    private JRadioButton _radioCelsius;
    private JRadioButton _radioKelvin;
    private static final String sImportMeasurementData = "Import experimental data";
    private static final String sLiteratureValues = "Literature data";

    public Step1(String title) {
        super(title);
    }

    @Override
    protected void initialize() {
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.panel.add(this.buildContentPane1(), "Center");
        this.panel.add((Component)this.buildStatusBar(), "South");
        this.iPageCount = 1;
        this.pack();
    }

    private Component buildContentPane1() {
        this._mainPane = new JPanel(new CardLayout());
        try {
            this.crystalList = new JComboBox();
            this.crystalList.setModel(new DefaultComboBoxModel<eCrystalSystem>(eCrystalSystem.values()));
            this._triclinicAngle = new ButtonGroup();
            this._chooseData = new ButtonGroup();
            this._chooseTempUnit = new ButtonGroup();
            this._radioBeta = new JRadioButton("beta", true);
            this._radioGamma = new JRadioButton("gamma");
            this._triclinicAngle.add(this._radioBeta);
            this._triclinicAngle.add(this._radioGamma);
            this._radioCelsius = new JRadioButton("Celsius", true);
            this._radioKelvin = new JRadioButton("Kelvin");
            this._chooseTempUnit.add(this._radioCelsius);
            this._chooseTempUnit.add(this._radioKelvin);
            this._chooseData = new ButtonGroup();
            this._radioImport = new JRadioButton(sImportMeasurementData, true);
            this._radioLiterature = new JRadioButton(sLiteratureValues);
            this._chooseData.add(this._radioImport);
            this._chooseData.add(this._radioLiterature);
            FormLayout layout = new FormLayout("fill:0:grow(0.25),right:pref, 3dlu, fill:pref:grow,fill:0:grow(0.25),", "p, 3dlu, p, 10dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, fill:p:grow");
            PanelBuilder builder = new PanelBuilder(layout);
            this._triclinicAngle.add(this._radioBeta);
            this._triclinicAngle.add(this._radioGamma);
            CellConstraints cc = new CellConstraints();
            builder.addSeparator("Crystal System:", cc.xyw(2, 1, 3));
            builder.add(this.crystalList, cc.xy(2, 3));
            this._radioPanel = new JPanel();
            this._radioPanel.add(new Label("oblique angle: "));
            this._radioPanel.add(this._radioBeta);
            this._radioPanel.add(this._radioGamma);
            this._radioPanelData = new JPanel();
            this._radioPanelData.add(this._radioImport);
            this._radioPanelData.add(this._radioLiterature);
            this._radioPanelTempUnit = new JPanel();
            this._radioPanelTempUnit.add(this._radioCelsius);
            this._radioPanelTempUnit.add(this._radioKelvin);
            builder.add((Component)this._radioPanel, cc.xyw(3, 3, 2));
            this._radioPanel.setVisible(false);
            builder.addSeparator("Select Data Type", cc.xyw(2, 5, 3));
            builder.add((Component)this._radioPanelData, cc.xyw(2, 7, 3));
            builder.addSeparator("Temperature Unit", cc.xyw(2, 9, 3));
            builder.add((Component)this._radioPanelTempUnit, cc.xyw(2, 11, 3));
            this._litImportPanel = new JPanel();
            this.tabbedPane = new JTabbedPane();
            this._litImportPanel.setLayout(new GridLayout(2, 1));
            this._LiteratureCardPanel = new JPanel(new CardLayout());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.select), eCrystalSystem.select.toString());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.Orthorhombic), eCrystalSystem.Orthorhombic.toString());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.Hexagonal), eCrystalSystem.Hexagonal.toString());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.Rhombohedral), eCrystalSystem.Rhombohedral.toString());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.Tetragonal), eCrystalSystem.Tetragonal.toString());
            this._LiteratureCardPanel.add((Component)this.buildLiteratureChartPanel(eCrystalSystem.Cubic), eCrystalSystem.Cubic.toString());
            this._DataImportCardPanel = new JPanel(new CardLayout());
            this._DataImportCardPanel.add((Component)this.buildFileChooser(), "Import");
            BuildLiteraturePanel _bLP = new BuildLiteraturePanel();
            this._LiteratureEinsteinCardPanel = _bLP.buildEinsteinPanel();
            this._LiteratureEinstein2TermCardPanel = _bLP.buildEinstein2TermPanel();
            this._LiteratureDebyeCardPanel = _bLP.buildDebyePanel();
            this._LiteratureDebye2TermCardPanel = _bLP.buildDebye2TermPanel();
            this._LiteratureDebyeEinAnCardPanel = _bLP.buildDebyeEinAnPanel();
            this.tabbedPane.add((Component)this._LiteratureCardPanel, "Polynomial Fct");
            this.tabbedPane.add((Component)this._LiteratureEinsteinCardPanel, "Einstein Fct");
            this.tabbedPane.add((Component)this._LiteratureDebyeCardPanel, "Debye Fct");
            this.tabbedPane.add((Component)this._LiteratureEinstein2TermCardPanel, "2-Term-Einstein Fct");
            this.tabbedPane.add((Component)this._LiteratureDebye2TermCardPanel, "2-Term-Debye Fct");
            this.tabbedPane.add((Component)this._LiteratureDebyeEinAnCardPanel, "Debye-Einstein-Anharmonic Fct");
            this.tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int i = Step1.this.tabbedPane.getSelectedIndex();
                    if (i == 0) {
                        if (Step1.this.crystalList.getSelectedItem() == eCrystalSystem.Monoclinic) {
                            Step1.this._radioPanel.setVisible(true);
                            Step1.this.tabbedPaneAngles.setVisible(false);
                        } else {
                            Step1.this._radioPanel.setVisible(false);
                            Step1.this.tabbedPaneAngles.setVisible(false);
                        }
                    } else if (Step1.this.crystalList.getSelectedItem() == eCrystalSystem.Monoclinic) {
                        Step1.this._radioPanel.setVisible(true);
                        Step1.this.tabbedPaneAngles.setVisible(true);
                    } else if (Step1.this.crystalList.getSelectedItem() == eCrystalSystem.Triclinic || Step1.this.crystalList.getSelectedItem() == eCrystalSystem.Rhombohedral) {
                        Step1.this._radioPanel.setVisible(false);
                        Step1.this.tabbedPaneAngles.setVisible(true);
                    } else {
                        Step1.this._radioPanel.setVisible(false);
                        Step1.this.tabbedPaneAngles.setVisible(false);
                    }
                }
            });
            this._LiteratureAnglePolyCardPanel = _bLP.buildLiteratureAnglePoly();
            this._LiteratureAngleEinsteinPanel = _bLP.buildEinsteinPanelAngle();
            this._literatureAngleCOSPanel = _bLP.buildCosPanelAngle();
            this._literatureAngleSatPanel = _bLP.buildSatPanelAngle();
            this.tabbedPaneAngles = new JTabbedPane();
            this.tabbedPaneAngles.add((Component)this._LiteratureAnglePolyCardPanel, "Polynomial Fct");
            this.tabbedPaneAngles.add((Component)this._literatureAngleCOSPanel, "Cosinus Fct");
            this.tabbedPaneAngles.add((Component)this._literatureAngleSatPanel, "Saturation Fct");
            this.tabbedPaneAngles.setVisible(false);
            this._litImportPanel.add((Component)this.tabbedPane, "Literature1");
            this._litImportPanel.add((Component)this.tabbedPaneAngles, "LiteratureAngles");
            this._DataImportCardPanel.add((Component)this._litImportPanel, "Literature");
            builder.add((Component)this._DataImportCardPanel, cc.xyw(2, 13, 3));
            this.crystalList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Step1.this.checkCrystalSystem();
                }
            });
            ActionListener sliceActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Step1.this.checkImportType(actionEvent);
                }
            };
            this._radioImport.addActionListener(sliceActionListener);
            this._radioLiterature.addActionListener(sliceActionListener);
            ActionListener checkTempUnitState = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Step1.this.setTempUnit(actionEvent);
                }
            };
            this._radioCelsius.addActionListener(checkTempUnitState);
            this._radioKelvin.addActionListener(checkTempUnitState);
            builder.border(Borders.DLU9);
            this._mainPane.add(builder.getPanel());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return this._mainPane;
    }

    private JComponent buildFileChooser() {
        this.fileChooser = new JFileChooser();
        this.fileChooser.setControlButtonsAreShown(false);
        return this.fileChooser;
    }

    private JComponent buildStatusBar() {
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.add(this.buildButtonBarBarPanel());
        return statusBar;
    }

    private Component buildButtonBarBarPanel() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.btnNext = new JButton("Next");
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Step1.this.btnStep1Clicked(e);
            }
        });
        this.btnRestart = new JButton("Restart");
        this.btnRestart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int reply = JOptionPane.showConfirmDialog(null, "Are you sure you want to restart the Application?", "Restart?", 0);
                if (reply == 0) {
                    Step1.this.dispose();
                    Step1App.main(null);
                }
            }
        });
        builder.addButton((JComponent)this.btnRestart);
        builder.addStrut(new ConstantSize(150, Sizes.getDefaultUnit()));
        builder.addButton((JComponent)this.btnNext);
        return this.wrap(builder.getPanel());
    }

    private JComponent wrap(Component buttonBar) {
        FormLayout layout = new FormLayout("0:grow(0.50), left:0:grow(0.50)", "fill:p:grow");
        JPanel panel = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        panel.setBorder(Borders.DIALOG);
        panel.add(buttonBar, cc.xy(2, 1));
        return panel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void btnStep1Clicked(ActionEvent e) {
        try {
            if (this.iPageCount == 1) {
                ImportUtilities _impUtilities = new ImportUtilities();
                boolean bMeasurementDataImport = true;
                Enumeration<AbstractButton> buttons = this._chooseData.getElements();
                while (buttons.hasMoreElements()) {
                    String _bText;
                    AbstractButton button = buttons.nextElement();
                    if (!button.isSelected() || !(_bText = button.getText()).equals(sLiteratureValues)) continue;
                    bMeasurementDataImport = false;
                }
                boolean bIsBeta = true;
                Enumeration<AbstractButton> buttons2 = this._triclinicAngle.getElements();
                while (buttons2.hasMoreElements()) {
                    String _bText;
                    AbstractButton button = buttons2.nextElement();
                    if (!button.isSelected() || !(_bText = button.getText()).equals("gamma")) continue;
                    bIsBeta = false;
                }
                if (bMeasurementDataImport) {
                    File file = this.fileChooser.getSelectedFile();
                    if (this.crystalList.getSelectedItem() == eCrystalSystem.select) {
                        throw new Exception("Please select crystal system!");
                    }
                    this._data = _impUtilities.importMeasurmentData(file, (eCrystalSystem)((Object)this.crystalList.getSelectedItem()), bIsBeta);
                    if (this._data != null) {
                        this._expParams = new ExpansionParams();
                        this._expParams.setFlag(bIsBeta);
                        this._expParams.setCrystalSystem((eCrystalSystem)((Object)this.crystalList.getSelectedItem()));
                        this.panel.remove(this._mainPane);
                        DynamicPanelBuilder _dynPanelBuilder = new DynamicPanelBuilder();
                        String DEGREE = "\u00b0";
                        if (this._isCelsius) {
                            this._expParams.setTempUnit(String.valueOf(DEGREE) + "C");
                            _dynPanelBuilder.sTemp = String.valueOf(DEGREE) + "C";
                        } else {
                            this._expParams.setTempUnit("K");
                            _dynPanelBuilder.sTemp = "K";
                        }
                        this._mainPane = _dynPanelBuilder.generateChartTabs(this._data);
                        this.panel.add((Component)this._mainPane, "Center");
                        logger.info((Object)"Import successful!");
                        this.iPageCount = 2;
                        this.validate();
                    } else {
                        logger.error((Object)"An error occurred while importing experimental data!");
                    }
                } else {
                    Container _selLitPanel = null;
                    int _selTabbedPane = this.tabbedPane.getSelectedIndex();
                    int _selTabbedPaneAngle = this.tabbedPaneAngles.getSelectedIndex();
                    if (_selTabbedPane == 0) {
                        Component[] componentArray = this._LiteratureCardPanel.getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component _comp = componentArray[n2];
                            if (_comp.isVisible()) {
                                _selLitPanel = (JPanel)_comp;
                            }
                            ++n2;
                        }
                        if (_selLitPanel != null) {
                            Component[] _components = _selLitPanel.getComponents();
                            String[] sPoly = null;
                            int iCount = 0;
                            sPoly = new String[6];
                            Component[] componentArray2 = _components;
                            int n3 = _components.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Component _comp = componentArray2[n4];
                                if (_comp instanceof JTextField) {
                                    if (((JTextField)_comp).getText().isEmpty()) throw new Exception("Empty Textfield!");
                                    sPoly[iCount] = ((JTextField)_comp).getText();
                                    if (!sPoly[iCount].contains("|")) throw new Exception("Required polynomial Order 1 - 5. Check number of coefficients!");
                                    String[] sSplitValues = sPoly[iCount].split("\\|");
                                    ++iCount;
                                    if (sSplitValues.length > 6 || sSplitValues.length < 2) {
                                        throw new Exception("Required polynomial Order 1 - 5. Check number of coefficients!");
                                    }
                                }
                                ++n4;
                            }
                            List<IFunctions> _listPolynoms = _impUtilities.returnLiteraturePolynomialList(sPoly, (eCrystalSystem)((Object)this.crystalList.getSelectedItem()), bIsBeta);
                            if (_listPolynoms != null) {
                                this._expParams = new ExpansionParams();
                                this._expParams.setFlag(bIsBeta);
                                this._expParams.setCrystalSystem((eCrystalSystem)((Object)this.crystalList.getSelectedItem()));
                                this._expParams.setLattParamFunc(_listPolynoms);
                                String DEGREE = "\u00b0";
                                if (this._isCelsius) {
                                    this._expParams.setTempUnit(String.valueOf(DEGREE) + "C");
                                } else {
                                    this._expParams.setTempUnit("K");
                                }
                                this.btnNext.setVisible(false);
                                MathExpansionCoeff _mathExp = new MathExpansionCoeff();
                                ExpansionParams _expParamsTest = _mathExp.returnCalcExpansionParams(25.0, this._expParams);
                                this.panel.remove(this._mainPane);
                                this.panel.add((Component)new CalcOverviewPresentationModel(_expParamsTest, true), "Center");
                                logger.info((Object)"Literature Import successful!");
                            }
                        }
                    } else {
                        Component _compLit = this.tabbedPane.getSelectedComponent();
                        JPanel _panel = null;
                        if (_compLit instanceof JPanel) {
                            _panel = (JPanel)_compLit;
                        }
                        if (_panel != null) {
                            Component _compLitAngle = this.tabbedPaneAngles.getSelectedComponent();
                            eCrystalSystem _eCS = (eCrystalSystem)((Object)this.crystalList.getSelectedItem());
                            List<IFunctions> _lFunc = null;
                            Component _selPanel = _panel.getComponent(_eCS.ordinal());
                            if (_selPanel instanceof JPanel) {
                                ReturnFunctionLists _rFL = new ReturnFunctionLists();
                                _lFunc = _rFL.returnLatticeList((JPanel)_selPanel, _eCS, _selTabbedPane);
                                if (_eCS == eCrystalSystem.Monoclinic || _eCS == eCrystalSystem.Triclinic) {
                                    Component _selPanelAngle;
                                    JPanel _panelAngle = null;
                                    if (_compLitAngle instanceof JPanel) {
                                        _panelAngle = (JPanel)_compLitAngle;
                                    }
                                    if (_panelAngle != null && (_selPanelAngle = _panelAngle.getComponent(_eCS.ordinal())) instanceof JPanel) {
                                        _lFunc = _rFL.returnLatticeListAngle((JPanel)_selPanelAngle, _lFunc, _eCS, _selTabbedPaneAngle, bIsBeta);
                                    }
                                }
                                if (_lFunc != null) {
                                    this._expParams = new ExpansionParams();
                                    this._expParams.setFlag(bIsBeta);
                                    this._expParams.setCrystalSystem((eCrystalSystem)((Object)this.crystalList.getSelectedItem()));
                                    this._expParams.setLattParamFunc(_lFunc);
                                    String DEGREE = "\u00b0";
                                    if (this._isCelsius) {
                                        this._expParams.setTempUnit(String.valueOf(DEGREE) + "C");
                                    } else {
                                        this._expParams.setTempUnit("K");
                                    }
                                    this.btnNext.setVisible(false);
                                    MathExpansionCoeff _mathExp = new MathExpansionCoeff();
                                    ExpansionParams _expParamsTest = _mathExp.returnCalcExpansionParams(25.0, this._expParams);
                                    this.panel.remove(this._mainPane);
                                    this.panel.add((Component)new CalcOverviewPresentationModel(_expParamsTest, true), "Center");
                                    logger.info((Object)"Literature Import successful!");
                                }
                            }
                        }
                    }
                }
                this.validate();
                return;
            } else if (this.iPageCount == 2) {
                Component _mainComp = this._mainPane.getComponent(0);
                if (_mainComp == null || !(_mainComp instanceof JTabbedPane)) return;
                FitUtilities _fitUtilities = new FitUtilities();
                List<IFunctions> _listPoly = _fitUtilities.returnPolyOrder((JTabbedPane)_mainComp);
                if (this._expParams == null) throw new Exception("Object Expensionparams is empty!");
                if (_listPoly == null) throw new Exception("ReturnValue Polynom is empty!");
                this.btnNext.setVisible(false);
                this._expParams.setLattParamFunc(_listPoly);
                MathExpansionCoeff _mathExp = new MathExpansionCoeff();
                double dCalcTemp = 25.0;
                if (this._data != null && this._data.getMinTemp() != 0.0) {
                    dCalcTemp = this._data.getMinTemp();
                }
                ExpansionParams _expParamsTest = _mathExp.returnCalcExpansionParams(dCalcTemp, this._expParams);
                this.panel.remove(this._mainPane);
                this.panel.add((Component)new CalcOverviewPresentationModel(_expParamsTest, true), "Center");
                this.invalidate();
                this.iPageCount = 3;
                return;
            } else {
                if (this.iPageCount != 3) return;
                this.iPageCount = 4;
            }
            return;
        }
        catch (IOException _IOex) {
            logger.error((Object)("Can't open File: " + _IOex.getMessage()));
            return;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
    }

    private void msgbox(String s) {
        JOptionPane.showMessageDialog(null, s);
    }

    private void checkCrystalSystem() {
        CardLayout _cardLayout = (CardLayout)this._LiteratureCardPanel.getLayout();
        _cardLayout.show(this._LiteratureCardPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutEinstein = (CardLayout)this._LiteratureEinsteinCardPanel.getLayout();
        _cardLayoutEinstein.show(this._LiteratureEinsteinCardPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutEinstein2Term = (CardLayout)this._LiteratureEinstein2TermCardPanel.getLayout();
        _cardLayoutEinstein2Term.show(this._LiteratureEinstein2TermCardPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutDebye = (CardLayout)this._LiteratureDebyeCardPanel.getLayout();
        _cardLayoutDebye.show(this._LiteratureDebyeCardPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutDebye2Term = (CardLayout)this._LiteratureDebye2TermCardPanel.getLayout();
        _cardLayoutDebye2Term.show(this._LiteratureDebye2TermCardPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutDebyeEinAnTerm = (CardLayout)this._LiteratureDebyeEinAnCardPanel.getLayout();
        _cardLayoutDebyeEinAnTerm.show(this._LiteratureDebyeEinAnCardPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutPolyAngle = (CardLayout)this._LiteratureAnglePolyCardPanel.getLayout();
        _cardLayoutPolyAngle.show(this._LiteratureAnglePolyCardPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutEinAngle = (CardLayout)this._LiteratureAngleEinsteinPanel.getLayout();
        _cardLayoutEinAngle.show(this._LiteratureAngleEinsteinPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutCOSAngle = (CardLayout)this._literatureAngleCOSPanel.getLayout();
        _cardLayoutCOSAngle.show(this._literatureAngleCOSPanel, this.crystalList.getSelectedItem().toString());
        CardLayout _cardLayoutSatAngle = (CardLayout)this._literatureAngleSatPanel.getLayout();
        _cardLayoutSatAngle.show(this._literatureAngleSatPanel, this.crystalList.getSelectedItem().toString());
        int i = this.tabbedPane.getSelectedIndex();
        if (i > 0) {
            if (this.crystalList.getSelectedItem() == eCrystalSystem.Monoclinic) {
                this._radioPanel.setVisible(true);
                this.tabbedPaneAngles.setVisible(true);
            } else if (this.crystalList.getSelectedItem() == eCrystalSystem.Triclinic || this.crystalList.getSelectedItem() == eCrystalSystem.Rhombohedral) {
                this._radioPanel.setVisible(false);
                this.tabbedPaneAngles.setVisible(true);
            } else {
                this.tabbedPaneAngles.setVisible(false);
                this._radioPanel.setVisible(false);
            }
        } else if (this.crystalList.getSelectedItem() == eCrystalSystem.Monoclinic) {
            this._radioPanel.setVisible(true);
            this.tabbedPaneAngles.setVisible(false);
        } else {
            this.tabbedPaneAngles.setVisible(false);
            this._radioPanel.setVisible(false);
        }
        this.validate();
    }

    private void checkImportType(ActionEvent actionEvent) {
        AbstractButton aButton = (AbstractButton)actionEvent.getSource();
        if (aButton.getText().equalsIgnoreCase(sImportMeasurementData)) {
            CardLayout _cardLayout = (CardLayout)this._DataImportCardPanel.getLayout();
            _cardLayout.show(this._DataImportCardPanel, "Import");
        } else {
            CardLayout _cardLayout = (CardLayout)this._DataImportCardPanel.getLayout();
            _cardLayout.show(this._DataImportCardPanel, "Literature");
        }
        this.validate();
    }

    private void setTempUnit(ActionEvent actionEvent) {
        AbstractButton aButton = (AbstractButton)actionEvent.getSource();
        this._isCelsius = aButton.getText().equalsIgnoreCase("Celsius");
        this.validate();
    }

    private JPanel buildLiteratureChartPanel(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [250dlu, pref], left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font(this.getName(), 1, 12);
            JLabel _lblAddPoly = new JLabel("Add Polynomial coefficients");
            _lblAddPoly.setFont(_fHeader);
            builder.add((Component)_lblAddPoly, CC.xyw((int)1, (int)1, (int)3));
            JButton _btnHelp = new JButton("How to add polynomial coefficients?");
            builder.add((Component)_btnHelp, CC.xy((int)4, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add polynomial coefficients</strong><br><br>Polynomial of order 3<br>f(T)=p<sub>0</sub>+p<sub>1</sub>*T+p<sub>2</sub>*T<sup>2</sup>+p<sub>3</sub>*T<sup>3</sup><br><br></p><p>Format of Input String<br>p<sub>0</sub>|p<sub>1</sub>|p<sub>2</sub>|p<sub>3</sub><br><br>Numerical example<br>6.80030E+00|-6.19870E-05|1.21170E-07|-1.60160E-10<br><br>Polynomial of order 2<br>p<sub>0</sub>|p<sub>1</sub>|p<sub>2</sub><br><br>Polynomial of order 1<br>p<sub>0</sub>|p<sub>1</sub></sub></p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic) {
                JTextField txtPolyA = new JTextField();
                JTextField txtPolyB = new JTextField();
                JTextField txtPolyC = new JTextField();
                JTextField txtPolyAlpha = new JTextField();
                JTextField txtPolyBeta = new JTextField();
                JTextField txtPolyGamma = new JTextField();
                txtPolyA.setText("6.80030E+00|-6.19870E-05|1.21170E-07|-1.60160E-10");
                txtPolyB.setText("8.35490E+00|-1.28640E-05|3.73500E-07|-5.17220E-10");
                txtPolyC.setText("9.89430E+00|-4.35220E-06|1.24430E-07");
                txtPolyAlpha.setText("9.71141E+01|-5.22390E-04|-1.91610E-06|4.07550E-09");
                txtPolyBeta.setText("1.07040E+02|-1.31540E-04|2.46050E-08");
                txtPolyGamma.setText("1.01167E+02|-1.65480E-04|6.16400E-08|2.44380E-11");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyA, CC.xy((int)3, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtPolyB, CC.xy((int)3, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtPolyC, CC.xy((int)3, (int)7));
                builder.addLabel("&alpha:", CC.xy((int)1, (int)9));
                builder.add((Component)txtPolyAlpha, CC.xy((int)3, (int)9));
                builder.addLabel("&beta:", CC.xy((int)1, (int)11));
                builder.add((Component)txtPolyBeta, CC.xy((int)3, (int)11));
                builder.addLabel("&gamma:", CC.xy((int)1, (int)13));
                builder.add((Component)txtPolyGamma, CC.xy((int)3, (int)13));
            } else if (pCrystalSystem == eCrystalSystem.Monoclinic) {
                JTextField txtPolyA = new JTextField();
                JTextField txtPolyB = new JTextField();
                JTextField txtPolyC = new JTextField();
                JTextField txtObliqueAngle = new JTextField();
                txtPolyA.setText("1.24665E+01|1.59457E-04|7.45038E-08");
                txtPolyB.setText("4.68341E+00|8.22690E-05|-2.27556E-08");
                txtPolyC.setText("1.39075E+01|1.70493E-04|-8.07028E-08");
                txtObliqueAngle.setText("9.37635E+01|3.87424E-04|8.49056E-08");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyA, CC.xy((int)3, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtPolyB, CC.xy((int)3, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtPolyC, CC.xy((int)3, (int)7));
                builder.addLabel("&oblique angle:", CC.xy((int)1, (int)9));
                builder.add((Component)txtObliqueAngle, CC.xy((int)3, (int)9));
            } else if (pCrystalSystem == eCrystalSystem.Orthorhombic) {
                JTextField txtPolyA = new JTextField();
                JTextField txtPolyB = new JTextField();
                JTextField txtPolyC = new JTextField();
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyA, CC.xy((int)3, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtPolyB, CC.xy((int)3, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtPolyC, CC.xy((int)3, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Tetragonal) {
                JTextField txtPolyA = new JTextField();
                JTextField txtPolyC = new JTextField();
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyA, CC.xy((int)3, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtPolyC, CC.xy((int)3, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Rhombohedral) {
                JTextField txtPolyA = new JTextField();
                JTextField txtObliqueAngle = new JTextField();
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyA, CC.xy((int)3, (int)3));
                builder.addLabel("&oblique angle:", CC.xy((int)1, (int)5));
                builder.add((Component)txtObliqueAngle, CC.xy((int)3, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Hexagonal) {
                JTextField txtPolyA = new JTextField();
                JTextField txtPolyC = new JTextField();
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyA, CC.xy((int)3, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtPolyC, CC.xy((int)3, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Cubic) {
                JTextField txtPolyA = new JTextField();
                txtPolyA.setText("8.000E+00|1.0E-4");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyA, CC.xy((int)3, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    private boolean checkTextLatticeFields(JTabbedPane _tabbedPane) {
        boolean _rv = false;
        return _rv;
    }

    private boolean checkTextAngleFields(JTabbedPane _tabbedPane, eCrystalSystem _cs) {
        boolean _rv = false;
        return _rv;
    }
}

