/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import myObjects.ExpansionParams;
import myObjects.eCrystalSystem;
import myUtilities.SectionPlotUtils;
import myUtilities.Visualize;
import org.apache.log4j.Logger;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.canvas.Plot2DCanvas;
import org.math.plot.canvas.Plot3DCanvas;
import org.math.plot.plotObjects.BasePlot;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.GridPlot3DSphere;
import org.math.plot.plots.Plot;

public class DataVisualizationWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel _outerFrame;
    private JPanel _VisualizePanel;
    private double[][][] complete;
    private double[][] ProX;
    private double[][] ProY;
    private double[][] ProZ;
    public double[][] CTE;
    public double[][] CrysAxesCoords;
    public double[][] EVCoords;
    public String sTemp;
    public String sTempUnit;
    public String _crystalSystem;
    public Color _cCrysAxes = Color.blue;
    public Color _cEVAxes = Color.MAGENTA;
    private JSlider _sliderTransparency;
    private JRadioButton _radioSurf;
    private JPanel _show3DPane;
    private static final String sSection = "Define section";
    static final int SLIDER_MIN = 0;
    static final int SLIDER_MAX = 60;
    static final int SLIDER_INIT = 30;
    private JTextField _txtU1;
    private JTextField _txtV1;
    private JTextField _txtW1;
    private JTextField _txtU2;
    private JTextField _txtV2;
    private JTextField _txtW2;
    private JPanel _sectionPanel;
    static Logger logger = Logger.getLogger(DataVisualizationWindow.class);
    private final ExpansionParams _expParams;
    private int iCanvasSizeX = 800;
    private int iCanvasSizeY = 1500;

    public DataVisualizationWindow(String title, ExpansionParams pExpParams) {
        super(title);
        this._expParams = pExpParams;
        this.configureUI();
    }

    public void buildInterface() {
        this.setSize(800, 800);
        this.setDefaultCloseOperation(2);
        this.generatePlotCards();
        this._outerFrame = this.buildPane();
        JScrollPane _scrollWrapper = new JScrollPane(this._outerFrame, 20, 30);
        _scrollWrapper.setBorder(BorderFactory.createEmptyBorder());
        this.getContentPane().add(_scrollWrapper);
        this.showCrystallographicAxes(false);
        this.showEV(false);
        this.pack();
        this.setVisible(true);
    }

    private JPanel buildPane() {
        FormLayout layout = new FormLayout("40dlu, fill:400dlu, 10dlu, pref, 5dlu, p", "20dlu, p, 15dlu, fill:400dlu, 25dlu, p, 5dlu, p, 25dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        ButtonBarBuilder BtnBuilder = new ButtonBarBuilder();
        JButton btn3D = new JButton("3D View");
        JButton btnX = new JButton("e2-e3 section");
        JButton btnY = new JButton("e1-e3 section");
        JButton btnZ = new JButton("e1-e2 section");
        JButton btnDefSection = new JButton(new actionDefineSection());
        JButton btnClose = new JButton("Close");
        btn3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataVisualizationWindow.this._btn3DActionPerformed(e);
            }
        });
        btnX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataVisualizationWindow.this._btnXActionPerformed(e);
            }
        });
        btnY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataVisualizationWindow.this._btnYActionPerformed(e);
            }
        });
        btnZ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataVisualizationWindow.this._btnZActionPerformed(e);
            }
        });
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataVisualizationWindow.this._btnCloseActionPerformed(e);
            }
        });
        BtnBuilder.addButton((JComponent)btn3D);
        BtnBuilder.addRelatedGap();
        BtnBuilder.addButton((JComponent)btnX);
        BtnBuilder.addRelatedGap();
        BtnBuilder.addButton((JComponent)btnY);
        BtnBuilder.addRelatedGap();
        BtnBuilder.addButton((JComponent)btnZ);
        BtnBuilder.addRelatedGap();
        BtnBuilder.addButton((JComponent)btnDefSection);
        builder.add((Component)BtnBuilder.getPanel(), cc.xyw(2, 2, 2));
        eCrystalSystem _eCrystalSystem = eCrystalSystem.fromString(this._crystalSystem);
        if (_eCrystalSystem != null && (_eCrystalSystem == eCrystalSystem.Triclinic || _eCrystalSystem == eCrystalSystem.Monoclinic)) {
            if (this.CrysAxesCoords != null) {
                JPanel _lblShowCryAxes = new JPanel();
                JCheckBox _showCrysAxes = new JCheckBox();
                _showCrysAxes.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractButton abstractButton = (AbstractButton)e.getSource();
                        boolean selected = abstractButton.getModel().isSelected();
                        DataVisualizationWindow.this.showCrystallographicAxes(selected);
                        DataVisualizationWindow.this._VisualizePanel.validate();
                    }
                });
                _lblShowCryAxes.add(new Label("show crystallographic axes: "));
                _lblShowCryAxes.add(_showCrysAxes);
                builder.add((Component)_lblShowCryAxes, cc.xy(2, 6));
            }
            if (this.EVCoords != null) {
                JPanel _lblShowEV = new JPanel();
                JCheckBox _showEVAxes = new JCheckBox();
                _showEVAxes.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractButton abstractButton = (AbstractButton)e.getSource();
                        boolean selected = abstractButton.getModel().isSelected();
                        DataVisualizationWindow.this.showEV(selected);
                        DataVisualizationWindow.this._VisualizePanel.validate();
                    }
                });
                _lblShowEV.add(new Label("show Eigenvectors: "));
                _lblShowEV.add(_showEVAxes);
                builder.add((Component)_lblShowEV, cc.xy(2, 8));
            }
        }
        builder.add((Component)this._VisualizePanel, cc.xy(2, 4));
        this._show3DPane = new JPanel(new GridLayout(2, 1));
        this._radioSurf = new JRadioButton("Opacity", true);
        this._sliderTransparency = new JSlider(0, 0, 60, 30);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("0"));
        labelTable.put(new Integer(10), new JLabel("10"));
        labelTable.put(new Integer(20), new JLabel("20"));
        labelTable.put(new Integer(30), new JLabel("30"));
        labelTable.put(new Integer(40), new JLabel("40"));
        labelTable.put(new Integer(50), new JLabel("50"));
        labelTable.put(new Integer(60), new JLabel("60"));
        this._sliderTransparency.setMajorTickSpacing(10);
        this._sliderTransparency.setPaintTicks(true);
        this._sliderTransparency.setSnapToTicks(true);
        this._sliderTransparency.setLabelTable(labelTable);
        this._sliderTransparency.setPaintLabels(true);
        this._sliderTransparency.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int value = DataVisualizationWindow.this._sliderTransparency.getValue();
                if (DataVisualizationWindow.this._radioSurf.isSelected()) {
                    float fTransparency = 0.9f;
                    if (value == 0) {
                        fTransparency = 0.0f;
                    } else if (value == 10) {
                        fTransparency = 0.1f;
                    } else if (value == 20) {
                        fTransparency = 0.2f;
                    } else if (value == 30) {
                        fTransparency = 0.3f;
                    } else if (value == 40) {
                        fTransparency = 0.4f;
                    } else if (value == 50) {
                        fTransparency = 0.5f;
                    } else if (value == 60) {
                        fTransparency = 0.6f;
                    }
                    if (fTransparency < 0.9f) {
                        GridPlot3DSphere _3dSphere = new GridPlot3DSphere(null, fTransparency, Color.decode("#8FBC8F"), DataVisualizationWindow.this.complete, true, true);
                        DataVisualizationWindow.replace3DPlot(DataVisualizationWindow.this._VisualizePanel, _3dSphere);
                    }
                }
            }
        });
        this._show3DPane.add(new JLabel("Opacity"));
        this._show3DPane.add(this._sliderTransparency);
        builder.add((Component)this._show3DPane, cc.xy(6, 2));
        JPanel _sectionPane = new JPanel(new GridLayout(2, 1));
        JLabel _lblColourCoding = new JLabel("<html><body bgcolor='white'><table><tr><td><strong>Color coding for the surface</strong></td></tr><tr><td><strong><font color='#8FBC8F'>positive values</strong></strong></td></tr><tr><td><strong><font color='#FF0000'>negative values</strong></strong></td></tr></table></body></html>");
        _sectionPane.add(_lblColourCoding);
        this._sectionPanel = this.returnSectionPanel();
        this._sectionPanel.setVisible(false);
        _sectionPane.add(this._sectionPanel);
        builder.add((Component)_sectionPane, cc.xy(6, 4));
        builder.add((Component)btnClose, cc.xy(4, 6));
        return builder.getPanel();
    }

    private static void replace3DPlot(JPanel _VisualizePanel, GridPlot3DSphere _plotSphere) {
        if (_VisualizePanel != null) {
            Component[] componentArray = _VisualizePanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component _compJP = componentArray[n2];
                if (_compJP instanceof JPanel) {
                    Component[] componentArray2 = ((JPanel)_compJP).getComponents();
                    int n3 = componentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Component _comp = componentArray2[n4];
                        if (_comp instanceof Plot3DPanel) {
                            Plot3DPanel _plot3D = (Plot3DPanel)_comp;
                            LinkedList<Plot> _plotList = _plot3D.getPlots();
                            int iWalker = 0;
                            while (iWalker < _plotList.size()) {
                                int i;
                                Plot _plot = _plotList.get(iWalker);
                                if (!_plot.getName().isEmpty() && (i = _plot.getName().indexOf("3D Visualization")) > -1) {
                                    int iIndex = _plot3D.getPlotIndex(_plot);
                                    String sName = _plot.getName();
                                    _plotSphere.setName(sName);
                                    _plot3D.setPlot(iIndex, _plotSphere);
                                    _plot3D.repaint();
                                }
                                ++iWalker;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void generatePlotCards() {
        int iPitchCount = 18;
        Plot3DPanel plot = new Plot3DPanel("SOUTH"){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        };
        if (this.complete == null) {
            double[][] fHor = Visualize.fVertPlane(iPitchCount, this.CTE);
            this.complete = Visualize.generateVertLineArrays(fHor, this.CTE);
        }
        if (this.ProX == null) {
            this.ProX = Visualize.generate2DProjectionNewCalc(Visualize.ProjectionDirection.X, this.CTE);
        }
        if (this.ProY == null) {
            this.ProY = Visualize.generate2DProjectionNewCalc(Visualize.ProjectionDirection.Y, this.CTE);
        }
        if (this.ProZ == null) {
            this.ProZ = Visualize.generate2DProjectionNewCalc(Visualize.ProjectionDirection.Z, this.CTE);
        }
        if (this._crystalSystem == null) {
            this._crystalSystem = "unknown";
        }
        String addTempInfo = "";
        if (this.sTemp != null) {
            addTempInfo = " 3D Visualization at temperature " + this.sTemp + " " + this.sTempUnit;
        }
        plot.addGridPlotSphere(String.valueOf(this._crystalSystem) + addTempInfo, 0.3f, Color.decode("#8FBC8F"), this.complete, true, true);
        double[] dOrigin = new double[]{0.0, 0.0, 0.0};
        if (this.CrysAxesCoords != null) {
            double[][] a = new double[2][3];
            double[][] b = new double[2][3];
            a[0] = new double[]{0.0, 0.0, 0.0, 1.0};
            a[0] = new double[]{this.CrysAxesCoords[0][0] * -1.0, this.CrysAxesCoords[0][1] * -1.0, this.CrysAxesCoords[0][2] * -1.0, 1.0};
            a[1] = this.CrysAxesCoords[0];
            b[0] = new double[]{0.0, 0.0, 0.0, 1.0};
            b[0] = new double[]{this.CrysAxesCoords[1][0] * -1.0, this.CrysAxesCoords[1][1] * -1.0, this.CrysAxesCoords[1][2] * -1.0, 1.0};
            b[1] = this.CrysAxesCoords[1];
            plot.addLinePlot("a", this._cCrysAxes, a);
            plot.addLabel("a", this._cCrysAxes, a[1]);
            double[] aVector = Visualize.fZOv(a[1][0], a[1][1], a[1][2], this.CTE);
            double[] bVector = Visualize.fZOv(b[1][0], b[1][1], b[1][2], this.CTE);
            double[] cVector = Visualize.fZOv(0.0, 0.0, 1.0, this.CTE);
            plot.addLinePlot("b", this._cCrysAxes, b);
            plot.addLabel("b", this._cCrysAxes, b[1]);
        }
        String[] _s = plot.getAxisScales();
        Plot3DCanvas _c = (Plot3DCanvas)plot.plotCanvas;
        _c.setSize(this.iCanvasSizeX, this.iCanvasSizeY);
        BasePlot _bP = _c.getGrid();
        double[] _dRoundMaxValues = _c.base.roundXmax;
        double dAxesLength = this.findMaxValue(_dRoundMaxValues);
        double[] _newBoundsMin = new double[]{-dAxesLength, -dAxesLength, -dAxesLength};
        double[] _newBoundsMax = new double[]{dAxesLength, dAxesLength, dAxesLength};
        System.out.println(dAxesLength);
        if (this.EVCoords != null) {
            double[][] EV1 = new double[2][3];
            double[][] EV2 = new double[2][3];
            double[][] EV3 = new double[2][3];
            EV1[1] = this.EVCoords[0];
            EV2[0] = new double[]{0.0, 0.0, 0.0, 1.0};
            EV2[1] = this.EVCoords[1];
            EV3[0] = new double[]{0.0, 0.0, 0.0, 1.0};
            EV3[1] = this.EVCoords[2];
            double[] ev1 = this.changeVectorLength(EV1[1], dAxesLength);
            double[] ev2 = this.changeVectorLength(EV2[1], dAxesLength);
            double[] ev3 = this.changeVectorLength(EV3[1], dAxesLength);
            EV1[0] = new double[]{ev1[0] * -1.0, ev1[1] * -1.0, ev1[2] * -1.0, 1.0};
            EV1[1][0] = ev1[0];
            EV1[1][1] = ev1[1];
            EV1[1][2] = ev1[2];
            EV2[0] = new double[]{ev2[0] * -1.0, ev2[1] * -1.0, ev2[2] * -1.0, 1.0};
            EV2[1][0] = ev2[0];
            EV2[1][1] = ev2[1];
            EV2[1][2] = ev2[2];
            EV3[0] = new double[]{ev3[0] * -1.0, ev3[1] * -1.0, ev3[2] * -1.0, 1.0};
            EV3[1][0] = ev3[0];
            EV3[1][1] = ev3[1];
            EV3[1][2] = ev3[2];
            plot.addLinePlot("EV1", this._cEVAxes, EV1);
            plot.addLabel("EV1", this._cEVAxes, EV1[1]);
            plot.addLinePlot("EV2", this._cEVAxes, EV2);
            plot.addLabel("EV2", this._cEVAxes, EV2[1]);
            plot.addLinePlot("EV3", this._cEVAxes, EV3);
            plot.addLabel("EV3", this._cEVAxes, EV3[1]);
        }
        FormLayout layout = new FormLayout("fill:400dlu", "p, fill:400dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        JLabel _Header = new JLabel(String.valueOf(this._crystalSystem) + addTempInfo);
        _Header.setHorizontalAlignment(0);
        plot.setNoteCoords(false);
        plot.setNotable(false);
        plot.removeLegend();
        _c.base.setFixedBounds(_newBoundsMin, _newBoundsMax);
        _c.base.baseCoords[0] = dOrigin;
        _c.base.baseCoords[1][0] = _dRoundMaxValues[0];
        _c.base.baseCoords[1][1] = 0.0;
        _c.base.baseCoords[1][2] = 0.0;
        _c.base.baseCoords[2][0] = 0.0;
        _c.base.baseCoords[2][1] = _dRoundMaxValues[1];
        _c.base.baseCoords[2][2] = 0.0;
        _c.base.baseCoords[3][0] = 0.0;
        _c.base.baseCoords[3][1] = 0.0;
        _c.base.baseCoords[3][2] = _dRoundMaxValues[2];
        _bP.setGridVisible(0, false);
        _bP.setGridVisible(1, false);
        _bP.setGridVisible(2, false);
        _c.setAxisLabel(0, "e1");
        _c.setAxisLabel(1, "e2");
        _c.setAxisLabel(2, "e3 || c");
        plot.repaint();
        builder.add((Component)_Header, cc.xy(1, 1));
        builder.add((Component)plot, cc.xy(1, 2));
        JPanel _3DCard = builder.getPanel();
        _3DCard.setBackground(new Color(0, 0, 0, 125));
        JPanel _ProjXCard = this.set2DProjectionPlot(Visualize.ProjectionDirection.X, this.ProX);
        _ProjXCard.setBackground(new Color(0, 0, 0, 0));
        JPanel _ProjYCard = this.set2DProjectionPlot(Visualize.ProjectionDirection.Y, this.ProY);
        JPanel _ProjZCard = this.set2DProjectionPlot(Visualize.ProjectionDirection.Z, this.ProZ);
        JPanel _sectionPlot = new JPanel();
        this._VisualizePanel = new JPanel(new CardLayout());
        this._VisualizePanel.add((Component)_3DCard, "3D");
        this._VisualizePanel.add((Component)_ProjXCard, "X");
        this._VisualizePanel.add((Component)_ProjYCard, "Y");
        this._VisualizePanel.add((Component)_ProjZCard, "Z");
        this._VisualizePanel.add((Component)_sectionPlot, "Section");
    }

    private JPanel set2DProjectionPlot(Visualize.ProjectionDirection eProjDir, double[][] pValues) {
        FormLayout layout = new FormLayout("fill:400dlu", "p, fill:400dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        Plot2DPanel plot = new Plot2DPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        };
        plot.addLegend("SOUTH");
        String[] sAxesLabel = new String[2];
        if (eProjDir == Visualize.ProjectionDirection.X) {
            sAxesLabel[0] = "e2";
            sAxesLabel[1] = "e3";
        } else if (eProjDir == Visualize.ProjectionDirection.Y) {
            sAxesLabel[0] = "e1";
            sAxesLabel[1] = "e3";
        } else if (eProjDir == Visualize.ProjectionDirection.Z) {
            sAxesLabel[0] = "e1";
            sAxesLabel[1] = "e2";
        }
        Plot2DCanvas _c = (Plot2DCanvas)plot.plotCanvas;
        _c.setSize(this.iCanvasSizeX, this.iCanvasSizeY);
        BasePlot _bP = _c.getGrid();
        _c.allowEdit = false;
        _c.allowNote = false;
        _c.allowNoteCoord = false;
        _c.setAxisLabels(sAxesLabel);
        _bP.setGridVisible(0, false);
        _bP.setGridVisible(1, false);
        String addTempInfo = "";
        if (this.sTemp != null) {
            addTempInfo = String.valueOf(this.sTemp) + " " + this.sTempUnit;
        }
        String sTitle = "";
        if (eProjDir == Visualize.ProjectionDirection.X) {
            sTitle = "e2-e3-section at temperature ";
        } else if (eProjDir == Visualize.ProjectionDirection.Y) {
            sTitle = "e1-e3-section at temperature ";
        } else if (eProjDir == Visualize.ProjectionDirection.Z) {
            sTitle = "e1-e2-section at temperature ";
        }
        JLabel _Header = new JLabel(String.valueOf(sTitle) + addTempInfo);
        _Header.setHorizontalAlignment(0);
        builder.add((Component)_Header, cc.xy(1, 1));
        plot.addLinePlot(String.valueOf(sTitle) + addTempInfo, Color.decode("#8FBC8F"), pValues);
        plot = this.addProjCrysAxes(plot, eProjDir, this.CrysAxesCoords);
        plot = this.addProjEVAxes(plot, eProjDir, this.EVCoords);
        double[] _dRoundMaxValues = _c.base.roundXmax;
        double dAxesLength = this.findMaxValue(_dRoundMaxValues);
        double[][] drawScale = new double[7][3];
        double sRulerLength = this.returnScaleLengthRuler(dAxesLength, 4);
        double dVertLinesDist = dAxesLength / 45.0;
        double dLineStringDistance = dVertLinesDist / 2.0;
        drawScale[0] = new double[]{-(sRulerLength /= 2.0), -dAxesLength - dVertLinesDist, 1.0};
        drawScale[1] = new double[]{-sRulerLength, -dAxesLength, 1.0};
        drawScale[2] = new double[]{0.0, -dAxesLength, 1.0};
        drawScale[3] = new double[]{0.0, -dAxesLength - dVertLinesDist, 1.0};
        drawScale[4] = new double[]{0.0, -dAxesLength, 1.0};
        drawScale[5] = new double[]{sRulerLength, -dAxesLength, 1.0};
        drawScale[6] = new double[]{sRulerLength, -dAxesLength - dVertLinesDist, 1.0};
        plot.addLabel("0", Color.black, -sRulerLength, -dAxesLength - (dVertLinesDist + dLineStringDistance));
        plot.addLabel("[1/" + this.sTempUnit + "] * 10E-6", Color.black, 0.0 + sRulerLength * 0.5, -dAxesLength + 4.0 * dLineStringDistance);
        plot.addLabel(Double.toString(sRulerLength), Color.black, 0.0, -dAxesLength - (dVertLinesDist + dLineStringDistance));
        plot.addLabel(Double.toString(sRulerLength * 2.0), Color.black, sRulerLength, -dAxesLength - (dVertLinesDist + dLineStringDistance));
        plot.addLinePlot("Scale", Color.black, drawScale);
        plot.removeLegend();
        double[] _newBoundsMin = new double[]{-dAxesLength, -dAxesLength};
        double[] _newBoundsMax = new double[]{dAxesLength, dAxesLength};
        _c.base.setFixedBounds(_newBoundsMin, _newBoundsMax);
        _c.base.baseCoords[0][0] = 0.0;
        _c.base.baseCoords[0][1] = 0.0;
        _c.base.baseCoords[1][1] = 0.0;
        _c.base.baseCoords[2][0] = 0.0;
        _c.base.baseCoords[1][0] = _dRoundMaxValues[0];
        _c.base.baseCoords[1][1] = 0.0;
        _c.base.baseCoords[2][0] = 0.0;
        _c.base.baseCoords[2][1] = _dRoundMaxValues[1];
        builder.add((Component)plot, cc.xy(1, 2));
        return builder.getPanel();
    }

    private JPanel set2DSectionPlot(double[][] pValues, String pUVW1, String pUVW2) {
        FormLayout layout = new FormLayout("fill:400dlu", "p, fill:400dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        Plot2DPanel plot = new Plot2DPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        };
        plot.addLegend("SOUTH");
        Plot2DCanvas _c = (Plot2DCanvas)plot.plotCanvas;
        _c.setSize(this.iCanvasSizeX, this.iCanvasSizeY);
        BasePlot _bP = _c.getGrid();
        _c.allowEdit = false;
        _c.allowNote = false;
        _c.allowNoteCoord = false;
        _bP.getAxis(0).setVisible(false);
        _bP.getAxis(1).setVisible(false);
        _bP.setGridVisible(0, false);
        _bP.setGridVisible(1, false);
        String addTempInfo = "";
        if (this.sTemp != null) {
            addTempInfo = " at temperature " + this.sTemp + " " + this.sTempUnit;
        }
        JLabel _Header = new JLabel("Section plot" + addTempInfo);
        _Header.setHorizontalAlignment(0);
        builder.add((Component)_Header, cc.xy(1, 1));
        double[][] pValuesTrim = new double[pValues.length - 1][pValues[0].length];
        System.arraycopy(pValues, 0, pValuesTrim, 0, pValuesTrim.length);
        plot.addLinePlot("Section plot " + addTempInfo, Color.decode("#8FBC8F"), pValuesTrim);
        double[] _dRoundMaxValues = _c.base.roundXmax;
        double dAxesLength = this.findMaxValue(_dRoundMaxValues);
        double[][] uvw1 = new double[3][3];
        double[][] uvw2 = new double[3][3];
        double[] uvw1Coord = pValues[0];
        uvw1Coord = SectionPlotUtils.returnNormalizedVector(uvw1Coord);
        uvw1Coord = this.changeVectorLength(uvw1Coord, dAxesLength);
        uvw1[0] = new double[]{0.0, 0.0, 1.0};
        uvw1[1] = uvw1Coord;
        uvw1[1][2] = 1.0;
        uvw1[2] = uvw1[0];
        uvw2[0] = new double[]{0.0, 0.0, 1.0};
        int iLastItem = pValues.length - 1;
        double[] uvw2Coord = pValues[iLastItem];
        uvw2Coord = SectionPlotUtils.returnNormalizedVector(uvw2Coord);
        uvw2Coord = this.changeVectorLength(uvw2Coord, dAxesLength);
        uvw2[1] = uvw2Coord;
        uvw2[1][2] = 1.0;
        uvw2[2] = uvw2[0];
        plot.addLinePlot("uvw1", Color.black, uvw1);
        plot.addLabel("[" + pUVW1 + "]", Color.black, uvw1[1]);
        plot.addLinePlot("uvw2", Color.black, uvw2);
        plot.addLabel("[" + pUVW2 + "]", Color.black, uvw2[1]);
        double[][] drawScale = new double[7][3];
        double sRulerLength = this.returnScaleLengthRuler(dAxesLength, 4);
        double dVertLinesDist = dAxesLength / 45.0;
        double dLineStringDistance = dVertLinesDist / 2.0;
        double spacer = dAxesLength * 0.8;
        drawScale[0] = new double[]{spacer - (sRulerLength /= 2.0), -dAxesLength - dVertLinesDist, 1.0};
        drawScale[1] = new double[]{spacer - sRulerLength, -dAxesLength, 1.0};
        drawScale[2] = new double[]{spacer, -dAxesLength, 1.0};
        drawScale[3] = new double[]{spacer, -dAxesLength - dVertLinesDist, 1.0};
        drawScale[4] = new double[]{spacer, -dAxesLength, 1.0};
        drawScale[5] = new double[]{spacer + sRulerLength, -dAxesLength, 1.0};
        drawScale[6] = new double[]{spacer + sRulerLength, -dAxesLength - dVertLinesDist, 1.0};
        plot.addLabel("0", Color.black, spacer - sRulerLength, -dAxesLength - (dVertLinesDist + dLineStringDistance));
        plot.addLabel("[1/" + this.sTempUnit + "] * 10E-6", Color.black, spacer + sRulerLength * 0.5, -dAxesLength + 4.0 * dLineStringDistance);
        plot.addLabel(Double.toString(sRulerLength), Color.black, spacer, -dAxesLength - (dVertLinesDist + dLineStringDistance));
        plot.addLabel(Double.toString(sRulerLength * 2.0), Color.black, spacer + sRulerLength, -dAxesLength - (dVertLinesDist + dLineStringDistance));
        plot.addLinePlot("Scale", Color.black, drawScale);
        plot.removeLegend();
        double[] _newBoundsMin = new double[]{-dAxesLength, -dAxesLength};
        double[] _newBoundsMax = new double[]{dAxesLength, dAxesLength};
        _c.base.setFixedBounds(_newBoundsMin, _newBoundsMax);
        _c.setAxisLabel(0, "");
        _c.setAxisLabel(1, "");
        _c.base.baseCoords[0][0] = 0.0;
        _c.base.baseCoords[0][1] = 0.0;
        _c.base.baseCoords[1][1] = 0.0;
        _c.base.baseCoords[2][0] = 0.0;
        _c.base.baseCoords[1][0] = _dRoundMaxValues[0];
        _c.base.baseCoords[1][1] = 0.0;
        _c.base.baseCoords[2][0] = 0.0;
        _c.base.baseCoords[2][1] = _dRoundMaxValues[1];
        builder.add((Component)plot, cc.xy(1, 2));
        return builder.getPanel();
    }

    private void _btn3DActionPerformed(ActionEvent e) {
        CardLayout _cardLayout = (CardLayout)this._VisualizePanel.getLayout();
        _cardLayout.show(this._VisualizePanel, "3D");
        this._sectionPanel.setVisible(false);
    }

    private void _btnXActionPerformed(ActionEvent e) {
        CardLayout _cardLayout = (CardLayout)this._VisualizePanel.getLayout();
        _cardLayout.show(this._VisualizePanel, "X");
        this._sectionPanel.setVisible(false);
    }

    private void _btnYActionPerformed(ActionEvent e) {
        CardLayout _cardLayout = (CardLayout)this._VisualizePanel.getLayout();
        _cardLayout.show(this._VisualizePanel, "Y");
        this._sectionPanel.setVisible(false);
    }

    private void _btnZActionPerformed(ActionEvent e) {
        CardLayout _cardLayout = (CardLayout)this._VisualizePanel.getLayout();
        _cardLayout.show(this._VisualizePanel, "Z");
        this._sectionPanel.setVisible(false);
    }

    private void _btnCloseActionPerformed(ActionEvent e) {
        this.dispose();
    }

    private void configureUI() {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setUseSystemFonts((boolean)true);
        Options.setDefaultIconSize((Dimension)new Dimension(18, 18));
        String lafName = LookUtils.IS_OS_WINDOWS_XP ? Options.getCrossPlatformLookAndFeelClassName() : Options.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
    }

    private double findMaxValue(double[] a) {
        double max = 0.0;
        int i = 0;
        while (i < a.length) {
            if (a[i] > max) {
                max = a[i];
            }
            ++i;
        }
        return max;
    }

    private double[] changeVectorLength(double[] pVector, double pLength) {
        double[] rv = new double[4];
        try {
            int i = 0;
            while (i < pVector.length) {
                rv[i] = pVector[i] * pLength;
                ++i;
            }
            rv[3] = 1.0;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    private double returnScaleLengthRuler(double range, int tickCount) {
        double unroundedTickSize = range / (double)(tickCount - 1);
        double x = Math.ceil(Math.log10(unroundedTickSize) - 1.0);
        double pow10x = Math.pow(10.0, x);
        double roundedTickRange = Math.ceil(unroundedTickSize / pow10x) * pow10x;
        return roundedTickRange;
    }

    private Plot2DPanel addProjCrysAxes(Plot2DPanel _plot, Visualize.ProjectionDirection _dir, double[][] _3DCoord) {
        if (_3DCoord != null) {
            double[] _xy = new double[3];
            if (_dir == Visualize.ProjectionDirection.X) {
                double[][] a = new double[3][3];
                double[][] b = new double[3][3];
                a[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _3DCoord[0][1];
                _xy[1] = _3DCoord[0][2];
                _xy[2] = 1.0;
                a[1] = _xy;
                a[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("a", this._cCrysAxes, a);
                _plot.addLabel("a", this._cCrysAxes, a[1]);
                _xy = new double[3];
                b[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _3DCoord[1][1];
                _xy[1] = _3DCoord[1][2];
                _xy[2] = 1.0;
                b[1] = _xy;
                b[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("b", this._cCrysAxes, b);
                _plot.addLabel("b", this._cCrysAxes, b[1]);
            } else if (_dir == Visualize.ProjectionDirection.Y) {
                double[][] a = new double[3][3];
                double[][] b = new double[3][3];
                a[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _3DCoord[0][0];
                _xy[1] = _3DCoord[0][2];
                _xy[2] = 1.0;
                a[1] = _xy;
                a[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("a", this._cCrysAxes, a);
                _plot.addLabel("a", this._cCrysAxes, a[1]);
                _xy = new double[3];
                b[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _3DCoord[1][0];
                _xy[1] = _3DCoord[1][2];
                _xy[2] = 1.0;
                b[1] = _xy;
                b[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("b", this._cCrysAxes, b);
                _plot.addLabel("b", this._cCrysAxes, b[1]);
            } else if (_dir == Visualize.ProjectionDirection.Z) {
                double[][] a = new double[3][3];
                double[][] b = new double[3][3];
                a[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _3DCoord[0][0];
                _xy[1] = _3DCoord[0][1];
                _xy[2] = 1.0;
                a[1] = _xy;
                a[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("a", this._cCrysAxes, a);
                _plot.addLabel("a", this._cCrysAxes, a[1]);
                _xy = new double[3];
                b[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _3DCoord[1][0];
                _xy[1] = _3DCoord[1][1];
                _xy[2] = 1.0;
                b[1] = _xy;
                b[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("b", this._cCrysAxes, b);
                _plot.addLabel("b", this._cCrysAxes, b[1]);
            }
        }
        return _plot;
    }

    private Plot2DPanel addProjEVAxes(Plot2DPanel _plot, Visualize.ProjectionDirection _dir, double[][] _EVCoord) {
        if (_EVCoord != null) {
            double[] _xy = new double[3];
            if (_dir == Visualize.ProjectionDirection.X) {
                double[][] EV1 = new double[3][3];
                double[][] EV2 = new double[3][3];
                double[][] EV3 = new double[3][3];
                EV1[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[0][1];
                _xy[1] = _EVCoord[0][2];
                _xy[2] = 1.0;
                EV1[1] = _xy;
                EV1[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV1", this._cEVAxes, EV1);
                _plot.addLabel("EV1", this._cEVAxes, EV1[1]);
                _xy = new double[3];
                EV2[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[1][1];
                _xy[1] = _EVCoord[1][2];
                _xy[2] = 1.0;
                EV2[1] = _xy;
                EV2[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV2", this._cEVAxes, EV2);
                _plot.addLabel("EV2", this._cEVAxes, EV2[1]);
                _xy = new double[3];
                EV3[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[2][1];
                _xy[1] = _EVCoord[2][2];
                _xy[2] = 1.0;
                EV3[1] = _xy;
                EV3[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV3", this._cEVAxes, EV3);
                _plot.addLabel("EV3", this._cEVAxes, EV3[1]);
            } else if (_dir == Visualize.ProjectionDirection.Y) {
                double[][] EV1 = new double[3][3];
                double[][] EV2 = new double[3][3];
                double[][] EV3 = new double[3][3];
                EV1[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[0][0];
                _xy[1] = _EVCoord[0][2];
                _xy[2] = 1.0;
                EV1[1] = _xy;
                EV1[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV1", this._cEVAxes, EV1);
                _plot.addLabel("EV1", this._cEVAxes, EV1[1]);
                _xy = new double[3];
                EV2[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[1][0];
                _xy[1] = _EVCoord[1][2];
                _xy[2] = 1.0;
                EV2[1] = _xy;
                EV2[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV2", this._cEVAxes, EV2);
                _plot.addLabel("EV2", this._cEVAxes, EV2[1]);
                _xy = new double[3];
                EV3[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[2][0];
                _xy[1] = _EVCoord[2][2];
                _xy[2] = 1.0;
                EV3[1] = _xy;
                EV3[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV3", this._cEVAxes, EV3);
                _plot.addLabel("EV3", this._cEVAxes, EV3[1]);
            } else if (_dir == Visualize.ProjectionDirection.Z) {
                double[][] EV1 = new double[3][3];
                double[][] EV2 = new double[3][3];
                double[][] EV3 = new double[3][3];
                EV1[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[0][0];
                _xy[1] = _EVCoord[0][1];
                _xy[2] = 1.0;
                EV1[1] = _xy;
                EV1[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV1", this._cEVAxes, EV1);
                _plot.addLabel("EV1", this._cEVAxes, EV1[1]);
                _xy = new double[3];
                EV2[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[1][0];
                _xy[1] = _EVCoord[1][1];
                _xy[2] = 1.0;
                EV2[1] = _xy;
                EV2[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV2", this._cEVAxes, EV2);
                _plot.addLabel("EV2", this._cEVAxes, EV2[1]);
                _xy = new double[3];
                EV3[0] = new double[]{0.0, 0.0, 1.0};
                _xy[0] = _EVCoord[2][0];
                _xy[1] = _EVCoord[2][1];
                _xy[2] = 1.0;
                EV3[1] = _xy;
                EV3[2] = new double[]{0.0, 0.0, 1.0};
                _plot.addLinePlot("EV3", this._cEVAxes, EV3);
                _plot.addLabel("EV3", this._cEVAxes, EV3[1]);
            }
        }
        return _plot;
    }

    private void showCrystallographicAxes(boolean bShow) {
        if (this._VisualizePanel != null) {
            Component[] componentArray = this._VisualizePanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component _compJP = componentArray[n2];
                if (_compJP instanceof JPanel) {
                    Component[] componentArray2 = ((JPanel)_compJP).getComponents();
                    int n3 = componentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        LinkedList<Plotable> _plotableList;
                        LinkedList<Plot> _plotList;
                        Component _comp = componentArray2[n4];
                        if (_comp instanceof Plot3DPanel) {
                            Plot3DPanel _plot3D = (Plot3DPanel)_comp;
                            _plotList = _plot3D.getPlots();
                            for (Plot _plot : _plotList) {
                                if (_plot.getName() != "a" && _plot.getName() != "b") continue;
                                _plot.setVisible(bShow);
                            }
                            _plotableList = ((Plot3DPanel)_comp).getPlotables();
                            for (Plotable plotable : _plotableList) {
                                if (((org.math.plot.plotObjects.Label)plotable).getText() != "a" && ((org.math.plot.plotObjects.Label)plotable).getText() != "b") continue;
                                plotable.setVisible(bShow);
                            }
                            _plot3D.repaint();
                        } else if (_comp instanceof Plot2DPanel) {
                            Plot2DPanel _plot2D = (Plot2DPanel)_comp;
                            _plotList = _plot2D.getPlots();
                            for (Plot _plot : _plotList) {
                                if (_plot.getName() != "a" && _plot.getName() != "b") continue;
                                _plot.setVisible(bShow);
                            }
                            _plotableList = ((Plot2DPanel)_comp).getPlotables();
                            for (Plotable plotable : _plotableList) {
                                if (!(plotable instanceof org.math.plot.plotObjects.Label) || ((org.math.plot.plotObjects.Label)plotable).getText() != "a" && ((org.math.plot.plotObjects.Label)plotable).getText() != "b") continue;
                                plotable.setVisible(bShow);
                            }
                            _plot2D.repaint();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void showEV(boolean bShow) {
        if (this._VisualizePanel != null) {
            Component[] componentArray = this._VisualizePanel.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component _compJP = componentArray[n2];
                if (_compJP instanceof JPanel) {
                    Component[] componentArray2 = ((JPanel)_compJP).getComponents();
                    int n3 = componentArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        LinkedList<Plotable> _plotableList;
                        LinkedList<Plot> _plotList;
                        Component _comp = componentArray2[n4];
                        if (_comp instanceof Plot3DPanel) {
                            Plot3DPanel _plot3D = (Plot3DPanel)_comp;
                            _plotList = _plot3D.getPlots();
                            for (Plot _plot : _plotList) {
                                if (_plot.getName() != "EV1" && _plot.getName() != "EV2" && _plot.getName() != "EV3") continue;
                                _plot.setVisible(bShow);
                            }
                            _plotableList = ((Plot3DPanel)_comp).getPlotables();
                            for (Plotable plotable : _plotableList) {
                                if (((org.math.plot.plotObjects.Label)plotable).getText() != "EV1" && ((org.math.plot.plotObjects.Label)plotable).getText() != "EV2" && ((org.math.plot.plotObjects.Label)plotable).getText() != "EV3") continue;
                                plotable.setVisible(bShow);
                            }
                            _plot3D.repaint();
                        } else if (_comp instanceof Plot2DPanel) {
                            Plot2DPanel _plot2D = (Plot2DPanel)_comp;
                            _plotList = _plot2D.getPlots();
                            for (Plot _plot : _plotList) {
                                if (_plot.getName() != "EV1" && _plot.getName() != "EV2" && _plot.getName() != "EV3") continue;
                                _plot.setVisible(bShow);
                            }
                            _plotableList = ((Plot2DPanel)_comp).getPlotables();
                            for (Plotable plotable : _plotableList) {
                                if (!(plotable instanceof org.math.plot.plotObjects.Label) || ((org.math.plot.plotObjects.Label)plotable).getText() != "EV1" && ((org.math.plot.plotObjects.Label)plotable).getText() != "EV2" && ((org.math.plot.plotObjects.Label)plotable).getText() != "EV3") continue;
                                plotable.setVisible(bShow);
                            }
                            _plot2D.repaint();
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private JPanel returnSectionPanel() {
        JPanel rv = null;
        this._txtU1 = new JTextField();
        this._txtV1 = new JTextField();
        this._txtW1 = new JTextField();
        this._txtU2 = new JTextField();
        this._txtV2 = new JTextField();
        this._txtW2 = new JTextField();
        FormLayout layoutUVWPanel = new FormLayout("[25dlu,pref], 5dlu, [25dlu,pref], 5dlu, [25dlu,pref]", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layoutUVWPanel);
        builder.addLabel("u1", CC.xy((int)1, (int)1));
        builder.addLabel("v1", CC.xy((int)3, (int)1));
        builder.addLabel("w1", CC.xy((int)5, (int)1));
        builder.add((Component)this._txtU1, CC.xy((int)1, (int)3));
        builder.add((Component)this._txtV1, CC.xy((int)3, (int)3));
        builder.add((Component)this._txtW1, CC.xy((int)5, (int)3));
        builder.addLabel("u2", CC.xy((int)1, (int)5));
        builder.addLabel("v2", CC.xy((int)3, (int)5));
        builder.addLabel("w2", CC.xy((int)5, (int)5));
        builder.add((Component)this._txtU2, CC.xy((int)1, (int)7));
        builder.add((Component)this._txtV2, CC.xy((int)3, (int)7));
        builder.add((Component)this._txtW2, CC.xy((int)5, (int)7));
        JButton _btnDrawSectionPlot = new JButton(new actionDrawSectionPlot());
        builder.add((Component)_btnDrawSectionPlot, CC.xyw((int)1, (int)9, (int)5));
        rv = builder.build();
        return rv;
    }

    private static void replaceSectionPlot(JPanel _VisualizePanel, JPanel _plotScene) {
        try {
            if (_VisualizePanel != null && _VisualizePanel.getComponents() != null && _VisualizePanel.getComponents().length == 5) {
                _VisualizePanel.remove(4);
                _VisualizePanel.add((Component)_plotScene, "Section");
                CardLayout _cardLayout = (CardLayout)_VisualizePanel.getLayout();
                _cardLayout.show(_VisualizePanel, "Section");
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    public static void main(String[] args) {
        double[][] CTE_test = new double[3][3];
        CTE_test[0][0] = 1.2496E-5;
        CTE_test[0][1] = 0.0;
        CTE_test[0][2] = 0.0;
        CTE_test[1][0] = 0.0;
        CTE_test[1][1] = 1.2496E-5;
        CTE_test[1][2] = 0.0;
        CTE_test[2][0] = 0.0;
        CTE_test[2][1] = 0.0;
        CTE_test[2][2] = 1.2496E-5;
        ExpansionParams _expParams = new ExpansionParams();
        DataVisualizationWindow instance = new DataVisualizationWindow("TEV :: Thermal Expansion Visualizing", _expParams);
        instance.CTE = CTE_test;
        instance._crystalSystem = "Monoclinic";
        instance.sTemp = "25";
        instance.sTempUnit = "K";
        instance.buildInterface();
        instance.setSize(1040, 1040);
    }

    private class actionDefineSection
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionDefineSection() {
            super(DataVisualizationWindow.sSection);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DataVisualizationWindow.this._sectionPanel.setVisible(true);
            CardLayout _cardLayout = (CardLayout)DataVisualizationWindow.this._VisualizePanel.getLayout();
            _cardLayout.show(DataVisualizationWindow.this._VisualizePanel, "Section");
        }
    }

    private class actionDrawSectionPlot
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionDrawSectionPlot() {
            super("Draw section plot");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                if (!(DataVisualizationWindow.this._txtU1.getText().isEmpty() || DataVisualizationWindow.this._txtV1.getText().isEmpty() || DataVisualizationWindow.this._txtW1.getText().isEmpty())) {
                    if (!(DataVisualizationWindow.this._txtU2.getText().isEmpty() || DataVisualizationWindow.this._txtV2.getText().isEmpty() || DataVisualizationWindow.this._txtW2.getText().isEmpty())) {
                        int iU1 = Integer.parseInt(DataVisualizationWindow.this._txtU1.getText());
                        int iV1 = Integer.parseInt(DataVisualizationWindow.this._txtV1.getText());
                        int iW1 = Integer.parseInt(DataVisualizationWindow.this._txtW1.getText());
                        int[] uvw1 = new int[]{iU1, iV1, iW1};
                        int iU2 = Integer.parseInt(DataVisualizationWindow.this._txtU2.getText());
                        int iV2 = Integer.parseInt(DataVisualizationWindow.this._txtV2.getText());
                        int iW2 = Integer.parseInt(DataVisualizationWindow.this._txtW2.getText());
                        int[] uvw2 = new int[]{iU2, iV2, iW2};
                        String pUVW1 = String.valueOf(Integer.toString(iU1)) + Integer.toString(iV1) + Integer.toString(iW1);
                        String pUVW2 = String.valueOf(Integer.toString(iU2)) + Integer.toString(iV2) + Integer.toString(iW2);
                        if (!SectionPlotUtils.compareArrays(uvw1, uvw2)) {
                            if (DataVisualizationWindow.this._expParams != null) {
                                double[] vec1 = SectionPlotUtils.returnUVW2Ortho(uvw1, DataVisualizationWindow.this._expParams.getdTemp(), DataVisualizationWindow.this._expParams.getLattParamFunc(), DataVisualizationWindow.this._expParams.getCrystalSystem(), DataVisualizationWindow.this._expParams.getEVCrystal());
                                double[] vec2 = SectionPlotUtils.returnUVW2Ortho(uvw2, DataVisualizationWindow.this._expParams.getdTemp(), DataVisualizationWindow.this._expParams.getLattParamFunc(), DataVisualizationWindow.this._expParams.getCrystalSystem(), DataVisualizationWindow.this._expParams.getEVCrystal());
                                double[] xProd = SectionPlotUtils.returnCrossProduct(vec1, vec2);
                                double[] xProdNorm = SectionPlotUtils.returnNormalizedVector(xProd);
                                double[][] sectionCoords = SectionPlotUtils.generateCircleCoords(xProdNorm, vec1, vec2, DataVisualizationWindow.this._expParams.getEVCrystal());
                                double[][] _SectionPlane = SectionPlotUtils.rotateIntoSection(sectionCoords, xProdNorm);
                                JPanel _SectionPlotPanel = DataVisualizationWindow.this.set2DSectionPlot(_SectionPlane, pUVW1, pUVW2);
                                DataVisualizationWindow.replaceSectionPlot(DataVisualizationWindow.this._VisualizePanel, _SectionPlotPanel);
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, "<html>Values of [u<sub>1</sub>v<sub>1</sub>w<sub>1</sub>] and [u<sub>2</sub>v<sub>2</sub>w<sub>2</sub>] equal!</html>");
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "<html>Check [u<sub>2</sub>v<sub>2</sub>w<sub>2</sub>] values!</html>");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "<html>Check [u<sub>1</sub>v<sub>1</sub>w<sub>1</sub>] values!</html>");
                }
            }
            catch (NumberFormatException _nbrFormatEx) {
                JOptionPane.showMessageDialog(null, "[uvw] number format exception: " + _nbrFormatEx.getMessage());
            }
            catch (Exception _ex) {
                JOptionPane.showMessageDialog(null, "Draw section plot: " + _ex);
            }
        }
    }
}

