/*
 * Decompiled with CFR 0.152.
 */
package view;

import Jama.Matrix;
import au.com.bytecode.opencsv.CSVWriter;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import myObjects.ExpansionParams;
import myObjects.ObjHKL;
import myObjects.ObjUVW;
import myObjects.Polynom;
import myObjects.eCrystalSystem;
import myObjects.eLatticeName;
import myObjects.functions.IFunctions;
import myUtilities.CalcUVW_HKL;
import myUtilities.MathExpansionCoeff;
import myUtilities.TableColumnAdjuster;
import myUtilities.TableRowHeader;
import org.apache.log4j.Logger;
import view.DataVisualizationWindow;

public class CalcOverviewPresentationModel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Trigger trigger;
    private PresentationModel<ExpansionParams> _presModel;
    SelectionInList<IFunctions> _selInList;
    private DisplayPolynomTableAdapter _disTableAdapt;
    private InsertMatrixToJTable _ViewCTE;
    private InsertMatrixToJTable _ViewEigenValues;
    private InsertMatrixToJTable _ViewEigenVectors;
    private InsertMatrixToJTable _ViewAngleBasis;
    private InsertMatrixToJTable _ViewAngleCrys;
    private static boolean bDefaultCalc;
    final JTable _tableCTE;
    final JTable _tableEigenValues;
    final JTable _tableEigenVectors;
    final JTable table;
    JTable _tableAngleBasis;
    JTable _tableAngleCrys;
    final JTextField dTempTxtField;
    final double dTemp;
    final String sTempUnit;
    final JTextField _txtU;
    final JTextField _txtV;
    final JTextField _txtW;
    final JTextField _txtH;
    final JTextField _txtK;
    final JTextField _txtL;
    final JTextField _txtStartTemp;
    final JTextField _txtTargetTemp;
    final JTextField _txtTempInc;
    final JLabel lblDetEigenVector;
    final StringBuffer _strBuilder;
    final JRadioButton DecSepPoint;
    final JRadioButton DecSepComma;
    final ButtonGroup DecSepGroup;
    private static ArrayListModel<IFunctions> _listModelPoly;
    static Logger logger;

    static {
        logger = Logger.getLogger(CalcOverviewPresentationModel.class);
    }

    public CalcOverviewPresentationModel(ExpansionParams _expParams, boolean pFirstCall) {
        FormLayout layout = new FormLayout("left:max(60dlu;pref), 4dlu, [60dlu,pref], 4dlu, left:max(80dlu;pref), 4dlu, left:max(60dlu;pref), 4dlu, left:max(90dlu;pref)", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        DefaultFormBuilder _defFormBuilder = new DefaultFormBuilder(layout);
        bDefaultCalc = true;
        this.trigger = new Trigger();
        this._presModel = new PresentationModel((Object)_expParams, (ValueModel)this.trigger);
        this.dTemp = _expParams.getdTemp();
        BufferedValueModel dTempAdapter = this._presModel.getBufferedModel("dTemp");
        this.dTempTxtField = BasicComponentFactory.createFormattedTextField((ValueModel)dTempAdapter, (Format)new DecimalFormat("#0.00"));
        JButton _btnClac = new JButton(new actionCalculateCTE());
        JButton _btnCopy = new JButton(new actionCopyToClipboard());
        JButton _btnPlot = new JButton(new actionPlotCTE());
        this._strBuilder = new StringBuffer();
        String sTempLabel = "Temperature ";
        if (_expParams.getTempUnit() != null) {
            sTempLabel = String.valueOf(sTempLabel) + "[" + _expParams.getTempUnit() + "]";
            this.sTempUnit = _expParams.getTempUnit();
        } else {
            this.sTempUnit = "";
        }
        _defFormBuilder.addLabel(sTempLabel, CC.xy((int)1, (int)1));
        _defFormBuilder.add((Component)this.dTempTxtField, CC.xy((int)3, (int)1));
        _defFormBuilder.add((Component)_btnClac, CC.xy((int)5, (int)1));
        _defFormBuilder.add((Component)_btnCopy, CC.xy((int)5, (int)37));
        _defFormBuilder.add((Component)_btnPlot, CC.xy((int)7, (int)1));
        _defFormBuilder.add((Component)new JSeparator(), CC.xyw((int)1, (int)3, (int)7));
        List<IFunctions> _listPoly = _expParams.getLattParamFunc();
        this._selInList = new SelectionInList(_listPoly);
        this._disTableAdapt = new DisplayPolynomTableAdapter((ListModel<Polynom>)this._selInList, new String[]{"Lattice Params", "Order", "Function", "Calculated"}, this.dTemp);
        this.table = new JTable((TableModel)((Object)this._disTableAdapt));
        this.table.setAutoResizeMode(4);
        TableColumnAdjuster _tca = new TableColumnAdjuster(this.table);
        _tca.adjustColumns();
        this.table.setSelectionModel((ListSelectionModel)new SingleListSelectionAdapter(this._selInList.getSelectionIndexHolder()));
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        _defFormBuilder.add((Component)scrollPane, CC.xyw((int)1, (int)5, (int)7));
        _defFormBuilder.add((Component)new JSeparator(), CC.xyw((int)1, (int)7, (int)7));
        String sAddPolynom = "<html><strong>Tensor of the thermal expansion coefficients:</strong></html>";
        _defFormBuilder.addLabel(sAddPolynom, CC.xyw((int)1, (int)9, (int)7));
        double[][] CTE = _expParams.getEVCrystal();
        this._ViewCTE = new InsertMatrixToJTable(CTE);
        this._tableCTE = new JTable(this._ViewCTE);
        this._tableCTE.setPreferredScrollableViewportSize(this._tableCTE.getPreferredSize());
        _defFormBuilder.add((Component)this._tableCTE, CC.xyw((int)1, (int)11, (int)7));
        String sEVHead = "<html><strong>EigenValues</strong></html>";
        _defFormBuilder.add((Component)new JSeparator(), CC.xyw((int)1, (int)13, (int)7));
        _defFormBuilder.addLabel(sEVHead, CC.xyw((int)1, (int)15, (int)7));
        double[] _EV = _expParams.getEigenValues();
        double[][] _EV2ndT = new double[3][3];
        _EV2ndT[0][0] = _EV[0];
        _EV2ndT[1][1] = _EV[1];
        _EV2ndT[2][2] = _EV[2];
        this._ViewEigenValues = new InsertMatrixToJTable(_EV2ndT);
        this._tableEigenValues = new JTable(this._ViewEigenValues);
        this._tableEigenValues.setPreferredScrollableViewportSize(this._tableEigenValues.getPreferredSize());
        _defFormBuilder.add((Component)this._tableEigenValues, CC.xyw((int)1, (int)17, (int)7));
        String sEWHead = "<html><strong>EigenVectors</strong></html>";
        _defFormBuilder.addLabel(sEWHead, CC.xyw((int)1, (int)19, (int)7));
        double[][] _EW = _expParams.getEigenVector();
        this._ViewEigenVectors = new InsertMatrixToJTable(this.returnTransposedMatrice(_EW));
        this._tableEigenVectors = new JTable(this._ViewEigenVectors);
        this._tableEigenVectors.setPreferredScrollableViewportSize(this._tableEigenVectors.getPreferredSize());
        JScrollPane _paneEV = new JScrollPane(this._tableEigenVectors);
        _defFormBuilder.add((Component)_paneEV, CC.xyw((int)1, (int)21, (int)7));
        String sDet = "<html><strong>Determinant of EigenVector: </strong></html>";
        _defFormBuilder.addLabel(sDet, CC.xy((int)5, (int)23));
        this.lblDetEigenVector = new JLabel(Double.toString(_expParams.getDeterminantEigenvector()));
        _defFormBuilder.add((Component)this.lblDetEigenVector, CC.xy((int)5, (int)25));
        _defFormBuilder.add((Component)new JSeparator(), CC.xyw((int)1, (int)27, (int)7));
        double[][] _angleEVBasis = _expParams.getAngleEVBasis();
        double[][] _angleEVCrys = _expParams.getAngleEVCrys();
        this._txtU = new JTextField();
        this._txtV = new JTextField();
        this._txtW = new JTextField();
        this._txtH = new JTextField();
        this._txtK = new JTextField();
        this._txtL = new JTextField();
        this._txtStartTemp = new JTextField();
        this._txtTargetTemp = new JTextField();
        this._txtTempInc = new JTextField();
        FormLayout layoutUVWPanel = new FormLayout("[25dlu,pref], 5dlu, [25dlu,pref], 5dlu, [25dlu,pref]", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layoutUVWPanel);
        builder.addLabel("u", CC.xy((int)1, (int)1));
        builder.addLabel("v", CC.xy((int)3, (int)1));
        builder.addLabel("w", CC.xy((int)5, (int)1));
        builder.add((Component)this._txtU, CC.xy((int)1, (int)3));
        builder.add((Component)this._txtV, CC.xy((int)3, (int)3));
        builder.add((Component)this._txtW, CC.xy((int)5, (int)3));
        JButton _btnUVW = new JButton(new actionUVWAmp());
        builder.add((Component)_btnUVW, CC.xyw((int)1, (int)5, (int)5));
        FormLayout layoutHKLPanel = new FormLayout("[25dlu,pref], 5dlu, [25dlu,pref], 5dlu, [25dlu,pref]", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builderHKL = new PanelBuilder(layoutHKLPanel);
        builderHKL.addLabel("h", CC.xy((int)1, (int)1));
        builderHKL.addLabel("k", CC.xy((int)3, (int)1));
        builderHKL.addLabel("l", CC.xy((int)5, (int)1));
        builderHKL.add((Component)this._txtH, CC.xy((int)1, (int)3));
        builderHKL.add((Component)this._txtK, CC.xy((int)3, (int)3));
        builderHKL.add((Component)this._txtL, CC.xy((int)5, (int)3));
        JButton _btnHKL = new JButton(new actionHKLAmp());
        _btnHKL.setToolTipText("Amplitude along reciprocal lattice vector perpendicular to (hkl) plane");
        builderHKL.add((Component)_btnHKL, CC.xyw((int)1, (int)5, (int)5));
        FormLayout layoutTempIncPanel = new FormLayout("[25dlu,pref], 5dlu, [25dlu,pref], 5dlu, [25dlu,pref]", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builderTempInc = new PanelBuilder(layoutTempIncPanel);
        builderTempInc.addLabel("Start Temp.", CC.xy((int)1, (int)1));
        builderTempInc.addLabel("Target Temp.", CC.xy((int)3, (int)1));
        builderTempInc.addLabel("Temp. Inc.", CC.xy((int)5, (int)1));
        builderTempInc.add((Component)this._txtStartTemp, CC.xy((int)1, (int)3));
        builderTempInc.add((Component)this._txtTargetTemp, CC.xy((int)3, (int)3));
        builderTempInc.add((Component)this._txtTempInc, CC.xy((int)5, (int)3));
        JButton _btnTempInc = new JButton(new actionTempInc());
        _btnTempInc.setToolTipText("Calculate");
        builderTempInc.add((Component)_btnTempInc, CC.xyw((int)1, (int)5, (int)5));
        this.DecSepPoint = new JRadioButton("'.'");
        this.DecSepPoint.setSelected(true);
        this.DecSepPoint.setBackground(Color.WHITE);
        this.DecSepComma = new JRadioButton("','");
        this.DecSepComma.setBackground(Color.WHITE);
        this.DecSepGroup = new ButtonGroup();
        this.DecSepGroup.add(this.DecSepPoint);
        this.DecSepGroup.add(this.DecSepComma);
        if (_angleEVBasis != null && _angleEVCrys != null) {
            String sAnglesBasis = "<html><strong>Angles [degrees] between principal (EV1, EV2, EV3) and cartesian axes (e1, e2, e3)</strong></html>";
            _defFormBuilder.addLabel(sAnglesBasis, CC.xyw((int)1, (int)29, (int)7));
            this._ViewAngleBasis = new InsertMatrixToJTable(this.returnTransposedMatrice(_angleEVBasis));
            this._tableAngleBasis = new JTable(this._ViewAngleBasis);
            this._tableAngleBasis.setPreferredScrollableViewportSize(this._tableAngleBasis.getPreferredSize());
            JScrollPane _pane = new JScrollPane(this._tableAngleBasis);
            _pane.setRowHeader(new TableRowHeader(this._tableAngleBasis, _pane, true));
            _defFormBuilder.add((Component)_pane, CC.xyw((int)1, (int)31, (int)7));
            String sAnglesCrys = "<html><strong>Angles [degrees] between principal axes (EV1, EV2, EV3) and crystallographic axes</strong></html>";
            _defFormBuilder.addLabel(sAnglesCrys, CC.xyw((int)1, (int)33, (int)7));
            this._ViewAngleCrys = new InsertMatrixToJTable(this.returnTransposedMatrice(_angleEVCrys));
            this._tableAngleCrys = new JTable(this._ViewAngleCrys);
            this._tableAngleCrys.setPreferredScrollableViewportSize(this._tableAngleCrys.getPreferredSize());
            JScrollPane _paneCrys = new JScrollPane(this._tableAngleCrys);
            _paneCrys.setRowHeader(new TableRowHeader(this._tableAngleCrys, _paneCrys, false));
            _defFormBuilder.add((Component)_paneCrys, CC.xyw((int)1, (int)35, (int)7));
            _defFormBuilder.add((Component)new JSeparator(), CC.xyw((int)1, (int)39, (int)7));
            String sCalcTempRange = "<html><strong>Sequential determination in a temperature range:</strong></html>";
            _defFormBuilder.addLabel(sCalcTempRange, CC.xy((int)9, (int)7));
            JPanel pDecSep = new JPanel();
            String sDecimalSeparator = "<html>Set datafile decimal separator:</html>";
            pDecSep.add(new JLabel(sDecimalSeparator));
            pDecSep.add(this.DecSepPoint);
            pDecSep.add(this.DecSepComma);
            _defFormBuilder.add((Component)pDecSep, CC.xy((int)9, (int)9));
            _defFormBuilder.add((Component)builderTempInc.getPanel(), CC.xywh((int)9, (int)11, (int)1, (int)5));
            _defFormBuilder.add((Component)builder.getPanel(), CC.xy((int)9, (int)31));
            _defFormBuilder.add((Component)builderHKL.getPanel(), CC.xy((int)9, (int)35));
        } else {
            String sDecimalSeparator = "<html><strong>Set Decimal separator:</strong></html>";
            _defFormBuilder.addLabel(sDecimalSeparator, CC.xyw((int)1, (int)29, (int)7));
            _defFormBuilder.add((Component)this.DecSepPoint, CC.xyw((int)1, (int)31, (int)2));
            _defFormBuilder.add((Component)this.DecSepComma, CC.xyw((int)3, (int)31, (int)2));
            String sCalcTempRange = "<html><strong>Sequential determination in a temperature range:</strong></html>";
            _defFormBuilder.addLabel(sCalcTempRange, CC.xyw((int)1, (int)33, (int)7));
            _defFormBuilder.add((Component)builderTempInc.getPanel(), CC.xyw((int)1, (int)35, (int)7));
            _defFormBuilder.add((Component)builder.getPanel(), CC.xyw((int)1, (int)37, (int)7));
            _defFormBuilder.add((Component)builderHKL.getPanel(), CC.xyw((int)1, (int)39, (int)7));
        }
        JScrollPane _scrollWrapper = new JScrollPane(_defFormBuilder.getPanel(), 20, 30);
        _scrollWrapper.setBorder(BorderFactory.createEmptyBorder());
        this.add(_scrollWrapper);
    }

    public double[][] returnTransposedMatrice(double[][] _pM) {
        Matrix _m = new Matrix(_pM);
        Matrix _mTrans = _m.transpose();
        double[][] dMTranspose = _mTrans.getArrayCopy();
        return dMTranspose;
    }

    private String formatDigit(double _n) {
        String rv = "";
        try {
            rv = this.DecSepPoint.isSelected() ? Double.toString(_n) : Double.toString(_n).replace('.', ',');
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    public static void main(String[] a) {
        ExpansionParams _expParams = new ExpansionParams(25.0);
        _expParams.setCrystalSystem(eCrystalSystem.Tetragonal);
        double[] aCoeff = new double[]{11.0, 0.012, 1.3E-4};
        Polynom aPoly = new Polynom(aCoeff, eLatticeName.a);
        double[] bCoeff = new double[]{21.0, 0.022, 2.3E-4};
        Polynom bPoly = new Polynom(bCoeff, eLatticeName.b);
        double[] cCoeff = new double[]{31.0, 0.032, 3.3E-4};
        Polynom cPoly = new Polynom(bCoeff, eLatticeName.c);
        ArrayList<IFunctions> _listPoly = new ArrayList<IFunctions>();
        _listModelPoly = new ArrayListModel();
        _listPoly.add(aPoly);
        _listPoly.add(bPoly);
        _listPoly.add(cPoly);
        _expParams.setLattParamFunc(_listPoly);
        _listModelPoly.add((Object)aPoly);
        _listModelPoly.add((Object)bPoly);
        _listModelPoly.add((Object)cPoly);
        double[][] CTE = new double[3][3];
        CTE[0][0] = 10.17;
        CTE[0][1] = 2.58;
        CTE[0][2] = 0.0;
        CTE[1][0] = CTE[0][1];
        CTE[1][1] = 11.03;
        CTE[1][2] = 0.0;
        CTE[2][0] = CTE[0][2];
        CTE[2][1] = CTE[1][2];
        CTE[2][2] = 8.76;
        double[] _EV = new double[]{-4.67, 16.99, 2.1};
        double[][] _EW = new double[3][3];
        _EW[0][0] = 0.97;
        _EW[0][1] = 0.13;
        _EW[0][2] = 0.2;
        _EW[1][0] = -9.0E-4;
        _EW[1][1] = 0.83;
        _EW[1][2] = -0.56;
        _EW[2][0] = -0.24;
        _EW[2][1] = 0.54;
        _EW[2][2] = 0.8;
        _expParams.setEVCrystal(CTE);
        _expParams.setEigenValues(_EV);
        _expParams.setEigenVector(_EW);
        _expParams.setDeterminantEigenvector(-15.0);
        JFrame f = new JFrame("Buffering Presentation Model Example");
        f.setDefaultCloseOperation(2);
        f.add(new CalcOverviewPresentationModel(_expParams, true));
        f.pack();
        f.setVisible(true);
    }

    private class DisplayPolynomTableAdapter
    extends AbstractTableAdapter<Polynom> {
        private static final long serialVersionUID = 1L;
        private double dTemp;

        public DisplayPolynomTableAdapter(ListModel<Polynom> listModel, String[] columnNames, double pTemp) {
            super(listModel, columnNames);
            this.dTemp = pTemp;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            IFunctions displayPolynom = (IFunctions)this.getRow(rowIndex);
            if (columnIndex == 0) {
                return displayPolynom.getParam();
            }
            if (columnIndex == 1) {
                return displayPolynom.getDegree();
            }
            if (columnIndex == 2) {
                return displayPolynom.toString();
            }
            if (columnIndex == 3) {
                return MathExpansionCoeff.formatDouble(displayPolynom.getValue(this.dTemp));
            }
            return null;
        }
    }

    public static class InsertMatrixToJTable
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private double[][] matrice_normalise;

        public InsertMatrixToJTable(double[][] matrice_normalise) {
            this.matrice_normalise = matrice_normalise;
        }

        public InsertMatrixToJTable(double[][] matrice_normalise, boolean _doTranspose) {
            this.matrice_normalise = matrice_normalise;
        }

        @Override
        public int getRowCount() {
            return this.matrice_normalise.length;
        }

        @Override
        public int getColumnCount() {
            return this.matrice_normalise.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.matrice_normalise[rowIndex][columnIndex];
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "EV1";
                }
                case 1: {
                    return "EV2";
                }
                case 2: {
                    return "EV3";
                }
            }
            return "text";
        }
    }

    private class actionCalculateCTE
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionCalculateCTE() {
            super("Calculate TE");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                CalcOverviewPresentationModel.this.trigger.triggerCommit();
                double dTemp = (Double)CalcOverviewPresentationModel.this._presModel.getValue("dTemp");
                ExpansionParams _expParams = (ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean());
                CalcOverviewPresentationModel.this._disTableAdapt = new DisplayPolynomTableAdapter((ListModel<Polynom>)CalcOverviewPresentationModel.this._selInList, new String[]{"Lattice Params", "Order", "Polynomial", "Calculated"}, dTemp);
                CalcOverviewPresentationModel.this.table.setModel((TableModel)((Object)CalcOverviewPresentationModel.this._disTableAdapt));
                CalcOverviewPresentationModel.this.table.setAutoResizeMode(4);
                TableColumnAdjuster _tca = new TableColumnAdjuster(CalcOverviewPresentationModel.this.table);
                _tca.adjustColumns();
                CalcOverviewPresentationModel.this.table.setSelectionModel((ListSelectionModel)new SingleListSelectionAdapter(CalcOverviewPresentationModel.this._selInList.getSelectionIndexHolder()));
                CalcOverviewPresentationModel.this.table.setPreferredScrollableViewportSize(CalcOverviewPresentationModel.this.table.getPreferredSize());
                CalcOverviewPresentationModel.this.table.revalidate();
                CalcOverviewPresentationModel.this.table.repaint();
                CalcOverviewPresentationModel.this._disTableAdapt.fireTableDataChanged();
                MathExpansionCoeff _mathExp = new MathExpansionCoeff();
                ExpansionParams _newBean = _mathExp.returnCalcExpansionParams(dTemp, _expParams);
                CalcOverviewPresentationModel.this._ViewCTE.matrice_normalise = _newBean.getEVCrystal();
                CalcOverviewPresentationModel.this._ViewCTE.fireTableStructureChanged();
                double[] _EV = _newBean.getEigenValues();
                double[][] _EV2ndT = new double[3][3];
                _EV2ndT[0][0] = _EV[0];
                _EV2ndT[1][1] = _EV[1];
                _EV2ndT[2][2] = _EV[2];
                CalcOverviewPresentationModel.this._ViewEigenValues.matrice_normalise = _EV2ndT;
                CalcOverviewPresentationModel.this._ViewEigenValues.fireTableStructureChanged();
                CalcOverviewPresentationModel.this._ViewEigenVectors.matrice_normalise = CalcOverviewPresentationModel.this.returnTransposedMatrice(_newBean.getEigenVector());
                CalcOverviewPresentationModel.this._ViewEigenVectors.fireTableStructureChanged();
                if (_newBean.getCrystalSystem() == eCrystalSystem.Triclinic || _newBean.getCrystalSystem() == eCrystalSystem.Monoclinic) {
                    CalcOverviewPresentationModel.this._ViewAngleBasis.matrice_normalise = CalcOverviewPresentationModel.this.returnTransposedMatrice(_newBean.getAngleEVBasis());
                    CalcOverviewPresentationModel.this._ViewAngleBasis.fireTableStructureChanged();
                    CalcOverviewPresentationModel.this._ViewAngleCrys.matrice_normalise = CalcOverviewPresentationModel.this.returnTransposedMatrice(_newBean.getAngleEVCrys());
                    CalcOverviewPresentationModel.this._ViewAngleCrys.fireTableStructureChanged();
                }
                CalcOverviewPresentationModel.this.lblDetEigenVector.setText(Double.toString(_newBean.getDeterminantEigenvector()));
                CalcOverviewPresentationModel.this.lblDetEigenVector.validate();
            }
            catch (Exception _ex) {
                logger.error((Object)_ex);
            }
        }
    }

    private class actionCopyToClipboard
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionCopyToClipboard() {
            super("Copy to Clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ExpansionParams _expParams = (ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean());
            List<IFunctions> _polyList = _expParams.getLattParamFunc();
            String sDelimiter = "####################";
            if (CalcOverviewPresentationModel.this.table != null && CalcOverviewPresentationModel.this._tableCTE != null && CalcOverviewPresentationModel.this.dTempTxtField != null) {
                int i;
                if (bDefaultCalc) {
                    i = 0;
                    while (i < CalcOverviewPresentationModel.this.table.getRowCount()) {
                        String sRegParamESU;
                        CalcOverviewPresentationModel.this._strBuilder.append(CalcOverviewPresentationModel.this.table.getValueAt(i, 0) + "\t" + CalcOverviewPresentationModel.this.table.getValueAt(i, 2) + "\n");
                        IFunctions _poly = _polyList.get(i);
                        if (_poly != null && (sRegParamESU = _poly.getESU()) != null) {
                            CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sRegParamESU) + "\n \n");
                        }
                        ++i;
                    }
                    bDefaultCalc = false;
                }
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                CalcOverviewPresentationModel.this._strBuilder.append("Temp.: " + CalcOverviewPresentationModel.this.dTempTxtField.getText() + CalcOverviewPresentationModel.this.sTempUnit + "\n");
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                if (!CalcOverviewPresentationModel.this.sTempUnit.isEmpty()) {
                    CalcOverviewPresentationModel.this._strBuilder.append("CTE [1/" + CalcOverviewPresentationModel.this.sTempUnit + "]\n");
                }
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                i = 0;
                while (i < CalcOverviewPresentationModel.this._tableCTE.getRowCount()) {
                    CalcOverviewPresentationModel.this._strBuilder.append(CalcOverviewPresentationModel.this._tableCTE.getValueAt(i, 0) + "\t" + CalcOverviewPresentationModel.this._tableCTE.getValueAt(i, 1) + "\t" + CalcOverviewPresentationModel.this._tableCTE.getValueAt(i, 2) + "\n");
                    ++i;
                }
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                CalcOverviewPresentationModel.this._strBuilder.append("\n");
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                CalcOverviewPresentationModel.this._strBuilder.append("EigenValues\n");
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                i = 0;
                while (i < CalcOverviewPresentationModel.this._tableEigenValues.getRowCount()) {
                    CalcOverviewPresentationModel.this._strBuilder.append(CalcOverviewPresentationModel.this._tableEigenValues.getValueAt(i, 0) + "\t" + CalcOverviewPresentationModel.this._tableEigenValues.getValueAt(i, 1) + "\t" + CalcOverviewPresentationModel.this._tableEigenValues.getValueAt(i, 2) + "\n");
                    ++i;
                }
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                CalcOverviewPresentationModel.this._strBuilder.append("\n");
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                CalcOverviewPresentationModel.this._strBuilder.append("EigenVectors\n");
                CalcOverviewPresentationModel.this._strBuilder.append("EV1 \t EV2 \t EV3 \t\n");
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                i = 0;
                while (i < CalcOverviewPresentationModel.this._tableEigenVectors.getRowCount()) {
                    CalcOverviewPresentationModel.this._strBuilder.append(CalcOverviewPresentationModel.this._tableEigenVectors.getValueAt(i, 0) + "\t" + CalcOverviewPresentationModel.this._tableEigenVectors.getValueAt(i, 1) + "\t" + CalcOverviewPresentationModel.this._tableEigenVectors.getValueAt(i, 2) + "\n");
                    ++i;
                }
                CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                if (CalcOverviewPresentationModel.this._tableAngleBasis != null && CalcOverviewPresentationModel.this._tableAngleCrys != null) {
                    CalcOverviewPresentationModel.this._strBuilder.append("\n");
                    CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                    CalcOverviewPresentationModel.this._strBuilder.append("Angles [degrees] between principal axes (EV1, EV2, EV3) and cartesian axes (e1, e2, e3) \n");
                    CalcOverviewPresentationModel.this._strBuilder.append("\t EV1 \t EV2 \t EV3 \t\n");
                    CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                    i = 0;
                    while (i < CalcOverviewPresentationModel.this._tableAngleBasis.getRowCount()) {
                        CalcOverviewPresentationModel.this._strBuilder.append("e" + Integer.toString(i + 1) + "\t" + CalcOverviewPresentationModel.this._tableAngleBasis.getValueAt(i, 0) + "\t" + CalcOverviewPresentationModel.this._tableAngleBasis.getValueAt(i, 1) + "\t" + CalcOverviewPresentationModel.this._tableAngleBasis.getValueAt(i, 2) + "\n");
                        ++i;
                    }
                    CalcOverviewPresentationModel.this._strBuilder.append("\n");
                    CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                    CalcOverviewPresentationModel.this._strBuilder.append("Angles [degrees] between principal axes (EV1, EV2, EV3) and crystallographic axes\n");
                    CalcOverviewPresentationModel.this._strBuilder.append("\t EV1 \t EV2 \t EV3 \t\n");
                    CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sDelimiter) + "\n");
                    i = 0;
                    while (i < CalcOverviewPresentationModel.this._tableAngleCrys.getRowCount()) {
                        String sAxis = "a";
                        if (i == 1) {
                            sAxis = "b";
                        } else if (i == 2) {
                            sAxis = "c";
                        }
                        CalcOverviewPresentationModel.this._strBuilder.append(String.valueOf(sAxis) + "\t" + CalcOverviewPresentationModel.this._tableAngleCrys.getValueAt(i, 0) + "\t" + CalcOverviewPresentationModel.this._tableAngleCrys.getValueAt(i, 1) + "\t" + CalcOverviewPresentationModel.this._tableAngleCrys.getValueAt(i, 2) + "\n");
                        ++i;
                    }
                    CalcOverviewPresentationModel.this._strBuilder.append("\n");
                }
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection _strSel = new StringSelection(CalcOverviewPresentationModel.this._strBuilder.toString());
                clpbrd.setContents(_strSel, null);
            }
        }
    }

    private class actionHKLAmp
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionHKLAmp() {
            super("Amplitude along reciprocal lattice vector perpendicular to (hkl) plane");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                double[][] CTE;
                int iL;
                int iK;
                int iH;
                int[] hkl;
                ObjHKL _objHKL;
                List<IFunctions> _listPoly = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getLattParamFunc();
                eCrystalSystem _eCrystalSystem = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getCrystalSystem();
                if (!(_listPoly == null || CalcOverviewPresentationModel.this._txtH.getText().isEmpty() || CalcOverviewPresentationModel.this._txtK.getText().isEmpty() || CalcOverviewPresentationModel.this._txtL.getText().isEmpty() || (_objHKL = CalcUVW_HKL.returnObjHKL(hkl = new int[]{iH = Integer.parseInt(CalcOverviewPresentationModel.this._txtH.getText()), iK = Integer.parseInt(CalcOverviewPresentationModel.this._txtK.getText()), iL = Integer.parseInt(CalcOverviewPresentationModel.this._txtL.getText())}, CalcOverviewPresentationModel.this.dTemp, _listPoly, _eCrystalSystem, CTE = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getEVCrystal())) == null)) {
                    JOptionPane.showConfirmDialog(null, "Amplitude along reciprocal lattice vector perpendicular to (" + CalcOverviewPresentationModel.this._txtH.getText() + CalcOverviewPresentationModel.this._txtK.getText() + CalcOverviewPresentationModel.this._txtL.getText() + ") plane: " + Double.toString(_objHKL.getHKLAmp()), null, -1);
                }
            }
            catch (NumberFormatException _nbrFormatEx) {
                logger.error((Object)("(hkl) number format exception: " + _nbrFormatEx.getMessage()));
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
            }
        }
    }

    private class actionPlotCTE
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionPlotCTE() {
            super("Plot TE");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DataVisualizationWindow instance = new DataVisualizationWindow("TEV :: Thermal Expansion Visualizing", (ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean()));
            instance.CTE = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getEVCrystal();
            instance._crystalSystem = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getCrystalSystem().toString();
            double dTemp = (Double)CalcOverviewPresentationModel.this._presModel.getValue("dTemp");
            instance.sTemp = String.valueOf(dTemp);
            instance.sTempUnit = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getTempUnit();
            if (((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getCrystallographicAxesCoord() != null) {
                instance.CrysAxesCoords = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getCrystallographicAxesCoord();
            }
            if (((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getEigenVector() != null) {
                Matrix _m = new Matrix(((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getEigenVector());
                Matrix _mTrans = _m.transpose();
                double[][] dMTranspose = _mTrans.getArrayCopy();
                dMTranspose = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getEigenVector();
                double[][] dNew = new double[dMTranspose.length][dMTranspose[0].length + 1];
                int i = 0;
                while (i < dMTranspose.length) {
                    int j = 0;
                    while (j < dMTranspose[0].length) {
                        if (j == dMTranspose[0].length - 1) {
                            dNew[i][j] = dMTranspose[i][j];
                            dNew[i][dMTranspose[0].length] = 1.0;
                        } else {
                            dNew[i][j] = dMTranspose[i][j];
                        }
                        ++j;
                    }
                    ++i;
                }
                instance.EVCoords = dNew;
            }
            instance.buildInterface();
            instance.setSize(1090, 950);
            CalcOverviewPresentationModel.this.trigger.triggerCommit();
        }
    }

    private class actionTempInc
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionTempInc() {
            super("Calculate");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                List<IFunctions> _listPoly = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getLattParamFunc();
                eCrystalSystem _eCrystalSystem = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getCrystalSystem();
                if (!(_listPoly == null || CalcOverviewPresentationModel.this._txtStartTemp.getText().isEmpty() || CalcOverviewPresentationModel.this._txtTargetTemp.getText().isEmpty() || CalcOverviewPresentationModel.this._txtTempInc.getText().isEmpty())) {
                    CalcOverviewPresentationModel.this.trigger.triggerCommit();
                    double dTemp = (Double)CalcOverviewPresentationModel.this._presModel.getValue("dTemp");
                    JFrame parentFrame = new JFrame();
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setDialogTitle("Specify a file to save");
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("CSV File (*.csv)", "csv");
                    fileChooser.setFileFilter(filter);
                    int userSelection = fileChooser.showSaveDialog(parentFrame);
                    if (userSelection == 0) {
                        File fileToSave = fileChooser.getSelectedFile();
                        System.out.println("Save as file: " + fileToSave.getAbsolutePath());
                        double dStarttemp = Double.parseDouble(CalcOverviewPresentationModel.this._txtStartTemp.getText());
                        double dTargettemp = Double.parseDouble(CalcOverviewPresentationModel.this._txtTargetTemp.getText());
                        double dTempInc = Double.parseDouble(CalcOverviewPresentationModel.this._txtTempInc.getText());
                        if (dTargettemp < dStarttemp) {
                            throw new Exception("Check values for start and target temperature");
                        }
                        int iSteps = (int)((dTargettemp - dStarttemp) / dTempInc);
                        ExpansionParams _newBean = null;
                        ExpansionParams _expParams = (ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean());
                        MathExpansionCoeff _mathExp = new MathExpansionCoeff();
                        double dCalcTemp = dStarttemp;
                        Date dt = new Date();
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                        String sFileName = fileToSave.getAbsolutePath();
                        if (!sFileName.endsWith(".csv")) {
                            sFileName = String.valueOf(sFileName) + ".csv";
                        }
                        CSVWriter writer = new CSVWriter((Writer)new FileWriter(sFileName), ';', '\u0000');
                        List<IFunctions> _polyList = _expParams.getLattParamFunc();
                        String[] entries = null;
                        int i = 0;
                        while (i <= iSteps) {
                            _newBean = _mathExp.returnCalcExpansionParams(dCalcTemp, _expParams);
                            boolean bIsOrtho = true;
                            double[][] _angleEVBasis = null;
                            double[][] _angleEVCrys = null;
                            double[] _dEV = null;
                            if (_newBean.getCrystalSystem() == eCrystalSystem.Triclinic || _newBean.getCrystalSystem() == eCrystalSystem.Monoclinic) {
                                bIsOrtho = false;
                                _angleEVBasis = _newBean.getAngleEVBasis();
                                _angleEVCrys = _newBean.getAngleEVCrys();
                                _dEV = _newBean.getEigenValues();
                            }
                            double[][] _cte = _newBean.getEVCrystal();
                            if (i == 0) {
                                String sHeader = "Temp [" + _newBean.getTempUnit() + "];alpha_11;alpha_22;alpha_33;alpha_12;alpha_13;alpha_23;";
                                if (!bIsOrtho) {
                                    sHeader = String.valueOf(sHeader) + "EV1;EV2;EV3;";
                                    sHeader = String.valueOf(sHeader) + "EV1<e1;EV1<e2;EV1<e3;EV2<e1;EV2<e2;EV2<e3;EV3<e1;EV3<e2;EV3<e3;";
                                    sHeader = String.valueOf(sHeader) + "EV1<a;EV1<b;EV1<c;EV2<a;EV2<b;EV2<c;EV3<a;EV3<b;EV3<c";
                                }
                                entries = sHeader.split(";");
                                writer.writeNext(entries);
                            }
                            String sCTE = String.valueOf(CalcOverviewPresentationModel.this.formatDigit(dCalcTemp)) + ";" + CalcOverviewPresentationModel.this.formatDigit(_cte[0][0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_cte[1][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_cte[2][2]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_cte[0][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_cte[0][2]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_cte[1][2]);
                            if (!bIsOrtho) {
                                System.out.println(String.valueOf(CalcOverviewPresentationModel.this.formatDigit(_dEV[0])) + "\n");
                                sCTE = String.valueOf(sCTE) + ";" + CalcOverviewPresentationModel.this.formatDigit(_dEV[0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_dEV[1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_dEV[2]);
                                sCTE = String.valueOf(sCTE) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[0][0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[1][0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[2][0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[0][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[1][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[2][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[0][2]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[1][2]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVBasis[2][2]);
                                sCTE = String.valueOf(sCTE) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[0][0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[1][0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[2][0]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[0][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[1][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[2][1]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[0][2]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[1][2]) + ";" + CalcOverviewPresentationModel.this.formatDigit(_angleEVCrys[2][2]);
                            }
                            entries = sCTE.split(";");
                            dCalcTemp += dTempInc;
                            writer.writeNext(entries);
                            ++i;
                        }
                        CalcOverviewPresentationModel.this._presModel.setValue("dTemp", (Object)dTemp);
                        JOptionPane.showConfirmDialog(null, "File successfully saved!", null, -1);
                        writer.close();
                    } else if (userSelection == 1) {
                        throw new Exception("Export cancelled by user!");
                    }
                }
            }
            catch (NumberFormatException _nbrFormatEx) {
                logger.error((Object)("Number format exception: " + _nbrFormatEx.getMessage()));
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
            }
        }
    }

    private class actionUVWAmp
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public actionUVWAmp() {
            super("Amplitude along [uvw]");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                double[][] CTE;
                int iW;
                int iV;
                int iU;
                int[] uvw;
                ObjUVW _objUVW;
                List<IFunctions> _listPoly = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getLattParamFunc();
                eCrystalSystem _eCrystalSystem = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getCrystalSystem();
                if (!(_listPoly == null || CalcOverviewPresentationModel.this._txtU.getText().isEmpty() || CalcOverviewPresentationModel.this._txtV.getText().isEmpty() || CalcOverviewPresentationModel.this._txtW.getText().isEmpty() || (_objUVW = CalcUVW_HKL.returnObjUVW(uvw = new int[]{iU = Integer.parseInt(CalcOverviewPresentationModel.this._txtU.getText()), iV = Integer.parseInt(CalcOverviewPresentationModel.this._txtV.getText()), iW = Integer.parseInt(CalcOverviewPresentationModel.this._txtW.getText())}, CalcOverviewPresentationModel.this.dTemp, _listPoly, _eCrystalSystem, CTE = ((ExpansionParams)((Object)CalcOverviewPresentationModel.this._presModel.getBean())).getEVCrystal())) == null)) {
                    JOptionPane.showConfirmDialog(null, "Amplitude along direction [" + CalcOverviewPresentationModel.this._txtU.getText() + CalcOverviewPresentationModel.this._txtV.getText() + CalcOverviewPresentationModel.this._txtW.getText() + "]: " + Double.toString(_objUVW.getUVWAmp()), null, -1);
                }
            }
            catch (NumberFormatException _nbrFormatEx) {
                logger.error((Object)("[uvw] number format exception: " + _nbrFormatEx.getMessage()));
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
            }
        }
    }
}

