/*
 * Decompiled with CFR 0.152.
 */
package view;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class About
extends JFrame {
    private static final long serialVersionUID = 1L;
    private BufferedImage UniLogo;
    static Logger logger = Logger.getLogger(About.class);

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new About().setVisible(true);
            }
        });
    }

    public About() {
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.setSize(420, 300);
        this.setResizable(false);
        FormLayout layout = new FormLayout("20dlu,left:50dlu,10dlu,left:0:grow", "20dlu, top:p,20dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        JLabel _label = new JLabel();
        String _txt = "<html><body><div><p>Institute of Mineralogy and Petrography,<br>Applied Mineralogy &amp; Crystallography Group,<br>University of Innsbruck,<br>Innrain 52,<br>A-6020 Innsbruck, Austria<br></p><br><p>Author: Thomas Langreiter<br><a href='mailto:tev-mineralogy@uibk.ac.at'>tev-mineralogy@uibk.ac.at</a></p></div></body></html>";
        _label.setText(_txt);
        JButton btnMailTo = new JButton();
        btnMailTo.addActionListener(new OpenUrlAction());
        btnMailTo.setText("<HTML>Send email</HTML>");
        builder.add((Component)_label, cc.xy(4, 2));
        builder.add((Component)btnMailTo, cc.xy(4, 3));
        this.loadUniLogo();
        if (this.UniLogo != null) {
            JLabel _gLabel = new JLabel(new ImageIcon(this.UniLogo));
            builder.add((Component)_gLabel, cc.xyw(2, 2, 2));
        }
        this.setContentPane(builder.getPanel());
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void loadUniLogo() {
        try {
            this.UniLogo = ImageIO.read(About.class.getResourceAsStream("icons/Uni_Logo_4C.jpg"));
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    class OpenUrlAction
    implements ActionListener {
        OpenUrlAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Desktop desktop = Desktop.getDesktop();
            String message = "mailto:tev-mineralogy@uibk.ac.at?subject=[TEV%20Application%20Request]";
            URI uri = URI.create(message);
            try {
                desktop.mail(uri);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

