/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.math.plot.utils.FastMath;

public class Array {
    public static HashMap<Double, String> reverseStringMap(HashMap<String, Double> map) {
        if (map == null) {
            return null;
        }
        HashMap<Double, String> reverseMap = new HashMap<Double, String>();
        for (String key : map.keySet()) {
            reverseMap.put(map.get(key), key);
        }
        return reverseMap;
    }

    private static HashMap<String, Double> mapStringArray(double minvalue, double step, List<String> array) {
        if (array == null) {
            return null;
        }
        Collections.sort(array);
        HashMap<String, Double> map = new HashMap<String, Double>(array.size());
        double v = minvalue;
        for (String string : array) {
            if (map.containsKey(string)) continue;
            map.put(string, v);
            v += step;
        }
        return map;
    }

    public static boolean equals(double[] x, double[] y) {
        if (x.length != y.length) {
            return false;
        }
        int i = 0;
        while (i < y.length) {
            if (x[i] != y[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toString(HashMap hash) {
        StringBuffer sb = new StringBuffer();
        for (Object key : hash.keySet()) {
            sb.append(key + " > " + hash.get(key) + "\n");
        }
        return sb.toString();
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException ne) {
            return false;
        }
        return true;
    }

    public static HashMap<String, Double> mapStringArray(List<String> array) {
        return Array.mapStringArray(0.0, 1.0, array);
    }

    public static String cat(Object[] array) {
        return Array.cat(" ", array);
    }

    public static String cat(String separator, Object[] array) {
        String o = "";
        int i = 0;
        while (i < array.length - 1) {
            o = String.valueOf(o) + array[i].toString() + separator;
            ++i;
        }
        o = String.valueOf(o) + array[array.length - 1].toString();
        return o;
    }

    public static String cat(String columnsSeparator, String rowsSeparator, Object[][] array) {
        String o = "";
        int i = 0;
        while (i < array.length - 1) {
            o = String.valueOf(o) + Array.cat(columnsSeparator, array[i]) + rowsSeparator;
            ++i;
        }
        o = String.valueOf(o) + Array.cat(columnsSeparator, array[array.length - 1]);
        return o;
    }

    public static String cat(Object[][] array) {
        return Array.cat(" ", "\n", array);
    }

    public static String[] duplicate(int m, String c) {
        String[] o = new String[m];
        int i = 0;
        while (i < o.length) {
            o[i] = c;
            ++i;
        }
        return o;
    }

    public static int[] duplicate(int m, int c) {
        int[] o = new int[m];
        int i = 0;
        while (i < o.length) {
            o[i] = c;
            ++i;
        }
        return o;
    }

    public static double[][] one(int m, int n) {
        return Array.one(m, n, 1.0);
    }

    public static double[][] one(int m, int n, double c) {
        double[][] o = new double[m][n];
        int i = 0;
        while (i < o.length) {
            int j = 0;
            while (j < o[i].length) {
                o[i][j] = c;
                ++j;
            }
            ++i;
        }
        return o;
    }

    public static double[] one(int m) {
        return Array.one(m, 1.0);
    }

    public static double[] one(int m, double c) {
        double[] o = new double[m];
        int i = 0;
        while (i < o.length) {
            o[i] = c;
            ++i;
        }
        return o;
    }

    public static double[][] increment(int m, int n, double begin, double pitch) {
        double[][] array = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                array[i][j] = begin + (double)i * pitch;
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static double[] increment(int m, double begin, double pitch) {
        double[] array = new double[m];
        int i = 0;
        while (i < m) {
            array[i] = begin + (double)i * pitch;
            ++i;
        }
        return array;
    }

    public static double[] copy(double[] M) {
        double[] array = new double[M.length];
        System.arraycopy(M, 0, array, 0, M.length);
        return array;
    }

    public static double[][] copy(double[][] M) {
        double[][] array = new double[M.length][M[0].length];
        int i = 0;
        while (i < array.length) {
            System.arraycopy(M[i], 0, array[i], 0, M[i].length);
            ++i;
        }
        return array;
    }

    public static double[][] getSubMatrixRangeCopy(double[][] M, int i1, int i2, int j1, int j2) {
        double[][] array = new double[i2 - i1 + 1][j2 - j1 + 1];
        int i = 0;
        while (i < i2 - i1 + 1) {
            System.arraycopy(M[i + i1], j1, array[i], 0, j2 - j1 + 1);
            ++i;
        }
        return array;
    }

    public static double[][] getColumnsRangeCopy(double[][] M, int j1, int j2) {
        double[][] array = new double[M.length][j2 - j1 + 1];
        int i = 0;
        while (i < M.length) {
            System.arraycopy(M[i], j1, array[i], 0, j2 - j1 + 1);
            ++i;
        }
        return array;
    }

    public static double[][] getColumnsCopy(double[][] M, int ... J) {
        double[][] array = new double[M.length][J.length];
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < J.length) {
                array[i][j] = M[i][J[j]];
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static double[] getColumnCopy(double[][] M, int j) {
        double[] array = new double[M.length];
        int i = 0;
        while (i < M.length) {
            array[i] = M[i][j];
            ++i;
        }
        return array;
    }

    public static double[] getColumnCopy(double[][][] M, int j, int k) {
        double[] array = new double[M.length];
        int i = 0;
        while (i < M.length) {
            array[i] = M[i][j][k];
            ++i;
        }
        return array;
    }

    public static double[][] getRowsCopy(double[][] M, int ... I) {
        double[][] array = new double[I.length][M[0].length];
        int i = 0;
        while (i < I.length) {
            System.arraycopy(M[I[i]], 0, array[i], 0, M[I[i]].length);
            ++i;
        }
        return array;
    }

    public static double[] getRowCopy(double[][] M, int i) {
        double[] array = new double[M[0].length];
        System.arraycopy(M[i], 0, array, 0, M[i].length);
        return array;
    }

    public static double[][] getRowsRangeCopy(double[][] M, int i1, int i2) {
        double[][] array = new double[i2 - i1 + 1][M[0].length];
        int i = 0;
        while (i < i2 - i1 + 1) {
            System.arraycopy(M[i + i1], 0, array[i], 0, M[i + i1].length);
            ++i;
        }
        return array;
    }

    public static double[] getRangeCopy(double[] M, int j1, int j2) {
        double[] array = new double[j2 - j1 + 1];
        System.arraycopy(M, j1, array, 0, j2 - j1 + 1);
        return array;
    }

    public static double[] getCopy(double[] M, int ... I) {
        double[] array = new double[I.length];
        int i = 0;
        while (i < I.length) {
            array[i] = M[I[i]];
            ++i;
        }
        return array;
    }

    public static int getColumnDimension(double[][] M, int i) {
        return M[i].length;
    }

    public static double[][] mergeRows(double[] ... x) {
        double[][] array = new double[x.length][];
        int i = 0;
        while (i < array.length) {
            array[i] = new double[x[i].length];
            System.arraycopy(x[i], 0, array[i], 0, array[i].length);
            ++i;
        }
        return array;
    }

    public static double[][] mergeColumns(double[] ... x) {
        double[][] array = new double[x[0].length][x.length];
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = x[j][i];
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static double[] merge(double[] ... x) {
        int[] xlength_array = new int[x.length];
        xlength_array[0] = x[0].length;
        int i = 1;
        while (i < x.length) {
            xlength_array[i] = x[i].length + xlength_array[i - 1];
            ++i;
        }
        double[] array = new double[xlength_array[x.length - 1]];
        System.arraycopy(x[0], 0, array, 0, x[0].length);
        int i2 = 1;
        while (i2 < x.length) {
            System.arraycopy(x[i2], 0, array, xlength_array[i2 - 1], x[i2].length);
            ++i2;
        }
        return array;
    }

    public static double[][] insertColumns(double[][] x, double[][] y, int J) {
        double[][] array = new double[x.length][x[0].length + y[0].length];
        int i = 0;
        while (i < array.length) {
            System.arraycopy(x[i], 0, array[i], 0, J);
            System.arraycopy(y[i], 0, array[i], J, y[i].length);
            System.arraycopy(x[i], J, array[i], J + y[i].length, x[i].length - J);
            ++i;
        }
        return array;
    }

    public static double[][] insertColumn(double[][] x, double[] y, int J) {
        double[][] array = new double[x.length][x[0].length + 1];
        int i = 0;
        while (i < array.length) {
            System.arraycopy(x[i], 0, array[i], 0, J);
            array[i][J] = y[i];
            System.arraycopy(x[i], J, array[i], J + 1, x[i].length - J);
            ++i;
        }
        return array;
    }

    public static double[][] insertRows(double[][] x, double[][] y, int I) {
        double[][] array = new double[x.length + y.length][x[0].length];
        int i = 0;
        while (i < I) {
            System.arraycopy(x[i], 0, array[i], 0, x[i].length);
            ++i;
        }
        i = 0;
        while (i < y.length) {
            System.arraycopy(y[i], 0, array[i + I], 0, y[i].length);
            ++i;
        }
        i = 0;
        while (i < x.length - I) {
            System.arraycopy(x[i + I], 0, array[i + I + y.length], 0, x[i].length);
            ++i;
        }
        return array;
    }

    public static double[][] insertRow(double[][] x, double[] y, int I) {
        double[][] array = new double[x.length + 1][x[0].length];
        int i = 0;
        while (i < I) {
            System.arraycopy(x[i], 0, array[i], 0, x[i].length);
            ++i;
        }
        System.arraycopy(y, 0, array[I], 0, y.length);
        i = 0;
        while (i < x.length - I) {
            System.arraycopy(x[i + I], 0, array[i + I + 1], 0, x[i].length);
            ++i;
        }
        return array;
    }

    public static double[] insert(double[] x, int I, double ... y) {
        double[] array = new double[x.length + y.length];
        System.arraycopy(x, 0, array, 0, I);
        System.arraycopy(y, 0, array, I, y.length);
        System.arraycopy(x, I, array, I + y.length, x.length - I);
        return array;
    }

    public static double[][] deleteColumnsRange(double[][] x, int J1, int J2) {
        double[][] array = new double[x.length][x[0].length - (J2 - J1 + 1)];
        int i = 0;
        while (i < array.length) {
            System.arraycopy(x[i], 0, array[i], 0, J1);
            System.arraycopy(x[i], J2 + 1, array[i], J1, x[i].length - (J2 + 1));
            ++i;
        }
        return array;
    }

    public static double[][] deleteColumns(double[][] x, int ... J) {
        double[][] array = new double[x.length][x[0].length - J.length];
        int i = 0;
        while (i < array.length) {
            System.arraycopy(x[i], 0, array[i], 0, J[0]);
            int j = 0;
            while (j < J.length - 1) {
                System.arraycopy(x[i], J[j] + 1, array[i], J[j] - j, J[j + 1] - J[j] - 1);
                ++j;
            }
            System.arraycopy(x[i], J[J.length - 1] + 1, array[i], J[J.length - 1] - J.length + 1, x[i].length - J[J.length - 1] - 1);
            ++i;
        }
        return array;
    }

    public static double[][] deleteRowsRange(double[][] x, int I1, int I2) {
        double[][] array = new double[x.length - (I2 - I1 + 1)][x[0].length];
        int i = 0;
        while (i < I1) {
            System.arraycopy(x[i], 0, array[i], 0, x[i].length);
            ++i;
        }
        i = 0;
        while (i < x.length - I2 - 1) {
            System.arraycopy(x[i + I2 + 1], 0, array[i + I1], 0, x[i].length);
            ++i;
        }
        return array;
    }

    public static double[][] deleteRows(double[][] x, int ... I) {
        double[][] array = new double[x.length - I.length][x[0].length];
        int i = 0;
        while (i < I[0]) {
            System.arraycopy(x[i], 0, array[i], 0, x[i].length);
            ++i;
        }
        int j = 0;
        while (j < I.length - 1) {
            int i2 = I[j] + 1;
            while (i2 < I[j + 1]) {
                System.arraycopy(x[i2], 0, array[i2 - j], 0, x[i2].length);
                ++i2;
            }
            ++j;
        }
        i = I[I.length - 1] + 1;
        while (i < x.length) {
            System.arraycopy(x[i], 0, array[i - I.length], 0, x[i].length);
            ++i;
        }
        return array;
    }

    public static double[] deleteRange(double[] x, int J1, int J2) {
        double[] array = new double[x.length - (J2 - J1 + 1)];
        System.arraycopy(x, 0, array, 0, J1);
        System.arraycopy(x, J2 + 1, array, J1, x.length - (J2 + 1));
        return array;
    }

    public static double[] delete(double[] x, int ... J) {
        double[] array = new double[x.length - J.length];
        System.arraycopy(x, 0, array, 0, J[0]);
        int j = 0;
        while (j < J.length - 1) {
            System.arraycopy(x, J[j] + 1, array, J[j] - j, J[j + 1] - J[j] - 1);
            ++j;
        }
        System.arraycopy(x, J[J.length - 1] + 1, array, J[J.length - 1] - J.length + 1, x.length - J[J.length - 1] - 1);
        return array;
    }

    public static double[][] buildXY(double Xmin, double Xmax, double[] Y) {
        int n = Y.length;
        double[][] XY = new double[n][2];
        int i = 0;
        while (i < n) {
            XY[i][0] = Xmin + (Xmax - Xmin) * (double)i / (double)(n - 1);
            XY[i][1] = Y[i];
            ++i;
        }
        return XY;
    }

    public static double[][] buildXY(double[] X, double[] Y) {
        return Array.mergeColumns(X, Y);
    }

    public static double[] min(double[][] M) {
        double[] min = new double[M[0].length];
        int j = 0;
        while (j < min.length) {
            min[j] = M[0][j];
            int i = 1;
            while (i < M.length) {
                min[j] = FastMath.min(min[j], M[i][j]);
                ++i;
            }
            ++j;
        }
        return min;
    }

    public static int min(int ... M) {
        int min = M[0];
        int i = 1;
        while (i < M.length) {
            min = FastMath.min(min, M[i]);
            ++i;
        }
        return min;
    }

    public static int max(int ... M) {
        int max = M[0];
        int i = 1;
        while (i < M.length) {
            max = FastMath.max(max, M[i]);
            ++i;
        }
        return max;
    }

    public static double min(double ... M) {
        double min = M[0];
        int i = 1;
        while (i < M.length) {
            min = FastMath.min(min, M[i]);
            ++i;
        }
        return min;
    }

    public static double[] max(double[][] M) {
        double[] max = new double[M[0].length];
        int j = 0;
        while (j < max.length) {
            max[j] = M[0][j];
            int i = 1;
            while (i < M.length) {
                max[j] = FastMath.max(max[j], M[i][j]);
                ++i;
            }
            ++j;
        }
        return max;
    }

    public static double max(double ... M) {
        double max = M[0];
        int i = 1;
        while (i < M.length) {
            max = FastMath.max(max, M[i]);
            ++i;
        }
        return max;
    }

    public static int[] minIndex(double[][] M) {
        int[] minI = new int[M[0].length];
        int j = 0;
        while (j < minI.length) {
            minI[j] = 0;
            int i = 1;
            while (i < M.length) {
                if (M[i][j] < M[minI[j]][j]) {
                    minI[j] = i;
                }
                ++i;
            }
            ++j;
        }
        return minI;
    }

    public static int minIndex(double ... M) {
        int minI = 0;
        int i = 1;
        while (i < M.length) {
            if (M[i] < M[minI]) {
                minI = i;
            }
            ++i;
        }
        return minI;
    }

    public static int[] maxIndex(double[][] M) {
        int[] maxI = new int[M[0].length];
        int j = 0;
        while (j < maxI.length) {
            maxI[j] = 0;
            int i = 1;
            while (i < M.length) {
                if (M[i][j] > M[maxI[j]][j]) {
                    maxI[j] = i;
                }
                ++i;
            }
            ++j;
        }
        return maxI;
    }

    public static int maxIndex(double ... M) {
        int maxI = 0;
        int i = 1;
        while (i < M.length) {
            if (M[i] > M[maxI]) {
                maxI = i;
            }
            ++i;
        }
        return maxI;
    }

    public static String toString(double[] ... v) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < v.length) {
            int j = 0;
            while (j < v[i].length) {
                str.append(String.valueOf(v[i][j]) + " ");
                ++j;
            }
            if (i < v.length - 1) {
                str.append("\n");
            }
            ++i;
        }
        return str.toString();
    }

    public static String toString(int[] ... v) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < v.length) {
            int j = 0;
            while (j < v[i].length) {
                str.append(String.valueOf(v[i][j]) + " ");
                ++j;
            }
            if (i < v.length - 1) {
                str.append("\n");
            }
            ++i;
        }
        return str.toString();
    }

    public static void throwError(String msg) {
        throw new IllegalArgumentException(msg);
    }

    public static void checkColumnDimension(double[][] M, int n) {
        int i = 0;
        while (i < M.length) {
            if (M[i].length != n) {
                Array.throwError("row " + i + " have " + M[i].length + " columns instead of " + n + " columns expected.");
            }
            ++i;
        }
    }

    public static boolean isColumnDimension(double[][] M, int n) {
        int i = 0;
        while (i < M.length) {
            if (M[i].length != n) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void checkRowDimension(double[][] M, int m) {
        if (M.length != m) {
            Array.throwError("columns have " + M.length + " rows instead of " + m + " rows expected.");
        }
    }

    public static boolean isRowDimension(double[][] M, int m) {
        return M.length == m;
    }

    public static void checkLength(double[] M, int n) {
        if (M.length != n) {
            Array.throwError("row have " + M.length + " elements instead of " + n + " elements expected.");
        }
    }

    public static boolean isLength(double[] M, int n) {
        return M.length == n;
    }
}

