/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.render;

import org.math.plot.render.AWTDrawer;
import org.math.plot.render.Projection;
import org.math.plot.utils.FastMath;

public class Projection3D
extends Projection {
    public double theta;
    public double phi;
    public double factor = 1.4;
    public double x0;
    public double y0;
    public double z0;
    public double cos_phi;
    public double sin_phi;
    public double tan_phi;
    public double cos_theta;
    public double sin_theta;
    public double tan_theta;
    static double pi = Math.PI;

    public Projection3D(AWTDrawer _draw) {
        super(_draw);
        this.theta(0.7853981633974483);
        this.phi(0.7853981633974483);
        this.initBaseCoordsProjection(true);
    }

    private void theta(double theta) {
        if (theta == this.theta) {
            return;
        }
        this.theta = theta;
        this.cos_theta = this.cos(theta);
        this.sin_theta = this.sin(theta);
        this.tan_theta = this.tan(theta);
    }

    private void phi(double phi) {
        if (phi == this.phi) {
            return;
        }
        this.phi = phi;
        this.cos_phi = this.cos(phi);
        this.sin_phi = this.sin(phi);
        this.tan_phi = this.tan(phi);
    }

    @Override
    protected void initBaseCoordsProjection(boolean reset) {
        if (reset) {
            this.x0 = (this.draw.canvas.base.roundXmax[0] + this.draw.canvas.base.roundXmin[0]) / 2.0;
            this.y0 = (this.draw.canvas.base.roundXmax[1] + this.draw.canvas.base.roundXmin[1]) / 2.0;
            this.z0 = (this.draw.canvas.base.roundXmax[2] + this.draw.canvas.base.roundXmin[2]) / 2.0;
        }
        super.initBaseCoordsProjection(reset);
    }

    protected void updateCoordsCenterScreen() {
        double dy;
        double dx;
        double dx0 = ((double)this.draw.canvas.getWidth() * 0.5 - (double)this.baseScreenCoords[0][0]) / (double)(this.baseScreenCoords[1][0] - this.baseScreenCoords[0][0]);
        double dy0 = ((double)this.draw.canvas.getWidth() * 0.5 - (double)this.baseScreenCoords[0][0]) / (double)(this.baseScreenCoords[2][0] - this.baseScreenCoords[0][0]);
        double dz0 = ((double)this.draw.canvas.getHeight() * 0.5 - (double)this.baseScreenCoords[0][1]) / (double)(this.baseScreenCoords[3][1] - this.baseScreenCoords[0][1]);
        double dz = 0.0;
        if ((this.theta - pi / 4.0) % pi > pi / 2.0) {
            dx = (0.5 * (this.sin_theta + this.cos_theta) - this.tan_theta * dy0) / (this.sin_theta * this.sin_theta + this.cos_theta);
            dy = this.tan_theta * dx + dy0;
        } else {
            dy = (0.5 * (this.sin_theta + this.cos_theta) - this.cos_theta * dx0) / (this.cos_theta / this.tan_theta + this.sin_theta);
            dx = 1.0 / this.tan_theta * dy + dx0;
        }
        dz = dz0 + 0.5 * this.tan_phi;
        double d = dx < 0.0 ? 0.0 : (dx = dx > 1.0 ? 1.0 : dx);
        double d2 = dy < 0.0 ? 0.0 : (dy = dy > 1.0 ? 1.0 : dy);
        dz = dz < 0.0 ? 0.0 : (dz > 1.0 ? 1.0 : dz);
        this.x0 = this.draw.canvas.base.roundXmin[0] + (this.draw.canvas.base.roundXmax[0] - this.draw.canvas.base.roundXmin[0]) * dx;
        this.y0 = this.draw.canvas.base.roundXmin[1] + (this.draw.canvas.base.roundXmax[1] - this.draw.canvas.base.roundXmin[1]) * dy;
        this.z0 = this.draw.canvas.base.roundXmin[2] + (this.draw.canvas.base.roundXmax[2] - this.draw.canvas.base.roundXmin[2]) * dz;
        this.x0 = 0.0;
        this.y0 = 0.0;
        this.z0 = 0.0;
    }

    @Override
    protected double[] baseCoordsScreenProjectionRatio(double[] xyz) {
        double normdist_xyz_x0 = (xyz[0] - this.x0) / (this.draw.canvas.base.roundXmax[0] - this.draw.canvas.base.roundXmin[0]);
        double normdist_xyz_y0 = (xyz[1] - this.y0) / (this.draw.canvas.base.roundXmax[1] - this.draw.canvas.base.roundXmin[1]);
        double normdist_xyz_z0 = (xyz[2] - this.z0) / (this.draw.canvas.base.roundXmax[2] - this.draw.canvas.base.roundXmin[2]);
        double[] sC = new double[]{(this.cos_theta * normdist_xyz_y0 - this.sin_theta * normdist_xyz_x0) / this.factor, (this.cos_phi * normdist_xyz_z0 - this.sin_phi * this.cos_theta * normdist_xyz_x0 - this.sin_phi * this.sin_theta * normdist_xyz_y0) / this.factor};
        return sC;
    }

    private double cos(double x) {
        return FastMath.cos(x);
    }

    private double tan(double x) {
        return FastMath.tan(x);
    }

    private double sin(double x) {
        return FastMath.sin(x);
    }

    public void rotate(double _theta, double _phi) {
        this.theta(_theta);
        this.phi(_phi);
        this.initBaseCoordsProjection(false);
    }

    public void rotate(int[] screenTranslation, int[] dimension) {
        this.theta(this.theta - (double)screenTranslation[0] / 100.0);
        this.phi(this.phi + (double)screenTranslation[1] / 100.0);
        this.initBaseCoordsProjection(false);
    }
}

