/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import java.util.LinkedList;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.plotObjects.Editable;
import org.math.plot.plotObjects.Noteable;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.DensityLayerPlot;
import org.math.plot.plots.GaussianDensityLayerPlot;
import org.math.plot.plots.LayerPlot;
import org.math.plot.plots.QuantileLayerPlot;
import org.math.plot.plots.VectorLayerPlot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public abstract class Plot
implements Plotable,
Noteable,
Editable {
    public String name;
    public Color color;
    public boolean visible = true;
    public LinkedList<LayerPlot> layers;
    public boolean noted = false;
    public int note_precision = 5;

    public Plot(String n, Color c) {
        this.name = n;
        this.color = c;
        this.layers = new LinkedList();
    }

    public void clearLayers() {
        this.layers.clear();
    }

    public void addLayer(LayerPlot q) {
        this.layers.add(q);
    }

    public void addQuantile(QuantileLayerPlot q) {
        this.layers.add(q);
    }

    public void addQuantile(int a, double r, double[] q, boolean symetric) {
        this.layers.add(new QuantileLayerPlot(this, a, q, r, symetric));
    }

    public void addQuantile(int a, double r, double q, boolean symetric) {
        this.layers.add(new QuantileLayerPlot(this, a, q, r, symetric));
    }

    public void addQuantiles(int a, double[][] q) {
        this.layers.add(new DensityLayerPlot(this, a, q));
    }

    public void addQuantiles(int a, double[] q) {
        this.layers.add(new DensityLayerPlot(this, a, q));
    }

    public void addGaussQuantiles(int a, double[] s) {
        this.layers.add(new GaussianDensityLayerPlot(this, a, s));
    }

    public void addGaussQuantiles(int a, double s) {
        this.layers.add(new GaussianDensityLayerPlot(this, a, s));
    }

    public void addVector(double[][] v) {
        this.layers.add(new VectorLayerPlot(this, v));
    }

    public abstract void setData(double[][] var1);

    public abstract double[][] getData();

    public double[] getBounds(int axis) {
        return Array.getColumnCopy(this.getBounds(), axis);
    }

    public double[][] getBounds() {
        return Array.mergeRows(Array.min(this.getData()), Array.max(this.getData()));
    }

    @Override
    public void setVisible(boolean v) {
        this.visible = v;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public abstract double[] isSelected(int[] var1, AbstractDrawer var2);

    @Override
    public void note(AbstractDrawer draw) {
        this.plot(draw, PlotCanvas.NOTE_COLOR);
        this.plotLayerPlots(draw, PlotCanvas.NOTE_COLOR);
    }

    public void noteCoord(AbstractDrawer draw, double[] coordNoted) {
        if (coordNoted == null) {
            return;
        }
        draw.setColor(PlotCanvas.NOTE_COLOR);
        draw.drawCoordinate(coordNoted);
        draw.drawText(Array.cat("\n", draw.canvas.reverseMapedData(coordNoted)), coordNoted);
    }

    public abstract void plot(AbstractDrawer var1, Color var2);

    @Override
    public void plot(AbstractDrawer draw) {
        this.plotLayerPlots(draw, this.color);
        this.plot(draw, this.color);
    }

    public void plotLayerPlots(AbstractDrawer draw, Color c) {
        int i = 0;
        while (i < this.layers.size()) {
            this.layers.get(i).plot(draw, c);
            ++i;
        }
    }

    @Override
    public void edit(Object src) {
        ((PlotCanvas)src).displayDataFrame(((PlotCanvas)src).getPlotIndex(this));
    }

    @Override
    public void editnote(AbstractDrawer draw) {
        this.plot(draw, PlotCanvas.EDIT_COLOR);
        this.plotLayerPlots(draw, PlotCanvas.EDIT_COLOR);
    }
}

