/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.ScatterPlot;
import org.math.plot.render.AbstractDrawer;

public class LinePlot
extends ScatterPlot {
    public boolean draw_dot = false;

    public LinePlot(String n, Color c, boolean[][] _pattern, double[][] _XY) {
        super(n, c, _pattern, _XY);
    }

    public LinePlot(String n, Color c, int _type, int _radius, double[][] _XY) {
        super(n, c, _type, _radius, _XY);
    }

    public LinePlot(String n, Color c, double[][] _XY) {
        super(n, c, _XY);
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        if (this.draw_dot) {
            super.plot(draw, c);
        }
        draw.setColor(c);
        draw.setLineType(1);
        int i = 0;
        while (i < this.XY.length - 1) {
            if (this.XY[i].length == 3) {
                if (this.XY[i][2] < 0.0 && this.XY[i + 1][2] < 0.0) {
                    draw.setColor(Color.RED);
                } else {
                    draw.setColor(c);
                }
            }
            draw.drawLine(this.XY[i], this.XY[i + 1]);
            ++i;
        }
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        double[][] XYZ = new double[100][2];
        int j = 0;
        while (j < XYZ.length) {
            XYZ[j][0] = Math.PI * 2 * (double)j / (double)XYZ.length;
            XYZ[j][1] = Math.sin(XYZ[j][0]);
            ++j;
        }
        p2.addLinePlot("sin", XYZ);
        p2.setLegendOrientation("South");
        new FrameView(p2).setDefaultCloseOperation(3);
    }
}

