/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot3DPanel;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class HistogramPlot3D
extends Plot {
    double[][] topNW;
    double[][] topNE;
    double[][] topSW;
    double[][] topSE;
    double[][] bottomNW;
    double[][] bottomNE;
    double[][] bottomSW;
    double[][] bottomSE;
    double[][] widths;
    double[] width_constant = new double[]{-1.0, -1.0};
    double[][] XY;
    boolean fill_shape = true;

    public HistogramPlot3D(String n, Color c, double[][] _XY, double[][] w) {
        super(n, c);
        this.XY = _XY;
        this.widths = w;
        this.build();
    }

    public HistogramPlot3D(String n, Color c, double[][] _XY, double wX, double wY) {
        super(n, c);
        this.XY = _XY;
        this.width_constant = new double[]{wX, wY};
        this.build();
    }

    public HistogramPlot3D(String n, Color c, double[][] _XY, double[] w) {
        super(n, c);
        this.XY = _XY;
        this.width_constant = w;
        this.build();
    }

    private void build() {
        if (this.width_constant[0] > 0.0) {
            this.topNW = new double[this.XY.length][];
            this.topNE = new double[this.XY.length][];
            this.topSW = new double[this.XY.length][];
            this.topSE = new double[this.XY.length][];
            this.bottomNW = new double[this.XY.length][];
            this.bottomNE = new double[this.XY.length][];
            this.bottomSW = new double[this.XY.length][];
            this.bottomSE = new double[this.XY.length][];
            int i = 0;
            while (i < this.XY.length) {
                this.topNW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, this.XY[i][2]};
                this.topNE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, this.XY[i][2]};
                this.topSW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, this.XY[i][2]};
                this.topSE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, this.XY[i][2]};
                this.bottomNW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, 0.0};
                this.bottomNE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] + this.width_constant[1] / 2.0, 0.0};
                this.bottomSW[i] = new double[]{this.XY[i][0] - this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, 0.0};
                this.bottomSE[i] = new double[]{this.XY[i][0] + this.width_constant[0] / 2.0, this.XY[i][1] - this.width_constant[1] / 2.0, 0.0};
                ++i;
            }
        } else {
            this.topNW = new double[this.XY.length][];
            this.topNE = new double[this.XY.length][];
            this.topSW = new double[this.XY.length][];
            this.topSE = new double[this.XY.length][];
            this.bottomNW = new double[this.XY.length][];
            this.bottomNE = new double[this.XY.length][];
            this.bottomSW = new double[this.XY.length][];
            this.bottomSE = new double[this.XY.length][];
            int i = 0;
            while (i < this.XY.length) {
                this.topNW[i] = new double[]{this.XY[i][0] - this.widths[i][0] / 2.0, this.XY[i][1] + this.widths[i][1] / 2.0, this.XY[i][2]};
                this.topNE[i] = new double[]{this.XY[i][0] + this.widths[i][0] / 2.0, this.XY[i][1] + this.widths[i][1] / 2.0, this.XY[i][2]};
                this.topSW[i] = new double[]{this.XY[i][0] - this.widths[i][0] / 2.0, this.XY[i][1] - this.widths[i][1] / 2.0, this.XY[i][2]};
                this.topSE[i] = new double[]{this.XY[i][0] + this.widths[i][0] / 2.0, this.XY[i][1] - this.widths[i][1] / 2.0, this.XY[i][2]};
                this.bottomNW[i] = new double[]{this.XY[i][0] - this.widths[i][0] / 2.0, this.XY[i][1] + this.widths[i][1] / 2.0, 0.0};
                this.bottomNE[i] = new double[]{this.XY[i][0] + this.widths[i][0] / 2.0, this.XY[i][1] + this.widths[i][1] / 2.0, 0.0};
                this.bottomSW[i] = new double[]{this.XY[i][0] - this.widths[i][0] / 2.0, this.XY[i][1] - this.widths[i][1] / 2.0, 0.0};
                this.bottomSE[i] = new double[]{this.XY[i][0] + this.widths[i][0] / 2.0, this.XY[i][1] - this.widths[i][1] / 2.0, 0.0};
                ++i;
            }
        }
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        draw.canvas.includeInBounds(this.bottomSW[0]);
        draw.canvas.includeInBounds(this.topNE[this.XY.length - 1]);
        draw.setColor(c);
        draw.setLineType(1);
        int i = 0;
        while (i < this.XY.length) {
            if (this.topNW[i][2] != this.bottomNW[i][2]) {
                draw.drawLine(this.topNW[i], this.topNE[i]);
                draw.drawLine(this.topNE[i], this.topSE[i]);
                draw.drawLine(this.topSE[i], this.topSW[i]);
                draw.drawLine(this.topSW[i], this.topNW[i]);
                draw.drawLine(this.bottomNW[i], this.bottomNE[i]);
                draw.drawLine(this.bottomNE[i], this.bottomSE[i]);
                draw.drawLine(this.bottomSE[i], this.bottomSW[i]);
                draw.drawLine(this.bottomSW[i], this.bottomNW[i]);
                draw.drawLine(this.bottomNW[i], this.topNW[i]);
                draw.drawLine(this.bottomNE[i], this.topNE[i]);
                draw.drawLine(this.bottomSE[i], this.topSE[i]);
                draw.drawLine(this.bottomSW[i], this.topSW[i]);
                if (this.fill_shape) {
                    draw.fillPolygon(0.2f, this.topNW[i], this.topNE[i], this.topSE[i], this.topSW[i]);
                }
            }
            ++i;
        }
    }

    @Override
    public void setData(double[][] d) {
        this.XY = d;
    }

    @Override
    public double[][] getData() {
        return this.XY;
    }

    @Override
    public double[][] getBounds() {
        return new double[][]{Array.min(this.bottomSW), Array.max(this.topNE)};
    }

    public void setDataWidth(double[][] w) {
        this.widths = w;
    }

    public void setDataWidth(double ... w) {
        this.width_constant = w;
        this.build();
    }

    public double[][] getDataWidth() {
        if (this.width_constant[0] > 0.0) {
            this.widths = new double[this.XY.length][2];
            int i = 0;
            while (i < this.widths.length) {
                this.widths[i][0] = this.width_constant[0];
                this.widths[i][1] = this.width_constant[1];
                ++i;
            }
        }
        return this.widths;
    }

    public void setData(double[][] d, double[][] w) {
        this.XY = d;
        this.widths = w;
    }

    public void setData(double[][] d, double ... w) {
        this.XY = d;
        this.setDataWidth(w);
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        int i = 0;
        while (i < this.XY.length) {
            int[] screenCoord = draw.project(this.XY[i]);
            if (screenCoord[0] + this.note_precision > screenCoordTest[0] && screenCoord[0] - this.note_precision < screenCoordTest[0] && screenCoord[1] + this.note_precision > screenCoordTest[1] && screenCoord[1] - this.note_precision < screenCoordTest[1]) {
                return this.XY[i];
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] args) {
        double[][] XY = new double[500][2];
        int i = 0;
        while (i < XY.length) {
            XY[i][0] = Math.random() + Math.random();
            XY[i][1] = Math.random() + Math.random();
            ++i;
        }
        Plot3DPanel p = new Plot3DPanel("SOUTH");
        p.addHistogramPlot("test", XY, 4, 6);
        new FrameView(p);
    }
}

