/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;

public class GridPlot3DSphere
extends Plot {
    private double xMax;
    private double yMax;
    private double zMax;
    private float fTransparency = 0.3f;
    private double[][][] XYZ_list;
    private double[][] XYZ_list2D;
    public boolean draw_lines = true;
    public boolean fill_shape = true;

    public GridPlot3DSphere(String n, float pTransparency, Color c, double[][][] pXYZ_list, boolean pDrawLines, boolean pFillShape) {
        super(n, c);
        this.draw_lines = pDrawLines;
        this.fill_shape = pFillShape;
        this.XYZ_list = pXYZ_list;
        this.fTransparency = pTransparency;
        this.buildXYZ_list();
        this.setXYZEV();
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        int i;
        int j;
        int j2;
        int i2;
        if (!this.visible) {
            return;
        }
        draw.setColor(c);
        draw.setLineWidth(1);
        if (this.draw_lines) {
            draw.setLineType(1);
            i2 = 0;
            while (i2 < this.XYZ_list.length) {
                j2 = 0;
                while (j2 < this.XYZ_list[0].length - 1) {
                    if (this.XYZ_list[i2][j2][3] < 0.0 || this.XYZ_list[i2][j2 + 1][3] < 0.0) {
                        draw.setColor(Color.RED);
                    } else {
                        draw.setColor(c);
                    }
                    draw.drawLine({this.XYZ_list[i2][j2][0], this.XYZ_list[i2][j2][1], this.XYZ_list[i2][j2][2]}, {this.XYZ_list[i2][j2 + 1][0], this.XYZ_list[i2][j2 + 1][1], this.XYZ_list[i2][j2 + 1][2]});
                    ++j2;
                }
                ++i2;
            }
            j = 0;
            while (j < this.XYZ_list[0].length) {
                i = 0;
                while (i < this.XYZ_list.length - 1) {
                    if (this.XYZ_list[i][j][3] < 0.0 || this.XYZ_list[i + 1][j][3] < 0.0) {
                        draw.setColor(Color.RED);
                    } else {
                        draw.setColor(c);
                    }
                    draw.drawLine({this.XYZ_list[i][j][0], this.XYZ_list[i][j][1], this.XYZ_list[i][j][2]}, {this.XYZ_list[i + 1][j][0], this.XYZ_list[i + 1][j][1], this.XYZ_list[i + 1][j][2]});
                    ++i;
                }
                ++j;
            }
        } else {
            draw.setDotType(1);
            draw.setDotRadius(2);
            i2 = 0;
            while (i2 < this.XYZ_list.length) {
                j2 = 0;
                while (j2 < this.XYZ_list[0].length) {
                    if (this.XYZ_list[i2][j2][3] < 0.0) {
                        draw.setColor(Color.RED);
                    } else {
                        draw.setColor(c);
                    }
                    draw.drawDot(this.XYZ_list[i2][j2][0], this.XYZ_list[i2][j2][1], this.XYZ_list[i2][j2][2]);
                    ++j2;
                }
                ++i2;
            }
        }
        if (this.fill_shape) {
            j = 0;
            while (j < this.XYZ_list[0].length - 1) {
                i = 0;
                while (i < this.XYZ_list.length - 1) {
                    if ((this.XYZ_list[i][j][3] < 0.0 || this.XYZ_list[i][j + 1][0] < 0.0) && (this.XYZ_list[i + 1][j][3] < 0.0 || this.XYZ_list[i + 1][j + 1][3] < 0.0)) {
                        draw.setColor(Color.RED);
                    } else {
                        draw.setColor(c);
                    }
                    draw.fillPolygon(this.fTransparency, {this.XYZ_list[i][j][0], this.XYZ_list[i][j][1], this.XYZ_list[i][j][2]}, {this.XYZ_list[i][j + 1][0], this.XYZ_list[i][j + 1][1], this.XYZ_list[i][j + 1][2]}, {this.XYZ_list[i + 1][j + 1][0], this.XYZ_list[i + 1][j + 1][1], this.XYZ_list[i + 1][j + 1][2]}, {this.XYZ_list[i + 1][j][0], this.XYZ_list[i + 1][j][1], this.XYZ_list[i + 1][j][2]});
                    ++i;
                }
                ++j;
            }
        }
    }

    private void buildXYZ_list() {
        int iTotalCoord = this.XYZ_list.length * this.XYZ_list[0].length;
        this.XYZ_list2D = new double[iTotalCoord][3];
        int iCounter = 0;
        int i = 0;
        while (i < this.XYZ_list.length) {
            int j = 0;
            while (j < this.XYZ_list[0].length) {
                double[] v = this.XYZ_list[i][j];
                if (iCounter < iTotalCoord) {
                    this.XYZ_list2D[iCounter] = v;
                    ++iCounter;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setData(double[][] _Z) {
        this.buildXYZ_list();
    }

    @Override
    public double[][] getData() {
        return this.XYZ_list2D;
    }

    @Override
    public double[][] getBounds() {
        return new double[][]{{this.xMax * -1.0, this.yMax * -1.0, this.zMax * -1.0}, {this.xMax, this.yMax, this.zMax}};
    }

    public void setData(double[][][] _Z) {
        this.XYZ_list = _Z;
    }

    private void setXYZEV() {
        int iInc = (this.XYZ_list[0].length - 1) / 2;
        this.xMax = this.XYZ_list[0][iInc][0];
        this.yMax = this.XYZ_list[iInc][iInc][1];
        this.zMax = this.XYZ_list[0][0][2];
    }

    @Override
    public double[] isSelected(int[] screenCoordTest, AbstractDrawer draw) {
        int i = 0;
        while (i < this.XYZ_list.length) {
            int j = 0;
            while (j < this.XYZ_list[0].length) {
                double[] XY = new double[]{this.XYZ_list[i][j][0], this.XYZ_list[i][j][1], this.XYZ_list[i][j][2]};
                int[] screenCoord = draw.project(XY);
                if (screenCoord[0] + this.note_precision > screenCoordTest[0] && screenCoord[0] - this.note_precision < screenCoordTest[0] && screenCoord[1] + this.note_precision > screenCoordTest[1] && screenCoord[1] - this.note_precision < screenCoordTest[1]) {
                    return XY;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

