/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.render.AbstractDrawer;

public class RasterImage
implements Plotable {
    File source;
    Image img;
    double[] xyzSW;
    double[] xyzSE;
    double[] xyzNW;
    boolean visible = true;
    float alpha;

    public RasterImage(File _source, float _alpha, double[] _xyzSW, double[] _xyzSE, double[] _xyzNW) {
        this.source = _source;
        this.img = Toolkit.getDefaultToolkit().getImage(this.source.getPath());
        this.xyzSW = _xyzSW;
        this.xyzSE = _xyzSE;
        this.xyzNW = _xyzNW;
        this.alpha = _alpha;
    }

    @Override
    public void plot(AbstractDrawer draw) {
        if (!this.visible) {
            return;
        }
        draw.drawImage(this.img, this.alpha, this.xyzSW, this.xyzSE, this.xyzNW);
    }

    @Override
    public void setVisible(boolean v) {
        this.visible = v;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void setColor(Color c) {
        throw new IllegalArgumentException("method not available for this Object: PlotImage");
    }

    @Override
    public Color getColor() {
        return null;
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        int i = 0;
        while (i < 1) {
            double[][] XYZ = new double[10][2];
            int j = 0;
            while (j < XYZ.length) {
                XYZ[j][0] = Math.random();
                XYZ[j][1] = Math.random();
                ++j;
            }
            p2.addScatterPlot("toto" + i, XYZ);
            ++i;
        }
        p2.addPlotable(new RasterImage(new File("test.gif"), 0.8f, new double[]{0.2, 0.5}, new double[]{1.2, 0.8}, new double[]{0.2, 1.1}));
        p2.setLegendOrientation("South");
        new FrameView(p2).setDefaultCloseOperation(3);
        Plot3DPanel p = new Plot3DPanel();
        int i2 = 0;
        while (i2 < 1) {
            double[][] XYZ = new double[10][3];
            int j = 0;
            while (j < XYZ.length) {
                XYZ[j][0] = Math.random();
                XYZ[j][1] = Math.random();
                XYZ[j][2] = Math.random();
                ++j;
            }
            p.addScatterPlot("toto" + i2, XYZ);
            ++i2;
        }
        p.addPlotable(new RasterImage(new File("test.gif"), 0.5f, new double[]{0.0, 0.0, 0.0}, new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 0.0, 1.0}));
        p.addPlotable(new RasterImage(new File("test.gif"), 0.5f, new double[]{0.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0}, new double[]{0.0, 0.0, 1.0}));
        p.addPlotable(new RasterImage(new File("test.gif"), 0.5f, new double[]{0.0, 0.0, 0.0}, new double[]{1.0, 0.0, 0.0}, new double[]{0.0, 1.0, 0.0}));
        p.setLegendOrientation("South");
        p.setPreferredSize(new Dimension(600, 600));
        new FrameView(p).setDefaultCloseOperation(3);
    }
}

