/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import java.awt.Color;
import org.math.plot.plotObjects.Axis;
import org.math.plot.plotObjects.Base;
import org.math.plot.plotObjects.BaseDependant;
import org.math.plot.render.AbstractDrawer;

public class BasePlot
implements BaseDependant {
    public static Color DEFAULT_COLOR = Color.BLACK;
    protected Base base;
    protected Axis[] axis;
    protected boolean visible = true;
    protected Color color;

    public BasePlot(Base b, String ... as) {
        this(b, DEFAULT_COLOR, as);
    }

    public BasePlot(Base b, Color c, Axis ... a) {
        this.base = b;
        this.axis = a;
        this.color = c;
    }

    public BasePlot(Base b, Color c, String ... as) {
        this.base = b;
        if (as.length != this.base.dimension) {
            throw new IllegalArgumentException("String array of axes names must have " + this.base.dimension + " elements.");
        }
        this.color = c;
        this.axis = new Axis[this.base.dimension];
        int i = 0;
        while (i < this.base.dimension) {
            this.axis[i] = new Axis(this.base, as[i], this.color, i);
            ++i;
        }
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void setVisible(int i, boolean v) {
        this.axis[i].setVisible(v);
    }

    public void setGridVisible(int i, boolean v) {
        this.axis[i].setGridVisible(v);
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setColor(Color c) {
        this.color = c;
        int i = 0;
        while (i < this.axis.length) {
            this.axis[i].setColor(c);
            ++i;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setLegend(String[] as) {
        if (as.length != this.base.dimension) {
            throw new IllegalArgumentException("String array of axes names must have " + this.base.dimension + " elements.");
        }
        int i = 0;
        while (i < this.axis.length) {
            this.axis[i].setLegend(as[i]);
            ++i;
        }
    }

    public void setLegend(int i, String as) {
        this.axis[i].setLegend(as);
    }

    public String[] getLegend() {
        String[] array = new String[this.axis.length];
        int i = 0;
        while (i < array.length) {
            array[i] = this.axis[i].getLegend();
            ++i;
        }
        return array;
    }

    public String getLegend(int i) {
        return this.axis[i].getLegend();
    }

    public void setBase(Base b) {
        this.base = b;
        int i = 0;
        while (i < this.axis.length) {
            this.axis[i].base = this.base;
            ++i;
        }
        this.resetBase();
    }

    public void plot(AbstractDrawer draw) {
        if (!this.visible) {
            return;
        }
        int i = 0;
        while (i < this.axis.length) {
            this.axis[i].plot(draw);
            ++i;
        }
    }

    public Axis getAxis(int i) {
        return this.axis[i];
    }

    public Axis[] getAxis() {
        return this.axis;
    }

    @Override
    public void resetBase() {
        int i = 0;
        while (i < this.axis.length) {
            this.axis[i].resetBase();
            ++i;
        }
    }
}

