/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import org.math.plot.utils.FastMath;

public class Base {
    public static final String STRINGS = "str";
    public static final String LINEAR = "lin";
    public static final String LOGARITHM = "log";
    public double[][] baseCoords;
    protected double[] precisionUnit;
    public double[] roundXmin;
    public double[] roundXmax;
    protected double[] trueXmin;
    protected double[] trueXmax;
    public int dimension;
    public String[] axesScales;

    public Base(double[] Xmi, double[] Xma, String[] scales) {
        this.trueXmin = Xmi;
        this.trueXmax = Xma;
        this.dimension = this.trueXmin.length;
        this.axesScales = scales;
        this.init(this.trueXmin.length);
        int dim = this.dimension;
        if (dim == 2 && Xmi.length == 3 && Xma.length == 3) {
            System.arraycopy(Xmi, 0, Xmi, 0, 2);
            System.arraycopy(Xma, 0, Xma, 0, 2);
        }
        this.setRoundBounds(this.trueXmin, this.trueXmax);
        this.resetCoords();
    }

    private void init(int d) {
        this.precisionUnit = new double[d];
        this.roundXmin = new double[d];
        this.roundXmax = new double[d];
        this.trueXmin = new double[d];
        this.trueXmax = new double[d];
    }

    private void resetCoords() {
        this.baseCoords = new double[this.dimension + 1][];
        int i = 0;
        while (i < this.baseCoords.length) {
            this.baseCoords[i] = (double[])this.roundXmin.clone();
            if (i > 0) {
                this.baseCoords[i][i - 1] = this.roundXmax[i - 1];
            }
            ++i;
        }
    }

    private void setPrecisionUnit(int i, double Xmi, double Xma) {
        this.precisionUnit[i] = Xma - Xmi > 0.0 ? FastMath.pow(10.0, FastMath.floor(FastMath.log(Xma - Xmi) / FastMath.log(10.0))) : 1.0;
    }

    public void setAxesScales(String[] scales) {
        this.axesScales = scales;
        this.setRoundBounds(this.trueXmin, this.trueXmax);
        this.resetCoords();
    }

    public void setAxesScales(int i, String scale) {
        this.axesScales[i] = scale;
        this.setRoundBounds(this.trueXmin, this.trueXmax);
        this.resetCoords();
    }

    public double[][] getCoords() {
        return this.baseCoords;
    }

    public String[] getAxesScales() {
        return this.axesScales;
    }

    public String getAxeScale(int i) {
        return this.axesScales[i];
    }

    public double[] getMinBounds() {
        return this.roundXmin;
    }

    public double[] getMaxBounds() {
        return this.roundXmax;
    }

    public double[] getPrecisionUnit() {
        return this.precisionUnit;
    }

    private void setBounds(int i, double Xmi, double Xma) {
        if (Xmi <= 0.0 && this.axesScales[i].equalsIgnoreCase(LOGARITHM)) {
            throw new IllegalArgumentException("Error while bounding dimension " + (i + 1) + " : bounds [" + Xmi + "," + Xma + "] are incompatible with Logarithm scale.");
        }
        if (Xmi == Xma) {
            Xmi = Xma - 1.0;
        }
        if (Xmi > Xma) {
            throw new IllegalArgumentException("Error while bounding dimension " + (i + 1) + " : min " + Xmi + " must be < to max " + Xma);
        }
        this.roundXmin[i] = Xmi;
        this.roundXmax[i] = Xma;
        this.resetCoords();
    }

    public void setFixedBounds(int i, double Xmi, double Xma) {
        this.setPrecisionUnit(i, Xmi, Xma);
        this.setBounds(i, Xmi, Xma);
    }

    public void setFixedBounds(double[] Xmi, double[] Xma) {
        int i = 0;
        while (i < Xmi.length) {
            this.setFixedBounds(i, Xmi[i], Xma[i]);
            ++i;
        }
    }

    public void roundBounds(int i) {
        this.setPrecisionUnit(i, this.trueXmin[i], this.trueXmax[i]);
        if (this.axesScales[i].equalsIgnoreCase(LOGARITHM)) {
            this.setBounds(i, FastMath.pow(10.0, FastMath.floor(FastMath.log(this.trueXmin[i]) / FastMath.log(10.0))), FastMath.pow(10.0, FastMath.ceil(FastMath.log(this.trueXmax[i]) / FastMath.log(10.0))));
        } else if (this.axesScales[i].equalsIgnoreCase(LINEAR) || this.axesScales[i].equalsIgnoreCase(STRINGS)) {
            this.setBounds(i, this.precisionUnit[i] * FastMath.floor(this.trueXmin[i] / this.precisionUnit[i]), this.precisionUnit[i] * FastMath.ceil(this.trueXmax[i] / this.precisionUnit[i]));
        }
    }

    public void setRoundBounds(int i, double Xmi, double Xma) {
        this.trueXmin[i] = Xmi;
        this.trueXmax[i] = Xma;
        this.roundBounds(i);
    }

    public void setRoundBounds(double[] Xmi, double[] Xma) {
        int i = 0;
        while (i < Xmi.length) {
            this.trueXmin[i] = Xmi[i];
            this.trueXmax[i] = Xma[i];
            this.roundBounds(i);
            ++i;
        }
    }

    public boolean includeInBounds(int dim, double XY) {
        boolean changed = false;
        int i = 0;
        while (i < this.roundXmin.length) {
            if (i == dim && XY < this.trueXmin[i]) {
                this.trueXmin[i] = XY;
                changed = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.roundXmax.length) {
            if (i == dim && XY > this.trueXmax[i]) {
                this.trueXmax[i] = XY;
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.roundBounds(dim);
        }
        return changed;
    }

    public boolean includeInBounds(double[] XY) {
        boolean changed = false;
        int i = 0;
        while (i < this.roundXmin.length) {
            if (XY[i] < this.trueXmin[i]) {
                this.trueXmin[i] = XY[i];
                changed = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.roundXmax.length) {
            if (XY[i] > this.trueXmax[i]) {
                this.trueXmax[i] = XY[i];
                changed = true;
            }
            ++i;
        }
        if (changed) {
            this.setRoundBounds(this.trueXmin, this.trueXmax);
        }
        return changed;
    }

    public boolean authorizedLogScale(int i) {
        return this.roundXmin[i] > 0.0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.baseCoords.length) {
            s.append("[");
            int j = 0;
            while (j < this.baseCoords[i].length) {
                s.append(String.valueOf(this.baseCoords[i][j]) + ",");
                ++j;
            }
            s.deleteCharAt(s.length() - 1);
            s.append("]");
            ++i;
        }
        return s.toString();
    }
}

