/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.canvas;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.math.plot.components.DataFrame;
import org.math.plot.components.LegendPanel;
import org.math.plot.components.ScalesFrame;
import org.math.plot.plotObjects.Base;
import org.math.plot.plotObjects.BaseDependant;
import org.math.plot.plotObjects.BaseLabel;
import org.math.plot.plotObjects.BasePlot;
import org.math.plot.plotObjects.Label;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;
import org.math.plot.utils.FastMath;

public abstract class PlotCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener,
BaseDependant,
MouseWheelListener {
    public Base base;
    protected AbstractDrawer draw;
    protected BasePlot grid;
    public LegendPanel linkedLegendPanel;
    public LinkedList<Plot> plots;
    public LinkedList<Plotable> objects;
    boolean adjustBounds = true;
    JFrame scalesFrame = new ScalesFrame(this);
    DataFrame dataFrame = new DataFrame(this, this.linkedLegendPanel);
    boolean mapset = false;
    HashMap<Double, String>[] reversedMaps;
    protected static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    public static Color NOTE_COLOR = Color.DARK_GRAY;
    public static Color EDIT_COLOR = Color.BLACK;
    public boolean allowEdit = true;
    public boolean allowNote = true;
    public boolean allowNoteCoord = true;
    protected double[] coordNoted;
    public static final int ZOOM = 0;
    public static final int TRANSLATION = 1;
    public int ActionMode;
    protected boolean dragging = false;
    protected int[] mouseCurent = new int[2];
    protected int[] mouseClick = new int[2];

    public PlotCanvas() {
        this.initPanel();
        this.initBasenGrid();
        this.initDrawer();
    }

    public PlotCanvas(Base b, BasePlot bp) {
        this.initPanel();
        this.initBasenGrid(b, bp);
        this.initDrawer();
    }

    public PlotCanvas(double[] min, double[] max) {
        this.initPanel();
        this.initBasenGrid(min, max);
        this.initDrawer();
    }

    public PlotCanvas(double[] min, double[] max, String[] axesScales, String[] axesLabels) {
        this.initPanel();
        this.initBasenGrid(min, max, axesScales, axesLabels);
        this.initDrawer();
    }

    public void attachLegend(LegendPanel lp) {
        this.linkedLegendPanel = lp;
    }

    private void initPanel() {
        this.objects = new LinkedList();
        this.plots = new LinkedList();
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public abstract void initDrawer();

    public void initBasenGrid(double[] min, double[] max, String[] axesScales, String[] axesLabels) {
        this.base = new Base(min, max, axesScales);
        this.grid = new BasePlot(this.base, axesLabels);
    }

    public abstract void initBasenGrid(double[] var1, double[] var2);

    public abstract void initBasenGrid();

    public void initBasenGrid(Base b, BasePlot bp) {
        this.base = b;
        this.grid = bp;
    }

    public void setActionMode(int am) {
        this.ActionMode = am;
    }

    public void setNoteCoords(boolean b) {
        this.allowNoteCoord = b;
    }

    public void setEditable(boolean b) {
        this.allowEdit = b;
    }

    public boolean getEditable() {
        return this.allowEdit;
    }

    public void setNotable(boolean b) {
        this.allowNote = b;
    }

    public boolean getNotable() {
        return this.allowNote;
    }

    public LinkedList<Plot> getPlots() {
        return this.plots;
    }

    public Plot getPlot(int i) {
        return this.plots.get(i);
    }

    public int getPlotIndex(Plot p) {
        int i = 0;
        while (i < this.plots.size()) {
            if (this.getPlot(i) == p) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public LinkedList<Plotable> getPlotables() {
        return this.objects;
    }

    public Plotable getPlotable(int i) {
        return this.objects.get(i);
    }

    public BasePlot getGrid() {
        return this.grid;
    }

    public String[] getAxisScales() {
        return this.base.getAxesScales();
    }

    public void setAxisLabels(String ... labels) {
        this.grid.setLegend(labels);
        this.repaint();
    }

    public void setAxisLabel(int axe, String label) {
        this.grid.setLegend(axe, label);
        this.repaint();
    }

    public void setAxisScales(String ... scales) {
        this.base.setAxesScales(scales);
        this.setAutoBounds();
    }

    public void setAxiScale(int axe, String scale) {
        this.base.setAxesScales(axe, scale);
        this.setAutoBounds(axe);
    }

    public void setFixedBounds(double[] min, double[] max) {
        this.base.setFixedBounds(min, max);
        this.resetBase();
        this.repaint();
    }

    public void setFixedBounds(int axe, double min, double max) {
        this.base.setFixedBounds(axe, min, max);
        this.resetBase();
        this.repaint();
    }

    public void includeInBounds(double ... into) {
        boolean changed = this.base.includeInBounds(into);
        if (!changed) {
            return;
        }
        this.grid.resetBase();
        this.repaint();
    }

    public void includeInBounds(Plot plot) {
        boolean changed = this.base.includeInBounds(Array.min(plot.getBounds()));
        if (!(changed |= this.base.includeInBounds(Array.max(plot.getBounds())))) {
            return;
        }
        this.resetBase();
        this.repaint();
    }

    public void setAutoBounds() {
        if (this.plots.size() > 0) {
            Plot plot0 = this.getPlot(0);
            double[] min = Array.min(plot0.getBounds());
            double[] max = Array.max(plot0.getBounds());
            String sName = plot0.getName();
            if ((sName.startsWith("e2-e3-section") || sName.startsWith("e1-e3-section") || sName.startsWith("e1-e2-section") || sName.startsWith("Section")) && min.length == 3 && max.length == 3) {
                double[] newMin = new double[2];
                double[] newMax = new double[2];
                System.arraycopy(min, 0, newMin, 0, 2);
                System.arraycopy(max, 0, newMax, 0, 2);
                this.base.setRoundBounds(newMin, newMax);
            } else {
                this.base.setRoundBounds(min, max);
            }
        } else {
            double[] min = new double[this.base.dimension];
            double[] max = new double[this.base.dimension];
            int i = 0;
            while (i < this.base.dimension) {
                if (this.base.getAxeScale(i).equalsIgnoreCase("lin")) {
                    min[i] = 0.0;
                    max[i] = 1.0;
                } else if (this.base.getAxeScale(i).equalsIgnoreCase("log")) {
                    min[i] = 1.0;
                    max[i] = 10.0;
                }
                ++i;
            }
            this.base.setRoundBounds(min, max);
        }
        int i = 1;
        while (i < this.plots.size()) {
            Plot ploti = this.getPlot(i);
            this.base.includeInBounds(Array.min(ploti.getBounds()));
            this.base.includeInBounds(Array.max(ploti.getBounds()));
            ++i;
        }
        this.resetBase();
        this.repaint();
    }

    public void setAutoBounds(int axe) {
        if (this.plots.size() > 0) {
            Plot plot0 = this.getPlot(0);
            this.base.setRoundBounds(axe, Array.min(plot0.getBounds())[axe], Array.max(plot0.getBounds())[axe]);
        } else {
            double min = 0.0;
            double max = 0.0;
            if (this.base.getAxeScale(axe).equalsIgnoreCase("lin") | this.base.getAxeScale(axe).equalsIgnoreCase("str")) {
                min = 0.0;
                max = 1.0;
            } else if (this.base.getAxeScale(axe).equalsIgnoreCase("log")) {
                min = 1.0;
                max = 10.0;
            }
            this.base.setRoundBounds(axe, min, max);
        }
        int i = 1;
        while (i < this.plots.size()) {
            Plot ploti = this.getPlot(i);
            this.base.includeInBounds(axe, Array.min(ploti.getBounds())[axe]);
            this.base.includeInBounds(axe, Array.max(ploti.getBounds())[axe]);
            ++i;
        }
        this.resetBase();
        this.repaint();
    }

    @Override
    public void resetBase() {
        this.draw.resetBaseProjection();
        this.grid.resetBase();
        int i = 0;
        while (i < this.objects.size()) {
            if (this.objects.get(i) instanceof BaseDependant) {
                ((BaseDependant)((Object)this.objects.get(i))).resetBase();
            }
            ++i;
        }
        this.repaint();
    }

    public void addLabel(String text, Color c, double ... where) {
        this.addPlotable(new Label(text, c, where));
    }

    public void addBaseLabel(String text, Color c, double ... where) {
        this.addPlotable(new BaseLabel(text, c, where));
    }

    public void addPlotable(Plotable p) {
        this.objects.add(p);
        this.repaint();
    }

    public void removePlotable(Plotable p) {
        this.objects.remove(p);
        this.repaint();
    }

    public void removePlotable(int i) {
        this.objects.remove(i);
        this.repaint();
    }

    public void removeAllPlotables() {
        this.objects.clear();
        this.repaint();
    }

    public void setAdjustBounds(boolean adjust) {
        this.adjustBounds = adjust;
    }

    public boolean getAdjustBounds() {
        return this.adjustBounds;
    }

    public int addPlot(Plot newPlot) {
        this.plots.add(newPlot);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        if (this.plots.size() == 1) {
            this.setAutoBounds();
        } else if (this.adjustBounds) {
            this.includeInBounds(newPlot);
        } else {
            this.repaint();
        }
        return this.plots.size() - 1;
    }

    public void setPlot(int I, Plot p) {
        this.plots.set(I, p);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.repaint();
    }

    public void changePlotData(int I, double[] ... XY) {
        this.getPlot(I).setData(XY);
        if (this.adjustBounds) {
            this.includeInBounds(this.getPlot(I));
        } else {
            this.repaint();
        }
    }

    public void changePlotName(int I, String name) {
        this.getPlot(I).setName(name);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.repaint();
    }

    public void changePlotColor(int I, Color c) {
        this.getPlot(I).setColor(c);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.repaint();
    }

    public void removePlot(int I) {
        this.plots.remove(I);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        if (this.plots.size() != 0) {
            if (this.adjustBounds) {
                this.setAutoBounds();
            } else {
                this.repaint();
            }
        }
    }

    public void removePlot(Plot p) {
        this.plots.remove(p);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        if (this.plots.size() != 0 && this.adjustBounds) {
            this.setAutoBounds();
        }
    }

    public void removeAllPlots() {
        this.plots.clear();
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.clearNotes();
    }

    public void addVectortoPlot(int numPlot, double[][] v) {
        this.getPlot(numPlot).addVector(v);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double[] q) {
        this.getPlot(numPlot).addQuantile(numAxe, rate, q, symetric);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double q) {
        this.getPlot(numPlot).addQuantile(numAxe, rate, q, symetric);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[][] q) {
        this.getPlot(numPlot).addQuantiles(numAxe, q);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[] q) {
        this.getPlot(numPlot).addQuantiles(numAxe, q);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double[] s) {
        this.getPlot(numPlot).addGaussQuantiles(numAxe, s);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double s) {
        this.getPlot(numPlot).addGaussQuantiles(numAxe, s);
    }

    public void toGraphicFile(File file) throws IOException {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        this.paint(image.getGraphics());
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setScalesFrame(JFrame scalesFrame) {
        this.scalesFrame = scalesFrame;
    }

    public void displayScalesFrame() {
        this.scalesFrame.setVisible(true);
    }

    public void setDataFrame(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
    }

    public void displayDataFrame(int i) {
        this.dataFrame.selectIndex(i);
    }

    public void displayDataFrame() {
        this.displayDataFrame(0);
    }

    public void resetMapData() {
        int i = 0;
        while (i < this.grid.getAxis().length) {
            this.grid.getAxis()[i].setStringMap(null);
            this.setAxiScale(i, "lin");
            ++i;
        }
        this.mapset = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double[][] mapData(Object[][] data) {
        double[][] mapeddata = new double[data.length][data[0].length];
        if (!this.mapset) {
            int j = 0;
            while (j < data[0].length) {
                if (!Array.isDouble(data[0][j].toString())) {
                    this.setAxiScale(j, "str");
                    ArrayList<String> string_array_j = new ArrayList<String>(data.length);
                    int i = 0;
                    while (i < data.length) {
                        string_array_j.add(data[i][j].toString());
                        ++i;
                    }
                    this.grid.getAxis(j).setStringMap(Array.mapStringArray(string_array_j));
                    this.grid.getAxis(j).init();
                    i = 0;
                    while (i < data.length) {
                        mapeddata[i][j] = this.grid.getAxis(j).getStringMap().get(data[i][j].toString());
                        ++i;
                    }
                    this.initReverseMap(j);
                } else {
                    int i = 0;
                    while (i < data.length) {
                        mapeddata[i][j] = Double.valueOf(data[i][j].toString());
                        ++i;
                    }
                }
                ++j;
            }
            this.mapset = true;
            return mapeddata;
        }
        int j = 0;
        while (j < data[0].length) {
            int i;
            if (!Array.isDouble(data[0][j].toString())) {
                if (!this.base.getAxeScale(j).equals("str")) throw new IllegalArgumentException("The mapping of this PlotPanel was not set on axis " + j);
                i = 0;
                while (i < data.length) {
                    if (!this.grid.getAxis(j).getStringMap().containsKey(data[i][j].toString())) {
                        Set<String> s = this.grid.getAxis(j).getStringMap().keySet();
                        ArrayList<String> string_array_j = new ArrayList<String>(s.size() + 1);
                        string_array_j.addAll(s);
                        string_array_j.add(data[i][j].toString());
                        this.grid.getAxis(j).setStringMap(Array.mapStringArray(string_array_j));
                        this.initReverseMap(j);
                    }
                    mapeddata[i][j] = this.grid.getAxis(j).getStringMap().get(data[i][j].toString());
                    ++i;
                }
            } else {
                i = 0;
                while (i < data.length) {
                    mapeddata[i][j] = Double.valueOf(data[i][j].toString());
                    ++i;
                }
            }
            ++j;
        }
        return mapeddata;
    }

    public Object[][] reverseMapedData(double[][] mapeddata) {
        Object[][] stringdata = new Object[mapeddata.length][mapeddata[0].length];
        int i = 0;
        while (i < mapeddata.length) {
            stringdata[i] = this.reverseMapedData(mapeddata[i]);
            ++i;
        }
        return stringdata;
    }

    public Object[] reverseMapedData(double[] mapeddata) {
        Object[] stringdata = new Object[mapeddata.length];
        if (this.reversedMaps == null) {
            this.reversedMaps = new HashMap[this.grid.getAxis().length];
        }
        int j = 0;
        while (j < mapeddata.length) {
            stringdata[j] = this.reversedMaps[j] != null ? this.reversedMaps[j].get(mapeddata[j]) : Double.valueOf(mapeddata[j]);
            ++j;
        }
        return stringdata;
    }

    private void initReverseMap(int j) {
        if (this.reversedMaps == null) {
            this.reversedMaps = new HashMap[this.grid.getAxis().length];
        }
        if (this.grid.getAxis(j) != null) {
            this.reversedMaps[j] = Array.reverseStringMap(this.grid.getAxis(j).getStringMap());
        }
    }

    @Override
    public void paint(Graphics gcomp) {
        Graphics2D gcomp2D = (Graphics2D)gcomp;
        gcomp2D.addRenderingHints(AALIAS);
        gcomp2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gcomp2D.setColor(this.getBackground());
        gcomp2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.draw.initGraphics(gcomp2D);
        this.grid.plot(this.draw);
        int i = 0;
        while (i < this.plots.size()) {
            this.getPlot(i).plot(this.draw);
            if (this.linkedLegendPanel != null) {
                this.linkedLegendPanel.nonote(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.objects.size()) {
            this.getPlotable(i).plot(this.draw);
            ++i;
        }
        if (this.allowNote) {
            i = 0;
            while (i < this.plots.size()) {
                if (this.getPlot((int)i).noted) {
                    if (this.linkedLegendPanel != null) {
                        this.linkedLegendPanel.note(i);
                    }
                    this.getPlot(i).note(this.draw);
                }
                if (this.allowNoteCoord && this.coordNoted != null) {
                    this.getPlot(i).noteCoord(this.draw, this.coordNoted);
                }
                ++i;
            }
        }
    }

    public void clearNotes() {
        this.coordNoted = null;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        switch (this.ActionMode) {
            case 1: {
                this.draw.translate(this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]);
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
                this.repaint();
                break;
            }
            case 0: {
                this.repaint();
                Graphics gcomp = this.getGraphics();
                gcomp.setColor(Color.black);
                gcomp.drawRect(FastMath.min(this.mouseClick[0], this.mouseCurent[0]), FastMath.min(this.mouseClick[1], this.mouseCurent[1]), FastMath.abs(this.mouseCurent[0] - this.mouseClick[0]), FastMath.abs(this.mouseCurent[1] - this.mouseClick[1]));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        switch (this.ActionMode) {
            case 0: {
                if (FastMath.abs(this.mouseCurent[0] - this.mouseClick[0]) <= 10 || FastMath.abs(this.mouseCurent[1] - this.mouseClick[1]) <= 10) break;
                int[] origin = new int[]{FastMath.min(this.mouseClick[0], this.mouseCurent[0]), FastMath.min(this.mouseClick[1], this.mouseCurent[1])};
                double[] ratio = new double[]{FastMath.abs((double)(this.mouseCurent[0] - this.mouseClick[0]) / (double)this.getWidth()), FastMath.abs((double)(this.mouseCurent[1] - this.mouseClick[1]) / (double)this.getHeight())};
                this.draw.dilate(origin, ratio);
                this.repaint();
            }
        }
        this.dragging = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i;
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        if (this.allowEdit && e.getModifiers() == 16 && e.getClickCount() > 1) {
            i = 0;
            while (i < this.grid.getAxis().length) {
                if (this.grid.getAxis(i).isSelected(this.mouseClick, this.draw) != null) {
                    this.grid.getAxis(i).edit(this);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.plots.size()) {
                if (this.getPlot(i).isSelected(this.mouseClick, this.draw) != null) {
                    return;
                }
                ++i;
            }
        }
        if (!this.dragging && this.allowNote) {
            i = 0;
            while (i < this.plots.size()) {
                double[] _coordNoted = this.getPlot(i).isSelected(this.mouseClick, this.draw);
                if (e.getModifiers() == 16) {
                    this.getPlot((int)i).noted = _coordNoted != null ? !this.getPlot((int)i).noted : false;
                } else if (e.getModifiers() == 4 && _coordNoted != null) {
                    if (this.coordNoted != null) {
                        boolean alreadyNoted = true;
                        int j = 0;
                        while (j < _coordNoted.length) {
                            alreadyNoted = alreadyNoted && _coordNoted[j] == this.coordNoted[j];
                            ++j;
                        }
                        this.coordNoted = (double[])(alreadyNoted ? null : _coordNoted);
                    } else {
                        this.coordNoted = _coordNoted;
                    }
                }
                ++i;
            }
            this.repaint();
        } else {
            this.dragging = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double[] ratio;
        int[] origin;
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        if (e.getWheelRotation() == -1) {
            origin = new int[]{this.getWidth() / 2 - this.getWidth() / 3, this.getHeight() / 2 - this.getHeight() / 3};
            ratio = new double[]{0.666, 0.666};
        } else {
            origin = new int[]{(int)((double)(this.getWidth() / 2) - (double)this.getWidth() / 1.333), (int)((double)(this.getHeight() / 2) - (double)this.getHeight() / 1.333)};
            ratio = new double[]{1.5, 1.5};
        }
        this.draw.dilate(origin, ratio);
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.draw != null) {
            this.draw.resetBaseProjection();
        }
        this.repaint();
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.componentResized(e);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

