/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot;

import java.awt.Color;
import org.math.plot.PlotPanel;
import org.math.plot.canvas.Plot3DCanvas;
import org.math.plot.canvas.PlotCanvas;
import org.math.plot.utils.Array;

public class Plot3DPanel
extends PlotPanel {
    private static final long serialVersionUID = 1L;

    public void setDefaultZoom(double zoom_factor) {
        ((Plot3DCanvas)this.plotCanvas).setDefaultZoom(zoom_factor);
        this.repaint();
    }

    public Plot3DPanel() {
        super(new Plot3DCanvas());
    }

    public Plot3DPanel(double[] min, double[] max, String[] axesScales, String[] axesLabels) {
        super(new Plot3DCanvas(min, max, axesScales, axesLabels));
    }

    public Plot3DPanel(PlotCanvas _canvas, String legendOrientation) {
        super(_canvas, legendOrientation);
    }

    public Plot3DPanel(PlotCanvas _canvas) {
        super(_canvas);
    }

    public Plot3DPanel(String legendOrientation) {
        super(new Plot3DCanvas(), legendOrientation);
    }

    public int addScatterPlot(String name, Color color, double[][] XY) {
        return ((Plot3DCanvas)this.plotCanvas).addScatterPlot(name, color, XY);
    }

    public int addScatterPlot(String name, Color color, double[] X, double[] Y, double[] Z) {
        return ((Plot3DCanvas)this.plotCanvas).addScatterPlot(name, color, X, Y, Z);
    }

    public int addScatterPlot(String name, double[][] XY) {
        return this.addScatterPlot(name, this.getNewColor(), XY);
    }

    public int addScatterPlot(String name, double[] X, double[] Y, double[] Z) {
        return this.addScatterPlot(name, this.getNewColor(), X, Y, Z);
    }

    public int addLinePlot(String name, Color color, double[][] XY) {
        return ((Plot3DCanvas)this.plotCanvas).addLinePlot(name, color, XY);
    }

    public int addLinePlot(String name, Color color, double[] X, double[] Y, double[] Z) {
        return ((Plot3DCanvas)this.plotCanvas).addLinePlot(name, color, X, Y, Z);
    }

    public int addLinePlot(String name, double[][] XY) {
        return this.addLinePlot(name, this.getNewColor(), XY);
    }

    public int addLinePlot(String name, double[] X, double[] Y, double[] Z) {
        return this.addLinePlot(name, this.getNewColor(), X, Y, Z);
    }

    public int addBarPlot(String name, Color color, double[][] XY) {
        return ((Plot3DCanvas)this.plotCanvas).addBarPlot(name, color, XY);
    }

    public int addBarPlot(String name, Color color, double[] X, double[] Y, double[] Z) {
        return ((Plot3DCanvas)this.plotCanvas).addBarPlot(name, color, X, Y, Z);
    }

    public int addBarPlot(String name, double[][] XY) {
        return this.addBarPlot(name, this.getNewColor(), XY);
    }

    public int addBarPlot(String name, double[] X, double[] Y, double[] Z) {
        return this.addBarPlot(name, this.getNewColor(), X, Y, Z);
    }

    public int addBoxPlot(String name, Color c, double[][] XY, double[][] dX) {
        return ((Plot3DCanvas)this.plotCanvas).addBoxPlot(name, c, XY, dX);
    }

    public int addBoxPlot(String name, double[][] XY, double[][] dX) {
        return this.addBoxPlot(name, this.getNewColor(), XY, dX);
    }

    public int addBoxPlot(String name, Color c, double[][] XYdX) {
        return ((Plot3DCanvas)this.plotCanvas).addBoxPlot(name, c, Array.getColumnsRangeCopy(XYdX, 0, 2), Array.getColumnsRangeCopy(XYdX, 3, 5));
    }

    public int addBoxPlot(String name, double[][] XYdX) {
        return this.addBoxPlot(name, this.getNewColor(), XYdX);
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double[][] dX) {
        return ((Plot3DCanvas)this.plotCanvas).addHistogramPlot(name, c, XY, dX);
    }

    public int addHistogramPlot(String name, double[][] XY, double[][] dX) {
        return this.addHistogramPlot(name, this.getNewColor(), XY, dX);
    }

    public int addHistogramPlot(String name, Color c, double[][] XYdX) {
        return ((Plot3DCanvas)this.plotCanvas).addHistogramPlot(name, c, Array.getColumnsRangeCopy(XYdX, 0, 2), Array.getColumnsRangeCopy(XYdX, 3, 4));
    }

    public int addHistogramPlot(String name, double[][] XYdX) {
        return this.addHistogramPlot(name, this.getNewColor(), XYdX);
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, int nX, int nY) {
        return ((Plot3DCanvas)this.plotCanvas).addHistogramPlot(name, c, XY, nX, nY);
    }

    public int addHistogramPlot(String name, double[][] XY, int nX, int nY) {
        return this.addHistogramPlot(name, this.getNewColor(), XY, nX, nY);
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double[] boundsX, double[] boundsY) {
        return ((Plot3DCanvas)this.plotCanvas).addHistogramPlot(name, c, XY, boundsX, boundsY);
    }

    public int addHistogramPlot(String name, double[][] XY, double[] boundsX, double[] boundsY) {
        return this.addHistogramPlot(name, this.getNewColor(), XY, boundsX, boundsY);
    }

    public int addHistogramPlot(String name, Color c, double[][] XY, double minX, double maxX, int nX, double minY, double maxY, int nY) {
        return ((Plot3DCanvas)this.plotCanvas).addHistogramPlot(name, c, XY, minX, maxX, nX, minY, maxY, nY);
    }

    public int addHistogramPlot(String name, double[][] XY, double minX, double maxX, int nX, double minY, double maxY, int nY) {
        return this.addHistogramPlot(name, this.getNewColor(), XY, minX, maxX, nX, minY, maxY, nY);
    }

    public int addGridPlot(String name, Color c, double[] X, double[] Y, double[][] Z) {
        return ((Plot3DCanvas)this.plotCanvas).addGridPlot(name, c, X, Y, Z);
    }

    public int addGridPlot(String name, double[] X, double[] Y, double[][] Z) {
        return this.addGridPlot(name, this.getNewColor(), X, Y, Z);
    }

    public int addGridPlot(String name, Color c, double[][] XYZMatrix) {
        return ((Plot3DCanvas)this.plotCanvas).addGridPlot(name, c, XYZMatrix);
    }

    public int addGridPlot(String name, double[][] XYZMatrix) {
        return this.addGridPlot(name, this.getNewColor(), XYZMatrix);
    }

    public int addGridPlotSphere(String name, float fTransparencey, Color c, double[][][] XYZ_list, boolean drawLines, boolean fillShape) {
        return ((Plot3DCanvas)this.plotCanvas).addGridPlotSphere(name, fTransparencey, c, XYZ_list, drawLines, fillShape);
    }

    public int addGridPlotSphere(String name, double[][][] XYZ_list) {
        return this.addGridPlotSphere(name, 0.3f, this.getNewColor(), XYZ_list, true, true);
    }

    public int addGridPlotSphere(String name, Color c, double[][][] XYZ_list) {
        return this.addGridPlotSphere(name, 0.3f, c, XYZ_list, true, true);
    }

    public int addCloudPlot(String name, Color color, double[][] sampleXYZ, int nX, int nY, int nZ) {
        return ((Plot3DCanvas)this.plotCanvas).addCloudPlot(name, color, sampleXYZ, nX, nY, nZ);
    }

    public int addCloudPlot(String name, double[][] sampleXYZ, int nX, int nY, int nZ) {
        return this.addCloudPlot(name, this.getNewColor(), sampleXYZ, nX, nY, nZ);
    }

    @Override
    public int addPlot(String type, String name, Color c, double[] ... XY) {
        if (type.equalsIgnoreCase("SCATTER")) {
            return this.addScatterPlot(name, c, XY);
        }
        if (type.equalsIgnoreCase("LINE")) {
            return this.addLinePlot(name, c, XY);
        }
        if (type.equalsIgnoreCase("BAR")) {
            return this.addBarPlot(name, c, XY);
        }
        if (type.equalsIgnoreCase("HISTOGRAM")) {
            return this.addHistogramPlot(name, c, XY);
        }
        if (type.equalsIgnoreCase("BOX")) {
            return this.addBoxPlot(name, c, XY);
        }
        if (type.equalsIgnoreCase("GRID")) {
            return this.addGridPlot(name, c, XY);
        }
        throw new IllegalArgumentException("Plot type is unknown : " + type);
    }

    public void rotate(double theta, double phi) {
        ((Plot3DCanvas)this.plotCanvas).rotate(theta, phi);
        this.repaint();
    }
}

