/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.math.io.files.ASCIIFile;
import org.math.plot.DataPanel;
import org.math.plot.utils.Array;

public class MatrixTablePanel
extends DataPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private TableModel model;
    private Object[][] M;
    private boolean viewHeaders = false;
    private String[] headers;

    public MatrixTablePanel(Object[][] m) {
        this.M = m;
        this.headers = this.M.length == 0 ? new String[0] : new String[this.M[0].length];
        this.setModel();
        this.toWindow();
    }

    @Override
    public void toClipBoard() {
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(Array.cat(this.M)), null);
        }
        catch (IllegalStateException e) {
            JOptionPane.showConfirmDialog(null, "Copy to clipboard failed : " + e.getMessage(), "Error", -1, 0);
        }
    }

    public String getText() {
        return this.M.toString();
    }

    @Override
    public void toASCIIFile(File file) {
        try {
            ASCIIFile.write((File)file, (String)Array.cat(this.M));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setModel() {
        this.model = new DefaultTableModel(this.M, this.headers){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }

    public void setHeaders(String[] h) {
        if (this.M.length != 0 && h.length != this.M[0].length) {
            throw new IllegalArgumentException("Headers of the table must have " + this.M[0].length + " elements.");
        }
        this.headers = h;
        this.update();
    }

    @Override
    public void update() {
        this.setModel();
        super.update();
    }

    public void setMatrix(Object[][] m) {
        this.M = m;
        this.headers = this.M.length == 0 ? new String[0] : new String[this.M[0].length];
        this.update();
    }

    @Override
    protected void toWindow() {
        this.table = new JTable(this.model);
        if (!this.viewHeaders) {
            this.table.setTableHeader(null);
        }
        this.table.setAutoResizeMode(4);
        this.table.setEnabled(false);
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
    }

    public Object[][] getMatrix() {
        return this.M;
    }
}

