/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.math.plot.FrameView;
import org.math.plot.Plot3DPanel;
import org.math.plot.utils.Array;

public class DataSelectTable
extends JPanel {
    private static final long serialVersionUID = 41918175232722331L;
    LinkedList<ParameterRow> rows;
    private Object[][] _data;
    private Object[][] _selecteddata;
    private LinkedList<Object[]> _tmpselecteddata;
    boolean dataUpdated = false;
    private int[] _tmpselectedIndex;
    private int _nbselected;
    private int[] _selectedindex;
    private String[] _parametersNames;
    private JTable _table;
    int _dimension;
    LinkedList<String> header;
    LinkedList<Class<?>> columnclasses;

    public DataSelectTable(Object[][] data, int dimension, String ... parametersNames) {
        this._data = data;
        this._dimension = dimension;
        this._parametersNames = parametersNames;
        if (this._dimension > parametersNames.length) {
            throw new IllegalArgumentException("Number of parameters must be > to dimension=" + this._dimension);
        }
        if (this._dimension == 1) {
            this.buildRows(0);
        } else if (this._dimension == 2) {
            this.buildRows(0, 1);
        } else if (this._dimension == 3) {
            this.buildRows(0, 1, 2);
        }
        this.add(new JScrollPane(this._table));
    }

    void buildRows(int ... selectedaxis) {
        this.header = new LinkedList();
        this.header.add("Parameter");
        if (this._dimension <= 1) {
            this.header.add("X");
        }
        if (this._dimension <= 2) {
            this.header.add("Y");
        }
        if (this._dimension <= 3) {
            this.header.add("Z");
        }
        this.header.add("min");
        this.header.add("<>");
        this.header.add("=");
        this.header.add("<>");
        this.header.add("max");
        this.columnclasses = new LinkedList();
        this.columnclasses.add(String.class);
        if (this._dimension <= 1) {
            this.columnclasses.add(Boolean.class);
        }
        if (this._dimension <= 2) {
            this.columnclasses.add(Boolean.class);
        }
        if (this._dimension <= 3) {
            this.columnclasses.add(Boolean.class);
        }
        this.columnclasses.add(Double.class);
        this.columnclasses.add(JSlider.class);
        this.columnclasses.add(Boolean.class);
        this.columnclasses.add(JSlider.class);
        this.columnclasses.add(Double.class);
        ButtonGroup xgrp = new ButtonGroup();
        ButtonGroup ygrp = new ButtonGroup();
        ButtonGroup zgrp = new ButtonGroup();
        this.rows = new LinkedList();
        int i = 0;
        while (i < this._parametersNames.length) {
            this.rows.add(new ParameterRow(this._parametersNames[i], DataSelectTable.getColumn(i, this._data)));
            this.rows.get((int)i).xaxis.setSelected(selectedaxis[0] == i);
            if (selectedaxis.length >= 2) {
                this.rows.get((int)i).yaxis.setSelected(selectedaxis[1] == i);
            }
            if (selectedaxis.length == 3) {
                this.rows.get((int)i).zaxis.setSelected(selectedaxis[2] == i);
            }
            xgrp.add(this.rows.get((int)i).xaxis);
            ygrp.add(this.rows.get((int)i).yaxis);
            zgrp.add(this.rows.get((int)i).zaxis);
            ++i;
        }
        this.updateSelectedData();
    }

    public void setData(Object[][] data) {
        if (data[0].length != this._data[0].length) {
            throw new IllegalArgumentException("new data dimension is not consistent with previous one.");
        }
        this._data = data;
        int[] selectedaxis = new int[this._dimension];
        int i = 0;
        while (i < this.rows.size()) {
            if (this.rows.get((int)i).xaxis.isSelected()) {
                selectedaxis[0] = i;
            }
            if (selectedaxis.length >= 2 && this.rows.get((int)i).yaxis.isSelected()) {
                selectedaxis[1] = i;
            }
            if (selectedaxis.length == 3 && this.rows.get((int)i).zaxis.isSelected()) {
                selectedaxis[2] = i;
            }
            this.rows.remove(i);
            ++i;
        }
        this.dataUpdated = false;
        this.buildRows(selectedaxis);
        this.fireSelectedDataChanged("setData");
    }

    void updateSelectedData() {
        if (this.dataUpdated) {
            return;
        }
        for (ParameterRow row : this.rows) {
            boolean isaxis;
            boolean bl = isaxis = row.xaxis.isSelected() || row.yaxis.isSelected() || row.zaxis.isSelected();
            if (row._isNumber) {
                row.min.setEnabled(!isaxis);
                row.max.setEnabled(!isaxis);
                continue;
            }
            row.list.setEnabled(!isaxis);
        }
        this._tmpselectedIndex = new int[this._data.length];
        this._nbselected = 0;
        this._tmpselecteddata = new LinkedList();
        int i = 0;
        while (i < this._data.length) {
            boolean sel = true;
            if (sel) {
                this._tmpselecteddata.add(this._data[i]);
                this._tmpselectedIndex[this._nbselected] = i;
                ++this._nbselected;
            }
            ++i;
        }
        this.dataUpdated = true;
    }

    public void fireSelectedDataChanged(String from) {
        System.out.println("fireSelectedDataChanged from " + from);
        Object[][] sel = this.getSelectedFullData();
        System.out.println("selected full data :");
        System.out.println(Array.cat(this._parametersNames));
        if (sel.length > 0) {
            System.out.println(Array.cat(this.getSelectedFullData()));
        }
        sel = this.getSelectedProjectedData();
        System.out.println("selected projected data :");
        switch (this._dimension) {
            case 1: {
                System.out.println(Array.cat(new String[]{this.getSelectedXAxis()}));
                break;
            }
            case 2: {
                System.out.println(Array.cat(new String[]{this.getSelectedXAxis(), this.getSelectedYAxis()}));
                break;
            }
            case 3: {
                System.out.println(Array.cat(new String[]{this.getSelectedXAxis(), this.getSelectedYAxis(), this.getSelectedZAxis()}));
            }
        }
        if (sel.length > 0) {
            System.out.println(Array.cat(this.getSelectedProjectedData()));
        }
    }

    public int[] getSelectedDataIndex() {
        this.updateSelectedData();
        this._selectedindex = new int[this._nbselected];
        int i = 0;
        while (i < this._nbselected) {
            this._selectedindex[i] = this._tmpselectedIndex[i];
            ++i;
        }
        return this._selectedindex;
    }

    public Object[][] getSelectedFullData() {
        this.updateSelectedData();
        this._selecteddata = new Object[this._tmpselecteddata.size()][this._data[0].length];
        int i = 0;
        while (i < this._selecteddata.length) {
            int j = 0;
            while (j < this._selecteddata[i].length) {
                this._selecteddata[i][j] = this._tmpselecteddata.get(i)[j];
                ++j;
            }
            ++i;
        }
        return this._selecteddata;
    }

    public Object[][] getSelectedProjectedData() {
        this.updateSelectedData();
        int[] selextedaxis = this.getSelectedAxisIndex();
        this._selecteddata = new Object[this._tmpselecteddata.size()][this._dimension];
        int i = 0;
        while (i < this._selecteddata.length) {
            int j = 0;
            while (j < this._dimension) {
                this._selecteddata[i][j] = this._tmpselecteddata.get(i)[selextedaxis[j]];
                ++j;
            }
            ++i;
        }
        return this._selecteddata;
    }

    public int[] getSelectedAxisIndex() {
        int[] selextedaxis = new int[this._dimension];
        this.updateSelectedData();
        return selextedaxis;
    }

    public String getSelectedXAxis() {
        this.updateSelectedData();
        for (ParameterRow row : this.rows) {
            if (!row.xaxis.isSelected()) continue;
            return row._paramName;
        }
        return null;
    }

    public String getSelectedYAxis() {
        this.updateSelectedData();
        for (ParameterRow row : this.rows) {
            if (!row.yaxis.isSelected()) continue;
            return row._paramName;
        }
        return null;
    }

    public String getSelectedZAxis() {
        this.updateSelectedData();
        for (ParameterRow row : this.rows) {
            if (!row.zaxis.isSelected()) continue;
            return row._paramName;
        }
        return null;
    }

    static Object[] getColumn(int j, Object[][] mat) {
        Object[] col = new Object[mat.length];
        int i = 0;
        while (i < col.length) {
            col[i] = mat[i][j];
            ++i;
        }
        return col;
    }

    public static void main(String[] args) {
        final Plot3DPanel pp = new Plot3DPanel("West");
        pp.setPreferredSize(new Dimension(400, 400));
        new FrameView(pp).setDefaultCloseOperation(3);
        Object[][] data = new Object[][]{{0, 0, 0, 0, "a0"}, {1, 1, 1, 1, "a1"}, {2, 2, 2, 2, "a2"}, {3, 3, 3, 3, "a3"}, {4, 3, 3, 3, "a3"}, {5, 3, 3, 3, "a4"}};
        DataSelectTable dsp = new DataSelectTable(data, 3, new String[]{"x1", "x2", "x3", "x4", "x5"}){
            private static final long serialVersionUID = 1L;

            @Override
            public void fireSelectedDataChanged(String from) {
                super.fireSelectedDataChanged(from);
                pp.setAxisLabel(0, this.getSelectedXAxis());
                pp.setAxisLabel(1, this.getSelectedYAxis());
                pp.setAxisLabel(2, this.getSelectedZAxis());
                if (pp.getPlots().size() == 0) {
                    pp.addPlot("SCATTER", "data", pp.mapData(this.getSelectedProjectedData()));
                } else if (from.endsWith("axis")) {
                    pp.resetMapData();
                    pp.removeAllPlots();
                    pp.addPlot("SCATTER", "data", pp.mapData(this.getSelectedProjectedData()));
                } else {
                    pp.getPlot(0).setData(pp.mapData(this.getSelectedProjectedData()));
                }
            }
        };
        new FrameView(dsp).setDefaultCloseOperation(3);
    }

    class Model
    implements TableModel {
        public Model(int ... selectedaxis) {
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return DataSelectTable.this._parametersNames[rowIndex];
            }
            if (columnIndex == DataSelectTable.this._dimension - 2) {
                return DataSelectTable.this.rows.get((int)rowIndex).xaxis;
            }
            if (columnIndex == DataSelectTable.this._dimension - 1) {
                return DataSelectTable.this.rows.get((int)rowIndex).yaxis;
            }
            if (columnIndex == DataSelectTable.this._dimension) {
                return DataSelectTable.this.rows.get((int)rowIndex).zaxis;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return DataSelectTable.this._parametersNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return DataSelectTable.this.header.get(columnIndex);
        }

        @Override
        public int getColumnCount() {
            return DataSelectTable.this.header.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return DataSelectTable.this.columnclasses.get(columnIndex);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }
    }

    class ParameterRow {
        String _paramName;
        JRadioButton xaxis;
        JRadioButton yaxis;
        JRadioButton zaxis;
        JComponent parameter;
        JSlider min;
        JSlider max;
        JCheckBox linkminmax;
        JList list;
        Vector<Object> _kernelStringValues;
        boolean _isNumber;
        double[] _kernelDoubleValues;

        public ParameterRow(String paramName, Object[] values) {
            this._paramName = paramName;
            this._isNumber = Array.isDouble(values[0].toString());
            if (!this._isNumber) {
                this._kernelStringValues = new Vector(values.length);
                int i = 0;
                while (i < values.length) {
                    if (!this._kernelStringValues.contains(values[i])) {
                        this._kernelStringValues.add(values[i]);
                    }
                    ++i;
                }
            } else {
                Vector<Double> _tmpdvalues = new Vector<Double>(values.length);
                int i = 0;
                while (i < values.length) {
                    if (!_tmpdvalues.contains(Double.valueOf(values[i].toString()))) {
                        _tmpdvalues.add(Double.valueOf(values[i].toString()));
                    }
                    ++i;
                }
                this._kernelDoubleValues = new double[_tmpdvalues.size()];
                i = 0;
                while (i < this._kernelDoubleValues.length) {
                    this._kernelDoubleValues[i] = (Double)_tmpdvalues.get(i);
                    ++i;
                }
            }
            DataSelectTable.this.setLayout(new GridLayout(1, 2));
            JPanel type = new JPanel(new BorderLayout());
            JPanel XYZ = new JPanel(new GridLayout(DataSelectTable.this._dimension, 1));
            this.xaxis = new JRadioButton("X");
            this.xaxis.addActionListener(new Action(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterRow.this.yaxis.setSelected(false);
                    ParameterRow.this.zaxis.setSelected(false);
                    for (ParameterRow r : ((ParameterRow)ParameterRow.this).DataSelectTable.this.rows) {
                        if (r._paramName.equals(ParameterRow.this._paramName)) continue;
                        r.xaxis.setSelected(false);
                    }
                    ((ParameterRow)ParameterRow.this).DataSelectTable.this.dataUpdated = false;
                    DataSelectTable.this.fireSelectedDataChanged(String.valueOf(ParameterRow.this._paramName) + " xaxis");
                }

                @Override
                public void setEnabled(boolean b) {
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener listener) {
                }

                @Override
                public void putValue(String key, Object value) {
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }

                @Override
                public Object getValue(String key) {
                    return null;
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener listener) {
                }
            });
            XYZ.add(this.xaxis);
            this.yaxis = new JRadioButton("Y");
            this.yaxis.addActionListener(new Action(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterRow.this.xaxis.setSelected(false);
                    ParameterRow.this.zaxis.setSelected(false);
                    for (ParameterRow r : ((ParameterRow)ParameterRow.this).DataSelectTable.this.rows) {
                        if (r._paramName.equals(ParameterRow.this._paramName)) continue;
                        r.yaxis.setSelected(false);
                    }
                    ((ParameterRow)ParameterRow.this).DataSelectTable.this.dataUpdated = false;
                    DataSelectTable.this.fireSelectedDataChanged(String.valueOf(ParameterRow.this._paramName) + " yaxis");
                }

                @Override
                public void setEnabled(boolean b) {
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener listener) {
                }

                @Override
                public void putValue(String key, Object value) {
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }

                @Override
                public Object getValue(String key) {
                    return null;
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener listener) {
                }
            });
            if (DataSelectTable.this._dimension >= 2) {
                XYZ.add(this.yaxis);
            }
            this.zaxis = new JRadioButton("Z");
            this.zaxis.addActionListener(new Action(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParameterRow.this.xaxis.setSelected(false);
                    ParameterRow.this.yaxis.setSelected(false);
                    for (ParameterRow r : ((ParameterRow)ParameterRow.this).DataSelectTable.this.rows) {
                        if (r._paramName.equals(ParameterRow.this._paramName)) continue;
                        r.zaxis.setSelected(false);
                    }
                    ((ParameterRow)ParameterRow.this).DataSelectTable.this.dataUpdated = false;
                    DataSelectTable.this.fireSelectedDataChanged(String.valueOf(ParameterRow.this._paramName) + " zaxis");
                }

                @Override
                public void setEnabled(boolean b) {
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener listener) {
                }

                @Override
                public void putValue(String key, Object value) {
                }

                @Override
                public boolean isEnabled() {
                    return true;
                }

                @Override
                public Object getValue(String key) {
                    return null;
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener listener) {
                }
            });
            if (DataSelectTable.this._dimension == 3) {
                XYZ.add(this.zaxis);
            }
            type.add((Component)XYZ, "West");
            if (this._isNumber) {
                this.parameter = new JPanel();
                this.parameter.setLayout(new GridLayout(2, 1));
                this.min = new JSlider(1, this._kernelDoubleValues.length, 1);
                this.min.setMinorTickSpacing(1);
                this.min.setSnapToTicks(true);
                this.min.setPaintTicks(true);
                this.max = new JSlider(1, this._kernelDoubleValues.length, this._kernelDoubleValues.length);
                this.max.setMinorTickSpacing(1);
                this.max.setSnapToTicks(true);
                this.max.setPaintTicks(true);
                this.min.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (ParameterRow.this.max.getValue() < ParameterRow.this.min.getValue()) {
                            ParameterRow.this.max.setValue(ParameterRow.this.min.getValue());
                        }
                        ((ParameterRow)ParameterRow.this).DataSelectTable.this.dataUpdated = false;
                        DataSelectTable.this.fireSelectedDataChanged(String.valueOf(ParameterRow.this._paramName) + " min");
                    }
                });
                this.max.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (ParameterRow.this.max.getValue() < ParameterRow.this.min.getValue()) {
                            ParameterRow.this.min.setValue(ParameterRow.this.max.getValue());
                        }
                        ((ParameterRow)ParameterRow.this).DataSelectTable.this.dataUpdated = false;
                        DataSelectTable.this.fireSelectedDataChanged(String.valueOf(ParameterRow.this._paramName) + " max");
                    }
                });
                this.parameter.add((Component)this.min, 0);
                this.parameter.add((Component)this.max, 1);
            } else {
                this.list = new JList<Object>(this._kernelStringValues);
                this.list.setSelectedIndices(this.buildIntSeq(0, this._kernelStringValues.size() - 1));
                this.list.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        ((ParameterRow)ParameterRow.this).DataSelectTable.this.dataUpdated = false;
                        DataSelectTable.this.fireSelectedDataChanged(String.valueOf(ParameterRow.this._paramName) + " list");
                    }
                });
                this.parameter = new JScrollPane(this.list);
            }
            type.add((Component)this.parameter, "Center");
            DataSelectTable.this.add((Component)type, 1);
            DataSelectTable.this.setBorder(BorderFactory.createEtchedBorder());
            DataSelectTable.this.setPreferredSize(new Dimension(400, 60));
        }

        int[] buildIntSeq(int min, int max) {
            int[] seq = new int[max - min + 1];
            int i = 0;
            while (i < seq.length) {
                seq[i] = min + i;
                ++i;
            }
            return seq;
        }

        boolean check(Object value) {
            if (this._isNumber) {
                double dval = Double.valueOf(value.toString());
                return dval >= this._kernelDoubleValues[this.min.getValue() - 1] && dval <= this._kernelDoubleValues[this.max.getValue() - 1];
            }
            int i = 0;
            while (i < this.list.getSelectedIndices().length) {
                if (this._kernelStringValues.get(this.list.getSelectedIndices()[i]).equals(value)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

