/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import org.apache.log4j.Logger;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;

public class Visualize {
    static Logger logger = Logger.getLogger(Visualize.class);

    public static double[][][] generateVertLineArrays(double[][] fHorCoord, double[][] XYZMatrix) {
        int iVertArray = fHorCoord.length;
        int iInc = (iVertArray - 1) / 2;
        int iHorArray = iInc * 4 + 1;
        double[][][] rv = new double[iHorArray][iVertArray][4];
        try {
            double[] v = new double[3];
            int iDegree = 10;
            try {
                iDegree = 90 / iInc;
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
            }
            int i = 0;
            while (i < iHorArray) {
                int j = 0;
                while (j < iVertArray) {
                    int iDegreeNow = i * iDegree;
                    double x = fHorCoord[j][0];
                    double y = fHorCoord[j][1];
                    double z = fHorCoord[j][2];
                    double dRad = Math.toRadians(iDegreeNow);
                    double[][] R = new double[2][2];
                    R[0][0] = Math.cos(dRad);
                    R[0][1] = -Math.sin(dRad);
                    R[1][0] = Math.sin(dRad);
                    R[1][1] = Math.cos(dRad);
                    v[0] = x * R[0][0] + y * R[0][1];
                    v[1] = x * R[1][0] + y * R[1][1];
                    v[2] = z;
                    v[0] = (double)Math.round(v[0] * 100.0) / 100.0;
                    v[1] = (double)Math.round(v[1] * 100.0) / 100.0;
                    v[2] = (double)Math.round(v[2] * 100.0) / 100.0;
                    double[] rvO = Visualize.fZOv(v[0], v[1], v[2], XYZMatrix);
                    rv[i][j][0] = rvO[0];
                    rv[i][j][1] = rvO[1];
                    rv[i][j][2] = rvO[2];
                    rv[i][j][3] = rvO[3];
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)("generateLineArrays: " + _ex.getMessage()));
            System.out.println("generateLineArrays: " + _ex.toString());
        }
        return rv;
    }

    public static double[][] fVertPlane(int iInc, double[][] XYZMatrix) {
        int iVertArray = iInc * 2 + 1;
        double[][] rv = new double[iVertArray][4];
        try {
            int iDegree = 10;
            iDegree = 90 / iInc;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            int i = 0;
            while (i < iVertArray) {
                int iDegreeNow = i * iDegree;
                double dRad = (double)(iDegreeNow / 180) * Math.PI;
                dRad = Math.toRadians(iDegreeNow);
                x = Math.sin(dRad);
                y = 0.0;
                z = Math.cos(dRad);
                rv[i][0] = (double)Math.round(x * 100.0) / 100.0;
                rv[i][1] = y;
                rv[i][2] = (double)Math.round(z * 100.0) / 100.0;
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)("fVertPlane" + _ex.getMessage()));
            System.out.println("fVertPlane" + _ex.toString());
        }
        return rv;
    }

    public static double[][] generateProjetion(ProjectionDirection _pDirection, double[][][] XYZComplete) {
        int iIncHor = XYZComplete.length;
        int iIncVert = XYZComplete[0].length;
        double[][] rv = new double[iIncHor][3];
        try {
            if (_pDirection == ProjectionDirection.X) {
                int iYZPlanePlus90 = iIncHor / 4;
                int iYZPlanePlus270 = iYZPlanePlus90 * 3;
                int iArrayLength = iIncVert * 2;
                rv = new double[iArrayLength][3];
                int i = 0;
                while (i < iIncVert) {
                    rv[i][0] = XYZComplete[iYZPlanePlus90][i][1];
                    rv[i][1] = XYZComplete[iYZPlanePlus90][i][2];
                    rv[i][2] = XYZComplete[iYZPlanePlus90][i][3];
                    ++i;
                }
                int iDesc = iIncVert - 1;
                int iCount = iIncVert;
                int i2 = 0;
                while (i2 < iIncVert) {
                    rv[iCount + i2][0] = XYZComplete[iYZPlanePlus270][iDesc - i2][1];
                    rv[iCount + i2][1] = XYZComplete[iYZPlanePlus270][iDesc - i2][2];
                    rv[iCount + i2][2] = XYZComplete[iYZPlanePlus270][iDesc - i2][3];
                    ++i2;
                }
            } else if (_pDirection == ProjectionDirection.Y) {
                int iXZPlanePlus180 = iIncHor / 2;
                int iArrayLength = iIncVert * 2;
                rv = new double[iArrayLength][3];
                int i = 0;
                while (i < iIncVert) {
                    rv[i][0] = XYZComplete[0][i][0];
                    rv[i][1] = XYZComplete[0][i][2];
                    rv[i][2] = XYZComplete[0][i][3];
                    ++i;
                }
                int iDesc = iIncVert - 1;
                int iCount = iIncVert;
                int i3 = 0;
                while (i3 < iIncVert) {
                    rv[iCount + i3][0] = XYZComplete[iXZPlanePlus180][iDesc - i3][0];
                    rv[iCount + i3][1] = XYZComplete[iXZPlanePlus180][iDesc - i3][2];
                    rv[iCount + i3][2] = XYZComplete[iXZPlanePlus180][iDesc - i3][3];
                    ++i3;
                }
            } else if (_pDirection == ProjectionDirection.Z) {
                int iXYPlane = iIncVert / 2;
                int i = 0;
                while (i < iIncHor) {
                    rv[i][0] = XYZComplete[i][iXYPlane][0];
                    rv[i][1] = XYZComplete[i][iXYPlane][1];
                    rv[i][2] = XYZComplete[i][iXYPlane][3];
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            System.out.println("generateProjetion: " + _ex.toString());
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    public static double[] fZOv(double x, double y, double z, double[][] XYZMatrix) {
        double[] RV = new double[4];
        try {
            double[] nV = new double[3];
            double nvAmp = x * x + y * y + z * z;
            double vB = Math.sqrt(nvAmp);
            nV[0] = x / vB;
            nV[1] = y / vB;
            nV[2] = z / vB;
            double tB = 0.0;
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    double dCheck = tB;
                    dCheck = nV[i] * nV[j] * XYZMatrix[i][j];
                    tB += dCheck;
                    ++j;
                }
                ++i;
            }
            RV[3] = 1.0;
            if (Double.compare(tB *= 1.0E7, 0.0) < 0) {
                RV[3] = Visualize.equals(tB, 0.0, 0.5) ? 0.0 : (double)Double.compare(tB, 0.0);
            }
            RV[0] = (double)Math.round(tB * nV[0] * 100.0) / 100.0;
            RV[1] = (double)Math.round(tB * nV[1] * 100.0) / 100.0;
            RV[2] = (double)Math.round(tB * nV[2] * 100.0) / 100.0;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
            System.out.println("fZOv" + _ex.toString());
        }
        return RV;
    }

    public static boolean equals(double a, double b, double eps) {
        return Math.abs(a - b) < eps;
    }

    public static double[][] generate2DProjectionNewCalc(ProjectionDirection pProjDir, double[][] XYZMatrix) {
        double[][] _unitCircleCoords = Visualize.generateCircleCoords(pProjDir);
        double[][] rv = new double[_unitCircleCoords.length][3];
        try {
            int i = 0;
            while (i < _unitCircleCoords.length) {
                double[] ds = _unitCircleCoords[i];
                double[] _calcRV = Visualize.fZOv(ds[0], ds[1], ds[2], XYZMatrix);
                if (pProjDir == ProjectionDirection.X) {
                    rv[i][0] = _calcRV[1];
                    rv[i][1] = _calcRV[2];
                    rv[i][2] = _calcRV[3];
                } else if (pProjDir == ProjectionDirection.Y) {
                    rv[i][0] = _calcRV[0];
                    rv[i][1] = _calcRV[2];
                    rv[i][2] = _calcRV[3];
                } else if (pProjDir == ProjectionDirection.Z) {
                    rv[i][0] = _calcRV[0];
                    rv[i][1] = _calcRV[1];
                    rv[i][2] = _calcRV[3];
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
            System.out.println("generate2DProjectionNewCalc: " + _ex.toString());
        }
        return rv;
    }

    private static double[][] generateCircleCoords(ProjectionDirection pProjDir) {
        double[][] rv = new double[361][3];
        int i = 0;
        while (i < rv.length) {
            double x = Math.cos(Math.toRadians(i * 1)) * 1.0;
            double y = Math.sin(Math.toRadians(i * 1)) * 1.0;
            if (pProjDir == ProjectionDirection.X) {
                rv[i][0] = 0.0;
                rv[i][1] = x;
                rv[i][2] = y;
            } else if (pProjDir == ProjectionDirection.Y) {
                rv[i][0] = x;
                rv[i][1] = 0.0;
                rv[i][2] = y;
            } else if (pProjDir == ProjectionDirection.Z) {
                rv[i][0] = x;
                rv[i][1] = y;
                rv[i][2] = 0.0;
            }
            ++i;
        }
        return rv;
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        double[][] XYZ = Visualize.generateCircleCoords(ProjectionDirection.X);
        p2.addScatterPlot("Projection Circle", XYZ);
        p2.setLegendOrientation("South");
        new FrameView(p2).setDefaultCloseOperation(3);
    }

    public static enum ProjectionDirection {
        X,
        Y,
        Z,
        SectionPlot;

    }
}

