/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

public class VectorProds {
    public static void main(String[] args) {
        Vector3D<Double> e = new Vector3D<Double>(0.0, 1.0, 0.0);
        Vector3D<Double> f = new Vector3D<Double>(0.741148, 0.0, -0.671342);
        Vector3D<Integer> a = new Vector3D<Integer>(3, 4, 5);
        Vector3D<Integer> b = new Vector3D<Integer>(4, 3, 5);
        Vector3D<Integer> c = new Vector3D<Integer>(-5, -12, -13);
        System.out.println(a.dot(b));
        System.out.println(e.cross(f));
        System.out.println(a.scalTrip(b, c));
        System.out.println(a.vecTrip(b, c));
    }

    public static class Vector3D<T extends Number> {
        private T a;
        private T b;
        private T c;

        public T getA() {
            return this.a;
        }

        public T getB() {
            return this.b;
        }

        public T getC() {
            return this.c;
        }

        public Vector3D(T a, T b, T c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public double dot(Vector3D<?> vec) {
            return ((Number)this.a).doubleValue() * ((Number)vec.a).doubleValue() + ((Number)this.b).doubleValue() * ((Number)vec.b).doubleValue() + ((Number)this.c).doubleValue() * ((Number)vec.c).doubleValue();
        }

        public Vector3D<Double> cross(Vector3D<?> vec) {
            Double newA = ((Number)this.b).doubleValue() * ((Number)vec.c).doubleValue() - ((Number)this.c).doubleValue() * ((Number)vec.b).doubleValue();
            Double newB = ((Number)this.c).doubleValue() * ((Number)vec.a).doubleValue() - ((Number)this.a).doubleValue() * ((Number)vec.c).doubleValue();
            Double newC = ((Number)this.a).doubleValue() * ((Number)vec.b).doubleValue() - ((Number)this.b).doubleValue() * ((Number)vec.a).doubleValue();
            return new Vector3D<Double>(newA, newB, newC);
        }

        public double scalTrip(Vector3D<?> vecB, Vector3D<?> vecC) {
            return this.dot(vecB.cross(vecC));
        }

        public Vector3D<Double> vecTrip(Vector3D<?> vecB, Vector3D<?> vecC) {
            return this.cross(vecB.cross(vecC));
        }

        public String toString() {
            return "<" + this.a.toString() + ", " + this.b.toString() + ", " + this.c.toString() + ">";
        }
    }
}

