/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TableRowHeader
extends JViewport
implements AdjustmentListener {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private Cell cell;
    private boolean isBase;

    public TableRowHeader(JTable table, JScrollPane parent, boolean pIsBase) {
        this.isBase = pIsBase;
        this.table = table;
        this.cell = new Cell();
        this.setView(new Dummy());
        this.setPreferredSize(new Dimension(100, 0));
        parent.getVerticalScrollBar().addAdjustmentListener(this);
        parent.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle rec = this.getViewRect();
        int y = 0;
        int rows = this.table.getRowCount();
        int index = 0;
        if (rows == 0) {
            return;
        }
        if (y + this.table.getRowHeight(0) < rec.y) {
            while (index < rows) {
                int height = this.table.getRowHeight(index);
                if (y + height >= rec.y) break;
                y += height;
                ++index;
            }
        }
        int max = rec.y + rec.height;
        int width = this.getWidth();
        while (y < max && index < rows) {
            int height = this.table.getRowHeight(index);
            this.cell.set(index);
            SwingUtilities.paintComponent(g, this.cell, this, 0, y - rec.y, width, height);
            y += height;
            ++index;
        }
    }

    private class Cell
    extends JLabel {
        private static final long serialVersionUID = 1L;

        private Cell() {
        }

        public void set(int row) {
            this.setHorizontalAlignment(0);
            this.setForeground(TableRowHeader.this.getForeground());
            this.setBackground(TableRowHeader.this.getBackground());
            this.setFont(TableRowHeader.this.getFont());
            if (TableRowHeader.this.isBase) {
                this.setText("e" + ++row);
            } else {
                switch (row) {
                    case 0: {
                        this.setText("a");
                        break;
                    }
                    case 1: {
                        this.setText("b");
                        break;
                    }
                    case 2: {
                        this.setText("c");
                        break;
                    }
                }
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
    }

    private static class Dummy
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Dummy() {
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void update(Graphics g) {
        }
    }
}

