/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;

public class SwingAppender
extends WriterAppender {
    static Logger logger = Logger.getLogger(SwingAppender.class);
    private static JTextPane logTextPane = null;

    public void setTextArea(JTextPane logTextPane) {
        SwingAppender.logTextPane = logTextPane;
    }

    public void append(LoggingEvent loggingEvent) {
        final String message = this.layout.format(loggingEvent);
        final LoggingEvent currentEvent = loggingEvent;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleAttributeSet a = new SimpleAttributeSet();
                StyledDocument styledDocMainLowerText = (StyledDocument)logTextPane.getDocument();
                Style style = styledDocMainLowerText.addStyle("StyledDocument", null);
                styledDocMainLowerText.setParagraphAttributes(0, styledDocMainLowerText.getLength(), a, true);
                StyleConstants.setFontFamily(style, "Cursive");
                StyleConstants.setFontSize(style, 12);
                if (currentEvent.getLevel().toString() == "ERROR") {
                    StyleConstants.setForeground(style, Color.red);
                } else {
                    StyleConstants.setForeground(style, Color.blue);
                }
                try {
                    styledDocMainLowerText.insertString(styledDocMainLowerText.getLength(), message, style);
                }
                catch (BadLocationException e) {
                    logger.fatal((Object)e);
                }
            }
        });
    }
}

