/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Jama.Matrix;
import java.util.List;
import myObjects.LattParam;
import myObjects.eCrystalSystem;
import myObjects.functions.IFunctions;
import myUtilities.CalcUVW_HKL;
import myUtilities.Visualize;
import org.apache.log4j.Logger;

public class SectionPlotUtils {
    static Logger logger = Logger.getLogger(SectionPlotUtils.class);

    public static double[] returnUVW2Ortho(int[] _uvw, double dTemp, List<IFunctions> _polyList, eCrystalSystem pCrystalSystem, double[][] pCTE) {
        double[] _rv = null;
        try {
            if (_polyList != null) {
                LattParam _lattParam = CalcUVW_HKL.returnLattParam(_polyList, dTemp, pCrystalSystem);
                double[][] _matrice = new double[3][3];
                _matrice[0][0] = SectionPlotUtils.returnRounded(_lattParam.getA() * _lattParam.getA(), 6);
                _matrice[1][1] = SectionPlotUtils.returnRounded(_lattParam.getB() * _lattParam.getB(), 6);
                _matrice[2][2] = SectionPlotUtils.returnRounded(_lattParam.getC() * _lattParam.getC(), 6);
                _matrice[0][1] = SectionPlotUtils.returnRounded(_lattParam.getA() * _lattParam.getB() * Math.cos(Math.toRadians(_lattParam.getGamma())), 6);
                _matrice[1][0] = _matrice[0][1];
                _matrice[0][2] = SectionPlotUtils.returnRounded(_lattParam.getA() * _lattParam.getC() * Math.cos(Math.toRadians(_lattParam.getBeta())), 6);
                _matrice[2][0] = _matrice[0][2];
                _matrice[2][1] = SectionPlotUtils.returnRounded(_lattParam.getB() * _lattParam.getC() * Math.cos(Math.toRadians(_lattParam.getAlpha())), 6);
                _matrice[1][2] = _matrice[2][1];
                Matrix _mat = new Matrix(_matrice);
                double dDet = _mat.det();
                double dVolume = Math.sqrt(SectionPlotUtils.returnRounded(dDet, 4));
                double a = _lattParam.getA();
                double b = _lattParam.getB();
                double c = _lattParam.getC();
                double alpha = Math.toRadians(_lattParam.getAlpha());
                double beta = Math.toRadians(_lattParam.getBeta());
                double gamma = Math.toRadians(_lattParam.getGamma());
                double aRec = b * c * Math.sin(alpha) / dVolume;
                double bRec = a * c * Math.sin(beta) / dVolume;
                double cRec = a * b * Math.sin(gamma) / dVolume;
                double alphaRecTerm1 = Math.cos(beta) * Math.cos(gamma) - Math.cos(alpha);
                double alphaRecTerm2 = Math.sin(beta) * Math.sin(gamma);
                double alphaRec = Math.acos(alphaRecTerm1 / alphaRecTerm2);
                double betaRecTerm1 = Math.cos(alpha) * Math.cos(gamma) - Math.cos(beta);
                double betaRecTerm2 = Math.sin(alpha) * Math.sin(gamma);
                double betaRec = Math.acos(betaRecTerm1 / betaRecTerm2);
                double gammaRecTerm1 = Math.cos(beta) * Math.cos(alpha) - Math.cos(gamma);
                double gammaRecTerm2 = Math.sin(beta) * Math.sin(alpha);
                double gammaRec = Math.acos(gammaRecTerm1 / gammaRecTerm2);
                int u = _uvw[0];
                int v = _uvw[1];
                int w = _uvw[2];
                double t_uvwTerm1 = Math.pow(u, 2.0) * _matrice[0][0] + Math.pow(v, 2.0) * _matrice[1][1] + Math.pow(w, 2.0) * _matrice[2][2];
                double t_uvwTerm2 = (double)(2 * v * w) * _matrice[2][1] + (double)(2 * u * v) * _matrice[1][0] + (double)(2 * u * w) * _matrice[2][0];
                double t_uvw = Math.sqrt(t_uvwTerm1 + t_uvwTerm2);
                double dVolRec = 1.0 / dVolume;
                double x = 1.0 / (dVolRec * c * t_uvw) * ((double)u * bRec - (double)v * aRec * Math.cos(gammaRec));
                double y = (double)v / (bRec * t_uvw);
                double z = 1.0 / t_uvw * ((double)u * a * Math.cos(beta) + (double)v * b * Math.cos(alpha) + (double)w * c);
                _rv = new double[]{x, y, z};
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _rv;
    }

    private static double returnRounded(double value, int frac) {
        return (double)Math.round(Math.pow(10.0, frac) * value) / Math.pow(10.0, frac);
    }

    public static boolean compareArrays(int[] a1, int[] a2) {
        boolean b = true;
        if (a1 != null && a2 != null) {
            if (a1.length != a2.length) {
                b = false;
                return b;
            }
            int i = 0;
            while (i < a2.length) {
                if (a2[i] != a1[i]) {
                    b = false;
                    return b;
                }
                ++i;
            }
        } else {
            b = false;
            return b;
        }
        return b;
    }

    public static double[][] generateCircleCoords(double[] nRotAxis, double[] sStartCoord, double[] uvw2, double[][] pCTE) {
        double[][] rv = new double[362][4];
        double[] n = new double[]{nRotAxis[0], nRotAxis[1], nRotAxis[2]};
        double dAlpha = Math.toRadians(0.0);
        double[][] rotationMatrice = new double[3][3];
        dAlpha = Math.toRadians(1.0);
        double dTerm = 1.0 - Math.cos(dAlpha);
        rotationMatrice[0][0] = n[0] * n[0] * dTerm + Math.cos(dAlpha);
        rotationMatrice[0][1] = n[0] * n[1] * dTerm - n[2] * Math.sin(dAlpha);
        rotationMatrice[0][2] = n[0] * n[2] * dTerm + n[1] * Math.sin(dAlpha);
        rotationMatrice[1][0] = n[0] * n[1] * dTerm + n[2] * Math.sin(dAlpha);
        rotationMatrice[1][1] = n[1] * n[1] * dTerm + Math.cos(dAlpha);
        rotationMatrice[1][2] = n[1] * n[2] * dTerm - n[0] * Math.sin(dAlpha);
        rotationMatrice[2][0] = n[0] * n[2] * dTerm - n[1] * Math.sin(dAlpha);
        rotationMatrice[2][1] = n[1] * n[2] * dTerm + n[0] * Math.sin(dAlpha);
        rotationMatrice[2][2] = n[2] * n[2] * dTerm + Math.cos(dAlpha);
        double[] merker = sStartCoord;
        int iAlpha = 0;
        while (iAlpha < rv.length) {
            int i = 0;
            while (i < 3) {
                double coeff = 0.0;
                int j = 0;
                while (j < 3) {
                    coeff += merker[j] * rotationMatrice[i][j];
                    ++j;
                }
                rv[iAlpha][i] = SectionPlotUtils.returnRounded(coeff, 6);
                ++i;
            }
            merker[0] = rv[iAlpha][0];
            merker[1] = rv[iAlpha][1];
            merker[2] = rv[iAlpha][2];
            double[] dmultCTE = Visualize.fZOv(merker[0], merker[1], merker[2], pCTE);
            rv[iAlpha][0] = dmultCTE[0];
            rv[iAlpha][1] = dmultCTE[1];
            rv[iAlpha][2] = dmultCTE[2];
            rv[iAlpha][3] = dmultCTE[3];
            ++iAlpha;
        }
        double[] uvw2CTE = Visualize.fZOv(uvw2[0], uvw2[1], uvw2[2], pCTE);
        rv[361] = uvw2CTE;
        return rv;
    }

    public static double[][] HouseholderTransformation(double[][] psectionPlotCoords, double[] nVec) {
        double[][] rv = null;
        try {
            if (psectionPlotCoords.length != 0) {
                int j;
                rv = new double[psectionPlotCoords.length][psectionPlotCoords[0].length];
                double[][] dyadProd = new double[3][3];
                int i = 0;
                while (i < 3) {
                    int j2 = 0;
                    while (j2 < 3) {
                        dyadProd[i][j2] = nVec[i] * nVec[j2];
                        ++j2;
                    }
                    ++i;
                }
                double[][] HouseholderMat = new double[3][3];
                HouseholderMat[0][0] = 1.0;
                HouseholderMat[1][1] = 1.0;
                HouseholderMat[2][2] = 1.0;
                int i2 = 0;
                while (i2 < 3) {
                    j = 0;
                    while (j < 3) {
                        HouseholderMat[i2][j] = HouseholderMat[i2][j] - dyadProd[i2][j];
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < psectionPlotCoords.length) {
                    j = 0;
                    while (j < 3) {
                        double sum = 0.0;
                        int k = 0;
                        while (k < 3) {
                            sum += HouseholderMat[j][k] * psectionPlotCoords[i2][k];
                            ++k;
                        }
                        rv[i2][j] = SectionPlotUtils.returnRounded(sum, 6);
                        ++j;
                    }
                    ++i2;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public static double[][] rotateIntoSection(double[][] psectionPlotCoords, double[] nVec) {
        double[][] rv = null;
        try {
            double n1 = nVec[0];
            double n2 = nVec[1];
            double n3 = nVec[2];
            double alpha = Math.signum(n2) * Math.acos(n3 / Math.sqrt(n2 * n2 + n3 * n3));
            double beta = Math.signum(n1) * Math.acos(Math.sqrt(n2 * n2 + n3 * n3) / Math.sqrt(n1 * n1 + n2 * n2 + n3 * n3));
            double alphaGrad = Math.toDegrees(alpha);
            double betaGrad = Math.toDegrees(beta);
            double[][] Rx = new double[3][3];
            Rx[0][0] = 1.0;
            Rx[0][1] = 0.0;
            Rx[0][2] = 0.0;
            Rx[1][0] = 0.0;
            Rx[1][1] = Math.cos(alpha);
            Rx[1][2] = Math.sin(alpha);
            Rx[2][0] = 0.0;
            Rx[2][1] = -Math.sin(alpha);
            Rx[2][2] = Math.cos(alpha);
            double[][] Ry = new double[3][3];
            Ry[0][0] = Math.cos(beta);
            Ry[0][1] = 0.0;
            Ry[0][2] = -Math.sin(beta);
            Ry[1][0] = 0.0;
            Ry[1][1] = 1.0;
            Ry[1][2] = 0.0;
            Ry[2][0] = Math.sin(beta);
            Ry[2][1] = 0.0;
            Ry[2][2] = Math.cos(beta);
            rv = new double[psectionPlotCoords.length][3];
            int i = 0;
            while (i < psectionPlotCoords.length) {
                double x = psectionPlotCoords[i][0];
                double y = psectionPlotCoords[i][1];
                double z = psectionPlotCoords[i][2];
                double rotX = 0.0;
                double rotY = 0.0;
                double rotZ = 0.0;
                rotX = x * Rx[0][0] + y * Rx[0][1] + z * Rx[0][2];
                rotY = x * Rx[1][0] + y * Rx[1][1] + z * Rx[1][2];
                rotZ = x * Rx[2][0] + y * Rx[2][1] + z * Rx[2][2];
                double rot2X = 0.0;
                double rot2Y = 0.0;
                double rot2Z = 0.0;
                rot2X = rotX * Ry[0][0] + rotY * Ry[0][1] + rotZ * Ry[0][2];
                rot2Y = rotX * Ry[1][0] + rotY * Ry[1][1] + rotZ * Ry[1][2];
                rot2Z = rotX * Ry[2][0] + rotY * Ry[2][1] + rotZ * Ry[2][2];
                rv[i][0] = rot2X;
                rv[i][1] = rot2Y;
                rv[i][2] = psectionPlotCoords[i][3];
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public static double[] returnCrossProduct(double[] vec1, double[] vec2) {
        double[] rv = null;
        try {
            int iLength = vec1.length;
            if (iLength == 3 && vec2.length == iLength) {
                rv = new double[]{vec1[1] * vec2[2] - vec1[2] * vec2[1], vec1[2] * vec2[0] - vec1[0] * vec2[2], vec1[0] * vec2[1] - vec1[1] * vec2[0]};
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    public static double[] returnNormalizedVector(double[] vec) {
        double[] rv = null;
        try {
            int iLength = vec.length;
            if (iLength == 3) {
                rv = new double[3];
                double sq = vec[0] * vec[0] + vec[1] * vec[1] + vec[2] * vec[2];
                int i = 0;
                while (i < iLength) {
                    rv[i] = vec[i] / Math.sqrt(sq);
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }
}

