/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTextField;
import myObjects.eCrystalSystem;
import myObjects.eLatticeName;
import myObjects.functions.DebyeEinsteinAnharmFctGruebl;
import myObjects.functions.DebyeFct;
import myObjects.functions.DebyeFct2Term;
import myObjects.functions.EinsteinFct;
import myObjects.functions.EinsteinFct2Term;
import myObjects.functions.IFunctions;
import myUtilities.ImportUtilities;
import org.apache.log4j.Logger;

public class ReturnFunctionLists {
    private HashMap<String, JTextField> componentMap;
    private String[] _prefixLatt = new String[]{"txtEin", "txtDeb", "txtEin", "txtDebye", "txtDebEinAn"};
    private String[][] _SufLatt = new String[][]{{"TE", "CE"}, {"TD", "x1"}, {"TE", "CE", "TE2", "CE2"}, {"TD", "TD2", "x1", "x2"}, {"x1", "x2", "x3", "TD", "CE"}};
    private String[][] _LattParam = new String[][]{{"A"}, {"A", "C"}, {"A", "B", "C"}};
    private String[] _prefixAngle = new String[]{"txtPoly", "txtEin", "txtCOS", "txtSat"};
    private String[][] _SufAngle = new String[][]{{""}, {"TE", "CE"}, {"A", "B"}, {"A", "B", "C"}};
    private String[][] _AngleParam = new String[][]{{"Oblique"}, {"Alpha", "Beta", "Gamma"}};
    static Logger logger = Logger.getLogger(ReturnFunctionLists.class);

    public List<IFunctions> returnLatticeList(JPanel _panel, eCrystalSystem _eCS, int iFct) {
        ArrayList<IFunctions> rv = null;
        try {
            Object _str = null;
            this.createComponentMap(_panel);
            if (iFct > 0) {
                if (iFct != 1) {
                    // empty if block
                }
                int _pCount = 0;
                if (iFct == 1) {
                    _pCount = 3;
                } else if (iFct == 2) {
                    _pCount = 3;
                } else if (iFct == 3) {
                    _pCount = 5;
                } else if (iFct == 4) {
                    _pCount = 5;
                } else if (iFct == 5) {
                    _pCount = 6;
                }
                if (_pCount == 0) {
                    throw new Exception("Parameter count!");
                }
                ArrayList<double[]> myParamsList = new ArrayList<double[]>();
                String prefFct = this._prefixLatt[iFct - 1];
                int iParams = this._SufLatt[iFct - 1].length;
                String[] LattParamSel = null;
                String _sEnum = _eCS.name();
                if (_eCS == eCrystalSystem.Triclinic || _eCS == eCrystalSystem.Monoclinic || _eCS == eCrystalSystem.Orthorhombic) {
                    LattParamSel = this._LattParam[2];
                } else if (_eCS == eCrystalSystem.Hexagonal || _eCS == eCrystalSystem.Tetragonal) {
                    LattParamSel = this._LattParam[1];
                } else if (_eCS == eCrystalSystem.Rhombohedral || _eCS == eCrystalSystem.Cubic) {
                    LattParamSel = this._LattParam[0];
                } else {
                    logger.error((Object)"Select Crystal System!");
                }
                int i = 0;
                while (i < LattParamSel.length) {
                    int iCounter = 0;
                    double[] _params = new double[_pCount];
                    String _latt = LattParamSel[i];
                    String _name = String.valueOf(prefFct) + _latt;
                    String _txt = this.getComponentByName(_name);
                    if (_txt.isEmpty()) {
                        throw new Exception("Empty Textfield!");
                    }
                    _params[iCounter] = this.S2D(_txt);
                    int j = 0;
                    while (j < iParams) {
                        ++iCounter;
                        String _suffix = this._SufLatt[iFct - 1][j];
                        _name = String.valueOf(prefFct) + _latt + "_" + _suffix;
                        _txt = this.getComponentByName(_name);
                        if (_txt.isEmpty()) {
                            throw new Exception("Empty Textfield!");
                        }
                        _params[iCounter] = this.S2D(_txt);
                        ++j;
                    }
                    myParamsList.add(_params);
                    ++i;
                }
                rv = new ArrayList<IFunctions>();
                int iSelLattCount = 0;
                if (iFct == 1) {
                    for (double[] _d : myParamsList) {
                        rv.add(new EinsteinFct(_d[0], _d[1], _d[2], eLatticeName.fromString(LattParamSel[iSelLattCount])));
                        ++iSelLattCount;
                    }
                } else if (iFct == 2) {
                    for (double[] _d : myParamsList) {
                        rv.add(new DebyeFct(_d[0], _d[1], _d[2], eLatticeName.fromString(LattParamSel[iSelLattCount])));
                        ++iSelLattCount;
                    }
                } else if (iFct == 3) {
                    for (double[] _d : myParamsList) {
                        rv.add(new EinsteinFct2Term(_d[0], _d[1], _d[2], _d[3], _d[4], eLatticeName.fromString(LattParamSel[iSelLattCount])));
                        ++iSelLattCount;
                    }
                } else if (iFct == 4) {
                    for (double[] _d : myParamsList) {
                        rv.add(new DebyeFct2Term(_d[0], _d[1], _d[2], _d[3], _d[4], eLatticeName.fromString(LattParamSel[iSelLattCount])));
                        ++iSelLattCount;
                    }
                } else if (iFct == 5) {
                    for (double[] _d : myParamsList) {
                        rv.add(new DebyeEinsteinAnharmFctGruebl(_d[0], _d[1], _d[2], _d[3], _d[4], _d[5], eLatticeName.fromString(LattParamSel[iSelLattCount])));
                        ++iSelLattCount;
                    }
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public List<IFunctions> returnLatticeListAngle(JPanel _panel, List<IFunctions> _list, eCrystalSystem _eCS, int iFct, boolean isBeta) {
        List<IFunctions> rv = null;
        try {
            ImportUtilities _iU;
            List<IFunctions> _l;
            if (_list == null) {
                throw new Exception("Empty Lattice Parameter List!");
            }
            rv = _list;
            Object _str = null;
            this.createComponentMap(_panel);
            int _pCount = 0;
            if (iFct == 1 || iFct == 2) {
                _pCount = 3;
            } else if (iFct == 3) {
                _pCount = 4;
            }
            ArrayList<double[]> myParamsList = new ArrayList<double[]>();
            String prefFct = this._prefixAngle[iFct];
            int iParams = this._SufAngle[iFct].length;
            String[] AngleParamSel = null;
            String _sEnum = _eCS.name();
            String[] sPoly = null;
            if (_eCS == eCrystalSystem.Triclinic) {
                AngleParamSel = this._AngleParam[1];
                sPoly = new String[3];
            } else if (_eCS == eCrystalSystem.Monoclinic) {
                AngleParamSel = this._AngleParam[0];
                sPoly = new String[1];
            } else {
                logger.error((Object)"Select Crystal System!");
            }
            int i = 0;
            while (i < AngleParamSel.length) {
                int iCounter = 0;
                double[] _params = new double[_pCount];
                String _latt = AngleParamSel[i];
                String _name = String.valueOf(prefFct) + _latt;
                String _txt = this.getComponentByName(_name);
                if (iFct == 0) {
                    sPoly[i] = _txt;
                } else {
                    if (_txt.isEmpty()) {
                        throw new Exception("Empty Textfield!");
                    }
                    _params[iCounter] = this.S2D(_txt);
                    int j = 0;
                    while (j < iParams) {
                        ++iCounter;
                        String _suffix = this._SufAngle[iFct - 1][j];
                        _name = String.valueOf(prefFct) + _latt + "_" + _suffix;
                        _txt = this.getComponentByName(_name);
                        if (_txt.isEmpty()) {
                            throw new Exception("Empty Textfield!");
                        }
                        _params[iCounter] = this.S2D(_txt);
                        ++j;
                    }
                    myParamsList.add(_params);
                }
                ++i;
            }
            int iSelLattCount = 0;
            if (iFct == 0 && (_l = (_iU = new ImportUtilities()).returnLiteratureAnglePolynomialList(sPoly, _eCS, isBeta)) != null) {
                rv.addAll(_l);
            }
            if (iFct == 1) {
                for (double[] _d : myParamsList) {
                    rv.add(new DebyeFct(_d[0], _d[1], _d[2], eLatticeName.fromString(AngleParamSel[iSelLattCount])));
                    ++iSelLattCount;
                }
            } else if (iFct == 2) {
                for (double[] _d : myParamsList) {
                    rv.add(new EinsteinFct2Term(_d[0], _d[1], _d[2], _d[3], _d[4], eLatticeName.fromString(AngleParamSel[iSelLattCount])));
                    ++iSelLattCount;
                }
            } else if (iFct == 3) {
                for (double[] _d : myParamsList) {
                    rv.add(new DebyeFct2Term(_d[0], _d[1], _d[2], _d[3], _d[4], eLatticeName.fromString(AngleParamSel[iSelLattCount])));
                    ++iSelLattCount;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    private double S2D(String _p) {
        double rv = 0.0;
        try {
            rv = Double.parseDouble(_p);
        }
        catch (NumberFormatException _nbrEx) {
            logger.error((Object)_nbrEx);
        }
        return rv;
    }

    private int S2I(String _p) {
        int rv = 0;
        try {
            rv = Integer.parseInt(_p);
        }
        catch (NumberFormatException _nbrEx) {
            logger.error((Object)_nbrEx);
        }
        return rv;
    }

    private void createComponentMap(JPanel _panel) {
        try {
            this.componentMap = new HashMap();
            Component[] components = _panel.getComponents();
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof JTextField) {
                    JTextField _txt = (JTextField)components[i];
                    String _txtValue = _txt.getText();
                    String _txtName = _txt.getName();
                    if (!_txtValue.isEmpty() && !_txtName.isEmpty()) {
                        this.componentMap.put(_txt.getName(), _txt);
                    } else {
                        throw new Exception("Empty Textfield!");
                    }
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    public String getComponentByName(String name) {
        String rv = null;
        if (this.componentMap.containsKey(name)) {
            rv = this.componentMap.get(name).getText();
        }
        return rv;
    }
}

