/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Jama.Matrix;
import java.math.BigDecimal;
import java.math.RoundingMode;
import myObjects.ExpansionParams;
import myUtilities.VectorProds;
import org.apache.log4j.Logger;

public class MonoclinicEVAnalytic {
    static Logger logger = Logger.getLogger(MonoclinicEVAnalytic.class);
    private double[][] EVCrystal;
    private double[] _Eigenwerte;
    private double[][] _Eigenvector;

    public ExpansionParams returnMonoclinicEVAnalytic(double[][] pEVCrystal, boolean isBeta) {
        ExpansionParams rv = null;
        try {
            if (pEVCrystal.length > 0) {
                double B11;
                rv = new ExpansionParams();
                VectorProds.Vector3D<Double> EV1 = null;
                VectorProds.Vector3D<Double> EV2 = null;
                VectorProds.Vector3D<Double> EV3 = null;
                double[][] EigenVector = new double[3][3];
                double l1 = 0.0;
                double l2 = 0.0;
                double l3 = 0.0;
                if (isBeta) {
                    B11 = pEVCrystal[0][0];
                    double B13 = pEVCrystal[0][2];
                    double B22 = pEVCrystal[1][1];
                    double B33 = pEVCrystal[2][2];
                    l2 = B22;
                    l3 = (B11 + B33 + Math.sqrt(Math.pow(B11 - B33, 2.0) + 4.0 * Math.pow(B13, 2.0))) / 2.0;
                    l1 = (B11 + B33 - Math.sqrt(Math.pow(B11 - B33, 2.0) + 4.0 * Math.pow(B13, 2.0))) / 2.0;
                    if (l1 > l3) {
                        double temp = l1;
                        l1 = l3;
                        l3 = temp;
                    }
                    EV2 = new VectorProds.Vector3D<Double>(0.0, 1.0, 0.0);
                    double D1 = B13 / (B11 - l1);
                    double x1 = 0.0;
                    double x3 = 0.0;
                    if (D1 > 0.0) {
                        x3 = -Math.sqrt(1.0 / (Math.pow(D1, 2.0) + 1.0));
                    } else if (D1 < 0.0) {
                        x3 = Math.sqrt(1.0 / (Math.pow(D1, 2.0) + 1.0));
                    }
                    x1 = -D1 * x3;
                    EV1 = new VectorProds.Vector3D<Double>(x1, 0.0, x3);
                    EV3 = EV1.cross(EV2);
                } else {
                    double B33;
                    B11 = pEVCrystal[0][0];
                    double B12 = pEVCrystal[0][1];
                    double B22 = pEVCrystal[1][1];
                    l3 = B33 = pEVCrystal[2][2];
                    l2 = (B11 + B22 + Math.sqrt(Math.pow(B11 - B22, 2.0) + 4.0 * Math.pow(B12, 2.0))) / 2.0;
                    l1 = (B11 + B22 - Math.sqrt(Math.pow(B11 - B22, 2.0) + 4.0 * Math.pow(B12, 2.0))) / 2.0;
                    if (l1 > l2) {
                        double temp = l1;
                        l1 = l2;
                        l2 = temp;
                    }
                    EV3 = new VectorProds.Vector3D<Double>(0.0, 0.0, 1.0);
                    double E1 = B12 / (B11 - l1);
                    double x1 = 0.0;
                    double x2 = 0.0;
                    if (E1 > 0.0) {
                        x2 = -Math.sqrt(1.0 / (Math.pow(E1, 2.0) + 1.0));
                    } else if (E1 < 0.0) {
                        x2 = Math.sqrt(1.0 / (Math.pow(E1, 2.0) + 1.0));
                    }
                    x1 = -E1 * x2;
                    x1 = Math.sqrt(Math.pow(E1, 2.0) / (Math.pow(E1, 2.0) + 1.0));
                    EV1 = new VectorProds.Vector3D<Double>(x1, x2, 0.0);
                    EV2 = EV3.cross(EV1);
                }
                EigenVector[0] = new double[]{MonoclinicEVAnalytic.formatDouble(EV1.getA()), MonoclinicEVAnalytic.formatDouble(EV1.getB()), MonoclinicEVAnalytic.formatDouble(EV1.getC())};
                EigenVector[1] = new double[]{MonoclinicEVAnalytic.formatDouble(EV2.getA()), MonoclinicEVAnalytic.formatDouble(EV2.getB()), MonoclinicEVAnalytic.formatDouble(EV2.getC())};
                EigenVector[2] = new double[]{MonoclinicEVAnalytic.formatDouble(EV3.getA()), MonoclinicEVAnalytic.formatDouble(EV3.getB()), MonoclinicEVAnalytic.formatDouble(EV3.getC())};
                rv.setEigenValues(new double[]{MonoclinicEVAnalytic.formatDouble(l1), MonoclinicEVAnalytic.formatDouble(l2), MonoclinicEVAnalytic.formatDouble(l3)});
                rv.setEigenVector(EigenVector);
                Matrix _matrixEV = new Matrix(EigenVector);
                rv.setDeterminantEigenvector(MonoclinicEVAnalytic.formatDouble(_matrixEV.det()));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public static double formatDouble(double dCoefficient) {
        double rv = 0.0;
        try {
            int scale = 4;
            RoundingMode mode = RoundingMode.HALF_DOWN;
            if (Double.isNaN(dCoefficient) || Double.isInfinite(dCoefficient)) {
                return dCoefficient;
            }
            scale = Math.max(scale, 0);
            BigDecimal bd = BigDecimal.valueOf(dCoefficient);
            BigDecimal bc = new BigDecimal(bd.unscaledValue(), bd.precision() - 1);
            return bc.setScale(scale, mode).scaleByPowerOfTen(bc.scale() - bd.scale()).doubleValue();
        }
        catch (NumberFormatException _nbrFormatEx) {
            logger.error((Object)_nbrFormatEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    public static void main(String[] a) {
        MonoclinicEVAnalytic _exp = new MonoclinicEVAnalytic();
        double[][] EklO = new double[3][3];
        EklO[0][0] = 13.09;
        EklO[0][1] = -3.56;
        EklO[0][2] = 0.0;
        EklO[1][0] = -3.56;
        EklO[1][1] = 16.87;
        EklO[1][2] = 0.0;
        EklO[2][0] = 0.0;
        EklO[2][1] = 0.0;
        EklO[2][2] = 11.97;
        ExpansionParams _rv = _exp.returnMonoclinicEVAnalytic(EklO, false);
        double[][] Egr0 = new double[3][3];
        Egr0[0][0] = 13.09;
        Egr0[0][1] = 3.56;
        Egr0[0][2] = 0.0;
        Egr0[1][0] = 3.56;
        Egr0[1][1] = 16.87;
        Egr0[1][2] = 0.0;
        Egr0[2][0] = 0.0;
        Egr0[2][1] = 0.0;
        Egr0[2][2] = 11.97;
        _rv = _exp.returnMonoclinicEVAnalytic(Egr0, false);
        double[][] Dkl0 = new double[3][3];
        Dkl0[0][0] = 13.09;
        Dkl0[0][1] = 0.0;
        Dkl0[0][2] = -3.56;
        Dkl0[1][0] = 0.0;
        Dkl0[1][1] = 11.97;
        Dkl0[1][2] = 0.0;
        Dkl0[2][0] = -3.56;
        Dkl0[2][1] = 0.0;
        Dkl0[2][2] = 16.87;
        _rv = _exp.returnMonoclinicEVAnalytic(Dkl0, true);
        double[][] Dgr0 = new double[3][3];
        Dgr0[0][0] = 13.09;
        Dgr0[0][1] = 0.0;
        Dgr0[0][2] = 3.56;
        Dgr0[1][0] = 0.0;
        Dgr0[1][1] = 11.97;
        Dgr0[1][2] = 0.0;
        Dgr0[2][0] = 3.56;
        Dgr0[2][1] = 0.0;
        Dgr0[2][2] = 16.87;
        _rv = _exp.returnMonoclinicEVAnalytic(Dgr0, true);
    }
}

