/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import myUtilities.MathExpansionCoeff;
import org.apache.log4j.Logger;

public class MatrixLib {
    static Logger logger = Logger.getLogger(MathExpansionCoeff.class);
    private int iMaxLoops = 10;
    private double dErrMin = -2.0;
    private int p = 0;
    private int q = 0;

    public double[][] MatEigenvalue_Jacobi(double[][] Mat) {
        return this.MatEigenvalue_Jacobi(Mat, 0);
    }

    public double[][] MatEigenvalue_Jacobi(double[][] Mat, int pMaxLoops) {
        double[][] A = Mat;
        int Loops = 1;
        double dpq = 0.0;
        double co = 0.0;
        double si = 0.0;
        double t = 0.0;
        try {
            int MaxLoops = pMaxLoops == 0 ? this.iMaxLoops : pMaxLoops;
            while (Loops <= MaxLoops) {
                ++Loops;
                this.Jacobi_Find_Max(A);
                if (this.p >= 0) {
                    dpq = A[this.q][this.q] - A[this.p][this.p];
                    if (dpq == 0.0) {
                        t = 1.0;
                    } else {
                        double x = dpq / A[this.p][this.q] / 2.0;
                        t = Math.signum(x) / (Math.abs(x) + Math.sqrt(x * x + 1.0));
                    }
                    co = 1.0 / Math.sqrt(t * t + 1.0);
                    si = t * co;
                    A = this.FastRotation_Jacobi(A, si, co, this.p, this.q);
                    continue;
                }
                break;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return this.MatMopUp(A, 0.0);
    }

    private double Jacobi_Find_Max(double[][] A) {
        double big = 0.0;
        this.p = -1;
        this.q = -1;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (i != j && Math.abs(A[i][j]) > big) {
                    big = Math.abs(A[i][j]);
                    this.p = i;
                    this.q = j;
                }
                ++j;
            }
            ++i;
        }
        return big;
    }

    private double[][] FastRotation_Jacobi(double[][] A, double si, double co, int pP, int pQ) {
        double Ap = 0.0;
        double aq = 0.0;
        int i = 0;
        while (i < 3) {
            Ap = A[i][pP];
            aq = A[i][pQ];
            A[i][pP] = co * Ap - si * aq;
            A[i][pQ] = si * Ap + co * aq;
            ++i;
        }
        int j = 0;
        while (j < 3) {
            Ap = A[pP][j];
            aq = A[pQ][j];
            A[pP][j] = co * Ap - si * aq;
            A[pQ][j] = si * Ap + co * aq;
            ++j;
        }
        return A;
    }

    public double[][] MatEigenvector_Jacobi(double[][] mat) {
        return this.MatEigenvector_Jacobi(mat, 0);
    }

    public double[][] MatEigenvector_Jacobi(double[][] mat, int pMaxLoops) {
        double[][] A = mat;
        double[][] u = this.M_ID();
        double[][] v = this.M_ID();
        int Loops = 1;
        double dpq = 0.0;
        double co = 0.0;
        double si = 0.0;
        double t = 0.0;
        double x = 0.0;
        try {
            int MaxLoops = pMaxLoops == 0 ? this.iMaxLoops : pMaxLoops;
            while (Loops <= MaxLoops) {
                ++Loops;
                this.Jacobi_Find_Max(A);
                if (this.p >= 0) {
                    dpq = A[this.q][this.q] - A[this.p][this.p];
                    if (dpq == 0.0) {
                        t = 1.0;
                    } else {
                        x = dpq / A[this.p][this.q] * 0.5;
                        t = Math.signum(x) / (Math.abs(x) + Math.sqrt(x * x + 1.0));
                    }
                    co = 1.0 / Math.sqrt(t * t + 1.0);
                    si = t * co;
                    A = this.FastRotation_Jacobi(A, si, co, this.p, this.q);
                    u = this.M_ID();
                    u[this.p][this.p] = co;
                    u[this.p][this.q] = si;
                    u[this.q][this.p] = -si;
                    u[this.q][this.q] = co;
                    v = this.multiplyMatrices(v, u);
                    continue;
                }
                break;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return this.MatMopUp(v);
    }

    public double[][] multiplyMatrices(double[][] a, double[][] b) {
        double[][] c = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                c[i][j] = 0.0;
                int k = 0;
                while (k < 3) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * b[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return c;
    }

    private double[][] M_ID() {
        double[][] aRV = new double[3][3];
        try {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    aRV[i][j] = i != j ? 0.0 : 1.0;
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return aRV;
    }

    private double[][] MatMopUp(double[][] Mat) {
        return this.MatMopUp(Mat, 0.0);
    }

    private double[][] MatMopUp(double[][] Mat, double ErrMin) {
        double[][] A = Mat;
        if (ErrMin == 0.0) {
            ErrMin = this.dErrMin;
        }
        try {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    if (Math.abs(A[i][j]) < ErrMin) {
                        A[i][j] = 0.0;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return A;
    }

    public double[][] transpose(double[][] inMatrix) {
        double[][] transposedM = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                transposedM[j][i] = inMatrix[i][j];
                ++j;
            }
            ++i;
        }
        return transposedM;
    }
}

