/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

public strictfp class Matrix {
    public int m;
    public int n;
    private double[][] matrix;

    public Matrix(int m, int n) {
        this.create(m, n);
    }

    public Matrix(String s) {
        String[] parts = s.split(",");
        int i = 0;
        while (i < parts.length) {
            String[] values = parts[i].split(" ");
            if (this.matrix == null) {
                this.create(parts.length, values.length);
            }
            int j = 0;
            while (j < values.length) {
                this.set(i, j, Double.parseDouble(values[j]));
                ++j;
            }
            ++i;
        }
    }

    public Matrix(int s) {
        Matrix r = new Matrix(s, s);
        r.randomize();
        this.set(r.mul(r.transpose()));
    }

    private void create(int m, int n) {
        this.matrix = new double[m][n];
        this.m = m;
        this.n = n;
    }

    public void randomize() {
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.m) {
                this.set(i, j, Math.random() * 10.0);
                ++j;
            }
            ++i;
        }
    }

    public void identity() {
        int i = 0;
        while (i < this.m) {
            this.set(i, i, 1.0);
            ++i;
        }
    }

    public double get(int m, int n) {
        return this.matrix[m][n];
    }

    public void set(int m, int n, double v) {
        this.matrix[m][n] = v;
    }

    public void set(Matrix m) {
        this.create(m.m, m.n);
        int i = 0;
        while (i < m.m) {
            int j = 0;
            while (j < m.n) {
                this.set(i, j, m.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public Matrix mul(Matrix x) {
        Matrix m = new Matrix(this.m, x.n);
        int i = 0;
        while (i < m.m) {
            int j = 0;
            while (j < m.n) {
                double sum = 0.0;
                int a = 0;
                while (a < this.n) {
                    sum += this.get(i, a) * x.get(a, j);
                    ++a;
                }
                m.set(i, j, sum);
                ++j;
            }
            ++i;
        }
        return m;
    }

    public Matrix transpose() {
        Matrix r = new Matrix(this.n, this.m);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                r.set(j, i, this.get(i, j));
                ++j;
            }
            ++i;
        }
        return r;
    }

    public double off() {
        double r = 0.0;
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                if (i != j) {
                    r += this.get(i, j) * this.get(i, j);
                }
                ++j;
            }
            ++i;
        }
        return r;
    }

    public double[] eigenvalues() {
        double a = (this.get(0, 0) + this.get(1, 1)) / 2.0;
        double c = (this.get(0, 0) - this.get(1, 1)) / 2.0;
        double b = Math.sqrt(this.get(0, 1) * this.get(0, 1) + c * c);
        return new double[]{a + b, a - b};
    }

    public double[][] eigenvectors() {
        double[] e = this.eigenvalues();
        double eplus = e[0] > e[1] ? e[0] : e[1];
        Matrix b = new Matrix(this.m, this.n);
        b.set(this);
        b.set(0, 0, b.get(0, 0) - eplus);
        b.set(1, 1, b.get(1, 1) - eplus);
        double[] r1_perp = new double[]{b.get(1, 0), -b.get(0, 0)};
        double r1_length = Math.sqrt(r1_perp[0] * r1_perp[0] + r1_perp[1] * r1_perp[1]);
        double[] u1 = new double[]{r1_perp[0] / r1_length, r1_perp[1] / r1_length};
        double[] u2 = new double[]{-u1[1], u1[0]};
        return new double[][]{u1, u2};
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                s = String.valueOf(s) + this.get(i, j) + " ";
                ++j;
            }
            s = String.valueOf(s) + "\n";
            ++i;
        }
        return s;
    }
}

