/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Jama.Matrix;
import java.math.BigDecimal;
import java.math.RoundingMode;
import myObjects.ExpansionParams;
import myObjects.eCrystalSystem;
import myObjects.eLatticeName;
import myObjects.functions.IFunctions;
import myUtilities.EigenDec;
import myUtilities.MathExpansionCoeff;
import org.apache.log4j.Logger;

public class MathExpansionCoeffBAKK {
    static Logger logger = Logger.getLogger(MathExpansionCoeff.class);
    private double[][] EVCrystal;
    private double[] _Eigenwerte;
    private double[][] _Eigenvector;
    private double _detEigenvector;
    private double[][] _CrystallographicAxesCoord;
    private double[][] _UVW;
    private int iJacobiIterations;
    double[][] A;
    double[][] V;
    double[] Y;

    public ExpansionParams returnCalcExpansionParams(double pTemp, ExpansionParams _expParams) {
        ExpansionParams rv = null;
        try {
            if (_expParams != null) {
                IFunctions aPol;
                eCrystalSystem pCrystallsystem = _expParams.getCrystalSystem();
                _expParams.setdTemp(pTemp);
                this.EVCrystal = new double[3][3];
                this._Eigenwerte = new double[3];
                this._Eigenvector = new double[3][3];
                if (pCrystallsystem == eCrystalSystem.Triclinic) {
                    aPol = _expParams.findObj(eLatticeName.a);
                    IFunctions bPol = _expParams.findObj(eLatticeName.b);
                    IFunctions cPol = _expParams.findObj(eLatticeName.c);
                    IFunctions alphaPol = _expParams.findObj(eLatticeName.alpha);
                    IFunctions betaPol = _expParams.findObj(eLatticeName.beta);
                    IFunctions gammaPol = _expParams.findObj(eLatticeName.gamma);
                    this.EVCrystal = this.returnUniversalCTE(aPol, bPol, cPol, alphaPol, betaPol, gammaPol, pTemp);
                } else if (pCrystallsystem == eCrystalSystem.Monoclinic) {
                    aPol = _expParams.findObj(eLatticeName.a);
                    IFunctions bPol = _expParams.findObj(eLatticeName.b);
                    IFunctions cPol = _expParams.findObj(eLatticeName.c);
                    boolean isBeta = true;
                    IFunctions obliqueAngle = null;
                    if (_expParams.findObj(eLatticeName.beta) != null) {
                        obliqueAngle = _expParams.findObj(eLatticeName.beta);
                    } else if (_expParams.findObj(eLatticeName.gamma) != null) {
                        obliqueAngle = _expParams.findObj(eLatticeName.gamma);
                        isBeta = false;
                    }
                    double a = aPol.getValue(pTemp);
                    double b = bPol.getValue(pTemp);
                    double c = cPol.getValue(pTemp);
                    double dObliqueAngle = MathExpansionCoeffBAKK.toRad(obliqueAngle.getValue(pTemp));
                    double aDer = aPol.getDerivative(pTemp);
                    double bDer = bPol.getDerivative(pTemp);
                    double cDer = cPol.getDerivative(pTemp);
                    double gammaDer = MathExpansionCoeffBAKK.toRad(obliqueAngle.getDerivative(pTemp));
                    this.EVCrystal[0][0] = MathExpansionCoeffBAKK.formatDouble(aDer / a);
                    this.EVCrystal[1][1] = MathExpansionCoeffBAKK.formatDouble(bDer / b + gammaDer * (1.0 / Math.tan(dObliqueAngle)));
                    this.EVCrystal[2][2] = MathExpansionCoeffBAKK.formatDouble(cDer / c);
                    if (!isBeta) {
                        this.EVCrystal[0][1] = MathExpansionCoeffBAKK.formatDouble(-0.5 * (aDer / a - bDer / b) * (1.0 / Math.tan(dObliqueAngle)) - gammaDer / 2.0);
                        this.EVCrystal[1][0] = this.EVCrystal[0][1];
                        this.EVCrystal[0][2] = 0.0;
                        this.EVCrystal[2][0] = 0.0;
                        this.setUVW(MathExpansionCoeffBAKK.toRad(90.0), MathExpansionCoeffBAKK.toRad(90.0), dObliqueAngle);
                    } else {
                        this.EVCrystal[0][2] = MathExpansionCoeffBAKK.formatDouble(-0.5 * (aDer / a - bDer / b) * (1.0 / Math.tan(dObliqueAngle)) - gammaDer / 2.0);
                        this.EVCrystal[2][0] = this.EVCrystal[0][2];
                        this.EVCrystal[0][1] = 0.0;
                        this.EVCrystal[1][0] = 0.0;
                        this.setUVW(MathExpansionCoeffBAKK.toRad(90.0), dObliqueAngle, MathExpansionCoeffBAKK.toRad(90.0));
                    }
                    this.EVCrystal[1][2] = 0.0;
                    this.EVCrystal[2][1] = 0.0;
                    this.doEigenDecomposition(this.EVCrystal);
                    double maxEV = this.findMaxValue(this._Eigenwerte);
                    this._CrystallographicAxesCoord = isBeta ? this.returnCrystallographicAxesCoord(maxEV, maxEV, maxEV, MathExpansionCoeffBAKK.toRad(90.0), dObliqueAngle, MathExpansionCoeffBAKK.toRad(90.0)) : this.returnCrystallographicAxesCoord(maxEV, maxEV, maxEV, MathExpansionCoeffBAKK.toRad(90.0), MathExpansionCoeffBAKK.toRad(90.0), dObliqueAngle);
                    _expParams.setCrystallographicAxesCoord(this._CrystallographicAxesCoord);
                } else if (pCrystallsystem == eCrystalSystem.Tetragonal || pCrystallsystem == eCrystalSystem.Hexagonal) {
                    double aDer;
                    double a;
                    aPol = _expParams.findObj(eLatticeName.a);
                    IFunctions cPol = _expParams.findObj(eLatticeName.c);
                    double b = a = aPol.getValue(pTemp);
                    double c = cPol.getValue(pTemp);
                    double bDer = aDer = aPol.getDerivative(pTemp);
                    double cDer = cPol.getDerivative(pTemp);
                    this.EVCrystal[0][0] = MathExpansionCoeffBAKK.formatDouble(aDer / a);
                    this.EVCrystal[1][1] = MathExpansionCoeffBAKK.formatDouble(bDer / b);
                    this.EVCrystal[2][2] = MathExpansionCoeffBAKK.formatDouble(cDer / c);
                    this.EVCrystal[0][1] = 0.0;
                    this.EVCrystal[1][0] = this.EVCrystal[0][1];
                    this.EVCrystal[0][2] = 0.0;
                    this.EVCrystal[2][0] = this.EVCrystal[0][2];
                    this.EVCrystal[1][2] = 0.0;
                    this.EVCrystal[2][1] = this.EVCrystal[1][2];
                    this.doEigenDecomposition(this.EVCrystal);
                } else if (pCrystallsystem == eCrystalSystem.Rhombohedral) {
                    aPol = _expParams.findObj(eLatticeName.a);
                    IFunctions obliqueAnglePol = _expParams.findObj(eLatticeName.alpha);
                    double a = aPol.getValue(pTemp);
                    double obliqueAngle = MathExpansionCoeffBAKK.toRad(obliqueAnglePol.getValue(pTemp));
                    double aDer = aPol.getDerivative(pTemp);
                    double obliqueAngleDerValue = MathExpansionCoeffBAKK.toRad(obliqueAnglePol.getDerivative(pTemp));
                    this.EVCrystal[0][0] = MathExpansionCoeffBAKK.formatDouble(aDer / a + obliqueAngleDerValue * (1.0 / Math.tan(obliqueAngle)));
                    this.EVCrystal[1][1] = this.EVCrystal[0][0];
                    this.EVCrystal[2][2] = MathExpansionCoeffBAKK.formatDouble(aDer / a);
                    this.EVCrystal[0][1] = 0.0;
                    this.EVCrystal[1][0] = this.EVCrystal[0][1];
                    this.EVCrystal[0][2] = 0.0;
                    this.EVCrystal[2][0] = this.EVCrystal[0][2];
                    this.EVCrystal[1][2] = 0.0;
                    this.EVCrystal[2][1] = this.EVCrystal[1][2];
                    this.doEigenDecomposition(this.EVCrystal);
                } else if (pCrystallsystem == eCrystalSystem.Orthorhombic) {
                    aPol = _expParams.findObj(eLatticeName.a);
                    IFunctions bPol = _expParams.findObj(eLatticeName.b);
                    IFunctions cPol = _expParams.findObj(eLatticeName.c);
                    double a = aPol.getValue(pTemp);
                    double b = bPol.getValue(pTemp);
                    double c = cPol.getValue(pTemp);
                    double aDer = aPol.getDerivative(pTemp);
                    double bDer = bPol.getDerivative(pTemp);
                    double cDer = cPol.getDerivative(pTemp);
                    this.EVCrystal[0][0] = MathExpansionCoeffBAKK.formatDouble(aDer / a);
                    this.EVCrystal[1][1] = MathExpansionCoeffBAKK.formatDouble(bDer / b);
                    this.EVCrystal[2][2] = MathExpansionCoeffBAKK.formatDouble(cDer / c);
                    this.EVCrystal[0][1] = 0.0;
                    this.EVCrystal[1][0] = this.EVCrystal[0][1];
                    this.EVCrystal[0][2] = 0.0;
                    this.EVCrystal[2][0] = this.EVCrystal[0][2];
                    this.EVCrystal[1][2] = 0.0;
                    this.EVCrystal[2][1] = this.EVCrystal[1][2];
                    this.doEigenDecomposition(this.EVCrystal);
                } else if (pCrystallsystem == eCrystalSystem.Cubic) {
                    aPol = _expParams.findObj(eLatticeName.a);
                    double a = aPol.getValue(pTemp);
                    double aDer = aPol.getDerivative(pTemp);
                    this.EVCrystal[0][0] = MathExpansionCoeffBAKK.formatDouble(aDer / a);
                    this.EVCrystal[1][1] = this.EVCrystal[0][0];
                    this.EVCrystal[2][2] = this.EVCrystal[0][0];
                    this.EVCrystal[0][1] = 0.0;
                    this.EVCrystal[1][0] = this.EVCrystal[0][1];
                    this.EVCrystal[0][2] = 0.0;
                    this.EVCrystal[2][0] = this.EVCrystal[0][2];
                    this.EVCrystal[1][2] = 0.0;
                    this.EVCrystal[2][1] = this.EVCrystal[1][2];
                    this.doEigenDecomposition(this.EVCrystal);
                }
                rv = _expParams;
                rv.setEVCrystal(this.EVCrystal);
                rv.setEigenValues(this._Eigenwerte);
                rv.setEigenVector(this._Eigenvector);
                double[][] _angleBasis = this.returnAngleBasis(this._Eigenvector);
                rv.setAngleEVBasis(_angleBasis);
                if (this._UVW != null) {
                    double[][] _angleCrysEV = this.returnAngleCrys(this._Eigenvector, this._UVW);
                    rv.setTransformationMatrix(this._UVW);
                    rv.setAngleEVCrys(_angleCrysEV);
                }
                rv.setJacobiIterations(this.iJacobiIterations);
                rv.setDeterminantEigenvector(MathExpansionCoeffBAKK.formatDouble(this._detEigenvector));
                rv.setCrystallographicAxesCoord(this._CrystallographicAxesCoord);
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public static void printMatrix(double[][] m) {
        try {
            int rows = m.length;
            int columns = m[0].length;
            String str = "|\t";
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < columns) {
                    str = String.valueOf(str) + m[i][j] + "\t";
                    ++j;
                }
                System.out.println(String.valueOf(str) + "|");
                str = "|\t";
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Matrix is empty!!");
        }
    }

    private static double toRad(double dGrad) {
        double rv = 0.0;
        try {
            rv = Math.toRadians(dGrad);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public static double formatDouble(double dCoefficient) {
        double rv = 0.0;
        try {
            int scale = 4;
            RoundingMode mode = RoundingMode.HALF_DOWN;
            if (Double.isNaN(dCoefficient) || Double.isInfinite(dCoefficient)) {
                return dCoefficient;
            }
            scale = Math.max(scale, 0);
            BigDecimal bd = BigDecimal.valueOf(dCoefficient);
            BigDecimal bc = new BigDecimal(bd.unscaledValue(), bd.precision() - 1);
            return bc.setScale(scale, mode).scaleByPowerOfTen(bc.scale() - bd.scale()).doubleValue();
        }
        catch (NumberFormatException _nbrFormatEx) {
            logger.error((Object)_nbrFormatEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    private static double[] formatVector(double[] pVector) {
        double[] newVector = new double[pVector.length];
        try {
            int i = 0;
            while (i < pVector.length) {
                newVector[i] = MathExpansionCoeffBAKK.formatDouble(pVector[i]);
                ++i;
            }
        }
        catch (NumberFormatException _nbrFormatEx) {
            logger.error((Object)_nbrFormatEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return newVector;
    }

    private static double[][] formatTensor(double[][] pTensor) {
        double[][] newTensor = new double[pTensor.length][pTensor[0].length];
        try {
            int i = 0;
            while (i < pTensor.length) {
                int j = 0;
                while (j < pTensor[0].length) {
                    newTensor[i][j] = MathExpansionCoeffBAKK.formatDouble(pTensor[i][j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (NumberFormatException _nbrFormatEx) {
            logger.error((Object)_nbrFormatEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return newTensor;
    }

    private static double[] returnformatedDiagonalTensor(double[][] pTensor) {
        double[] rv = new double[3];
        try {
            int i = 0;
            while (i < pTensor.length) {
                rv[i] = MathExpansionCoeffBAKK.formatDouble(pTensor[i][i]);
                ++i;
            }
        }
        catch (NumberFormatException _nbrFormatEx) {
            logger.error((Object)_nbrFormatEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    private double[][] returnCrystallographicAxesCoord(double a, double b, double c, double alpha, double beta, double gammaStern) {
        double[][] _coords = new double[3][4];
        try {
            b *= 1.0E7;
            c *= 1.0E7;
            _coords[0][0] = (a *= 1.0E7) * Math.sin(beta);
            _coords[0][1] = 0.0;
            _coords[0][2] = a * Math.cos(beta);
            _coords[0][3] = 1.0;
            _coords[1][0] = -b * Math.sin(alpha) * Math.cos(gammaStern);
            _coords[1][1] = b * Math.sin(alpha) * Math.sin(gammaStern);
            _coords[1][2] = b * Math.cos(alpha);
            _coords[1][3] = 1.0;
            _coords[2][0] = 0.0;
            _coords[2][1] = 0.0;
            _coords[2][2] = c;
            _coords[2][3] = 1.0;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
            System.out.println(_ex);
        }
        return _coords;
    }

    private double[][] returnAngleBasis(double[][] pEV) {
        double[][] rv = new double[3][3];
        try {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    rv[i][j] = MathExpansionCoeffBAKK.formatDouble(Math.toDegrees(Math.acos(pEV[i][j])));
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    private double[][] returnAngleCrys(double[][] pEV, double[][] pUVW) {
        double[][] rv = new double[3][3];
        try {
            int i = 0;
            while (i < 3) {
                double dEVa = 0.0;
                double dEVb = 0.0;
                double dEVc = 0.0;
                int j = 0;
                while (j < 3) {
                    double dEVatmp = pEV[j][i] * pUVW[0][j];
                    dEVa += dEVatmp;
                    double dEVbtmp = pEV[j][i] * pUVW[1][j];
                    dEVb += dEVbtmp;
                    double dEVctmp = pEV[j][i] * pUVW[2][j];
                    dEVc += dEVctmp;
                    ++j;
                }
                rv[0][i] = MathExpansionCoeffBAKK.formatDouble(Math.toDegrees(Math.acos(dEVa)));
                rv[1][i] = MathExpansionCoeffBAKK.formatDouble(Math.toDegrees(Math.acos(dEVb)));
                rv[2][i] = MathExpansionCoeffBAKK.formatDouble(Math.toDegrees(Math.acos(dEVc)));
                ++i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    public static double[] transformUVW2Orth(double[] uvw, double[][] pTransformMatrice) {
        double[] rv = null;
        return rv;
    }

    private double findMaxValue(double[] a) {
        double max = 0.0;
        int i = 0;
        while (i < a.length) {
            if (Math.abs(a[i]) > max) {
                max = Math.abs(a[i]);
            }
            ++i;
        }
        return max;
    }

    private double[][] returnUniversalCTE(IFunctions aPol, IFunctions bPol, IFunctions cPol, IFunctions alphaPol, IFunctions betaPol, IFunctions gammaPol, double pTemp) {
        double[][] EVCrystal = new double[3][3];
        try {
            double a = aPol.getValue(pTemp);
            double b = bPol.getValue(pTemp);
            double c = cPol.getValue(pTemp);
            double alpha = MathExpansionCoeffBAKK.toRad(alphaPol.getValue(pTemp));
            double beta = MathExpansionCoeffBAKK.toRad(betaPol.getValue(pTemp));
            double gamma = MathExpansionCoeffBAKK.toRad(gammaPol.getValue(pTemp));
            double dTerm1 = Math.cos(alpha) * Math.cos(beta) - Math.cos(gamma);
            double dTerm2 = Math.sin(alpha) * Math.sin(beta);
            double gammaStern = Math.acos(dTerm1 / dTerm2);
            this.setUVW(alpha, beta, gamma);
            double aDer = aPol.getDerivative(pTemp);
            double bDer = bPol.getDerivative(pTemp);
            double cDer = cPol.getDerivative(pTemp);
            double alphaDer = MathExpansionCoeffBAKK.toRad(alphaPol.getDerivative(pTemp));
            double betaDer = MathExpansionCoeffBAKK.toRad(betaPol.getDerivative(pTemp));
            double gammaDer = MathExpansionCoeffBAKK.toRad(gammaPol.getDerivative(pTemp));
            double dTerm1Der = (gammaDer * Math.sin(gamma) - betaDer * Math.cos(alpha) * Math.sin(beta) - alphaDer * Math.sin(alpha) * Math.cos(beta)) / (Math.sin(alpha) * Math.sin(beta));
            double dTerm2Der = alphaDer * Math.cos(alpha) * (Math.cos(alpha) * Math.cos(beta) - Math.cos(gamma)) / (Math.sin(alpha) * Math.sin(alpha) * Math.sin(beta));
            double dTerm3Der = betaDer * Math.cos(beta) * (Math.cos(alpha) * Math.cos(beta) - Math.cos(gamma)) / (Math.sin(beta) * Math.sin(beta) * Math.sin(alpha));
            double gammaSternDer = -1.0 / Math.sin(gammaStern) * (dTerm1Der - dTerm2Der - dTerm3Der);
            EVCrystal[0][0] = MathExpansionCoeffBAKK.formatDouble(aDer / a + betaDer * (1.0 / Math.tan(beta)));
            EVCrystal[1][1] = MathExpansionCoeffBAKK.formatDouble(bDer / b + alphaDer * (1.0 / Math.tan(alpha)) + gammaSternDer * (1.0 / Math.tan(gammaStern)));
            EVCrystal[2][2] = MathExpansionCoeffBAKK.formatDouble(cDer / c);
            EVCrystal[0][1] = MathExpansionCoeffBAKK.formatDouble(0.5 * (1.0 / Math.tan(gammaStern)) * (aDer / a - bDer / b - alphaDer * (1.0 / Math.tan(alpha)) + betaDer * (1.0 / Math.tan(beta))) + gammaSternDer / 2.0);
            EVCrystal[1][0] = MathExpansionCoeffBAKK.formatDouble(EVCrystal[0][1]);
            EVCrystal[0][2] = MathExpansionCoeffBAKK.formatDouble(0.5 * (aDer / a - cDer / c) * (1.0 / Math.tan(beta)) - betaDer / 2.0);
            EVCrystal[2][0] = MathExpansionCoeffBAKK.formatDouble(EVCrystal[0][2]);
            EVCrystal[1][2] = MathExpansionCoeffBAKK.formatDouble(0.5 * ((aDer / a - cDer / c) * (1.0 / Math.tan(gammaStern)) * (1.0 / Math.tan(beta)) + (bDer / b - cDer / c) * (1.0 / Math.tan(alpha) / Math.sin(gammaStern)) - (1.0 / Math.sin(gammaStern) * alphaDer + betaDer * (1.0 / Math.tan(gammaStern)))));
            EVCrystal[2][1] = MathExpansionCoeffBAKK.formatDouble(EVCrystal[1][2]);
            this.doEigenDecomposition(EVCrystal);
            double maxEV = this.findMaxValue(this._Eigenwerte);
            this._CrystallographicAxesCoord = this.returnCrystallographicAxesCoord(maxEV, maxEV, maxEV, alpha, beta, gammaStern);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return EVCrystal;
    }

    private void doEigenDecomposition(double[][] _matrice) {
        try {
            if (_matrice.length > 0) {
                EigenDec.doDecomposition(_matrice);
                double[][] eigenVector = MathExpansionCoeffBAKK.formatTensor(EigenDec.V);
                double[] eigenValue = MathExpansionCoeffBAKK.returnformatedDiagonalTensor(EigenDec.AA);
                this._Eigenwerte = eigenValue;
                this._Eigenvector = eigenVector;
                Matrix mEigenVector = new Matrix(EigenDec.V);
                this._detEigenvector = mEigenVector.det();
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
    }

    private void setUVW(double alpha, double beta, double gamma) {
        double dTerm1 = Math.cos(alpha) * Math.cos(beta) - Math.cos(gamma);
        double dTerm2 = Math.sin(alpha) * Math.sin(beta);
        double gammaStern = Math.acos(dTerm1 / dTerm2);
        this._UVW = new double[3][3];
        this._UVW[0][0] = Math.sin(beta);
        this._UVW[0][1] = 0.0;
        this._UVW[0][2] = Math.cos(beta);
        this._UVW[1][0] = -Math.sin(alpha) * Math.cos(gammaStern);
        this._UVW[1][1] = Math.sin(alpha) * Math.sin(gammaStern);
        this._UVW[1][2] = Math.cos(alpha);
        this._UVW[2][0] = 0.0;
        this._UVW[2][1] = 0.0;
        this._UVW[2][2] = 1.0;
    }
}

