/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import org.apache.log4j.Logger;

public class LinearRegression {
    double[][] V;
    public double[] C;
    public double[] SEC;
    double RYSQ;
    double SDV;
    double FReg;
    double[] Ycalc;
    double[] DY;
    static Logger logger = Logger.getLogger(LinearRegression.class);

    public boolean Regress(double[][] XY, double[] weights, int order) {
        int countXY = XY.length;
        double[][] x = new double[order + 1][countXY];
        double[] y = new double[countXY];
        int i = 0;
        while (i < countXY) {
            int j = 0;
            while (j <= order) {
                x[j][i] = Math.pow(XY[i][0], j);
                ++j;
            }
            y[i] = XY[i][1];
            ++i;
        }
        return this.Regress(y, x, weights);
    }

    public boolean Regress(double[] Y, double[][] X, double[] W) {
        int j;
        int i;
        double[] B;
        int NDF;
        int N;
        int M;
        block18: {
            M = Y.length;
            N = X.length * X[0].length / M;
            NDF = M - N;
            this.Ycalc = new double[M];
            this.DY = new double[M];
            if (NDF < 1) {
                throw new Exception("not enough data (" + Integer.toString(M) + " rows) for this many predictors (" + Integer.toString(N) + " predictors)");
            }
            this.V = new double[N][N];
            this.C = new double[N];
            this.SEC = new double[N];
            B = new double[N];
            i = 0;
            while (i < N) {
                j = 0;
                while (j < N) {
                    this.V[i][j] = 0.0;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < N) {
                j = 0;
                while (j < N) {
                    this.V[i][j] = 0.0;
                    int k = 0;
                    while (k < M) {
                        this.V[i][j] = this.V[i][j] + W[k] * X[i][k] * X[j][k];
                        ++k;
                    }
                    ++j;
                }
                B[i] = 0.0;
                int k = 0;
                while (k < M) {
                    B[i] = B[i] + W[k] * X[i][k] * Y[k];
                    ++k;
                }
                ++i;
            }
            if (this.SymmetricMatrixInvert(this.V)) break block18;
            return false;
        }
        try {
            i = 0;
            while (i < N) {
                this.C[i] = 0.0;
                j = 0;
                while (j < N) {
                    this.C[i] = this.C[i] + this.V[i][j] * B[j];
                    ++j;
                }
                ++i;
            }
            double TSS = 0.0;
            double RSS = 0.0;
            double YBAR = 0.0;
            double WSUM = 0.0;
            int k = 0;
            while (k < M) {
                YBAR += W[k] * Y[k];
                WSUM += W[k];
                ++k;
            }
            YBAR /= WSUM;
            k = 0;
            while (k < M) {
                this.Ycalc[k] = 0.0;
                int i2 = 0;
                while (i2 < N) {
                    this.Ycalc[k] = this.Ycalc[k] + this.C[i2] * X[i2][k];
                    ++i2;
                }
                this.DY[k] = this.Ycalc[k] - Y[k];
                TSS += W[k] * (Y[k] - YBAR) * (Y[k] - YBAR);
                RSS += W[k] * this.DY[k] * this.DY[k];
                ++k;
            }
            double SSQ = RSS / (double)NDF;
            this.RYSQ = 1.0 - RSS / TSS;
            this.FReg = 9999999.0;
            if (this.RYSQ < 0.9999999) {
                this.FReg = this.RYSQ / (1.0 - this.RYSQ) * (double)NDF / (double)(N - 1);
            }
            this.SDV = Math.sqrt(SSQ);
            int i3 = 0;
            while (i3 < N) {
                int j2 = 0;
                while (j2 < N) {
                    this.V[i3][j2] = this.V[i3][j2] * SSQ;
                    ++j2;
                }
                this.SEC[i3] = Math.sqrt(this.V[i3][i3]);
                ++i3;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
            return false;
        }
        return true;
    }

    public boolean SymmetricMatrixInvert(double[][] V) {
        int L;
        int N = (int)Math.sqrt(V.length * V[0].length);
        double[] t = new double[N];
        double[] Q = new double[N];
        double[] R = new double[N];
        int M = 0;
        while (M < N) {
            R[M] = 1.0;
            ++M;
        }
        int K = 0;
        M = 0;
        while (M < N) {
            double Big = 0.0;
            L = 0;
            while (L < N) {
                double AB = Math.abs(V[L][L]);
                if (AB > Big && R[L] != 0.0) {
                    Big = AB;
                    K = L;
                }
                ++L;
            }
            if (Big == 0.0) {
                return false;
            }
            R[K] = 0.0;
            Q[K] = 1.0 / V[K][K];
            t[K] = 1.0;
            V[K][K] = 0.0;
            if (K != 0) {
                L = 0;
                while (L < K) {
                    t[L] = V[L][K];
                    Q[L] = R[L] == 0.0 ? V[L][K] * Q[K] : -V[L][K] * Q[K];
                    V[L][K] = 0.0;
                    ++L;
                }
            }
            if (K + 1 < N) {
                L = K + 1;
                while (L < N) {
                    t[L] = R[L] != 0.0 ? V[K][L] : -V[K][L];
                    Q[L] = -V[K][L] * Q[K];
                    V[K][L] = 0.0;
                    ++L;
                }
            }
            L = 0;
            while (L < N) {
                K = L;
                while (K < N) {
                    V[L][K] = V[L][K] + t[L] * Q[K];
                    ++K;
                }
                ++L;
            }
            ++M;
        }
        M = N;
        L = N - 1;
        K = 1;
        while (K < N) {
            --M;
            --L;
            int J = 0;
            while (J <= L) {
                V[M][J] = V[J][M];
                ++J;
            }
            ++K;
        }
        return true;
    }
}

