/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.bean.ColumnPositionMappingStrategy;
import au.com.bytecode.opencsv.bean.CsvToBean;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import myObjects.LattParam;
import myObjects.MeasurementData;
import myObjects.Polynom;
import myObjects.eCrystalSystem;
import myObjects.eLatticeName;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class ImportUtilities {
    static Logger logger = Logger.getLogger(ImportUtilities.class);

    public MeasurementData importMeasurmentData(File file, eCrystalSystem _eCrystalSystem, boolean isBeta) {
        MeasurementData _list = null;
        try {
            String[] nextLine;
            if (file == null) {
                throw new Exception("No Crystal System or Measurement Dataset selected!");
            }
            CSVReader reader = new CSVReader((Reader)new FileReader(file.getAbsolutePath()), ';');
            ArrayList<LattParam> _measurementData = new ArrayList<LattParam>();
            boolean isUncertainty = false;
            int iCounter = 0;
            double[] dValue = null;
            double dMinTemp = 0.0;
            double dMaxTemp = 0.0;
            while ((nextLine = reader.readNext()) != null) {
                dValue = null;
                LattParam _obj = new LattParam();
                if (iCounter == 0) {
                    dMinTemp = Double.parseDouble(nextLine[0]);
                    dMaxTemp = Double.parseDouble(nextLine[0]);
                }
                if (dMinTemp > Double.parseDouble(nextLine[0])) {
                    dMinTemp = Double.parseDouble(nextLine[0]);
                }
                if (dMaxTemp < Double.parseDouble(nextLine[0])) {
                    dMaxTemp = Double.parseDouble(nextLine[0]);
                }
                if (iCounter == 0 && nextLine[1].indexOf("(") > -1) {
                    isUncertainty = true;
                }
                if (_eCrystalSystem == eCrystalSystem.Triclinic) {
                    if (nextLine.length != 7) {
                        throw new Exception("Column count does not match with selected crystal system!");
                    }
                    _obj.setTemp(Double.parseDouble(nextLine[0]));
                    dValue = this.returnLattParam(nextLine[1], isUncertainty);
                    _obj.setA(dValue[0]);
                    _obj.setA_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[2], isUncertainty);
                    _obj.setB(dValue[0]);
                    _obj.setB_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[3], isUncertainty);
                    _obj.setC(dValue[0]);
                    _obj.setC_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[4], isUncertainty);
                    _obj.setAlpha(dValue[0]);
                    _obj.setAlpha_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[5], isUncertainty);
                    _obj.setBeta(dValue[0]);
                    _obj.setBeta_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[6], isUncertainty);
                    _obj.setGamma(dValue[0]);
                    _obj.setGamma_u(dValue[1]);
                } else if (_eCrystalSystem == eCrystalSystem.Monoclinic) {
                    if (nextLine.length != 5) {
                        throw new Exception("Column count does not match with selected crystal system!");
                    }
                    _obj.setTemp(Double.parseDouble(nextLine[0]));
                    dValue = this.returnLattParam(nextLine[1], isUncertainty);
                    _obj.setA(dValue[0]);
                    _obj.setA_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[2], isUncertainty);
                    _obj.setB(dValue[0]);
                    _obj.setB_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[3], isUncertainty);
                    _obj.setC(dValue[0]);
                    _obj.setC_u(dValue[1]);
                    if (isBeta) {
                        dValue = this.returnLattParam(nextLine[4], isUncertainty);
                        _obj.setBeta(dValue[0]);
                        _obj.setBeta_u(dValue[1]);
                    } else {
                        dValue = this.returnLattParam(nextLine[4], isUncertainty);
                        _obj.setGamma(dValue[0]);
                        _obj.setGamma_u(dValue[1]);
                    }
                } else if (_eCrystalSystem == eCrystalSystem.Orthorhombic) {
                    if (nextLine.length != 4) {
                        throw new Exception("Column count does not match with selected crystal system!");
                    }
                    _obj.setTemp(Double.parseDouble(nextLine[0]));
                    dValue = this.returnLattParam(nextLine[1], isUncertainty);
                    _obj.setA(dValue[0]);
                    _obj.setA_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[2], isUncertainty);
                    _obj.setB(dValue[0]);
                    _obj.setB_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[3], isUncertainty);
                    _obj.setC(dValue[0]);
                    _obj.setC_u(dValue[1]);
                } else if (_eCrystalSystem == eCrystalSystem.Tetragonal || _eCrystalSystem == eCrystalSystem.Hexagonal) {
                    if (nextLine.length != 3) {
                        throw new Exception("Column count does not match with selected crystal system!");
                    }
                    _obj.setTemp(Double.parseDouble(nextLine[0]));
                    dValue = this.returnLattParam(nextLine[1], isUncertainty);
                    _obj.setA(dValue[0]);
                    _obj.setA_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[2], isUncertainty);
                    _obj.setC(dValue[0]);
                    _obj.setC_u(dValue[1]);
                } else if (_eCrystalSystem == eCrystalSystem.Rhombohedral) {
                    if (nextLine.length != 3) {
                        throw new Exception("Column count does not match with selected crystal system!");
                    }
                    _obj.setTemp(Double.parseDouble(nextLine[0]));
                    dValue = this.returnLattParam(nextLine[1], isUncertainty);
                    _obj.setA(dValue[0]);
                    _obj.setA_u(dValue[1]);
                    dValue = this.returnLattParam(nextLine[2], isUncertainty);
                    _obj.setAlpha(dValue[0]);
                    _obj.setAlpha_u(dValue[1]);
                } else if (_eCrystalSystem == eCrystalSystem.Cubic) {
                    if (nextLine.length != 2) {
                        throw new Exception("Column count does not match with selected crystal system!");
                    }
                    _obj.setTemp(Double.parseDouble(nextLine[0]));
                    dValue = this.returnLattParam(nextLine[1], isUncertainty);
                    _obj.setA(dValue[0]);
                    _obj.setA_u(dValue[1]);
                }
                _measurementData.add(_obj);
                ++iCounter;
            }
            if (!_measurementData.isEmpty()) {
                _list = new MeasurementData();
                _list.setMinTemp(dMinTemp);
                _list.setMaxTemp(dMaxTemp);
                _list.setCrystalSystem(_eCrystalSystem);
                _list.setMeasurementData(_measurementData);
                _list.setFlag(isBeta);
            }
            reader.close();
        }
        catch (IOException _ioEx) {
            logger.error((Object)_ioEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _list;
    }

    private double[] returnLattParam(String pLattParam, boolean uncertainty) {
        double[] rv;
        block5: {
            rv = null;
            try {
                rv = new double[2];
                if (pLattParam.indexOf("(") > 0 && uncertainty) {
                    String[] sSplitDec = pLattParam.split("\\.");
                    int indexBracket = sSplitDec[1].indexOf("(");
                    String[] sSplitBracket = pLattParam.split("\\(|\\)");
                    rv[0] = Double.parseDouble(sSplitBracket[0]);
                    rv[1] = this.returnStdUncertainty(sSplitBracket[1], indexBracket);
                    break block5;
                }
                if (pLattParam.indexOf("(") < 0 && !uncertainty) {
                    rv[0] = Double.parseDouble(pLattParam);
                    rv[1] = 1.0;
                    break block5;
                }
                throw new Exception("No mixed data (with AND without uncertainties) are allowed. Please check your data set.");
            }
            catch (NumberFormatException _nbrEx) {
                logger.error((Object)_nbrEx.getMessage());
                return null;
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
                return null;
            }
        }
        return rv;
    }

    private double returnStdUncertainty(String sValue, int pos) {
        double rv = 1.0;
        try {
            String sU = "0.";
            pos -= sValue.length();
            int i = 0;
            while (i < pos) {
                sU = String.valueOf(sU) + "0";
                ++i;
            }
            sU = String.valueOf(sU) + sValue;
            rv = Double.parseDouble(sU);
        }
        catch (NumberFormatException _nbrEx) {
            logger.error((Object)_nbrEx);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public MeasurementData importCSVbindBean(File file, eCrystalSystem _eCrystalSystem, boolean isBeta) {
        MeasurementData _list = null;
        ColumnPositionMappingStrategy strat = new ColumnPositionMappingStrategy();
        strat.setType(LattParam.class);
        String[] columns = null;
        if (_eCrystalSystem == eCrystalSystem.Triclinic) {
            columns = new String[]{"Temp", "a", "b", "c", "alpha", "beta", "gamma"};
        } else if (_eCrystalSystem == eCrystalSystem.Monoclinic) {
            columns = isBeta ? new String[]{"Temp", "a", "b", "c", "beta"} : new String[]{"Temp", "a", "b", "c", "gamma"};
        } else if (_eCrystalSystem == eCrystalSystem.Orthorhombic) {
            columns = new String[]{"Temp", "a", "b", "c"};
        } else if (_eCrystalSystem == eCrystalSystem.Tetragonal || _eCrystalSystem == eCrystalSystem.Hexagonal) {
            columns = new String[]{"Temp", "a", "c"};
        } else if (_eCrystalSystem == eCrystalSystem.Rhombohedral) {
            columns = new String[]{"Temp", "a", "alpha"};
        } else if (_eCrystalSystem == eCrystalSystem.Cubic) {
            columns = new String[]{"Temp", "a"};
        }
        strat.setColumnMapping(columns);
        try {
            if (file == null || _eCrystalSystem == eCrystalSystem.select) {
                throw new Exception("No Crystal System or Measurement Dataset selected!");
            }
            CsvToBean bean = new CsvToBean();
            CSVReader reader = new CSVReader((Reader)new FileReader(file.getAbsolutePath()), ';');
            List _measurementData = bean.parse((MappingStrategy)strat, reader);
            if (!_measurementData.isEmpty()) {
                _list = new MeasurementData();
                _list.setCrystalSystem(_eCrystalSystem);
                _list.setMeasurementData(_measurementData);
                _list.setFlag(isBeta);
                reader.close();
            }
        }
        catch (IOException _ioEx) {
            logger.error((Object)_ioEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _list;
    }

    public List<IFunctions> returnLiteraturePolynomialList(String[] sPolynomials, eCrystalSystem pCrystalSystem, boolean isBeta) {
        ArrayList<Polynom> _listPoly = null;
        try {
            if (sPolynomials != null && pCrystalSystem != eCrystalSystem.select) {
                _listPoly = new ArrayList<Polynom>();
                if (pCrystalSystem == eCrystalSystem.Triclinic) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.a));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[1], eLatticeName.b));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[2], eLatticeName.c));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[3], eLatticeName.alpha));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[4], eLatticeName.beta));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[5], eLatticeName.gamma));
                } else if (pCrystalSystem == eCrystalSystem.Monoclinic) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.a));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[1], eLatticeName.b));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[2], eLatticeName.c));
                    if (isBeta) {
                        _listPoly.add(this.returnPolynomForStringValue(sPolynomials[3], eLatticeName.beta));
                    } else {
                        _listPoly.add(this.returnPolynomForStringValue(sPolynomials[3], eLatticeName.gamma));
                    }
                } else if (pCrystalSystem == eCrystalSystem.Orthorhombic) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.a));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[1], eLatticeName.b));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[2], eLatticeName.c));
                } else if (pCrystalSystem == eCrystalSystem.Tetragonal) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.a));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[1], eLatticeName.c));
                } else if (pCrystalSystem == eCrystalSystem.Rhombohedral) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.a));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[1], eLatticeName.alpha));
                } else if (pCrystalSystem == eCrystalSystem.Hexagonal) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.a));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[1], eLatticeName.c));
                } else if (pCrystalSystem == eCrystalSystem.Cubic) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.a));
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _listPoly;
    }

    public List<IFunctions> returnLiteratureAnglePolynomialList(String[] sPolynomials, eCrystalSystem pCrystalSystem, boolean isBeta) {
        ArrayList<Polynom> _listPoly = null;
        try {
            if (sPolynomials != null && pCrystalSystem != eCrystalSystem.select) {
                _listPoly = new ArrayList<Polynom>();
                if (pCrystalSystem == eCrystalSystem.Triclinic) {
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.alpha));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[1], eLatticeName.beta));
                    _listPoly.add(this.returnPolynomForStringValue(sPolynomials[2], eLatticeName.gamma));
                } else if (pCrystalSystem == eCrystalSystem.Monoclinic) {
                    if (isBeta) {
                        _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.beta));
                    } else {
                        _listPoly.add(this.returnPolynomForStringValue(sPolynomials[0], eLatticeName.gamma));
                    }
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _listPoly;
    }

    private Polynom returnPolynomForStringValue(String sValue, eLatticeName _LatticeParam) {
        Polynom _rv;
        block5: {
            _rv = null;
            try {
                if (!sValue.isEmpty()) {
                    String[] sSplitValues = sValue.split("\\|");
                    if (sSplitValues.length > 1) {
                        double[] _dCoeff = new double[sSplitValues.length];
                        int iCount = 0;
                        String[] stringArray = sSplitValues;
                        int n = sSplitValues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String _sCoeff = stringArray[n2];
                            _dCoeff[iCount] = Double.parseDouble(_sCoeff);
                            ++iCount;
                            ++n2;
                        }
                        _rv = new Polynom(_dCoeff, _LatticeParam);
                        break block5;
                    }
                    throw new Exception("returnPolynomForStringValue: Check Order of Polynomial");
                }
                throw new Exception("returnPolynomForStringValue: Empty String");
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
            }
        }
        return _rv;
    }

    public List<IFunctions> returnCosFunctionsList() {
        List<IFunctions> _rv = null;
        return _rv;
    }

    public static void main(String[] args) {
        ImportUtilities _iu = new ImportUtilities();
        File _file = new File("C:\\00UncertaintyTric.csv");
        _iu.importMeasurmentData(_file, eCrystalSystem.Triclinic, true);
    }
}

