/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import myObjects.Polynom;

public class GoF {
    private static final int SP = 4;

    public static double returnR2(double[] pX, double[] pY, Polynom pPoly) {
        double rv = -1.0;
        if (pX == null || pY == null || pPoly == null) {
            return rv;
        }
        if (pX.length != pY.length) {
            return rv;
        }
        int n = pX.length;
        double mean = 0.0;
        double SSE = 0.0;
        double SST = 0.0;
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            sum += pY[i];
            ++i;
        }
        mean = sum / (double)n;
        i = 0;
        while (i < n) {
            SSE += Math.pow(pY[i] - pPoly.getValue(pX[i]), 2.0);
            SST += Math.pow(pY[i] - mean, 2.0);
            ++i;
        }
        double R2 = (SST - SSE) / SST;
        rv = GoF.roundSignificant(R2, 4);
        return rv;
    }

    private static double roundSignificant(double d, int significantPrecision) {
        if (d == 0.0 || significantPrecision < 1 || significantPrecision > 14) {
            return d;
        }
        double mul10 = 1.0;
        double minVal = Math.pow(10.0, significantPrecision - 1);
        while (Math.abs(d) < minVal) {
            mul10 *= 10.0;
            d *= 10.0;
        }
        return (double)Math.round(d) / mul10;
    }
}

