/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Paint;
import java.awt.Toolkit;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import myObjects.Polynom;
import myObjects.eLatticeName;
import myObjects.functions.IFunctions;
import myUtilities.GoF;
import myUtilities.LinearRegression;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYErrorRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.PolynomialFunction2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.statistics.Regression;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;

public class FitUtilities {
    static Logger logger = Logger.getLogger(FitUtilities.class);

    public ChartPanel createScatterPlot(XYDataset dataset, YIntervalSeriesCollection yintervalseriescollection, String LatticeParam, String sTempUnit) {
        NumberAxis xAxis = new NumberAxis("Temperature [" + sTempUnit + "]");
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setAutoRange(true);
        NumberAxis yAxis = new NumberAxis("Lattice parameter " + LatticeParam);
        yAxis.setAutoRangeIncludesZero(false);
        yAxis.setAutoRange(true);
        XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(false, true);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer1);
        if (yintervalseriescollection != null) {
            XYErrorRenderer errorrenderer = new XYErrorRenderer();
            plot.setDataset(1, (XYDataset)yintervalseriescollection);
            plot.setRenderer(1, (XYItemRenderer)errorrenderer);
            plot.getRenderer(1).setSeriesVisibleInLegend(0, Boolean.valueOf(false));
        }
        JFreeChart chart = new JFreeChart("Scatterplot", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        LegendTitle legend = chart.getLegend();
        Font labelFont = new Font("Arial", 1, 12);
        legend.setItemFont(labelFont);
        ChartPanel chartPanel = new ChartPanel(chart, false);
        try {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            double x = dim.getWidth() * 0.75;
            double y = dim.getHeight() * 0.55;
            Dimension newDim = new Dimension();
            newDim.setSize(x, y);
            chartPanel.setPreferredSize(newDim);
        }
        catch (HeadlessException _DimEx) {
            logger.error((Object)_DimEx.getMessage());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return chartPanel;
    }

    public ChartPanel createChartPanelRegression(XYDataset _dataset, YIntervalSeriesCollection yintervalseriescollection, String LatticeParam, double[] _polyCoefficients, double dStart, double dEnd, String sTempUnit) {
        ChartPanel chartPanel = null;
        try {
            XYSeries _series;
            XYSeriesCollection _seriesColl;
            if (_dataset != null & _polyCoefficients != null && (_seriesColl = (XYSeriesCollection)_dataset) != null && (_series = _seriesColl.getSeries(0)) != null) {
                int _itemCount = _series.getItemCount();
                double[] xData = new double[_itemCount];
                double[] yData = new double[_itemCount];
                double[] yDataCalc = new double[_itemCount];
                int i = 0;
                Polynom _p = new Polynom(_polyCoefficients, eLatticeName.a);
                while (i < _itemCount) {
                    xData[i] = (Double)_series.getX(i);
                    yData[i] = (Double)_series.getY(i);
                    yDataCalc[i] = _p.getValue(yData[i]);
                    ++i;
                }
                if (dStart == 0.0) {
                    dStart = FitUtilities.minValue(xData);
                }
                if (dEnd == 0.0) {
                    dEnd = FitUtilities.maxValue(xData);
                }
                NumberAxis xAxis = new NumberAxis("Temperature [" + sTempUnit + "]");
                xAxis.setAutoRangeIncludesZero(false);
                xAxis.setAutoRange(true);
                NumberAxis yAxis = new NumberAxis(LatticeParam);
                yAxis.setAutoRangeIncludesZero(false);
                yAxis.setAutoRange(true);
                XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(false, true);
                XYPlot plot = new XYPlot(_dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer1);
                if (yintervalseriescollection != null) {
                    XYErrorRenderer errorrenderer = new XYErrorRenderer();
                    plot.setDataset(1, (XYDataset)yintervalseriescollection);
                    plot.setRenderer(1, (XYItemRenderer)errorrenderer);
                }
                PolynomialFunction2D curve1 = new PolynomialFunction2D(_polyCoefficients);
                String sPolyCoeff = _p.toString();
                Polynom _poly = new Polynom(_polyCoefficients, eLatticeName.a);
                double R2 = GoF.returnR2(xData, yData, _poly);
                XYDataset regressionData1 = DatasetUtilities.sampleFunction2D((Function2D)curve1, (double)dStart, (double)dEnd, (int)800, (Comparable)((Object)(String.valueOf(sPolyCoeff) + " -> R^2: " + Double.toString(R2))));
                XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(true, false);
                renderer2.setSeriesPaint(0, (Paint)Color.blue);
                plot.setDataset(1, regressionData1);
                plot.setRenderer(1, (XYItemRenderer)renderer2);
                JFreeChart chart = new JFreeChart("Regression", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                LegendTitle legend = chart.getLegend();
                Font labelFont = new Font("Arial", 1, 12);
                legend.setItemFont(labelFont);
                chartPanel = new ChartPanel(chart, false);
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return chartPanel;
    }

    public ChartPanel createChartPanelRegression(XYDataset _dataset, YIntervalSeriesCollection yintervalseriescollection, String LatticeParam, double[][] _polyCoefficients, double dStart, double dEnd, String sTempUnit) {
        ChartPanel chartPanel = null;
        try {
            XYSeries _series;
            XYSeriesCollection _seriesColl;
            if (_dataset != null & _polyCoefficients != null && (_seriesColl = (XYSeriesCollection)_dataset) != null && (_series = _seriesColl.getSeries(0)) != null) {
                int _itemCount = _series.getItemCount();
                double[] xData = new double[_itemCount];
                double[] yData = new double[_itemCount];
                double[] yDataCalc = new double[_itemCount];
                int i = 0;
                Polynom _p = new Polynom(_polyCoefficients[0], eLatticeName.a);
                while (i < _itemCount) {
                    xData[i] = (Double)_series.getX(i);
                    yData[i] = (Double)_series.getY(i);
                    yDataCalc[i] = _p.getValue(yData[i]);
                    ++i;
                }
                if (dStart == 0.0) {
                    dStart = FitUtilities.minValue(xData);
                }
                if (dEnd == 0.0) {
                    dEnd = FitUtilities.maxValue(xData);
                }
                NumberAxis xAxis = new NumberAxis("Temperature [" + sTempUnit + "]");
                xAxis.setAutoRangeIncludesZero(false);
                xAxis.setAutoRange(true);
                NumberAxis yAxis = new NumberAxis(LatticeParam);
                yAxis.setAutoRangeIncludesZero(false);
                yAxis.setAutoRange(true);
                XYLineAndShapeRenderer renderer1 = new XYLineAndShapeRenderer(false, true);
                XYPlot plot = new XYPlot(_dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer1);
                int dsCount = 1;
                if (yintervalseriescollection != null) {
                    XYErrorRenderer errorrenderer = new XYErrorRenderer();
                    plot.setDataset(1, (XYDataset)yintervalseriescollection);
                    plot.setRenderer(1, (XYItemRenderer)errorrenderer);
                    plot.getRenderer(1).setSeriesVisibleInLegend(0, Boolean.valueOf(false));
                    ++dsCount;
                }
                PolynomialFunction2D curve1 = new PolynomialFunction2D(_polyCoefficients[0]);
                String sPolyCoeff = _p.toString();
                Polynom _poly = new Polynom(_polyCoefficients[0], eLatticeName.a);
                double R2 = GoF.returnR2(xData, yData, _poly);
                String sRegParamStdErr = "";
                int iCoeff = _polyCoefficients[0].length;
                String sDelta = "\u0394";
                int j = 0;
                while (j < iCoeff) {
                    double dCoeff = Polynom.round(_polyCoefficients[0][j], 4, RoundingMode.HALF_DOWN);
                    double dErr = Polynom.round(_polyCoefficients[1][j], 4, RoundingMode.HALF_DOWN);
                    sRegParamStdErr = j < 4 ? String.valueOf(sRegParamStdErr) + "\np" + Integer.toString(j) + "=" + Double.toString(dCoeff) + ", " + sDelta + "p" + Integer.toString(j) + "=" + Double.toString(dErr) + "; " : String.valueOf(sRegParamStdErr) + "\np" + Integer.toString(j) + "=" + Double.toString(dCoeff) + ", " + sDelta + "p" + Integer.toString(j) + "=" + Double.toString(dErr) + "; ";
                    ++j;
                }
                XYDataset regressionData1 = DatasetUtilities.sampleFunction2D((Function2D)curve1, (double)dStart, (double)dEnd, (int)800, (Comparable)((Object)(String.valueOf(sPolyCoeff) + " -> R^2: " + Double.toString(R2) + "\n" + sRegParamStdErr)));
                XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(true, false);
                renderer2.setSeriesPaint(0, (Paint)Color.blue);
                plot.setDataset(dsCount, regressionData1);
                plot.setRenderer(dsCount, (XYItemRenderer)renderer2);
                JFreeChart chart = new JFreeChart("Regression", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
                plot.setNoDataMessage(sRegParamStdErr);
                LegendTitle legend = chart.getLegend();
                Font labelFont = new Font("Arial", 1, 12);
                legend.setItemFont(labelFont);
                chartPanel = new ChartPanel(chart, false);
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return chartPanel;
    }

    public double[] returnPolyFitArray(XYDataset _dataset, int _iOrder) {
        double[] coefficients = null;
        try {
            if (_dataset != null) {
                coefficients = Regression.getPolynomialRegression((XYDataset)_dataset, (int)0, (int)_iOrder);
                double[] coefficientsChop = new double[coefficients.length - 1];
                System.arraycopy(coefficients, 0, coefficientsChop, 0, coefficients.length - 1);
                coefficients = coefficientsChop;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return coefficients;
    }

    public double[][] returnPolyStat(XYDataset _dataset, YIntervalSeriesCollection yIntervallSeries, int _iOrder) {
        double[][] rv = null;
        try {
            LinearRegression _reg = new LinearRegression();
            int iItems = _dataset.getItemCount(0);
            boolean bU = false;
            double[] uncertainty = null;
            if (yIntervallSeries != null) {
                bU = true;
                YIntervalSeries _series = yIntervallSeries.getSeries(0);
                int count = _series.getItemCount();
                uncertainty = new double[count];
                int i = 0;
                while (i < count) {
                    double dUnc;
                    uncertainty[i] = dUnc = _series.getYHighValue(i) - _series.getYValue(i);
                    ++i;
                }
            }
            double[][] XY = new double[iItems][2];
            double[] x = new double[iItems];
            double[] y = new double[iItems];
            double[] weight = new double[iItems];
            int i = 0;
            while (i < iItems) {
                x[i] = _dataset.getXValue(0, i);
                y[i] = _dataset.getYValue(0, i);
                XY[i][0] = _dataset.getXValue(0, i);
                XY[i][1] = _dataset.getYValue(0, i);
                weight[i] = bU ? 1.0 / (uncertainty[i] * uncertainty[i]) : 1.0;
                ++i;
            }
            if (_reg.Regress(XY, weight, _iOrder)) {
                double[] coef = _reg.C;
                double[] regParamStdErr = _reg.SEC;
                rv = new double[2][coef.length];
                rv[0] = coef;
                rv[1] = regParamStdErr;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return rv;
    }

    public List<IFunctions> returnPolyOrder(JTabbedPane _tabbedPane) {
        ArrayList<Polynom> rv = null;
        int iOrder = -1;
        try {
            if (_tabbedPane != null) {
                ArrayList<Polynom> _polyList = new ArrayList<Polynom>();
                int iTotalTabs = _tabbedPane.getTabCount();
                int i = 0;
                while (i < iTotalTabs) {
                    Component _selTabComp = _tabbedPane.getComponentAt(i);
                    String _Tabname = _tabbedPane.getTitleAt(i);
                    if (_selTabComp != null && _selTabComp instanceof JPanel) {
                        Component[] _compList;
                        JPanel _panel = (JPanel)_selTabComp;
                        Component[] componentArray = _compList = _panel.getComponents();
                        int n = _compList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            if (c instanceof JPanel) {
                                Component[] _compListInner;
                                JPanel _panelInner = (JPanel)c;
                                Component[] componentArray2 = _compListInner = _panelInner.getComponents();
                                int n3 = _compListInner.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Component comp = componentArray2[n4];
                                    Polynom _poly = null;
                                    if (comp instanceof JRadioButton) {
                                        JRadioButton _radio = (JRadioButton)comp;
                                        if (_radio.getText() == "Order 1" && _radio.isSelected()) {
                                            iOrder = 1;
                                        } else if (_radio.getText() == "Order 2" && _radio.isSelected()) {
                                            iOrder = 2;
                                        } else if (_radio.getText() == "Order 3" && _radio.isSelected()) {
                                            iOrder = 3;
                                        } else if (_radio.getText() == "Order 4" && _radio.isSelected()) {
                                            iOrder = 4;
                                        } else if (_radio.getText() == "Order 5" && _radio.isSelected()) {
                                            iOrder = 5;
                                        } else if (_radio.getText() == "none" && _radio.isSelected()) {
                                            throw new Exception("Fit each single lattice parameter!");
                                        }
                                    } else if (comp instanceof ChartPanel && iOrder > 0) {
                                        double[] _coefficients;
                                        JFreeChart _chart = ((ChartPanel)comp).getChart();
                                        XYPlot _plot = (XYPlot)_chart.getPlot();
                                        String sRegParamUncertainties = _plot.getNoDataMessage();
                                        XYDataset _fitDataset = _plot.getDataset(1);
                                        if (_plot.getDatasetCount() > 2) {
                                            _fitDataset = _plot.getDataset(2);
                                        }
                                        if ((_coefficients = this.returnPolyFitArray(_fitDataset, iOrder)).length > 0) {
                                            _poly = new Polynom(_coefficients, sRegParamUncertainties, eLatticeName.fromString(_Tabname));
                                            _polyList.add(_poly);
                                        }
                                    }
                                    ++n4;
                                }
                                if (_polyList.size() > 0) {
                                    rv = _polyList;
                                }
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
            rv = null;
        }
        return rv;
    }

    public double returnChiSquare(double[] observered, double[] calculated, boolean bTrueFreq) {
        double rv = 0.0;
        try {
            int iCount = observered.length;
            if (iCount == calculated.length) {
                int i = 0;
                while (i < iCount) {
                    double dDiff = observered[i] - calculated[i];
                    double dDiffSquare = Math.pow(dDiff, 2.0);
                    rv += dDiffSquare / calculated[i];
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    public double returnRSquareValue(double[] observered, double[] calculated) {
        double rv = 0.0;
        try {
            int iCount = observered.length;
            if (iCount == calculated.length) {
                int i = 0;
                while (i < iCount) {
                    double dDiff = observered[i] - calculated[i];
                    double dDiffSquare = Math.pow(dDiff, 2.0);
                    rv += dDiffSquare / calculated[i];
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    private static double maxValue(double[] dArray) {
        double max = 0.0;
        int ktr = 0;
        while (ktr < dArray.length) {
            if (dArray[ktr] > max) {
                max = dArray[ktr];
            }
            ++ktr;
        }
        return max;
    }

    private static double minValue(double[] dArray) {
        double min = dArray[0];
        int ktr = 0;
        while (ktr < dArray.length) {
            if (dArray[ktr] < min) {
                min = dArray[ktr];
            }
            ++ktr;
        }
        return min;
    }
}

