/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Jama.Matrix;
import org.apache.log4j.Logger;

public class EigenDecompositionBakk {
    static Logger logger = Logger.getLogger(EigenDecompositionBakk.class);
    public static double[][] AA;
    public static double[][] V;
    public static double[][] AAj;
    public static double[] Vj;
    private static double[] c;
    private static double[] s;

    public static void doDecomposition(double[][] A) {
        try {
            if (A != null) {
                int j;
                int i;
                if (A.length != A[0].length) {
                    throw new Exception("Matrice not symmetric!");
                }
                int n = A.length;
                boolean issymmetric = true;
                int j2 = 0;
                while (j2 < n & issymmetric) {
                    int i2 = 0;
                    while (i2 < n & issymmetric) {
                        issymmetric = A[i2][j2] == A[j2][i2];
                        ++i2;
                    }
                    ++j2;
                }
                if (issymmetric) {
                    AA = new double[3][3];
                    V = new double[3][3];
                    i = 0;
                    while (i < n) {
                        j = 0;
                        while (j < n) {
                            EigenDecompositionBakk.AA[i][j] = A[i][j];
                            ++j;
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < n) {
                    j = 0;
                    while (j < n) {
                        EigenDecompositionBakk.V[i][j] = 0.0;
                        ++j;
                    }
                    EigenDecompositionBakk.V[i][i] = 1.0;
                    ++i;
                }
                c = new double[1];
                s = new double[1];
                EigenDecompositionBakk.c[0] = 1.0;
                EigenDecompositionBakk.s[0] = 0.0;
                AAj = new double[4][4];
                Vj = new double[4];
                i = 0;
                while (i < n) {
                    j = 0;
                    while (j < n - 1) {
                        int k = j + 1;
                        while (k < n) {
                            EigenDecompositionBakk.jacobi(A, 2, Vj, AAj);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    private static void calcCosSin(double[][] A, int p, int q, double[] c, double[] s) {
        try {
            if (A[p][q] != 0.0) {
                double Theta = (A[q][q] - A[p][p]) / (A[p][q] * 2.0);
                double t = Math.signum(Theta) / (Math.abs(Theta) + Math.sqrt(1.0 + Math.pow(Theta, 2.0)));
                c[0] = 1.0 / Math.sqrt(1.0 + Math.pow(t, 2.0));
                s[0] = t * c[0];
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
    }

    private static void jacobi(double[][] a, int n, double[] d, double[][] v) {
        int iq;
        double[] b = new double[n + 1];
        double[] z = new double[n + 1];
        int ip = 1;
        while (ip <= n) {
            iq = 1;
            while (iq <= n) {
                v[ip][iq] = 0.0;
                ++iq;
            }
            v[ip][ip] = 1.0;
            ++ip;
        }
        ip = 1;
        while (ip <= n) {
            b[ip] = d[ip] = a[ip][ip];
            z[ip] = 0.0;
            ++ip;
        }
        int i = 1;
        while (i <= 50) {
            double sm = 0.0;
            ip = 1;
            while (ip <= n - 1) {
                iq = ip + 1;
                while (iq <= n) {
                    sm += Math.abs(a[ip][iq]);
                    ++iq;
                }
                ++ip;
            }
            if (sm == 0.0) {
                return;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            ip = 1;
            while (ip <= n - 1) {
                iq = ip + 1;
                while (iq <= n) {
                    double g = 100.0 * Math.abs(a[ip][iq]);
                    if (i > 4 && Math.abs(d[ip]) + g == Math.abs(d[ip]) && Math.abs(d[iq]) + g == Math.abs(d[iq])) {
                        a[ip][iq] = 0.0;
                    } else if (Math.abs(a[ip][iq]) > tresh) {
                        double t;
                        double h = d[iq] - d[ip];
                        if (Math.abs(h) + g == Math.abs(h)) {
                            t = a[ip][iq] / h;
                        } else {
                            double theta = 0.5 * h / a[ip][iq];
                            t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                            if (theta < 0.0) {
                                t = -t;
                            }
                        }
                        double c = 1.0 / Math.sqrt(1.0 + t * t);
                        double s = t * c;
                        double tau = s / (1.0 + c);
                        h = t * a[ip][iq];
                        int n2 = ip;
                        z[n2] = z[n2] - h;
                        int n3 = iq;
                        z[n3] = z[n3] + h;
                        int n4 = ip;
                        d[n4] = d[n4] - h;
                        int n5 = iq;
                        d[n5] = d[n5] + h;
                        a[ip][iq] = 0.0;
                        int j = 1;
                        while (j <= ip - 1) {
                            g = a[j][ip];
                            h = a[j][iq];
                            a[j][ip] = g - s * (h + g * tau);
                            a[j][iq] = h + s * (g - h * tau);
                            ++j;
                        }
                        j = ip + 1;
                        while (j <= iq - 1) {
                            g = a[ip][j];
                            h = a[j][iq];
                            a[ip][j] = g - s * (h + g * tau);
                            a[j][iq] = h + s * (g - h * tau);
                            ++j;
                        }
                        j = iq + 1;
                        while (j <= n) {
                            g = a[ip][j];
                            h = a[iq][j];
                            a[ip][j] = g - s * (h + g * tau);
                            a[iq][j] = h + s * (g - h * tau);
                            ++j;
                        }
                        j = 1;
                        while (j <= n) {
                            g = v[j][ip];
                            h = v[j][iq];
                            v[j][ip] = g - s * (h + g * tau);
                            v[j][iq] = h + s * (g - h * tau);
                            ++j;
                        }
                    }
                    ++iq;
                }
                ++ip;
            }
            ip = 1;
            while (ip <= n) {
                int n6 = ip;
                b[n6] = b[n6] + z[ip];
                d[ip] = b[ip];
                z[ip] = 0.0;
                ++ip;
            }
            ++i;
        }
        System.err.println("Too many iterations in routine jacobi");
    }

    private static void transform(int p, int q, double[] c, double[] s, double[][] A, double[][] VV) {
        try {
            double[][] X = new double[3][3];
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    X[i][j] = 0.0;
                    ++j;
                }
                X[i][i] = 1.0;
                ++i;
            }
            X[p][p] = c[0];
            X[p][q] = -s[0];
            X[q][q] = c[0];
            X[q][p] = s[0];
            Matrix mX = new Matrix(X);
            Matrix mA = new Matrix(A);
            Matrix mV = new Matrix(VV);
            Matrix mB = mX.times(mA);
            mX.set(p, q, s[0]);
            mX.set(q, p, -s[0]);
            mA = mB.times(mX);
            mB = mV.times(mX);
            V = mB.getArray();
            AA = mA.getArray();
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    public static void main(String[] a) {
        double[][] CTE_test = new double[3][3];
        CTE_test[0][0] = 1.0685E-5;
        CTE_test[0][1] = 0.0;
        CTE_test[0][2] = 2.8452E-6;
        CTE_test[1][0] = 0.0;
        CTE_test[1][1] = 1.0545E-5;
        CTE_test[1][2] = 0.0;
        CTE_test[2][0] = 2.8452E-6;
        CTE_test[2][1] = 0.0;
        CTE_test[2][2] = 9.289E-6;
        EigenDecompositionBakk.doDecomposition(CTE_test);
        System.out.println("---------------------------------");
        double[][] AA = AAj;
        double[] V = Vj;
        Matrix eigenvalue = new Matrix(AA);
        eigenvalue.print(2, 12);
        System.out.println("det(eigenvector)");
        System.out.println("---------------------------------");
    }
}

