/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Jama.Matrix;
import org.apache.log4j.Logger;

public class EigenDecomposition {
    static Logger logger = Logger.getLogger(EigenDecomposition.class);
    public static double[][] AA;
    public static double[][] V;
    private static double[] c;
    private static double[] s;

    public static void doDecomposition(double[][] A) {
        try {
            if (A != null) {
                int j;
                int i;
                if (A.length != A[0].length) {
                    throw new Exception("Matrice not symmetric!");
                }
                int n = A.length;
                boolean issymmetric = true;
                int j2 = 0;
                while (j2 < n & issymmetric) {
                    int i2 = 0;
                    while (i2 < n & issymmetric) {
                        issymmetric = A[i2][j2] == A[j2][i2];
                        ++i2;
                    }
                    ++j2;
                }
                if (issymmetric) {
                    AA = new double[3][3];
                    V = new double[3][3];
                    i = 0;
                    while (i < n) {
                        j = 0;
                        while (j < n) {
                            EigenDecomposition.AA[i][j] = A[i][j];
                            ++j;
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < n) {
                    j = 0;
                    while (j < n) {
                        EigenDecomposition.V[i][j] = 0.0;
                        ++j;
                    }
                    EigenDecomposition.V[i][i] = 1.0;
                    ++i;
                }
                boolean isDiagonal = EigenDecomposition.isDiagonal();
                int iter = 0;
                int maxIter = 1000;
                c = new double[1];
                s = new double[1];
                EigenDecomposition.c[0] = 1.0;
                EigenDecomposition.s[0] = 0.0;
                while (!isDiagonal) {
                    if (iter < maxIter) {
                        int i3 = 0;
                        while (i3 < n) {
                            int j3 = 0;
                            while (j3 < n - 1) {
                                int k = j3 + 1;
                                while (k < n) {
                                    EigenDecomposition.transform(j3, k, AA, V);
                                    ++k;
                                }
                                ++j3;
                            }
                            ++i3;
                        }
                        ++iter;
                        isDiagonal = EigenDecomposition.isDiagonal();
                        continue;
                    }
                    throw new Exception("doEigenDecomposition: maximum iteration reached");
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    private static void calcCosSin(double[][] A, int p, int q, double[] c, double[] s) {
        try {
            if (A[p][q] != 0.0) {
                double Theta = (A[q][q] - A[p][p]) / A[p][q];
                double t = Math.signum(Theta) / Math.pow(Math.abs(Theta), 2.0) + Math.sqrt(1.0 + Math.pow(Theta, 2.0));
                c[0] = 1.0 / Math.sqrt(1.0 + Math.pow(t, 2.0));
                s[0] = t * c[0];
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
    }

    private static void rotate(int p, int q) {
        double d = (AA[p][p] - AA[q][q]) / (2.0 * AA[p][q]);
        double t = Math.signum(d) / (Math.abs(d) + Math.sqrt(d * d + 1.0));
        double c = 1.0 / Math.sqrt(t * t + 1.0);
        double s = t * c;
        int n = AA.length;
        double[] dArray = AA[p];
        int n2 = p;
        dArray[n2] = dArray[n2] + t * AA[p][q];
        double[] dArray2 = AA[q];
        int n3 = q;
        dArray2[n3] = dArray2[n3] - t * AA[p][q];
        EigenDecomposition.AA[q][p] = 0.0;
        EigenDecomposition.AA[p][q] = 0.0;
        int k = 0;
        while (k < n) {
            if (k != p && k != q) {
                double akp = c * AA[k][p] + s * AA[k][q];
                double akq = -s * AA[k][p] + c * AA[k][q];
                double d2 = akp;
                EigenDecomposition.AA[p][k] = d2;
                EigenDecomposition.AA[k][p] = d2;
                double d3 = akq;
                EigenDecomposition.AA[q][k] = d3;
                EigenDecomposition.AA[k][q] = d3;
            }
            ++k;
        }
        k = 0;
        while (k < n) {
            double rkp = c * V[k][p] + s * V[k][q];
            double rkq = -s * V[k][p] + c * V[k][q];
            EigenDecomposition.V[k][p] = rkp;
            EigenDecomposition.V[k][q] = rkq;
            ++k;
        }
    }

    private static void transform(int p, int q, double[][] A, double[][] VV) {
        try {
            if (A[p][q] != 0.0) {
                double Theta = (A[q][q] - A[p][p]) / A[p][q];
                if (Theta == 0.0) {
                    Theta = 0.7853981633974483;
                }
                double t = Math.signum(Theta) / Math.abs(Theta * Theta) + Math.sqrt(1.0 + Math.pow(Theta, 2.0));
                double c = 1.0 / Math.sqrt(1.0 + Math.pow(t, 2.0));
                double s = t * c;
                double[][] P = new double[3][3];
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        P[i][j] = 0.0;
                        ++j;
                    }
                    P[i][i] = 1.0;
                    ++i;
                }
                P[p][p] = c;
                P[p][q] = s;
                P[q][q] = c;
                P[q][p] = -s;
                Matrix mP = new Matrix(P);
                Matrix mA = new Matrix(A);
                Matrix mV = new Matrix(VV);
                Matrix mB = mP.times(mA);
                mP.set(p, q, -s);
                mP.set(q, p, s);
                mA = mB.times(mP);
                mB = mV.times(mP);
                AA = mA.getArray();
                V = mB.getArray();
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    private static void transformRot(int p, int q, double c, double s, double[][] A, double[][] VV) {
        try {
            double[][] P = new double[3][3];
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    P[i][j] = 0.0;
                    ++j;
                }
                P[i][i] = 1.0;
                ++i;
            }
            P[p][p] = c;
            P[p][q] = -s;
            P[q][q] = c;
            P[q][p] = s;
            Matrix mP = new Matrix(P);
            Matrix mA = new Matrix(A);
            Matrix mV = new Matrix(VV);
            Matrix mB = mP.times(mA);
            mP.set(p, q, s);
            mP.set(q, p, -s);
            mA = mB.times(mP);
            mB = mV.times(mP);
            AA = mA.getArray();
            V = mB.getArray();
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    private static double maxOffDiag() {
        double max = 0.0;
        int n = AA.length;
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                double aij = Math.abs(AA[i][j]);
                if (aij > max) {
                    max = aij;
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    private static boolean isDiagonal() {
        double epsilon = 1.0E-16;
        boolean rv = false;
        double offDiag = 0.0;
        double Diag = 0.0;
        int n = AA.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (i == j) {
                    Diag += Math.abs(AA[i][i] * AA[i][i]);
                } else {
                    offDiag += Math.abs(AA[i][j] * AA[i][j]);
                }
                ++j;
            }
            ++i;
        }
        if (offDiag < epsilon) {
            rv = true;
        }
        return rv;
    }

    private static void print(double[][] M) {
        int n = M.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                System.out.print(String.valueOf(M[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void main(String[] a) {
        double[][] CTE_test = new double[3][3];
        CTE_test[0][0] = 1.0685E-5;
        CTE_test[0][1] = 0.0;
        CTE_test[0][2] = 2.8452E-6;
        CTE_test[1][0] = 0.0;
        CTE_test[1][1] = 1.0545E-5;
        CTE_test[1][2] = 0.0;
        CTE_test[2][0] = 2.8452E-6;
        CTE_test[2][1] = 0.0;
        CTE_test[2][2] = 9.289E-6;
        EigenDecomposition.doDecomposition(CTE_test);
        System.out.println("---------------------------------");
        double[][] AA = EigenDecomposition.AA;
        EigenDecomposition.print(AA);
        System.out.println("---------------------------------");
        double[][] V = EigenDecomposition.V;
        EigenDecomposition.print(V);
        System.out.println("---------------------------------");
    }
}

