/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Jama.Matrix;
import org.apache.log4j.Logger;

public class EigenDec {
    static Logger logger = Logger.getLogger(EigenDec.class);
    public static double[][] A;
    public static double[][] AA;
    public static double[][] V;
    public static int[] pq;

    private static void print(double[][] M) {
        int n = M.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                System.out.print(String.valueOf(M[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void doDecomposition(double[][] pA) {
        try {
            A = pA;
            if (A != null) {
                int j;
                int i;
                if (A.length != A[0].length) {
                    throw new Exception("Matrice not symmetric!");
                }
                int n = A.length;
                boolean issymmetric = true;
                int j2 = 0;
                while (j2 < n & issymmetric) {
                    int i2 = 0;
                    while (i2 < n & issymmetric) {
                        issymmetric = A[i2][j2] == A[j2][i2];
                        ++i2;
                    }
                    ++j2;
                }
                if (issymmetric) {
                    AA = new double[3][3];
                    V = new double[3][3];
                    i = 0;
                    while (i < n) {
                        j = 0;
                        while (j < n) {
                            EigenDec.AA[i][j] = A[i][j];
                            ++j;
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < n) {
                    j = 0;
                    while (j < n) {
                        EigenDec.V[i][j] = 0.0;
                        ++j;
                    }
                    EigenDec.V[i][i] = 1.0;
                    ++i;
                }
                pq = new int[2];
                boolean isDiagonal = EigenDec.isDiagonal();
                int iter = 0;
                int maxIter = 1000;
                while (!isDiagonal) {
                    if (iter < maxIter) {
                        EigenDec.transform(pq[0], pq[1]);
                        ++iter;
                        isDiagonal = EigenDec.isDiagonal();
                        continue;
                    }
                    throw new Exception("doEigenDecomposition: maximum iteration reached");
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    private static void transform(int p, int q) {
        try {
            if (A[p][q] != 0.0) {
                double Theta = 0.0;
                Theta = (AA[q][q] - AA[p][p]) / (2.0 * AA[p][q]);
                double tanphi = 1.0;
                if (Theta != 0.0) {
                    tanphi = 1.0 / (Theta + Math.signum(Theta) * Math.sqrt(1.0 + Math.pow(Theta, 2.0)));
                }
                double phi = Math.atan(tanphi);
                double c = Math.cos(phi);
                double s = Math.sin(phi);
                double[][] P = new double[3][3];
                int i = 0;
                while (i < 3) {
                    int j = 0;
                    while (j < 3) {
                        P[i][j] = 0.0;
                        ++j;
                    }
                    P[i][i] = 1.0;
                    ++i;
                }
                P[p][p] = c;
                P[q][q] = c;
                P[p][q] = s;
                P[q][p] = -s;
                Matrix mP = new Matrix(P);
                Matrix mA = new Matrix(AA);
                Matrix mV = new Matrix(V);
                Matrix mB = mP.transpose().times(mA).times(mP);
                mP = mP.transpose();
                mA = mB;
                mB = mP.times(mV);
                AA = mA.getArray();
                V = mB.getArray();
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
    }

    private static boolean isDiagonal() {
        double epsilon = 1.0E-32;
        boolean rv = false;
        double offDiag = 0.0;
        double Diag = 0.0;
        int n = AA.length;
        int i = 0;
        while (i < n) {
            int j = i + 1;
            while (j < n) {
                if (offDiag < AA[i][j]) {
                    offDiag = AA[i][j];
                    EigenDec.pq[0] = i;
                    EigenDec.pq[1] = j;
                }
                ++j;
            }
            ++i;
        }
        if (offDiag < epsilon) {
            rv = true;
        }
        return rv;
    }

    public static void main(String[] a) {
        double[][] A = new double[3][3];
        A[0][0] = 1.0671E-5;
        A[1][1] = 1.0365E-5;
        A[2][2] = 9.6004E-6;
        A[0][2] = 2.6807E-6;
        A[2][0] = 2.6807E-6;
        EigenDec.doDecomposition(A);
        System.out.println("---------------------------------");
        double[][] AA = EigenDec.AA;
        EigenDec.print(AA);
        System.out.println("---------------------------------");
        double[][] V = EigenDec.V;
        EigenDec.print(V);
        System.out.println("---------------------------------");
    }
}

