/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import com.jgoodies.binding.adapter.RadioButtonAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import myObjects.LattParam;
import myObjects.MeasurementData;
import myObjects.Polynom;
import myObjects.eCrystalSystem;
import myUtilities.FitUtilities;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;

public class DynamicPanelBuilder {
    static Logger logger = Logger.getLogger(DynamicPanelBuilder.class);
    private JTabbedPane _tabPane = null;
    public String sTemp;

    public JPanel generateChartTabs(MeasurementData _data) {
        JPanel _panel = null;
        try {
            List<LattParam> _list = _data.getMeasurementData();
            boolean bFlag = _data.getFlag();
            if (_list != null) {
                double[] A_u = new double[_list.size()];
                double[] B_u = new double[_list.size()];
                double[] C_u = new double[_list.size()];
                double[] Alpha_u = new double[_list.size()];
                double[] Beta_u = new double[_list.size()];
                double[] Gamma_u = new double[_list.size()];
                XYSeries _sA = new XYSeries((Comparable)((Object)"a"));
                XYSeries _sB = new XYSeries((Comparable)((Object)"b"));
                XYSeries _sC = new XYSeries((Comparable)((Object)"c"));
                XYSeries _sAlpha = new XYSeries((Comparable)((Object)"alpha"));
                XYSeries _sBeta = new XYSeries((Comparable)((Object)"beta"));
                XYSeries _sGamma = new XYSeries((Comparable)((Object)"gamma"));
                int iCounter = 0;
                for (LattParam lattParam : _list) {
                    if (lattParam == null) continue;
                    _sA.add(lattParam.getTemp(), lattParam.getA());
                    A_u[iCounter] = lattParam.getA_u();
                    _sB.add(lattParam.getTemp(), lattParam.getB());
                    B_u[iCounter] = lattParam.getB_u();
                    _sC.add(lattParam.getTemp(), lattParam.getC());
                    C_u[iCounter] = lattParam.getC_u();
                    _sAlpha.add(lattParam.getTemp(), lattParam.getAlpha());
                    Alpha_u[iCounter] = lattParam.getAlpha_u();
                    _sBeta.add(lattParam.getTemp(), lattParam.getBeta());
                    Beta_u[iCounter] = lattParam.getBeta_u();
                    _sGamma.add(lattParam.getTemp(), lattParam.getGamma());
                    Gamma_u[iCounter] = lattParam.getGamma_u();
                    ++iCounter;
                }
                if (_data.getCrystalSystem() == eCrystalSystem.Triclinic) {
                    _panel = new JPanel();
                    this._tabPane = new JTabbedPane();
                    this._tabPane.add("a", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sA), this.setErrorBar(_sA.toArray()[0], _sA.toArray()[1], A_u), "a", this.sTemp));
                    this._tabPane.add("b", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sB), this.setErrorBar(_sB.toArray()[0], _sB.toArray()[1], B_u), "b", this.sTemp));
                    this._tabPane.add("c", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sC), this.setErrorBar(_sC.toArray()[0], _sC.toArray()[1], C_u), "c", this.sTemp));
                    this._tabPane.add("alpha", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sAlpha), this.setErrorBar(_sAlpha.toArray()[0], _sAlpha.toArray()[1], Alpha_u), "alpha", this.sTemp));
                    this._tabPane.add("beta", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sBeta), this.setErrorBar(_sBeta.toArray()[0], _sBeta.toArray()[1], Beta_u), "beta", this.sTemp));
                    this._tabPane.add("gamma", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sGamma), this.setErrorBar(_sGamma.toArray()[0], _sGamma.toArray()[1], Gamma_u), "gamma", this.sTemp));
                    _panel.add(this._tabPane);
                } else if (_data.getCrystalSystem() == eCrystalSystem.Monoclinic) {
                    _panel = new JPanel();
                    this._tabPane = new JTabbedPane();
                    this._tabPane.add("a", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sA), this.setErrorBar(_sA.toArray()[0], _sA.toArray()[1], A_u), "a", this.sTemp));
                    this._tabPane.add("b", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sB), this.setErrorBar(_sB.toArray()[0], _sB.toArray()[1], B_u), "b", this.sTemp));
                    this._tabPane.add("c", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sC), this.setErrorBar(_sC.toArray()[0], _sC.toArray()[1], C_u), "c", this.sTemp));
                    if (bFlag) {
                        this._tabPane.add("beta", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sBeta), this.setErrorBar(_sBeta.toArray()[0], _sBeta.toArray()[1], Beta_u), "beta", this.sTemp));
                    } else {
                        this._tabPane.add("gamma", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sGamma), this.setErrorBar(_sGamma.toArray()[0], _sGamma.toArray()[1], Gamma_u), "gamma", this.sTemp));
                    }
                    _panel.add(this._tabPane);
                } else if (_data.getCrystalSystem() == eCrystalSystem.Orthorhombic) {
                    _panel = new JPanel();
                    this._tabPane = new JTabbedPane();
                    this._tabPane.add("a", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sA), this.setErrorBar(_sA.toArray()[0], _sA.toArray()[1], A_u), "a", this.sTemp));
                    this._tabPane.add("b", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sB), this.setErrorBar(_sB.toArray()[0], _sB.toArray()[1], B_u), "b", this.sTemp));
                    this._tabPane.add("c", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sC), this.setErrorBar(_sC.toArray()[0], _sC.toArray()[1], C_u), "c", this.sTemp));
                    _panel.add(this._tabPane);
                } else if (_data.getCrystalSystem() == eCrystalSystem.Hexagonal) {
                    _panel = new JPanel();
                    this._tabPane = new JTabbedPane();
                    this._tabPane.add("a", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sA), this.setErrorBar(_sA.toArray()[0], _sA.toArray()[1], A_u), "a", this.sTemp));
                    this._tabPane.add("c", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sC), this.setErrorBar(_sC.toArray()[0], _sC.toArray()[1], C_u), "c", this.sTemp));
                    _panel.add(this._tabPane);
                } else if (_data.getCrystalSystem() == eCrystalSystem.Rhombohedral) {
                    _panel = new JPanel();
                    this._tabPane = new JTabbedPane();
                    this._tabPane.add("a", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sA), this.setErrorBar(_sA.toArray()[0], _sA.toArray()[1], A_u), "a", this.sTemp));
                    this._tabPane.add("alpha", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sAlpha), this.setErrorBar(_sAlpha.toArray()[0], _sAlpha.toArray()[1], Alpha_u), "alpha", this.sTemp));
                    _panel.add(this._tabPane);
                } else if (_data.getCrystalSystem() == eCrystalSystem.Tetragonal) {
                    _panel = new JPanel();
                    this._tabPane = new JTabbedPane();
                    this._tabPane.add("a", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sA), this.setErrorBar(_sA.toArray()[0], _sA.toArray()[1], A_u), "a", this.sTemp));
                    this._tabPane.add("c", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sC), this.setErrorBar(_sC.toArray()[0], _sC.toArray()[1], C_u), "c", this.sTemp));
                    _panel.add(this._tabPane);
                } else if (_data.getCrystalSystem() == eCrystalSystem.Cubic) {
                    _panel = new JPanel();
                    this._tabPane = new JTabbedPane();
                    this._tabPane.add("a", this.returnChartPanel((XYDataset)new XYSeriesCollection(_sA), this.setErrorBar(_sA.toArray()[0], _sA.toArray()[1], A_u), "a", this.sTemp));
                    _panel.add(this._tabPane);
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _panel;
    }

    public JPanel generateCalcOverview(List<Polynom> _listPoly) {
        JPanel _panel = null;
        return _panel;
    }

    public JPanel returnChartPanel(XYDataset _dataset, YIntervalSeriesCollection _yintervalseriescollection, String _latticeParam, String sTempUnit) {
        JPanel _panel = null;
        try {
            if (_dataset != null) {
                _panel = new JPanel();
                FormLayout layout = new FormLayout("10dlu, fill:pref, left:pref, 10dlu,", "10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, top:pref:grow, 10dlu");
                PanelBuilder builder = new PanelBuilder(layout);
                builder.border(Borders.DIALOG);
                ValueHolder selectionModel = new ValueHolder();
                JRadioButton radioButton0 = new JRadioButton("none");
                radioButton0.setSelected(true);
                RadioButtonAdapter radioButtonAdapter0 = new RadioButtonAdapter((ValueModel)selectionModel, (Object)Color.WHITE);
                radioButtonAdapter0.setSelected(true);
                radioButton0.setModel((ButtonModel)radioButtonAdapter0);
                JRadioButton radioButton1 = new JRadioButton("Order 1");
                RadioButtonAdapter radioButtonAdapter1 = new RadioButtonAdapter((ValueModel)selectionModel, (Object)Color.RED);
                radioButton1.setModel((ButtonModel)radioButtonAdapter1);
                JRadioButton radioButton2 = new JRadioButton("Order 2");
                RadioButtonAdapter radioButtonAdapter2 = new RadioButtonAdapter((ValueModel)selectionModel, (Object)Color.GREEN);
                radioButton2.setModel((ButtonModel)radioButtonAdapter2);
                JRadioButton radioButton3 = new JRadioButton("Order 3");
                RadioButtonAdapter radioButtonAdapter3 = new RadioButtonAdapter((ValueModel)selectionModel, (Object)Color.BLUE);
                radioButton3.setModel((ButtonModel)radioButtonAdapter3);
                JRadioButton radioButton4 = new JRadioButton("Order 4");
                RadioButtonAdapter radioButtonAdapter4 = new RadioButtonAdapter((ValueModel)selectionModel, (Object)Color.ORANGE);
                radioButton4.setModel((ButtonModel)radioButtonAdapter4);
                JRadioButton radioButton5 = new JRadioButton("Order 5");
                RadioButtonAdapter radioButtonAdapter5 = new RadioButtonAdapter((ValueModel)selectionModel, (Object)Color.PINK);
                radioButton5.setModel((ButtonModel)radioButtonAdapter5);
                CellConstraints cc = new CellConstraints();
                builder.addLabel("Regression:", cc.xy(3, 2));
                builder.add((Component)radioButton0, cc.xy(2, 4));
                builder.add((Component)radioButton1, cc.xy(2, 6));
                builder.add((Component)radioButton2, cc.xy(2, 8));
                builder.add((Component)radioButton3, cc.xy(2, 10));
                builder.add((Component)radioButton4, cc.xy(2, 12));
                builder.add((Component)radioButton5, cc.xy(2, 14));
                selectionModel.addPropertyChangeListener((PropertyChangeListener)new RadioChangeListener());
                FitUtilities _fitUtilities = new FitUtilities();
                ChartPanel _chartPanel = _fitUtilities.createScatterPlot(_dataset, _yintervalseriescollection, _latticeParam, this.sTemp);
                builder.add((Component)_chartPanel, cc.xywh(3, 2, 1, 13));
                _panel.add(builder.getPanel());
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _panel;
    }

    public YIntervalSeriesCollection setErrorBar(double[] X, double[] Y, double[] uncertainty) {
        YIntervalSeriesCollection yintervalseriescollection = null;
        if (uncertainty[1] != 1.0 && X.length == Y.length && Y.length == uncertainty.length) {
            YIntervalSeries yInt = new YIntervalSeries((Comparable)((Object)"Error bar"));
            int i = 0;
            while (i < X.length) {
                yInt.add(X[i], Y[i], Y[i] - uncertainty[i], Y[i] + uncertainty[i]);
                ++i;
            }
            yintervalseriescollection = new YIntervalSeriesCollection();
            yintervalseriescollection.addSeries(yInt);
        }
        return yintervalseriescollection;
    }

    public boolean checkFitStatus(JTabbedPane _tabbedPane) {
        boolean rv = true;
        try {
            if (_tabbedPane != null) {
                int iTotalTabs = _tabbedPane.getTabCount();
                int i = 0;
                while (i < iTotalTabs) {
                    Component _selTabComp = _tabbedPane.getComponentAt(i);
                    if (_selTabComp != null && _selTabComp instanceof JPanel) {
                        Component[] _compList;
                        JPanel _panel = (JPanel)_selTabComp;
                        Component[] componentArray = _compList = _panel.getComponents();
                        int n = _compList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            if (c instanceof JPanel) {
                                Component[] _compListInner;
                                JPanel _panelInner = (JPanel)c;
                                Component[] componentArray2 = _compListInner = _panelInner.getComponents();
                                int n3 = _compListInner.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    JRadioButton _radio;
                                    Component comp = componentArray2[n4];
                                    if (comp instanceof JRadioButton && (_radio = (JRadioButton)comp).getText() == "none" && _radio.isSelected()) {
                                        rv = false;
                                        throw new Exception("Please fit all lattice Params!");
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    public double[] ReturnFitCoefficients(JTabbedPane _tabbedPane) {
        double[] rv = null;
        try {
            if (_tabbedPane != null) {
                int iTotalTabs = _tabbedPane.getTabCount();
                int i = 0;
                while (i < iTotalTabs) {
                    Component _selTabComp = _tabbedPane.getComponentAt(i);
                    if (_selTabComp != null && _selTabComp instanceof JPanel) {
                        Component[] _compList;
                        JPanel _panel = (JPanel)_selTabComp;
                        Component[] componentArray = _compList = _panel.getComponents();
                        int n = _compList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            if (c instanceof JPanel) {
                                Component[] _compListInner;
                                JPanel _panelInner = (JPanel)c;
                                Component[] componentArray2 = _compListInner = _panelInner.getComponents();
                                int n3 = _compListInner.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    Component comp = componentArray2[n4];
                                    if (comp instanceof ChartPanel) {
                                        JFreeChart _chart = ((ChartPanel)comp).getChart();
                                        XYPlot _plot = (XYPlot)_chart.getPlot();
                                        XYDataset _fitDataset = _plot.getDataset(1);
                                        FitUtilities _fitUtil = new FitUtilities();
                                        int iOrder = 0;
                                        rv = _fitUtil.returnPolyFitArray(_fitDataset, iOrder);
                                    }
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    private class RadioChangeListener
    implements PropertyChangeListener {
        private RadioChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                if (evt.getNewValue() != null) {
                    XYDataset _data = null;
                    Color _regOrder = (Color)evt.getNewValue();
                    if (DynamicPanelBuilder.this._tabPane != null) {
                        Component _selTabComp = DynamicPanelBuilder.this._tabPane.getSelectedComponent();
                        String _lattParam = _selTabComp.getName();
                        if (_selTabComp != null && _selTabComp instanceof JPanel) {
                            Component[] _compList;
                            JPanel _panel = (JPanel)_selTabComp;
                            Component[] componentArray = _compList = _panel.getComponents();
                            int n = _compList.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component c = componentArray[n2];
                                if (c instanceof JPanel) {
                                    Component[] _compListInner;
                                    JPanel _panelInner = (JPanel)c;
                                    Component[] componentArray2 = _compListInner = _panelInner.getComponents();
                                    int n3 = _compListInner.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        Component comp = componentArray2[n4];
                                        if (comp instanceof ChartPanel) {
                                            double[][] CoefAndStat;
                                            FitUtilities _fitUtilities = new FitUtilities();
                                            JFreeChart _jfc = ((ChartPanel)comp).getChart();
                                            _data = _jfc.getXYPlot().getDataset();
                                            ValueAxis _vAxis = _jfc.getXYPlot().getRangeAxis(0);
                                            String sYAxisName = "Lattice parameter";
                                            if (_vAxis != null) {
                                                sYAxisName = _vAxis.getLabel();
                                            }
                                            YIntervalSeriesCollection _dataErr = null;
                                            if (_jfc.getXYPlot().getDatasetCount() > 1) {
                                                int i = 0;
                                                while (i < _jfc.getXYPlot().getDatasetCount()) {
                                                    if (_jfc.getXYPlot().getDataset(1) instanceof YIntervalSeriesCollection) {
                                                        _dataErr = (YIntervalSeriesCollection)_jfc.getXYPlot().getDataset(1);
                                                    }
                                                    ++i;
                                                }
                                            }
                                            ChartPanel _chartPanel = null;
                                            if (_regOrder == Color.WHITE) {
                                                _chartPanel = _fitUtilities.createScatterPlot(_data, _dataErr, _lattParam, DynamicPanelBuilder.this.sTemp);
                                            } else if (_regOrder == Color.RED) {
                                                CoefAndStat = _fitUtilities.returnPolyStat(_data, _dataErr, 1);
                                                if (CoefAndStat != null) {
                                                    _chartPanel = _fitUtilities.createChartPanelRegression(_data, _dataErr, sYAxisName, CoefAndStat, 0.0, 0.0, DynamicPanelBuilder.this.sTemp);
                                                }
                                            } else if (_regOrder == Color.GREEN) {
                                                CoefAndStat = _fitUtilities.returnPolyStat(_data, _dataErr, 2);
                                                if (CoefAndStat != null) {
                                                    _chartPanel = _fitUtilities.createChartPanelRegression(_data, _dataErr, sYAxisName, CoefAndStat, 0.0, 0.0, DynamicPanelBuilder.this.sTemp);
                                                }
                                            } else if (_regOrder == Color.BLUE) {
                                                CoefAndStat = _fitUtilities.returnPolyStat(_data, _dataErr, 3);
                                                if (CoefAndStat != null) {
                                                    _chartPanel = _fitUtilities.createChartPanelRegression(_data, _dataErr, sYAxisName, CoefAndStat, 0.0, 0.0, DynamicPanelBuilder.this.sTemp);
                                                }
                                            } else if (_regOrder == Color.ORANGE) {
                                                CoefAndStat = _fitUtilities.returnPolyStat(_data, _dataErr, 4);
                                                if (CoefAndStat != null) {
                                                    _chartPanel = _fitUtilities.createChartPanelRegression(_data, _dataErr, sYAxisName, CoefAndStat, 0.0, 0.0, DynamicPanelBuilder.this.sTemp);
                                                }
                                            } else if (_regOrder == Color.PINK && (CoefAndStat = _fitUtilities.returnPolyStat(_data, _dataErr, 5)) != null) {
                                                _chartPanel = _fitUtilities.createChartPanelRegression(_data, _dataErr, sYAxisName, CoefAndStat, 0.0, 0.0, DynamicPanelBuilder.this.sTemp);
                                            }
                                            if (_chartPanel != null) {
                                                ((ChartPanel)comp).setChart(_chartPanel.getChart());
                                                _panel.repaint();
                                            }
                                        }
                                        ++n4;
                                    }
                                }
                                ++n2;
                            }
                        }
                    }
                }
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
            }
        }
    }
}

