/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import myObjects.LattParam;
import myObjects.ObjHKL;
import myObjects.ObjUVW;
import myObjects.Polynom;
import myObjects.eCrystalSystem;
import myObjects.eLatticeName;
import myObjects.functions.IFunctions;
import myUtilities.MathExpansionCoeff;
import org.apache.log4j.Logger;

public class CalcUVW_HKL {
    static Logger logger = Logger.getLogger(CalcUVW_HKL.class);

    public static ObjUVW returnObjUVW(int[] _uvw, double dTemp, List<IFunctions> _polyList, eCrystalSystem pCrystalSystem, double[][] pCTE) {
        ObjUVW _rv = null;
        try {
            if (_polyList != null) {
                LattParam _lattParam = CalcUVW_HKL.returnLattParam(_polyList, dTemp, pCrystalSystem);
                double[][] _matrice = new double[3][3];
                _matrice[0][0] = CalcUVW_HKL.returnRounded(_lattParam.getA() * _lattParam.getA(), 6);
                _matrice[1][1] = CalcUVW_HKL.returnRounded(_lattParam.getB() * _lattParam.getB(), 6);
                _matrice[2][2] = CalcUVW_HKL.returnRounded(_lattParam.getC() * _lattParam.getC(), 6);
                _matrice[0][1] = CalcUVW_HKL.returnRounded(_lattParam.getA() * _lattParam.getB() * Math.cos(Math.toRadians(_lattParam.getGamma())), 6);
                _matrice[1][0] = _matrice[0][1];
                _matrice[0][2] = CalcUVW_HKL.returnRounded(_lattParam.getA() * _lattParam.getC() * Math.cos(Math.toRadians(_lattParam.getBeta())), 6);
                _matrice[2][0] = _matrice[0][2];
                _matrice[2][1] = CalcUVW_HKL.returnRounded(_lattParam.getB() * _lattParam.getC() * Math.cos(Math.toRadians(_lattParam.getAlpha())), 6);
                _matrice[1][2] = _matrice[2][1];
                Matrix _mat = new Matrix(_matrice);
                double dDet = _mat.det();
                double dVolume = Math.sqrt(CalcUVW_HKL.returnRounded(dDet, 4));
                double a = _lattParam.getA();
                double b = _lattParam.getB();
                double c = _lattParam.getC();
                double alpha = Math.toRadians(_lattParam.getAlpha());
                double beta = Math.toRadians(_lattParam.getBeta());
                double gamma = Math.toRadians(_lattParam.getGamma());
                double aRec = b * c * Math.sin(alpha) / dVolume;
                double bRec = a * c * Math.sin(beta) / dVolume;
                double cRec = a * b * Math.sin(gamma) / dVolume;
                double alphaRecTerm1 = Math.cos(beta) * Math.cos(gamma) - Math.cos(alpha);
                double alphaRecTerm2 = Math.sin(beta) * Math.sin(gamma);
                double alphaRec = Math.acos(alphaRecTerm1 / alphaRecTerm2);
                double betaRecTerm1 = Math.cos(alpha) * Math.cos(gamma) - Math.cos(beta);
                double betaRecTerm2 = Math.sin(alpha) * Math.sin(gamma);
                double betaRec = Math.acos(betaRecTerm1 / betaRecTerm2);
                double gammaRecTerm1 = Math.cos(beta) * Math.cos(alpha) - Math.cos(gamma);
                double gammaRecTerm2 = Math.sin(beta) * Math.sin(alpha);
                double gammaRec = Math.acos(gammaRecTerm1 / gammaRecTerm2);
                _rv = new ObjUVW();
                _rv.setVolume(CalcUVW_HKL.returnRounded(Math.sqrt(dDet), 4));
                MathExpansionCoeff.printMatrix(_matrice);
                int u = _uvw[0];
                int v = _uvw[1];
                int w = _uvw[2];
                double t_uvwTerm1 = Math.pow(u, 2.0) * _matrice[0][0] + Math.pow(v, 2.0) * _matrice[1][1] + Math.pow(w, 2.0) * _matrice[2][2];
                double t_uvwTerm2 = (double)(2 * v * w) * _matrice[2][1] + (double)(2 * u * v) * _matrice[1][0] + (double)(2 * u * w) * _matrice[2][0];
                double t_uvw = Math.sqrt(t_uvwTerm1 + t_uvwTerm2);
                double dVolRec = 1.0 / dVolume;
                double x = 1.0 / (dVolRec * c * t_uvw) * ((double)u * bRec - (double)v * aRec * Math.cos(gammaRec));
                double y = (double)v / (bRec * t_uvw);
                double z = 1.0 / t_uvw * ((double)u * a * Math.cos(beta) + (double)v * b * Math.cos(alpha) + (double)w * c);
                _rv.setX(x);
                _rv.setY(y);
                _rv.setZ(z);
                double _amp = CalcUVW_HKL.returnLengthOfThermalExp(x, y, z, pCTE);
                _rv.setUVWAmp(_amp);
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _rv;
    }

    public static ObjHKL returnObjHKL(int[] _hkl, double dTemp, List<IFunctions> _polyList, eCrystalSystem pCrystalSystem, double[][] pCTE) {
        ObjHKL _rv = null;
        try {
            if (_polyList != null) {
                LattParam _lattParam = CalcUVW_HKL.returnLattParam(_polyList, dTemp, pCrystalSystem);
                double[][] _matrice = new double[3][3];
                _matrice[0][0] = CalcUVW_HKL.returnRounded(_lattParam.getA() * _lattParam.getA(), 6);
                _matrice[1][1] = CalcUVW_HKL.returnRounded(_lattParam.getB() * _lattParam.getB(), 6);
                _matrice[2][2] = CalcUVW_HKL.returnRounded(_lattParam.getC() * _lattParam.getC(), 6);
                _matrice[0][1] = CalcUVW_HKL.returnRounded(_lattParam.getA() * _lattParam.getB() * Math.cos(Math.toRadians(_lattParam.getGamma())), 6);
                _matrice[1][0] = _matrice[0][1];
                _matrice[0][2] = CalcUVW_HKL.returnRounded(_lattParam.getA() * _lattParam.getC() * Math.cos(Math.toRadians(_lattParam.getBeta())), 6);
                _matrice[2][0] = _matrice[0][2];
                _matrice[2][1] = CalcUVW_HKL.returnRounded(_lattParam.getB() * _lattParam.getC() * Math.cos(Math.toRadians(_lattParam.getAlpha())), 6);
                _matrice[1][2] = _matrice[2][1];
                Matrix _mat = new Matrix(_matrice);
                double dDet = _mat.det();
                double dVolume = Math.sqrt(CalcUVW_HKL.returnRounded(dDet, 4));
                double a = _lattParam.getA();
                double b = _lattParam.getB();
                double c = _lattParam.getC();
                double alpha = Math.toRadians(_lattParam.getAlpha());
                double beta = Math.toRadians(_lattParam.getBeta());
                double gamma = Math.toRadians(_lattParam.getGamma());
                double aRec = b * c * Math.sin(alpha) / dVolume;
                double bRec = a * c * Math.sin(beta) / dVolume;
                double cRec = a * b * Math.sin(gamma) / dVolume;
                double alphaRecTerm1 = Math.cos(beta) * Math.cos(gamma) - Math.cos(alpha);
                double alphaRecTerm2 = Math.sin(beta) * Math.sin(gamma);
                double alphaRec = Math.acos(alphaRecTerm1 / alphaRecTerm2);
                double betaRecTerm1 = Math.cos(alpha) * Math.cos(gamma) - Math.cos(beta);
                double betaRecTerm2 = Math.sin(alpha) * Math.sin(gamma);
                double betaRec = Math.acos(betaRecTerm1 / betaRecTerm2);
                double gammaRecTerm1 = Math.cos(beta) * Math.cos(alpha) - Math.cos(gamma);
                double gammaRecTerm2 = Math.sin(beta) * Math.sin(alpha);
                double gammaRec = Math.acos(gammaRecTerm1 / gammaRecTerm2);
                _rv = new ObjHKL();
                _rv.setaRec(CalcUVW_HKL.returnRounded(aRec, 4));
                _rv.setbRec(CalcUVW_HKL.returnRounded(bRec, 4));
                _rv.setcRec(CalcUVW_HKL.returnRounded(cRec, 4));
                _rv.setAlphaRec(CalcUVW_HKL.returnRounded(Math.toDegrees(alphaRec), 4));
                _rv.setBetaRec(CalcUVW_HKL.returnRounded(Math.toDegrees(betaRec), 4));
                _rv.setGammaRec(CalcUVW_HKL.returnRounded(Math.toDegrees(gammaRec), 4));
                _rv.setVolume(CalcUVW_HKL.returnRounded(dVolume, 4));
                MathExpansionCoeff.printMatrix(_matrice);
                int h = _hkl[0];
                int k = _hkl[1];
                int l = _hkl[2];
                double[][] _matriceRec = new double[3][3];
                _matriceRec[0][0] = CalcUVW_HKL.returnRounded(Math.pow(aRec, 2.0), 6);
                _matriceRec[1][1] = CalcUVW_HKL.returnRounded(Math.pow(bRec, 2.0), 6);
                _matriceRec[2][2] = CalcUVW_HKL.returnRounded(Math.pow(cRec, 2.0), 6);
                _matriceRec[0][1] = CalcUVW_HKL.returnRounded(aRec * bRec * Math.cos(gammaRec), 6);
                _matriceRec[1][0] = _matriceRec[0][1];
                _matriceRec[0][2] = CalcUVW_HKL.returnRounded(aRec * cRec * Math.cos(betaRec), 6);
                _matriceRec[2][0] = _matriceRec[0][2];
                _matriceRec[2][1] = CalcUVW_HKL.returnRounded(bRec * cRec * Math.cos(alphaRec), 6);
                _matriceRec[1][2] = _matriceRec[2][1];
                MathExpansionCoeff.printMatrix(_matriceRec);
                double d_hklTerm1 = Math.pow(h, 2.0) * _matriceRec[0][0] + Math.pow(k, 2.0) * _matriceRec[1][1] + Math.pow(l, 2.0) * _matriceRec[2][2];
                double d_hklTerm2 = (double)(2 * k * l) * _matriceRec[2][1] + (double)(2 * h * k) * _matriceRec[1][0] + (double)(2 * h * l) * _matriceRec[2][0];
                double d_hkl = 1.0 / Math.sqrt(d_hklTerm1 + d_hklTerm2);
                _rv.setdHKL(CalcUVW_HKL.returnRounded(d_hkl, 4));
                _rv.setdHKLRec(CalcUVW_HKL.returnRounded(1.0 / d_hkl, 4));
                double dRec = 1.0 / d_hkl;
                double x = 1.0 / (dVolume * bRec * dRec) * ((double)h * c - (double)l * a * Math.cos(beta));
                double y = 1.0 / dRec * ((double)h * aRec * Math.cos(gammaRec) + (double)k * bRec + (double)l * cRec * Math.cos(alphaRec));
                double z = (double)l / (c * dRec);
                _rv.setX(x);
                _rv.setY(y);
                _rv.setZ(z);
                double _amp = CalcUVW_HKL.returnLengthOfThermalExp(x, y, z, pCTE);
                _rv.setHKLAmp(_amp);
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _rv;
    }

    private static double returnLengthOfThermalExp(double x, double y, double z, double[][] CTE) {
        double rv = 0.0;
        try {
            double[] nV = new double[3];
            double nvAmp = x * x + y * y + z * z;
            double vB = Math.sqrt(nvAmp);
            nV[0] = x / vB;
            nV[1] = y / vB;
            nV[2] = z / vB;
            double _amp = 0.0;
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    double dCheck = nV[i] * nV[j] * CTE[i][j];
                    _amp += dCheck;
                    ++j;
                }
                ++i;
            }
            rv = MathExpansionCoeff.formatDouble(_amp);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    private static double returnRounded(double value, int frac) {
        return (double)Math.round(Math.pow(10.0, frac) * value) / Math.pow(10.0, frac);
    }

    public static LattParam returnLattParam(List<IFunctions> _listPoly, double pTemp, eCrystalSystem pCrystaSystem) {
        LattParam _lattParam = new LattParam();
        try {
            for (IFunctions polynom : _listPoly) {
                if (polynom.getParam() == eLatticeName.a) {
                    _lattParam.setA(polynom.getValue(pTemp));
                    if (pCrystaSystem == eCrystalSystem.Cubic || pCrystaSystem == eCrystalSystem.Rhombohedral) {
                        _lattParam.setB(polynom.getValue(pTemp));
                        _lattParam.setC(polynom.getValue(pTemp));
                        continue;
                    }
                    if (pCrystaSystem == eCrystalSystem.Tetragonal) {
                        _lattParam.setB(polynom.getValue(pTemp));
                        continue;
                    }
                    if (pCrystaSystem != eCrystalSystem.Hexagonal) continue;
                    _lattParam.setB(polynom.getValue(pTemp));
                    _lattParam.setGamma(120.0);
                    continue;
                }
                if (polynom.getParam() == eLatticeName.b) {
                    _lattParam.setB(polynom.getValue(pTemp));
                    continue;
                }
                if (polynom.getParam() == eLatticeName.c) {
                    _lattParam.setC(polynom.getValue(pTemp));
                    continue;
                }
                if (polynom.getParam() == eLatticeName.alpha) {
                    _lattParam.setAlpha(polynom.getValue(pTemp));
                    if (pCrystaSystem != eCrystalSystem.Rhombohedral) continue;
                    _lattParam.setBeta(polynom.getValue(pTemp));
                    _lattParam.setGamma(polynom.getValue(pTemp));
                    continue;
                }
                if (polynom.getParam() == eLatticeName.beta) {
                    _lattParam.setBeta(polynom.getValue(pTemp));
                    continue;
                }
                if (polynom.getParam() != eLatticeName.gamma) continue;
                _lattParam.setGamma(polynom.getValue(pTemp));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return _lattParam;
    }

    public static void main(String[] args) {
        ArrayList<IFunctions> _lP = new ArrayList<IFunctions>();
        Polynom a = new Polynom(new double[]{12.4665, 1.59457E-4, 7.45038E-8}, eLatticeName.a);
        Polynom b = new Polynom(new double[]{4.68341, 8.2269E-5, -2.27556E-8}, eLatticeName.b);
        Polynom c = new Polynom(new double[]{13.9075, 1.70493E-4, -8.07028E-8}, eLatticeName.c);
        Polynom beta = new Polynom(new double[]{93.7635, 3.87424E-4, 8.49056E-8}, eLatticeName.beta);
        _lP.add(a);
        _lP.add(b);
        _lP.add(c);
        _lP.add(beta);
        double[][] dArray = new double[3][3];
        ObjUVW _testUVW = CalcUVW_HKL.returnObjUVW(new int[]{2, 3, 4}, 25.0, _lP, eCrystalSystem.Monoclinic, dArray);
        ObjHKL _testHKL = CalcUVW_HKL.returnObjHKL(new int[]{2, 3, 4}, 25.0, _lP, eCrystalSystem.Monoclinic, dArray);
    }
}

