/*
 * Decompiled with CFR 0.152.
 */
package myUtilities;

import Validation.MyInputVerifierDouble;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import myObjects.eCrystalSystem;
import org.apache.log4j.Logger;

public class BuildLiteraturePanel {
    static Logger logger = Logger.getLogger(BuildLiteraturePanel.class);

    public JPanel buildEinsteinPanel() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.Orthorhombic), eCrystalSystem.Orthorhombic.toString());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.Hexagonal), eCrystalSystem.Hexagonal.toString());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.Rhombohedral), eCrystalSystem.Rhombohedral.toString());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.Tetragonal), eCrystalSystem.Tetragonal.toString());
            _rv.add((Component)this.buildEinsteinPanel(eCrystalSystem.Cubic), eCrystalSystem.Cubic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildEinsteinPanel(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Lattice start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddTE = new JLabel("<html>Add Einstein temperature, T<sub>E</sub></html>");
            _lblAddTE.setFont(_fHeader);
            builder.add((Component)_lblAddTE, CC.xy((int)5, (int)1));
            JLabel _lblAddCE = new JLabel("<html>Add Einstein constant, x<sub>E</sub></html>");
            _lblAddCE.setFont(_fHeader);
            builder.add((Component)_lblAddCE, CC.xy((int)7, (int)1));
            JButton _btnHelp = new JButton("How to add Einstein Function?");
            builder.add((Component)_btnHelp, CC.xy((int)9, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Einstein Function</strong><br><br>f(T)=p<sub>0</sub>+(x<sub>E</sub>/(exp(T<sub>E</sub>/T)-1))<br><br></p><p>p<sub>0</sub><br>Lattice start parameter<br><br>T<sub>E</sub><br>Einstein temperature<br><br>x<sub>E</sub><br>Einstein constant<br><br></p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic || pCrystalSystem == eCrystalSystem.Monoclinic) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB = new JTextField();
                txtEinB.setName("txtEinB");
                txtEinB.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_TE = new JTextField();
                txtEinB_TE.setName("txtEinB_TE");
                txtEinB_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_CE = new JTextField();
                txtEinB_CE.setName("txtEinB_CE");
                txtEinB_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC = new JTextField();
                txtEinC.setName("txtEinC");
                txtEinC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE = new JTextField();
                txtEinC_TE.setName("txtEinC_TE");
                txtEinC_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE = new JTextField();
                txtEinC_CE.setName("txtEinC_CE");
                txtEinC_CE.setInputVerifier(new MyInputVerifierDouble());
                txtEinA.setText("6.80030");
                txtEinB.setText("8.35490");
                txtEinC.setText("9.89430");
                txtEinA_CE.setText("0.0186118");
                txtEinB_CE.setText("0.0186118");
                txtEinC_CE.setText("0.0186118");
                txtEinA_TE.setText("120.697");
                txtEinB_TE.setText("120.697");
                txtEinC_TE.setText("120.697");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinB, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinB_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinB_CE, CC.xy((int)7, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtEinC, CC.xy((int)3, (int)7));
                builder.add((Component)txtEinC_TE, CC.xy((int)5, (int)7));
                builder.add((Component)txtEinC_CE, CC.xy((int)7, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Orthorhombic) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB = new JTextField();
                txtEinB.setName("txtEinB");
                txtEinB.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_TE = new JTextField();
                txtEinB_TE.setName("txtEinB_TE");
                txtEinB_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_CE = new JTextField();
                txtEinB_CE.setName("txtEinB_CE");
                txtEinB_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC = new JTextField();
                txtEinC.setName("txtEinC");
                txtEinC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE = new JTextField();
                txtEinC_TE.setName("txtEinC_TE");
                txtEinC_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE = new JTextField();
                txtEinC_CE.setName("txtEinC_CE");
                txtEinC_CE.setInputVerifier(new MyInputVerifierDouble());
                txtEinA.setText("6.80030");
                txtEinB.setText("8.35490");
                txtEinC.setText("9.89430");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinB, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinB_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinB_CE, CC.xy((int)7, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtEinC, CC.xy((int)3, (int)7));
                builder.add((Component)txtEinC_TE, CC.xy((int)5, (int)7));
                builder.add((Component)txtEinC_CE, CC.xy((int)7, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Tetragonal) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC = new JTextField();
                txtEinC.setName("txtEinC");
                txtEinC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE = new JTextField();
                txtEinC_TE.setName("txtEinC_TE");
                txtEinC_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE = new JTextField();
                txtEinC_CE.setName("txtEinC_CE");
                txtEinC_CE.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinC, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinC_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinC_CE, CC.xy((int)7, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Rhombohedral) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
            } else if (pCrystalSystem == eCrystalSystem.Hexagonal) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC = new JTextField();
                txtEinC.setName("txtEinC");
                txtEinC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE = new JTextField();
                txtEinC_TE.setName("txtEinC_TE");
                txtEinC_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE = new JTextField();
                txtEinC_CE.setName("txtEinC_CE");
                txtEinC_CE.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)5, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinC, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinC_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinC_CE, CC.xy((int)5, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Cubic) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                txtEinA.setText("7.08757");
                txtEinA_TE.setText("120.697");
                txtEinA_CE.setText("0.0186118");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildEinsteinPanelAngle() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildEinsteinPanelAngle(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildEinsteinPanelAngle(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildEinsteinPanelAngle(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildEinsteinPanelAngle(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Angle start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddTE = new JLabel("<html>Add Einstein temperature, , T<sub>E</sub></html>");
            _lblAddTE.setFont(_fHeader);
            builder.add((Component)_lblAddTE, CC.xy((int)5, (int)1));
            JLabel _lblAddCE = new JLabel("<html>Add Einstein constant, x<sub>E</sub></html>");
            _lblAddCE.setFont(_fHeader);
            builder.add((Component)_lblAddCE, CC.xy((int)7, (int)1));
            JButton _btnHelp = new JButton("How to add Einstein Function?");
            builder.add((Component)_btnHelp, CC.xy((int)9, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Einstein Function</strong><br><br>f(T)=p<sub>0</sub>+(x<sub>E</sub>/(exp(T<sub>E</sub>/T)-1))<br><br></p><p>p<sub>0</sub><br>Lattice start parameter<br><br>T<sub>E</sub><br>Einstein temperature<br><br>x<sub>E</sub><br>Einstein constant<br><br></p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic) {
                JTextField txtEinAlpha = new JTextField();
                txtEinAlpha.setName("txtEinAlpha");
                txtEinAlpha.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinAlpha_TE = new JTextField();
                txtEinAlpha_TE.setName("txtEinAlpha_TE");
                txtEinAlpha_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinAlpha_CE = new JTextField();
                txtEinAlpha_CE.setName("txtEinAlpha_CE");
                txtEinAlpha_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinBeta = new JTextField();
                txtEinBeta.setName("txtEinBeta");
                txtEinBeta.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinBeta_TE = new JTextField();
                txtEinBeta_TE.setName("txtEinBeta_TE");
                txtEinBeta_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinBeta_CE = new JTextField();
                txtEinBeta_CE.setName("txtEinBeta_CE");
                txtEinBeta_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinGamma = new JTextField();
                txtEinGamma.setName("txtEinGamma");
                txtEinGamma.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinGamma_TE = new JTextField();
                txtEinGamma_TE.setName("txtEinGamma_TE");
                txtEinGamma_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinGamma_CE = new JTextField();
                txtEinGamma_CE.setName("txtEinGamma_CE");
                txtEinGamma_CE.setInputVerifier(new MyInputVerifierDouble());
                txtEinAlpha.setText("6.80030");
                txtEinBeta.setText("8.35490");
                txtEinGamma.setText("9.89430");
                builder.addLabel("&alpha:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinAlpha, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinAlpha_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinAlpha_CE, CC.xy((int)7, (int)3));
                builder.addLabel("&beta:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinBeta, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinBeta_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinBeta_CE, CC.xy((int)7, (int)5));
                builder.addLabel("&gamma:", CC.xy((int)1, (int)7));
                builder.add((Component)txtEinGamma, CC.xy((int)3, (int)7));
                builder.add((Component)txtEinGamma_TE, CC.xy((int)5, (int)7));
                builder.add((Component)txtEinGamma_CE, CC.xy((int)7, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Monoclinic) {
                JTextField txtEinOblique = new JTextField();
                txtEinOblique.setName("txtEinOblique");
                txtEinOblique.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinOblique_TE = new JTextField();
                txtEinOblique_TE.setName("txtEinOblique_TE");
                txtEinOblique_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinOblique_CE = new JTextField();
                txtEinOblique_CE.setName("txtEinOblique_CE");
                txtEinOblique_CE.setInputVerifier(new MyInputVerifierDouble());
                txtEinOblique.setText("8.35490");
                builder.addLabel("&oblique angle:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinOblique, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinOblique_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinOblique_CE, CC.xy((int)7, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildCosPanelAngle() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildCosPanelAngle(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildCosPanelAngle(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildCosPanelAngle(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildCosPanelAngle(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Angle start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddPA = new JLabel("Add paramameter A");
            _lblAddPA.setFont(_fHeader);
            builder.add((Component)_lblAddPA, CC.xy((int)5, (int)1));
            JLabel _lblAddPB = new JLabel("Add paramameter B");
            _lblAddPB.setFont(_fHeader);
            builder.add((Component)_lblAddPB, CC.xy((int)7, (int)1));
            JButton _btnHelp = new JButton("How to add Cosinus Function?");
            builder.add((Component)_btnHelp, CC.xy((int)9, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Cosinus Function</strong><br><br>f(T) = &alpha;<sub>0</sub> + (A * cos(B * x))<br><br></p><p>&alpha;<sub>0</sub><br>Angle start parameter<br><br>A, B<br>Parameter<br><br></p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic) {
                JTextField txtCOSAlpha = new JTextField();
                txtCOSAlpha.setName("txtCOSAlpha");
                txtCOSAlpha.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSAlpha_A = new JTextField();
                txtCOSAlpha_A.setName("txtCOSAlpha_A");
                txtCOSAlpha_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSAlpha_B = new JTextField();
                txtCOSAlpha_B.setName("txtCOSAlpha_B");
                txtCOSAlpha_B.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSBeta = new JTextField();
                txtCOSBeta.setName("txtCOSBeta");
                txtCOSBeta.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSBeta_A = new JTextField();
                txtCOSBeta_A.setName("txtCOSBeta_A");
                txtCOSBeta_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSBeta_B = new JTextField();
                txtCOSBeta_B.setName("txtCOSBeta_B");
                txtCOSBeta_B.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSGamma = new JTextField();
                txtCOSGamma.setName("txtCOSGamma");
                txtCOSGamma.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSGamma_A = new JTextField();
                txtCOSGamma_A.setName("txtCOSGamma_A");
                txtCOSGamma_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSGamma_B = new JTextField();
                txtCOSGamma_B.setName("txtCOSGamma_B");
                txtCOSGamma_B.setInputVerifier(new MyInputVerifierDouble());
                txtCOSAlpha.setText("");
                txtCOSBeta.setText("");
                txtCOSGamma.setText("");
                builder.addLabel("&alpha:", CC.xy((int)1, (int)3));
                builder.add((Component)txtCOSAlpha, CC.xy((int)3, (int)3));
                builder.add((Component)txtCOSAlpha_A, CC.xy((int)5, (int)3));
                builder.add((Component)txtCOSAlpha_B, CC.xy((int)7, (int)3));
                builder.addLabel("&beta:", CC.xy((int)1, (int)5));
                builder.add((Component)txtCOSBeta, CC.xy((int)3, (int)5));
                builder.add((Component)txtCOSBeta_A, CC.xy((int)5, (int)5));
                builder.add((Component)txtCOSBeta_B, CC.xy((int)7, (int)5));
                builder.addLabel("&gamma:", CC.xy((int)1, (int)7));
                builder.add((Component)txtCOSGamma, CC.xy((int)3, (int)7));
                builder.add((Component)txtCOSGamma_A, CC.xy((int)5, (int)7));
                builder.add((Component)txtCOSGamma_B, CC.xy((int)7, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Monoclinic) {
                JTextField txtCOSOblique = new JTextField();
                txtCOSOblique.setName("txtCOSOblique");
                txtCOSOblique.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSOblique_A = new JTextField();
                txtCOSOblique_A.setName("txtCOSOblique_A");
                txtCOSOblique_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtCOSOblique_B = new JTextField();
                txtCOSOblique_B.setName("txtCOSOblique_B");
                txtCOSOblique_B.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&oblique angle:", CC.xy((int)1, (int)3));
                builder.add((Component)txtCOSOblique, CC.xy((int)3, (int)3));
                builder.add((Component)txtCOSOblique_A, CC.xy((int)5, (int)3));
                builder.add((Component)txtCOSOblique_B, CC.xy((int)7, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildSatPanelAngle() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildSatPanelAngle(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildSatPanelAngle(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildSatPanelAngle(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildSatPanelAngle(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Angle start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddPA = new JLabel("Add paramameter A");
            _lblAddPA.setFont(_fHeader);
            builder.add((Component)_lblAddPA, CC.xy((int)5, (int)1));
            JLabel _lblAddPB = new JLabel("Add paramameter B");
            _lblAddPB.setFont(_fHeader);
            builder.add((Component)_lblAddPB, CC.xy((int)7, (int)1));
            JLabel _lblAddPC = new JLabel("Add paramameter C");
            _lblAddPC.setFont(_fHeader);
            builder.add((Component)_lblAddPC, CC.xy((int)9, (int)1));
            JButton _btnHelp = new JButton("How to add Saturation Function?");
            builder.add((Component)_btnHelp, CC.xy((int)11, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Saturation Function</strong><br><br>f(T)=&alpha;<sub>0</sub>+A * (1 - exp(-B * x))<sup>C</sup><br><br></p><p>&alpha;<sub>0</sub><br>Angle start parameter<br><br>A, B, C<br>Parameter<br><br></p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic) {
                JTextField txtSatAlpha = new JTextField();
                txtSatAlpha.setName("txtSatAlpha");
                txtSatAlpha.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatAlpha_A = new JTextField();
                txtSatAlpha_A.setName("txtSatAlpha_A");
                txtSatAlpha_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatAlpha_B = new JTextField();
                txtSatAlpha_B.setName("txtSatAlpha_B");
                txtSatAlpha_B.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatAlpha_C = new JTextField();
                txtSatAlpha_C.setName("txtSatAlpha_C");
                txtSatAlpha_C.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatBeta = new JTextField();
                txtSatBeta.setName("txtSatBeta");
                txtSatBeta.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatBeta_A = new JTextField();
                txtSatBeta_A.setName("txtSatBeta_A");
                txtSatBeta_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatBeta_B = new JTextField();
                txtSatBeta_B.setName("txtSatBeta_B");
                txtSatBeta_B.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatBeta_C = new JTextField();
                txtSatBeta_C.setName("txtSatBeta_C");
                txtSatBeta_C.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatGamma = new JTextField();
                txtSatGamma.setName("txtSatGamma");
                txtSatGamma.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatGamma_A = new JTextField();
                txtSatGamma_A.setName("txtSatGamma_A");
                txtSatGamma_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatGamma_B = new JTextField();
                txtSatGamma_B.setName("txtSatGamma_B");
                txtSatGamma_B.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatGamma_C = new JTextField();
                txtSatGamma_C.setName("txtSatGamma_C");
                txtSatGamma_C.setInputVerifier(new MyInputVerifierDouble());
                txtSatAlpha.setText("");
                txtSatBeta.setText("");
                txtSatGamma.setText("");
                builder.addLabel("&alpha:", CC.xy((int)1, (int)3));
                builder.add((Component)txtSatAlpha, CC.xy((int)3, (int)3));
                builder.add((Component)txtSatAlpha_A, CC.xy((int)5, (int)3));
                builder.add((Component)txtSatAlpha_B, CC.xy((int)7, (int)3));
                builder.add((Component)txtSatAlpha_C, CC.xy((int)9, (int)3));
                builder.addLabel("&beta:", CC.xy((int)1, (int)5));
                builder.add((Component)txtSatBeta, CC.xy((int)3, (int)5));
                builder.add((Component)txtSatBeta_A, CC.xy((int)5, (int)5));
                builder.add((Component)txtSatBeta_B, CC.xy((int)7, (int)5));
                builder.add((Component)txtSatBeta_C, CC.xy((int)9, (int)5));
                builder.addLabel("&gamma:", CC.xy((int)1, (int)7));
                builder.add((Component)txtSatGamma, CC.xy((int)3, (int)7));
                builder.add((Component)txtSatGamma_A, CC.xy((int)5, (int)7));
                builder.add((Component)txtSatGamma_B, CC.xy((int)7, (int)7));
                builder.add((Component)txtSatGamma_C, CC.xy((int)9, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Monoclinic) {
                JTextField txtSatOblique = new JTextField();
                txtSatOblique.setName("txtSatOblique");
                txtSatOblique.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatOblique_A = new JTextField();
                txtSatOblique_A.setName("txtSatOblique_A");
                txtSatOblique_A.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatOblique_B = new JTextField();
                txtSatOblique_B.setName("txtSatOblique_B");
                txtSatOblique_B.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtSatOblique_C = new JTextField();
                txtSatOblique_C.setName("txtSatOblique_C");
                txtSatOblique_C.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&oblique angle:", CC.xy((int)1, (int)3));
                builder.add((Component)txtSatOblique, CC.xy((int)3, (int)3));
                builder.add((Component)txtSatOblique_A, CC.xy((int)5, (int)3));
                builder.add((Component)txtSatOblique_B, CC.xy((int)7, (int)3));
                builder.add((Component)txtSatOblique_C, CC.xy((int)9, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildEinstein2TermPanel() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.Orthorhombic), eCrystalSystem.Orthorhombic.toString());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.Hexagonal), eCrystalSystem.Hexagonal.toString());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.Rhombohedral), eCrystalSystem.Rhombohedral.toString());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.Tetragonal), eCrystalSystem.Tetragonal.toString());
            _rv.add((Component)this.buildEinstein2TermPanel(eCrystalSystem.Cubic), eCrystalSystem.Cubic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildEinstein2TermPanel(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Lattice start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddTE = new JLabel("<html>Add Einstein temperature, T<sub>E1</sub></html>");
            _lblAddTE.setFont(_fHeader);
            builder.add((Component)_lblAddTE, CC.xy((int)5, (int)1));
            JLabel _lblAddCE = new JLabel("<html>Add Einstein constant, x<sub>E1</sub></html>");
            _lblAddCE.setFont(_fHeader);
            builder.add((Component)_lblAddCE, CC.xy((int)7, (int)1));
            JLabel _lblAddTE2 = new JLabel("<html>Add Einstein temperature, T<sub>E2</sub></html>");
            _lblAddTE2.setFont(_fHeader);
            builder.add((Component)_lblAddTE2, CC.xy((int)9, (int)1));
            JLabel _lblAddCE2 = new JLabel("<html>Add Einstein constant, x<sub>E2</sub></html>");
            _lblAddCE2.setFont(_fHeader);
            builder.add((Component)_lblAddCE2, CC.xy((int)11, (int)1));
            JButton _btnHelp = new JButton("How to add Einstein-2-Term-Function?");
            builder.add((Component)_btnHelp, CC.xy((int)13, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Einstein Function</strong><br><br>f(T)=p<sub>0</sub>+(x<sub>E1</sub>/(exp(T<sub>E1</sub>/T)-1)) + (x<sub>E2</sub>/(exp(T<sub>E2</sub>/T)-1))<br><br></p><p>p<sub>0</sub><br>Lattice start parameter<br><br>T<sub>E1</sub>, T<sub>E2</sub><br>Einstein temperatures<br><br>x<sub>E1</sub>, x<sub>E2</sub><br>Einstein constants<br><br></p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic || pCrystalSystem == eCrystalSystem.Monoclinic || pCrystalSystem == eCrystalSystem.Orthorhombic) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE2 = new JTextField();
                txtEinA_TE2.setName("txtEinA_TE2");
                txtEinA_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE2 = new JTextField();
                txtEinA_CE2.setName("txtEinA_CE2");
                txtEinA_CE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB = new JTextField();
                txtEinB.setName("txtEinB");
                txtEinB.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_TE = new JTextField();
                txtEinB_TE.setName("txtEinB_TE");
                txtEinB_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_CE = new JTextField();
                txtEinB_CE.setName("txtEinB_CE");
                txtEinB_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_TE2 = new JTextField();
                txtEinB_TE2.setName("txtEinB_TE2");
                txtEinB_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinB_CE2 = new JTextField();
                txtEinB_CE2.setName("txtEinB_CE2");
                txtEinB_CE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC = new JTextField();
                txtEinC.setName("txtEinC");
                txtEinC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE = new JTextField();
                txtEinC_TE.setName("txtEinC_TE");
                txtEinC_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE = new JTextField();
                txtEinC_CE.setName("txtEinC_CE");
                txtEinC_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE2 = new JTextField();
                txtEinC_TE2.setName("txtEinC_TE2");
                txtEinC_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE2 = new JTextField();
                txtEinC_CE2.setName("txtEinC_CE2");
                txtEinC_CE2.setInputVerifier(new MyInputVerifierDouble());
                txtEinA.setText("6.80030");
                txtEinB.setText("8.35490");
                txtEinC.setText("9.89430");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.add((Component)txtEinA_TE2, CC.xy((int)9, (int)3));
                builder.add((Component)txtEinA_CE2, CC.xy((int)11, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinB, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinB_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinB_CE, CC.xy((int)7, (int)5));
                builder.add((Component)txtEinB_TE2, CC.xy((int)9, (int)5));
                builder.add((Component)txtEinB_CE2, CC.xy((int)11, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtEinC, CC.xy((int)3, (int)7));
                builder.add((Component)txtEinC_TE, CC.xy((int)5, (int)7));
                builder.add((Component)txtEinC_CE, CC.xy((int)7, (int)7));
                builder.add((Component)txtEinC_TE2, CC.xy((int)9, (int)7));
                builder.add((Component)txtEinC_CE2, CC.xy((int)11, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Tetragonal) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC = new JTextField();
                txtEinC.setName("txtEinC");
                txtEinC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE2 = new JTextField();
                txtEinA_TE2.setName("txtEinA_TE2");
                txtEinA_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE2 = new JTextField();
                txtEinA_CE2.setName("txtEinA_CE2");
                txtEinA_CE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE = new JTextField();
                txtEinC_TE.setName("txtEinC_TE");
                txtEinC_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE2 = new JTextField();
                txtEinC_TE2.setName("txtEinC_TE2");
                txtEinC_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE = new JTextField();
                txtEinC_CE.setName("txtEinC_CE");
                txtEinC_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE2 = new JTextField();
                txtEinC_CE2.setName("txtEinC_CE2");
                txtEinC_CE2.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.add((Component)txtEinA_TE2, CC.xy((int)9, (int)3));
                builder.add((Component)txtEinA_CE2, CC.xy((int)11, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinC, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinC_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinC_CE, CC.xy((int)7, (int)5));
                builder.add((Component)txtEinC_TE2, CC.xy((int)9, (int)5));
                builder.add((Component)txtEinC_CE2, CC.xy((int)11, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Rhombohedral) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE2 = new JTextField();
                txtEinA_TE2.setName("txtEinA_TE2");
                txtEinA_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE2 = new JTextField();
                txtEinA_CE2.setName("txtEinA_CE2");
                txtEinA_CE2.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.add((Component)txtEinA_TE2, CC.xy((int)9, (int)3));
                builder.add((Component)txtEinA_CE2, CC.xy((int)11, (int)3));
            } else if (pCrystalSystem == eCrystalSystem.Hexagonal) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC = new JTextField();
                txtEinC.setName("txtEinC");
                txtEinC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE2 = new JTextField();
                txtEinA_TE2.setName("txtEinA_TE2");
                txtEinA_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE2 = new JTextField();
                txtEinA_CE2.setName("txtEinA_CE2");
                txtEinA_CE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE = new JTextField();
                txtEinC_TE.setName("txtEinC_TE");
                txtEinC_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_TE2 = new JTextField();
                txtEinC_TE2.setName("txtEinC_TE2");
                txtEinC_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE = new JTextField();
                txtEinC_CE.setName("txtEinC_CE");
                txtEinC_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinC_CE2 = new JTextField();
                txtEinC_CE2.setName("txtEinC_CE2");
                txtEinC_CE2.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.add((Component)txtEinA_TE2, CC.xy((int)9, (int)3));
                builder.add((Component)txtEinA_CE2, CC.xy((int)11, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtEinC, CC.xy((int)3, (int)5));
                builder.add((Component)txtEinC_TE, CC.xy((int)5, (int)5));
                builder.add((Component)txtEinC_CE, CC.xy((int)7, (int)5));
                builder.add((Component)txtEinC_TE2, CC.xy((int)9, (int)5));
                builder.add((Component)txtEinC_CE2, CC.xy((int)11, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Cubic) {
                JTextField txtEinA = new JTextField();
                txtEinA.setName("txtEinA");
                txtEinA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE = new JTextField();
                txtEinA_TE.setName("txtEinA_TE");
                txtEinA_TE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_TE2 = new JTextField();
                txtEinA_TE2.setName("txtEinA_TE2");
                txtEinA_TE2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE = new JTextField();
                txtEinA_CE.setName("txtEinA_CE");
                txtEinA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtEinA_CE2 = new JTextField();
                txtEinA_CE2.setName("txtEinA_CE2");
                txtEinA_CE2.setInputVerifier(new MyInputVerifierDouble());
                txtEinA.setText("5.51546");
                txtEinA_TE.setText("229.982");
                txtEinA_CE.setText("0.00773583");
                txtEinA_TE2.setText("731.333");
                txtEinA_CE2.setText("0.0220693");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtEinA, CC.xy((int)3, (int)3));
                builder.add((Component)txtEinA_TE, CC.xy((int)5, (int)3));
                builder.add((Component)txtEinA_CE, CC.xy((int)7, (int)3));
                builder.add((Component)txtEinA_TE2, CC.xy((int)9, (int)3));
                builder.add((Component)txtEinA_CE2, CC.xy((int)11, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildDebyePanel() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.Orthorhombic), eCrystalSystem.Orthorhombic.toString());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.Hexagonal), eCrystalSystem.Hexagonal.toString());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.Rhombohedral), eCrystalSystem.Rhombohedral.toString());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.Tetragonal), eCrystalSystem.Tetragonal.toString());
            _rv.add((Component)this.buildDebyePanel(eCrystalSystem.Cubic), eCrystalSystem.Cubic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildDebyePanel(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Lattice start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddCE = new JLabel("<html>Add Debye temperature, T<sub>D</sub></html>");
            _lblAddCE.setFont(_fHeader);
            builder.add((Component)_lblAddCE, CC.xy((int)5, (int)1));
            JLabel _lblAddCE2 = new JLabel("<html>Add Debye scaling, x<sub>D</sub></html>");
            _lblAddCE2.setFont(_fHeader);
            builder.add((Component)_lblAddCE2, CC.xy((int)7, (int)1));
            JButton _btnHelp = new JButton("How to add Debye-Function?");
            builder.add((Component)_btnHelp, CC.xy((int)9, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Debye-Function</strong><br><br><br>f(T)=p<sub>0</sub>+x<sub>D</sub>*T*(1+C1*(T<sub>D</sub>/T)+C2*(T<sub>D</sub>/T)<sup>2</sup>)/(1+C3*(T<sub>D</sub>/T)+C4*(T<sub>D</sub>/T)<sup>2</sup>+C5*(T<sub>D</sub>/T)<sup>3</sup>+C6*(T<sub>D</sub>/T)<sup>4</sup>+C2*(5/&#960;<sup>4</sup>)*(T<sub>D</sub>/T)<sup>5</sup>)<br><br>p<sub>0</sub><br>Lattice start parameter<br><br>T<sub>D</sub><br>Debye temperature<br><br>x<sub>D</sub><br>Debye scaling<br><br>C1, C2, C3, C4, C5, C6<br>Parametrisation of Debye function according to Masyukov &amp; Dmitriev (2007), see TEV-Manual</p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic || pCrystalSystem == eCrystalSystem.Monoclinic || pCrystalSystem == eCrystalSystem.Orthorhombic) {
                JTextField txtDebA = new JTextField();
                txtDebA.setName("txtDebA");
                txtDebA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_TD = new JTextField();
                txtDebA_TD.setName("txtDebA_TD");
                txtDebA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_x1 = new JTextField();
                txtDebA_x1.setName("txtDebA_x1");
                txtDebA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebB = new JTextField();
                txtDebB.setName("txtDebB");
                txtDebB.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebB_TD = new JTextField();
                txtDebB_TD.setName("txtDebB_TD");
                txtDebB_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebB_x1 = new JTextField();
                txtDebB_x1.setName("txtDebB_x1");
                txtDebB_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC = new JTextField();
                txtDebC.setName("txtDebC");
                txtDebC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC_TD = new JTextField();
                txtDebC_TD.setName("txtDebC_TD");
                txtDebC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC_x1 = new JTextField();
                txtDebC_x1.setName("txtDebC_x1");
                txtDebC_x1.setInputVerifier(new MyInputVerifierDouble());
                txtDebA.setText("6.80030");
                txtDebB.setText("8.35490");
                txtDebC.setText("9.89430");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebA_x1, CC.xy((int)7, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebB, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebB_TD, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebB_x1, CC.xy((int)7, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtDebC, CC.xy((int)3, (int)7));
                builder.add((Component)txtDebC_TD, CC.xy((int)5, (int)7));
                builder.add((Component)txtDebC_x1, CC.xy((int)7, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Tetragonal) {
                JTextField txtDebA = new JTextField();
                txtDebA.setName("txtDebA");
                txtDebA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC = new JTextField();
                txtDebC.setName("txtDebC");
                txtDebC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_TD = new JTextField();
                txtDebA_TD.setName("txtDebA_TD");
                txtDebA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_x1 = new JTextField();
                txtDebA_x1.setName("txtDebA_x1");
                txtDebA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC_TD = new JTextField();
                txtDebC_TD.setName("txtDebC_TD");
                txtDebC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC_x1 = new JTextField();
                txtDebC_x1.setName("txtDebC_x1");
                txtDebC_x1.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebA_x1, CC.xy((int)7, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebC, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebC_TD, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebC_x1, CC.xy((int)7, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Rhombohedral) {
                JTextField txtDebA = new JTextField();
                txtDebA.setName("txtDebA");
                txtDebA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_TD = new JTextField();
                txtDebA_TD.setName("txtDebA_TD");
                txtDebA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_x1 = new JTextField();
                txtDebA_x1.setName("txtDebA_x1");
                txtDebA_x1.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebA_x1, CC.xy((int)7, (int)3));
            } else if (pCrystalSystem == eCrystalSystem.Hexagonal) {
                JTextField txtDebA = new JTextField();
                txtDebA.setName("txtDebA");
                txtDebA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC = new JTextField();
                txtDebC.setName("txtDebC");
                txtDebC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_TD = new JTextField();
                txtDebA_TD.setName("txtDebA_TD");
                txtDebA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_x1 = new JTextField();
                txtDebA_x1.setName("txtDebA_x1");
                txtDebA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC_TD = new JTextField();
                txtDebC_TD.setName("txtDebC_TD");
                txtDebC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebC_x1 = new JTextField();
                txtDebC_x1.setName("txtDebC_x1");
                txtDebC_x1.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebA_x1, CC.xy((int)7, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebC, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebC_TD, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebC_x1, CC.xy((int)7, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Cubic) {
                JTextField txtDebA = new JTextField();
                txtDebA.setName("txtDebA");
                txtDebA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_TD = new JTextField();
                txtDebA_TD.setName("txtDebA_TD");
                txtDebA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebA_x1 = new JTextField();
                txtDebA_x1.setName("txtDebA_x1");
                txtDebA_x1.setInputVerifier(new MyInputVerifierDouble());
                txtDebA.setText("9.45488");
                txtDebA_TD.setText("489.674");
                txtDebA_x1.setText("0.000155791");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebA_x1, CC.xy((int)7, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildDebye2TermPanel() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.Orthorhombic), eCrystalSystem.Orthorhombic.toString());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.Hexagonal), eCrystalSystem.Hexagonal.toString());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.Rhombohedral), eCrystalSystem.Rhombohedral.toString());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.Tetragonal), eCrystalSystem.Tetragonal.toString());
            _rv.add((Component)this.buildDebye2TermPanel(eCrystalSystem.Cubic), eCrystalSystem.Cubic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildDebye2TermPanel(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Lattice start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddCE = new JLabel("<html>Add Debye temperature, T<sub>D1</sub></html>");
            _lblAddCE.setFont(_fHeader);
            builder.add((Component)_lblAddCE, CC.xy((int)5, (int)1));
            JLabel _lblAddCE2 = new JLabel("<html>Add Debye temperature, T<sub>D2</sub></html>");
            _lblAddCE2.setFont(_fHeader);
            builder.add((Component)_lblAddCE2, CC.xy((int)7, (int)1));
            JLabel _lblAddX1 = new JLabel("<html>Add Debye scaling, x<sub>D1</sub></html>");
            _lblAddX1.setFont(_fHeader);
            builder.add((Component)_lblAddX1, CC.xy((int)9, (int)1));
            JLabel _lblAddX2 = new JLabel("<html>Add Debye scaling, x<sub>D2</sub></html>");
            _lblAddX2.setFont(_fHeader);
            builder.add((Component)_lblAddX2, CC.xy((int)11, (int)1));
            JButton _btnHelp = new JButton("How to add Debye-2-Term-Function?");
            builder.add((Component)_btnHelp, CC.xy((int)13, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Debye-2-Term-Function weighted 1:2</strong><br><br><br>f(T)=x<sub>D1</sub>*T*(1+C1*(T<sub>D1</sub>/T)+C2*(T<sub>D1</sub>/T)<sup>2</sup>)/(1+C3*(T<sub>D1</sub>/T)+C4*(T<sub>D1</sub>/T)<sup>2</sup>+C5*(T<sub>D1</sub>/T)<sup>3</sup>+C6*(T<sub>D1</sub>/T)<sup>4</sup>+C2*(5/&#960;<sup>4</sup>)*(T<sub>D1</sub>/T)<sup>5</sup>)<br>g(T)=x<sub>D2</sub>*T*(1+C1*(T<sub>D2</sub>/T)+C2*(T<sub>D2</sub>/T)<sup>2</sup>)/(1+C3*(T<sub>D2</sub>/T)+C4*(T<sub>D2</sub>/T)<sup>2</sup>+C5*(T<sub>D2</sub>/T)<sup>3</sup>+C6*(T<sub>D2</sub>/T)<sup>4</sup>+C2*(5/&#960;<sup>4</sup>)*(T<sub>D2</sub>/T)<sup>5</sup>)<br><strong>h(T)=p<sub>0</sub>+f(T)+g(T)</strong><br>p<sub>0</sub><br>Lattice start parameter<br><br>T<sub>D1</sub>, T<sub>D2</sub><br>Debye temperatures<br><br>x<sub>D1</sub><br>Debye scaling<br><br>x<sub>D2</sub> = 0.5 * x<sub>D1</sub><br><br>C1, C2, C3, C4, C5, C6<br>Parametrisation of Debye function according to Masyukov &amp; Dmitriev (2007), see TEV-Manual</p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic || pCrystalSystem == eCrystalSystem.Monoclinic || pCrystalSystem == eCrystalSystem.Orthorhombic) {
                JTextField txtDebyeA = new JTextField();
                txtDebyeA.setName("txtDebyeA");
                txtDebyeA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD = new JTextField();
                txtDebyeA_TD.setName("txtDebyeA_TD");
                txtDebyeA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD2 = new JTextField();
                txtDebyeA_TD2.setName("txtDebyeA_TD2");
                txtDebyeA_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x1 = new JTextField();
                txtDebyeA_x1.setName("txtDebyeA_x1");
                txtDebyeA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x2 = new JTextField();
                txtDebyeA_x2.setName("txtDebyeA_x2");
                txtDebyeA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeB = new JTextField();
                txtDebyeB.setName("txtDebyeB");
                txtDebyeB.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeB_TD = new JTextField();
                txtDebyeB_TD.setName("txtDebyeB_TD");
                txtDebyeB_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeB_TD2 = new JTextField();
                txtDebyeB_TD2.setName("txtDebyeB_TD2");
                txtDebyeB_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeB_x1 = new JTextField();
                txtDebyeB_x1.setName("txtDebyeB_x1");
                txtDebyeB_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeB_x2 = new JTextField();
                txtDebyeB_x2.setName("txtDebyeB_x2");
                txtDebyeB_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC = new JTextField();
                txtDebyeC.setName("txtDebyeC");
                txtDebyeC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_TD = new JTextField();
                txtDebyeC_TD.setName("txtDebyeC_TD");
                txtDebyeC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_TD2 = new JTextField();
                txtDebyeC_TD2.setName("txtDebyeC_TD2");
                txtDebyeC_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_x1 = new JTextField();
                txtDebyeC_x1.setName("txtDebyeC_x1");
                txtDebyeC_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_x2 = new JTextField();
                txtDebyeC_x2.setName("txtDebyeC_x2");
                txtDebyeC_x2.setInputVerifier(new MyInputVerifierDouble());
                txtDebyeA.setText("6.80030");
                txtDebyeB.setText("8.35490");
                txtDebyeC.setText("9.89430");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebyeA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebyeA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebyeA_TD2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebyeA_x1, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebyeA_x2, CC.xy((int)11, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebyeB, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebyeB_TD, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebyeB_TD2, CC.xy((int)7, (int)5));
                builder.add((Component)txtDebyeB_x1, CC.xy((int)9, (int)5));
                builder.add((Component)txtDebyeB_x2, CC.xy((int)11, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtDebyeC, CC.xy((int)3, (int)7));
                builder.add((Component)txtDebyeC_TD, CC.xy((int)5, (int)7));
                builder.add((Component)txtDebyeC_TD2, CC.xy((int)7, (int)7));
                builder.add((Component)txtDebyeC_x1, CC.xy((int)9, (int)7));
                builder.add((Component)txtDebyeC_x2, CC.xy((int)11, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Tetragonal) {
                JTextField txtDebyeA = new JTextField();
                txtDebyeA.setName("txtDebyeA");
                txtDebyeA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC = new JTextField();
                txtDebyeC.setName("txtDebyeC");
                txtDebyeC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD = new JTextField();
                txtDebyeA_TD.setName("txtDebyeA_TD");
                txtDebyeA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD2 = new JTextField();
                txtDebyeA_TD2.setName("txtDebyeA_TD2");
                txtDebyeA_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x1 = new JTextField();
                txtDebyeA_x1.setName("txtDebyeA_x1");
                txtDebyeA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x2 = new JTextField();
                txtDebyeA_x2.setName("txtDebyeA_x2");
                txtDebyeA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_TD = new JTextField();
                txtDebyeC_TD.setName("txtDebyeC_TD");
                txtDebyeC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_TD2 = new JTextField();
                txtDebyeC_TD2.setName("txtDebyeC_TD2");
                txtDebyeC_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_x1 = new JTextField();
                txtDebyeC_x1.setName("txtDebyeC_x1");
                txtDebyeC_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_x2 = new JTextField();
                txtDebyeC_x2.setName("txtDebyeC_x2");
                txtDebyeC_x2.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebyeA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebyeA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebyeA_TD2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebyeA_x1, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebyeA_x2, CC.xy((int)11, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebyeC, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebyeC_TD, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebyeC_TD2, CC.xy((int)7, (int)5));
                builder.add((Component)txtDebyeC_x1, CC.xy((int)9, (int)5));
                builder.add((Component)txtDebyeC_x2, CC.xy((int)11, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Rhombohedral) {
                JTextField txtDebyeA = new JTextField();
                txtDebyeA.setName("txtDebyeA");
                txtDebyeA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD = new JTextField();
                txtDebyeA_TD.setName("txtDebyeA_TD");
                txtDebyeA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD2 = new JTextField();
                txtDebyeA_TD2.setName("txtDebyeA_TD2");
                txtDebyeA_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x1 = new JTextField();
                txtDebyeA_x1.setName("txtDebyeA_x1");
                txtDebyeA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x2 = new JTextField();
                txtDebyeA_x2.setName("txtDebyeA_x2");
                txtDebyeA_x2.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebyeA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebyeA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebyeA_TD2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebyeA_x1, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebyeA_x2, CC.xy((int)11, (int)3));
            } else if (pCrystalSystem == eCrystalSystem.Hexagonal) {
                JTextField txtDebyeA = new JTextField();
                txtDebyeA.setName("txtDebyeA");
                txtDebyeA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC = new JTextField();
                txtDebyeC.setName("txtDebyeC");
                txtDebyeC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD = new JTextField();
                txtDebyeA_TD.setName("txtDebyeA_TD");
                txtDebyeA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD2 = new JTextField();
                txtDebyeA_TD2.setName("txtDebyeA_TD2");
                txtDebyeA_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x1 = new JTextField();
                txtDebyeA_x1.setName("txtDebyeA_x1");
                txtDebyeA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_TD = new JTextField();
                txtDebyeC_TD.setName("txtDebyeC_TD");
                txtDebyeC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_TD2 = new JTextField();
                txtDebyeC_TD2.setName("txtDebyeC_TD2");
                txtDebyeC_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_x1 = new JTextField();
                txtDebyeC_x1.setName("txtDebyeC_x1");
                txtDebyeC_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x2 = new JTextField();
                txtDebyeA_x2.setName("txtDebyeA_x2");
                txtDebyeA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeC_x2 = new JTextField();
                txtDebyeC_x2.setName("txtDebyeC_x2");
                txtDebyeC_x2.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebyeA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebyeA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebyeA_TD2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebyeA_x1, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebyeA_x2, CC.xy((int)11, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebyeC, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebyeC_TD, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebyeC_TD2, CC.xy((int)7, (int)5));
                builder.add((Component)txtDebyeC_x1, CC.xy((int)9, (int)5));
                builder.add((Component)txtDebyeC_x2, CC.xy((int)11, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Cubic) {
                JTextField txtDebyeA = new JTextField();
                txtDebyeA.setText("5.51544");
                txtDebyeA.setName("txtDebyeA");
                txtDebyeA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD = new JTextField();
                txtDebyeA_TD.setText("327");
                txtDebyeA_TD.setName("txtDebyeA_TD");
                txtDebyeA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_TD2 = new JTextField();
                txtDebyeA_TD2.setText("977");
                txtDebyeA_TD2.setName("txtDebyeA_TD2");
                txtDebyeA_TD2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x1 = new JTextField();
                txtDebyeA_x1.setText("3.31797e-005");
                txtDebyeA_x1.setName("txtDebyeA_x1");
                txtDebyeA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebyeA_x2 = new JTextField();
                txtDebyeA_x2.setText("3.0975e-005");
                txtDebyeA_x2.setName("txtDebyeA_x2");
                txtDebyeA_x2.setInputVerifier(new MyInputVerifierDouble());
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebyeA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebyeA_TD, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebyeA_TD2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebyeA_x1, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebyeA_x2, CC.xy((int)11, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildDebyeEinAnPanel() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.Orthorhombic), eCrystalSystem.Orthorhombic.toString());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.Hexagonal), eCrystalSystem.Hexagonal.toString());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.Rhombohedral), eCrystalSystem.Rhombohedral.toString());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.Tetragonal), eCrystalSystem.Tetragonal.toString());
            _rv.add((Component)this.buildDebyeEinAnPanel(eCrystalSystem.Cubic), eCrystalSystem.Cubic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    public JPanel buildDebyeEinAnPanel(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [100dlu, pref], 20dlu, [50dlu, pref], 20dlu, [50dlu, pref], 20dlu, [50dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, [100dlu, pref], 20dlu, left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAdd0 = new JLabel("Add Lattice start parameter");
            _lblAdd0.setFont(_fHeader);
            builder.add((Component)_lblAdd0, CC.xy((int)3, (int)1));
            JLabel _lblAddX1 = new JLabel("<html>Add Einstein constant, x<sub>E</sub></html>");
            _lblAddX1.setFont(_fHeader);
            builder.add((Component)_lblAddX1, CC.xy((int)5, (int)1));
            JLabel _lblAddX2 = new JLabel("<html>Add Debye scaling, x<sub>D</sub></html>");
            _lblAddX2.setFont(_fHeader);
            builder.add((Component)_lblAddX2, CC.xy((int)7, (int)1));
            JLabel _lblAddX3 = new JLabel("<html>Add anharmonic scaling, x<sub>A</sub></html>");
            _lblAddX3.setFont(_fHeader);
            builder.add((Component)_lblAddX3, CC.xy((int)9, (int)1));
            JLabel _lblAddTD = new JLabel("<html>Add Debye Temperature, T<sub>D</sub></html>");
            _lblAddTD.setFont(_fHeader);
            builder.add((Component)_lblAddTD, CC.xy((int)11, (int)1));
            JLabel _lblAddTE = new JLabel("<html>Add Einstein Temperature, T<sub>E</sub></html>");
            _lblAddTE.setFont(_fHeader);
            builder.add((Component)_lblAddTE, CC.xy((int)13, (int)1));
            JButton _btnHelp = new JButton("How to add Function?");
            builder.add((Component)_btnHelp, CC.xy((int)15, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add Debye-Einstein-Anharmonic-Function</strong><br><br>see TEV-Manual</p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic || pCrystalSystem == eCrystalSystem.Monoclinic || pCrystalSystem == eCrystalSystem.Orthorhombic) {
                JTextField txtDebEinAnA = new JTextField();
                txtDebEinAnA.setName("txtDebEinAnA");
                txtDebEinAnA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x1 = new JTextField();
                txtDebEinAnA_x1.setName("txtDebEinAnA_x1");
                txtDebEinAnA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x2 = new JTextField();
                txtDebEinAnA_x2.setName("txtDebEinAnA_x2");
                txtDebEinAnA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x3 = new JTextField();
                txtDebEinAnA_x3.setName("txtDebEinAnA_x3");
                txtDebEinAnA_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_TD = new JTextField();
                txtDebEinAnA_TD.setName("txtDebEinAnA_TD");
                txtDebEinAnA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_CE = new JTextField();
                txtDebEinAnA_CE.setName("txtDebEinAnA_CE");
                txtDebEinAnA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnB = new JTextField();
                txtDebEinAnB.setName("txtDebEinAnB");
                txtDebEinAnB.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnB_x1 = new JTextField();
                txtDebEinAnB_x1.setName("txtDebEinAnB_x1");
                txtDebEinAnB_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnB_x2 = new JTextField();
                txtDebEinAnB_x2.setName("txtDebEinAnB_x2");
                txtDebEinAnB_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnB_x3 = new JTextField();
                txtDebEinAnB_x3.setName("txtDebEinAnB_x3");
                txtDebEinAnB_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnB_TD = new JTextField();
                txtDebEinAnB_TD.setName("txtDebEinAnB_TD");
                txtDebEinAnB_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnB_CE = new JTextField();
                txtDebEinAnB_CE.setName("txtDebEinAnB_CE");
                txtDebEinAnB_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC = new JTextField();
                txtDebEinAnC.setName("txtDebEinAnC");
                txtDebEinAnC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x1 = new JTextField();
                txtDebEinAnC_x1.setName("txtDebEinAnC_x1");
                txtDebEinAnC_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x2 = new JTextField();
                txtDebEinAnC_x2.setName("txtDebEinAnC_x2");
                txtDebEinAnC_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x3 = new JTextField();
                txtDebEinAnC_x3.setName("txtDebEinAnC_x3");
                txtDebEinAnC_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_TD = new JTextField();
                txtDebEinAnC_TD.setName("txtDebEinAnC_TD");
                txtDebEinAnC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_CE = new JTextField();
                txtDebEinAnC_CE.setName("txtDebEinAnC_CE");
                txtDebEinAnC_CE.setInputVerifier(new MyInputVerifierDouble());
                txtDebEinAnA.setText("6.80030");
                txtDebEinAnB.setText("8.35490");
                txtDebEinAnC.setText("9.89430");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebEinAnA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebEinAnA_x1, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebEinAnA_x2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebEinAnA_x3, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebEinAnA_TD, CC.xy((int)11, (int)3));
                builder.add((Component)txtDebEinAnA_CE, CC.xy((int)13, (int)3));
                builder.addLabel("&b:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebEinAnB, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebEinAnB_x1, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebEinAnB_x2, CC.xy((int)7, (int)5));
                builder.add((Component)txtDebEinAnB_x3, CC.xy((int)9, (int)5));
                builder.add((Component)txtDebEinAnB_TD, CC.xy((int)11, (int)5));
                builder.add((Component)txtDebEinAnB_CE, CC.xy((int)13, (int)5));
                builder.addLabel("&c:", CC.xy((int)1, (int)7));
                builder.add((Component)txtDebEinAnC, CC.xy((int)3, (int)7));
                builder.add((Component)txtDebEinAnC_x1, CC.xy((int)5, (int)7));
                builder.add((Component)txtDebEinAnC_x2, CC.xy((int)7, (int)7));
                builder.add((Component)txtDebEinAnC_x3, CC.xy((int)9, (int)7));
                builder.add((Component)txtDebEinAnC_TD, CC.xy((int)11, (int)7));
                builder.add((Component)txtDebEinAnC_CE, CC.xy((int)13, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Tetragonal) {
                JTextField txtDebEinAnA = new JTextField();
                txtDebEinAnA.setName("txtDebEinAnA");
                txtDebEinAnA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x1 = new JTextField();
                txtDebEinAnA_x1.setName("txtDebEinAnA_x1");
                txtDebEinAnA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x2 = new JTextField();
                txtDebEinAnA_x2.setName("txtDebEinAnA_x2");
                txtDebEinAnA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x3 = new JTextField();
                txtDebEinAnA_x3.setName("txtDebEinAnA_x3");
                txtDebEinAnA_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_TD = new JTextField();
                txtDebEinAnA_TD.setName("txtDebEinAnA_TD");
                txtDebEinAnA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_CE = new JTextField();
                txtDebEinAnA_CE.setName("txtDebEinAnA_CE");
                txtDebEinAnA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC = new JTextField();
                txtDebEinAnC.setName("txtDebEinAnC");
                txtDebEinAnC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x1 = new JTextField();
                txtDebEinAnC_x1.setName("txtDebEinAnC_x1");
                txtDebEinAnC_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x2 = new JTextField();
                txtDebEinAnC_x2.setName("txtDebEinAnC_x2");
                txtDebEinAnC_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x3 = new JTextField();
                txtDebEinAnC_x3.setName("txtDebEinAnC_x3");
                txtDebEinAnC_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_TD = new JTextField();
                txtDebEinAnC_TD.setName("txtDebEinAnC_TD");
                txtDebEinAnC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_CE = new JTextField();
                txtDebEinAnC_CE.setName("txtDebEinAnC_CE");
                txtDebEinAnC_CE.setInputVerifier(new MyInputVerifierDouble());
                txtDebEinAnA.setText("6.80030");
                txtDebEinAnC.setText("9.89430");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebEinAnA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebEinAnA_x1, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebEinAnA_x2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebEinAnA_x3, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebEinAnA_TD, CC.xy((int)11, (int)3));
                builder.add((Component)txtDebEinAnA_CE, CC.xy((int)13, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebEinAnC, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebEinAnC_x1, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebEinAnC_x2, CC.xy((int)7, (int)5));
                builder.add((Component)txtDebEinAnC_x3, CC.xy((int)9, (int)5));
                builder.add((Component)txtDebEinAnC_TD, CC.xy((int)11, (int)5));
                builder.add((Component)txtDebEinAnC_CE, CC.xy((int)13, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Rhombohedral) {
                JTextField txtDebEinAnA = new JTextField();
                txtDebEinAnA.setName("txtDebEinAnA");
                txtDebEinAnA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x1 = new JTextField();
                txtDebEinAnA_x1.setName("txtDebEinAnA_x1");
                txtDebEinAnA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x2 = new JTextField();
                txtDebEinAnA_x2.setName("txtDebEinAnA_x2");
                txtDebEinAnA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x3 = new JTextField();
                txtDebEinAnA_x3.setName("txtDebEinAnA_x3");
                txtDebEinAnA_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_TD = new JTextField();
                txtDebEinAnA_TD.setName("txtDebEinAnA_TD");
                txtDebEinAnA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_CE = new JTextField();
                txtDebEinAnA_CE.setName("txtDebEinAnA_CE");
                txtDebEinAnA_CE.setInputVerifier(new MyInputVerifierDouble());
                txtDebEinAnA.setText("6.80030");
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebEinAnA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebEinAnA_x1, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebEinAnA_x2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebEinAnA_x3, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebEinAnA_TD, CC.xy((int)11, (int)3));
                builder.add((Component)txtDebEinAnA_CE, CC.xy((int)13, (int)3));
            } else if (pCrystalSystem == eCrystalSystem.Hexagonal) {
                JTextField txtDebEinAnA = new JTextField();
                txtDebEinAnA.setName("txtDebEinAnA");
                txtDebEinAnA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x1 = new JTextField();
                txtDebEinAnA_x1.setName("txtDebEinAnA_x1");
                txtDebEinAnA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x2 = new JTextField();
                txtDebEinAnA_x2.setName("txtDebEinAnA_x2");
                txtDebEinAnA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x3 = new JTextField();
                txtDebEinAnA_x3.setName("txtDebEinAnA_x3");
                txtDebEinAnA_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_TD = new JTextField();
                txtDebEinAnA_TD.setName("txtDebEinAnA_TD");
                txtDebEinAnA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_CE = new JTextField();
                txtDebEinAnA_CE.setName("txtDebEinAnA_CE");
                txtDebEinAnA_CE.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC = new JTextField();
                txtDebEinAnC.setName("txtDebEinAnC");
                txtDebEinAnC.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x1 = new JTextField();
                txtDebEinAnC_x1.setName("txtDebEinAnC_x1");
                txtDebEinAnC_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x2 = new JTextField();
                txtDebEinAnC_x2.setName("txtDebEinAnC_x2");
                txtDebEinAnC_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_x3 = new JTextField();
                txtDebEinAnC_x3.setName("txtDebEinAnC_x3");
                txtDebEinAnC_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_TD = new JTextField();
                txtDebEinAnC_TD.setName("txtDebEinAnC_TD");
                txtDebEinAnC_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnC_CE = new JTextField();
                txtDebEinAnC_CE.setName("txtDebEinAnC_CE");
                txtDebEinAnC_CE.setInputVerifier(new MyInputVerifierDouble());
                txtDebEinAnA.setText("6.80030");
                txtDebEinAnC.setText("9.89430");
                builder.addLabel("&a1=a2=a3:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebEinAnA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebEinAnA_x1, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebEinAnA_x2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebEinAnA_x3, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebEinAnA_TD, CC.xy((int)11, (int)3));
                builder.add((Component)txtDebEinAnA_CE, CC.xy((int)13, (int)3));
                builder.addLabel("&c:", CC.xy((int)1, (int)5));
                builder.add((Component)txtDebEinAnC, CC.xy((int)3, (int)5));
                builder.add((Component)txtDebEinAnC_x1, CC.xy((int)5, (int)5));
                builder.add((Component)txtDebEinAnC_x2, CC.xy((int)7, (int)5));
                builder.add((Component)txtDebEinAnC_x3, CC.xy((int)9, (int)5));
                builder.add((Component)txtDebEinAnC_TD, CC.xy((int)11, (int)5));
                builder.add((Component)txtDebEinAnC_CE, CC.xy((int)13, (int)5));
            } else if (pCrystalSystem == eCrystalSystem.Cubic) {
                JTextField txtDebEinAnA = new JTextField();
                txtDebEinAnA.setName("txtDebEinAnA");
                txtDebEinAnA.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x1 = new JTextField();
                txtDebEinAnA_x1.setName("txtDebEinAnA_x1");
                txtDebEinAnA_x1.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x2 = new JTextField();
                txtDebEinAnA_x2.setName("txtDebEinAnA_x2");
                txtDebEinAnA_x2.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_x3 = new JTextField();
                txtDebEinAnA_x3.setName("txtDebEinAnA_x3");
                txtDebEinAnA_x3.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_TD = new JTextField();
                txtDebEinAnA_TD.setName("txtDebEinAnA_TD");
                txtDebEinAnA_TD.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtDebEinAnA_CE = new JTextField();
                txtDebEinAnA_CE.setName("txtDebEinAnA_CE");
                txtDebEinAnA_CE.setInputVerifier(new MyInputVerifierDouble());
                txtDebEinAnA.setText("10.327");
                txtDebEinAnA_x1.setText("0.000339136");
                txtDebEinAnA_x2.setText("-0.0445914");
                txtDebEinAnA_x3.setText("-5.15142E-06");
                txtDebEinAnA_TD.setText("796.669");
                txtDebEinAnA_CE.setText("134.828");
                builder.addLabel("&a:", CC.xy((int)1, (int)3));
                builder.add((Component)txtDebEinAnA, CC.xy((int)3, (int)3));
                builder.add((Component)txtDebEinAnA_x1, CC.xy((int)5, (int)3));
                builder.add((Component)txtDebEinAnA_x2, CC.xy((int)7, (int)3));
                builder.add((Component)txtDebEinAnA_x3, CC.xy((int)9, (int)3));
                builder.add((Component)txtDebEinAnA_TD, CC.xy((int)11, (int)3));
                builder.add((Component)txtDebEinAnA_CE, CC.xy((int)13, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }

    public JPanel buildLiteratureAnglePoly() {
        JPanel _rv = null;
        try {
            _rv = new JPanel(new CardLayout());
            _rv.add((Component)this.buildLiteratureAnglePoly(eCrystalSystem.select), eCrystalSystem.select.toString());
            _rv.add((Component)this.buildLiteratureAnglePoly(eCrystalSystem.Triclinic), eCrystalSystem.Triclinic.toString());
            _rv.add((Component)this.buildLiteratureAnglePoly(eCrystalSystem.Monoclinic), eCrystalSystem.Monoclinic.toString());
        }
        catch (Exception _ex) {
            logger.error((Object)_ex);
        }
        return _rv;
    }

    private JPanel buildLiteratureAnglePoly(eCrystalSystem pCrystalSystem) {
        FormLayout layout = new FormLayout("pref, 4dlu, [250dlu, pref], left:pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu,p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        try {
            Font _fHeader = new Font("", 1, 12);
            JLabel _lblAddPoly = new JLabel("Add Polynomial coefficients");
            _lblAddPoly.setFont(_fHeader);
            builder.add((Component)_lblAddPoly, CC.xyw((int)1, (int)1, (int)3));
            JButton _btnHelp = new JButton("How to add polynomial coefficients?");
            builder.add((Component)_btnHelp, CC.xy((int)4, (int)1));
            _btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLabel _lblInfo = new JLabel();
                    _lblInfo.setText("<html><body><div><p><strong>Add polynomial coefficients</strong><br><br>Polynomial of order 3<br>f(T)=p<sub>0</sub>+p<sub>1</sub>*T+p<sub>2</sub>*T<sup>2</sup>+p<sub>3</sub>*T<sup>3</sup><br><br></p><p>Format of Input String<br>p<sub>0</sub>|p<sub>1</sub>|p<sub>2</sub>|p<sub>3</sub><br><br>Numerical example<br>6.80030E+00|-6.19870E-05|1.21170E-07|-1.60160E-10<br><br>Polynomial of order 2<br>p<sub>0</sub>|p<sub>1</sub>|p<sub>2</sub><br><br>Polynomial of order 1<br>p<sub>0</sub>|p<sub>1</sub></sub></p></div></body></html>");
                    JOptionPane.showMessageDialog(null, _lblInfo);
                }
            });
            if (pCrystalSystem == eCrystalSystem.Triclinic) {
                JTextField txtPolyAlpha = new JTextField();
                txtPolyAlpha.setName("txtPolyAlpha");
                txtPolyAlpha.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtPolyBeta = new JTextField();
                txtPolyBeta.setName("txtPolyBeta");
                txtPolyBeta.setInputVerifier(new MyInputVerifierDouble());
                JTextField txtPolyGamma = new JTextField();
                txtPolyGamma.setName("txtPolyGamma");
                txtPolyGamma.setInputVerifier(new MyInputVerifierDouble());
                txtPolyAlpha.setText("9.71141E+01|-5.22390E-04|-1.91610E-06|4.07550E-09");
                txtPolyBeta.setText("1.07040E+02|-1.31540E-04|2.46050E-08");
                txtPolyGamma.setText("1.01167E+02|-1.65480E-04|6.16400E-08|2.44380E-11");
                builder.addLabel("&alpha:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyAlpha, CC.xy((int)3, (int)3));
                builder.addLabel("&beta:", CC.xy((int)1, (int)5));
                builder.add((Component)txtPolyBeta, CC.xy((int)3, (int)5));
                builder.addLabel("&gamma:", CC.xy((int)1, (int)7));
                builder.add((Component)txtPolyGamma, CC.xy((int)3, (int)7));
            } else if (pCrystalSystem == eCrystalSystem.Monoclinic) {
                JTextField txtPolyOblique = new JTextField();
                txtPolyOblique.setName("txtPolyOblique");
                txtPolyOblique.setText("9.37635E+01|3.87424E-04|8.49056E-08");
                builder.addLabel("&oblique angle:", CC.xy((int)1, (int)3));
                builder.add((Component)txtPolyOblique, CC.xy((int)3, (int)3));
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return builder.getPanel();
    }
}

