/*
 * Decompiled with CFR 0.152.
 */
package myObjects.functions;

import myObjects.eLatticeName;
import myObjects.functions.EinsteinFct;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class SatFct
implements IFunctions {
    public double beta0 = 117.0;
    public double A = 0.01;
    public double B = 110.0;
    public double C = 0.5;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(EinsteinFct.class);

    public SatFct(double pBeta0, double pA, double pB, double pC, eLatticeName _lattName) {
        this.beta0 = pBeta0;
        this.A = pA;
        this.B = pB;
        this.C = pC;
        this.ParamName = _lattName;
    }

    @Override
    public double getDerivative(double x) {
        double ableitung = 0.0;
        try {
            double term = 1.0 - Math.exp(-this.B * x);
            ableitung = this.A * this.B * this.C * Math.pow(term, this.C - 1.0) * Math.exp(-this.B * x);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return ableitung;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public String getESU() {
        return null;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        try {
            double term = 1.0 - Math.exp(-this.B * x);
            funktionsWert = this.beta0 + this.A * Math.pow(term, this.C);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "f(T)=" + Double.toString(this.beta0) + "+(" + Double.toString(this.A) + " * cos(" + Double.toString(this.B) + " * T))";
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 50.0;
        SatFct satFct = new SatFct(107.562, 0.01, 0.01, 0.5, eLatticeName.beta);
        System.out.println(satFct.toString());
        System.out.println("Funktionswert S\u00e4ttigungsfunktion an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + satFct.getValue(x));
        System.out.println("Ableitung:");
        System.out.println("Funktionswert der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f'(" + x + ")=" + satFct.getDerivative(x));
        System.out.println();
    }
}

