/*
 * Decompiled with CFR 0.152.
 */
package myObjects.functions;

import myObjects.eLatticeName;
import myObjects.functions.EinsteinFct;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class EinsteinFct2Term
implements IFunctions {
    public double a0 = 5.5;
    public double CE = 0.01;
    public double TE = 230.0;
    public double CE2 = 0.01;
    public double TE2 = 500.0;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(EinsteinFct.class);

    public EinsteinFct2Term(double pa0, double pTE, double pCE, double pTE2, double pCE2, eLatticeName _lattName) {
        this.a0 = pa0;
        this.CE = pCE;
        this.TE = pTE;
        this.CE2 = pCE2;
        this.TE2 = pTE2;
        this.ParamName = _lattName;
    }

    @Override
    public double getDerivative(double x) {
        double ableitung = 0.0;
        try {
            ableitung = this.CE * this.TE * Math.exp(this.TE / x) / (Math.pow(Math.exp(this.TE / x) - 1.0, 2.0) * Math.pow(x, 2.0)) + this.CE2 * this.TE2 * Math.exp(this.TE2 / x) / (Math.pow(Math.exp(this.TE2 / x) - 1.0, 2.0) * Math.pow(x, 2.0));
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return ableitung;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public String getESU() {
        return null;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        try {
            funktionsWert = this.a0 + this.CE / (Math.exp(this.TE / x) - 1.0) + this.CE2 / (Math.exp(this.TE2 / x) - 1.0);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "f(T)=" + Double.toString(this.a0) + "+(3*kb*N*" + Double.toString(this.TE) + "/(exp(" + Double.toString(this.TE) + "/T)-1))";
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 50.0;
        EinsteinFct2Term einsteinFct2Term = new EinsteinFct2Term(5.51546, 0.01, 229.982, 0.01, 731.333, eLatticeName.a);
        System.out.println("Funktionswert 2-Term-Einsteinfunktion an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + einsteinFct2Term.getValue(x));
        System.out.println("Ableitung:");
        System.out.println("Funktionswert der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f'(" + x + ")=" + einsteinFct2Term.getDerivative(x));
        System.out.println();
    }
}

