/*
 * Decompiled with CFR 0.152.
 */
package myObjects.functions;

import myObjects.eLatticeName;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class EinsteinFct
implements IFunctions {
    public double a0 = 7.0;
    public double CE = 0.01;
    public double TE = 110.0;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(EinsteinFct.class);

    public EinsteinFct(double pa0, double pTE, double pCE, eLatticeName _lattName) {
        this.a0 = pa0;
        this.CE = pCE;
        this.TE = pTE;
        this.ParamName = _lattName;
    }

    @Override
    public double getDerivative(double x) {
        double ableitung = 0.0;
        try {
            ableitung = this.CE * this.TE * Math.exp(this.TE / x) / (Math.pow(Math.exp(this.TE / x) - 1.0, 2.0) * Math.pow(x, 2.0));
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return ableitung;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public String getESU() {
        return null;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        try {
            funktionsWert = this.a0 + this.CE / (Math.exp(this.TE / x) - 1.0);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "f(T)=" + Double.toString(this.a0) + "+(" + Double.toString(this.CE) + "/(exp(" + Double.toString(this.TE) + "/T)-1))";
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 50.0;
        EinsteinFct einsteinFct = new EinsteinFct(104.0, 7.08757, 120.697, eLatticeName.a);
        System.out.println("Funktionswert Einsteinfunktion an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + einsteinFct.getValue(x));
        System.out.println("Ableitung:");
        System.out.println("Funktionswert der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f'(" + x + ")=" + einsteinFct.getDerivative(x));
        System.out.println();
    }
}

