/*
 * Decompiled with CFR 0.152.
 */
package myObjects.functions;

import myObjects.eLatticeName;
import myObjects.functions.EinsteinFct;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class DebyeFct2Term
implements IFunctions {
    private double kb = 1.3806487999999998E-23;
    private double C1 = -0.07713;
    private double C2 = 0.02433;
    private double C3 = 0.30548;
    private double C4 = 0.06513;
    private double C5 = 0.03487;
    private double C6 = -0.00324;
    public double a0 = 5.51546;
    public double TD = 200.0;
    public double x1 = 6.0E16;
    public double TD2 = 800.0;
    public double x2 = 6.0E16;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(EinsteinFct.class);

    public DebyeFct2Term(double pa0, double pTD, double pTD2, double px1, double px2, eLatticeName _lattName) {
        this.a0 = pa0;
        this.TD = pTD;
        this.TD2 = pTD2;
        this.x1 = px1;
        this.x2 = px2;
        this.ParamName = _lattName;
    }

    @Override
    public double getDerivative(double x) {
        double rv = 0.0;
        double ableitung = 0.0;
        double ableitung2 = 0.0;
        try {
            double xTerm1 = this.TD / x;
            double xTerm2 = this.TD2 / x;
            double termA = 1.0 + this.C1 * xTerm1 + this.C2 * Math.pow(xTerm1, 2.0);
            double termB = 1.0 + this.C3 * xTerm1 + this.C4 * Math.pow(xTerm1, 2.0) + this.C5 * Math.pow(xTerm1, 3.0) + this.C6 * Math.pow(xTerm1, 4.0) + this.C2 * 5.0 / Math.pow(Math.PI, 4.0) * Math.pow(xTerm1, 5.0);
            double termADer = 2.0 * this.C2 * this.TD * this.TD / Math.pow(x, 3.0) - -this.C1 * this.TD / Math.pow(x, 2.0);
            double termBDer = -25.0 * this.C2 * Math.pow(this.TD, 5.0) / (Math.pow(Math.PI, 4.0) * Math.pow(x, 6.0)) - 4.0 * this.C6 * Math.pow(this.TD, 4.0) / Math.pow(x, 5.0) - 3.0 * this.C5 * Math.pow(this.TD, 3.0) / Math.pow(x, 4.0) - 2.0 * this.C4 * Math.pow(this.TD, 2.0) / Math.pow(x, 3.0) - this.C3 * this.TD / Math.pow(x, 2.0);
            double Vf = x * this.x1;
            ableitung = Vf * (termB * termADer - termBDer * termA) / Math.pow(termB, 2.0);
            double termA2 = 1.0 + this.C1 * this.TD2 / x + this.C2 * Math.pow(xTerm2, 2.0);
            double termB2 = 1.0 + this.C3 * xTerm2 + this.C4 * Math.pow(this.TD2, 2.0) / Math.pow(x, 2.0) + this.C5 * Math.pow(xTerm2, 3.0) + this.C6 * Math.pow(xTerm2, 4.0) + this.C2 * 5.0 / Math.pow(Math.PI, 4.0) * Math.pow(xTerm2, 5.0);
            double termA2Der = 2.0 * this.C2 * this.TD2 * this.TD2 / Math.pow(x, 3.0) - -this.C1 * this.TD2 / Math.pow(x, 2.0);
            double termB2Der = -25.0 * this.C2 * Math.pow(this.TD2, 5.0) / (Math.pow(Math.PI, 4.0) * Math.pow(x, 6.0)) - 4.0 * this.C6 * Math.pow(this.TD2, 4.0) / Math.pow(x, 5.0) - 3.0 * this.C5 * Math.pow(this.TD2, 3.0) / Math.pow(x, 4.0) - 2.0 * this.C4 * Math.pow(this.TD2, 2.0) / Math.pow(x, 3.0) - this.C3 * this.TD2 / Math.pow(x, 2.0);
            double Vf2 = 0.5 * this.x2 * x;
            ableitung2 = Vf2 * (termB2 * termA2Der - termB2Der * termA2) / Math.pow(termB2, 2.0);
            rv = ableitung + ableitung2;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return rv;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public String getESU() {
        return null;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        try {
            double Term1 = this.x1 * x * (1.0 + this.C1 * (this.TD / x) + Math.pow(this.C2 * (this.TD / x), 2.0)) / (1.0 + this.C3 * (this.TD / x) + Math.pow(this.C4 * (this.TD / x), 2.0) + Math.pow(this.C5 * (this.TD / x), 3.0) + Math.pow(this.C6 * (this.TD / x), 4.0) + this.C2 * (5.0 / Math.pow(Math.PI, 4.0)) * Math.pow(this.TD / x, 5.0));
            double Term2 = this.x2 * x * (1.0 + this.C1 * (this.TD2 / x) + Math.pow(this.C2 * (this.TD2 / x), 2.0)) / (1.0 + this.C3 * (this.TD2 / x) + Math.pow(this.C4 * (this.TD2 / x), 2.0) + Math.pow(this.C5 * (this.TD2 / x), 3.0) + Math.pow(this.C6 * (this.TD2 / x), 4.0) + this.C2 * (5.0 / Math.pow(Math.PI, 4.0)) * Math.pow(this.TD2 / x, 5.0));
            Term1 = x * this.x1 * (1.0 + this.C1 * (this.TD / x) + this.C2 * (this.TD * this.TD / x * x)) / (1.0 + this.C3 * (this.TD / x) + this.C4 * (this.TD * this.TD / x * x) + this.C5 * (Math.pow(this.TD, 3.0) / Math.pow(x, 3.0)) + this.C6 * (Math.pow(this.TD, 4.0) / Math.pow(x, 4.0)) + 5.0 * this.C2 / Math.pow(Math.PI, 4.0) * (Math.pow(this.TD, 5.0) / Math.pow(x, 5.0)));
            Term2 = x * this.x2 * (1.0 + this.C1 * (this.TD2 / x) + this.C2 * (this.TD2 * this.TD2 / x * x)) / (1.0 + this.C3 * (this.TD2 / x) + this.C4 * (this.TD2 * this.TD2 / x * x) + this.C5 * (Math.pow(this.TD2, 3.0) / Math.pow(x, 3.0)) + this.C6 * (Math.pow(this.TD2, 4.0) / Math.pow(x, 4.0)) + 5.0 * this.C2 / Math.pow(Math.PI, 4.0) * (Math.pow(this.TD2, 5.0) / Math.pow(x, 5.0)));
            double xTerm1 = this.TD / x;
            double xTerm2 = this.TD2 / x;
            Term1 = x * this.x1 * (1.0 + this.C1 * xTerm1 + this.C2 * Math.pow(xTerm1, 2.0)) / (1.0 + this.C3 * xTerm1 + this.C4 * Math.pow(xTerm1, 2.0) + this.C5 * Math.pow(xTerm1, 3.0) + this.C6 * Math.pow(xTerm1, 4.0) + this.C2 * (5.0 / Math.pow(Math.PI, 4.0)) * Math.pow(xTerm1, 5.0));
            Term2 = x * this.x2 * (1.0 + this.C1 * xTerm2 + this.C2 * Math.pow(xTerm2, 2.0)) / (1.0 + this.C3 * xTerm2 + this.C4 * Math.pow(xTerm2, 2.0) + this.C5 * Math.pow(xTerm2, 3.0) + this.C6 * Math.pow(xTerm2, 4.0) + this.C2 * (5.0 / Math.pow(Math.PI, 4.0)) * Math.pow(xTerm2, 5.0));
            funktionsWert = this.a0 + Term1 + Term2;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "Approximation of 2-Term Debye-Fct";
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 50.0;
        DebyeFct2Term debyeFct2Term = new DebyeFct2Term(5.51546, 300.0, 800.0, 5.0E16, 2.5E16, eLatticeName.a);
        System.out.println("Funktionswert 2-Term-Debyefunktion an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + debyeFct2Term.getValue(x));
        System.out.println("Ableitung:");
        System.out.println("Funktionswert der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f'(" + x + ")=" + debyeFct2Term.getDerivative(x));
        System.out.println();
    }
}

