/*
 * Decompiled with CFR 0.152.
 */
package myObjects.functions;

import myObjects.eLatticeName;
import myObjects.functions.EinsteinFct;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class DebyeFct
implements IFunctions {
    private double kb = 1.3806488E-23;
    private double C1 = -0.07713;
    private double C2 = 0.02433;
    private double C3 = 0.30548;
    private double C4 = 0.06513;
    private double C5 = 0.03487;
    private double C6 = -0.00324;
    public double a0 = 5.51546;
    public double TD = 200.0;
    public double x1 = 6.0E16;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(EinsteinFct.class);

    public DebyeFct(double pa0, double pTD, double px1, eLatticeName _lattName) {
        this.a0 = pa0;
        this.TD = pTD;
        this.x1 = px1;
        this.ParamName = _lattName;
    }

    @Override
    public double getDerivative(double x) {
        double ableitung = 0.0;
        try {
            double xTerm = this.TD / x;
            double termA = 1.0 + this.C1 * xTerm + this.C2 * Math.pow(xTerm, 2.0);
            double termB = 1.0 + this.C3 * xTerm + this.C4 * Math.pow(xTerm, 2.0) + this.C5 * Math.pow(xTerm, 3.0) + this.C6 * Math.pow(xTerm, 4.0) + this.C2 * 5.0 / Math.pow(Math.PI, 4.0) * Math.pow(xTerm, 5.0);
            double termADer = 2.0 * this.C2 * this.TD * this.TD / Math.pow(x, 3.0) - -this.C1 * this.TD / Math.pow(x, 2.0);
            double termBDer = -25.0 * this.C2 * Math.pow(this.TD, 5.0) / (Math.pow(Math.PI, 4.0) * Math.pow(x, 6.0)) - 4.0 * this.C6 * Math.pow(this.TD, 4.0) / Math.pow(x, 5.0) - 3.0 * this.C5 * Math.pow(this.TD, 3.0) / Math.pow(x, 4.0) - 2.0 * this.C4 * Math.pow(this.TD, 2.0) / Math.pow(x, 3.0) - this.C3 * this.TD / Math.pow(x, 2.0);
            double Vf = x * this.x1;
            ableitung = Vf * (termB * termADer - termBDer * termA) / Math.pow(termB, 2.0);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return ableitung;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public String getESU() {
        return null;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        try {
            double xTerm = this.TD / x;
            funktionsWert = this.a0 + this.x1 * x * (1.0 + this.C1 * xTerm + this.C2 * Math.pow(xTerm, 2.0)) / (1.0 + this.C3 * xTerm + this.C4 * Math.pow(xTerm, 2.0) + this.C5 * Math.pow(xTerm, 3.0) + this.C6 * Math.pow(xTerm, 4.0) + this.C2 * (5.0 / Math.pow(Math.PI, 4.0)) * Math.pow(xTerm, 5.0));
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "Approximation of Debye-Fct";
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 50.0;
        DebyeFct debyeFct = new DebyeFct(5.51546, 200.0, 6.0E16, eLatticeName.a);
        double t1 = 33.0;
        double t2 = Math.pow(5.0, 2.0);
        System.out.println("Funktionswert Debyefunktion an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + debyeFct.getValue(x));
        System.out.println("Ableitung:");
        System.out.println("Funktionswert der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f'(" + x + ")=" + debyeFct.getDerivative(x));
        System.out.println();
        System.out.println("TD^2/x^2:" + t1);
        System.out.println("(TD/x)^2:" + t2);
    }
}

