/*
 * Decompiled with CFR 0.152.
 */
package myObjects.functions;

import myObjects.eLatticeName;
import myObjects.functions.EinsteinFct;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class DebyeEinsteinAnharmFct
implements IFunctions {
    private double kb = 1.3806487999999998E-23;
    private double C1 = -0.07713;
    private double C2 = 0.02433;
    private double C3 = 0.30548;
    private double C4 = 0.06513;
    private double C5 = 0.03487;
    private double C6 = -0.00324;
    public double a0 = 5.51546;
    public double TD = 200.0;
    public double x1 = 11.0;
    public double x2 = -11.0;
    public double x3 = -2.0;
    public double TE = 110.0;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(EinsteinFct.class);

    public DebyeEinsteinAnharmFct(double px1, double px2, double px3, double pa0, double pTD, double pTE, eLatticeName _lattName) {
        this.a0 = pa0;
        this.TD = pTD;
        this.x1 = px1;
        this.x2 = px2;
        this.x3 = px3;
        this.TE = pTE;
        this.ParamName = _lattName;
    }

    @Override
    public double getDerivative(double x) {
        double debyeDer = 0.0;
        double einsteinDer = 0.0;
        double AnharmDer = 0.0;
        double ableitung = 0.0;
        try {
            double termA = 1.0 + this.C1 * this.TD / x + this.C2 * Math.pow(this.TD, 2.0) / Math.pow(x, 2.0);
            double termB = 1.0 + this.C3 * this.TD / x + this.C4 * Math.pow(this.TD, 2.0) / Math.pow(x, 2.0) + this.C5 * Math.pow(this.TD, 3.0) / Math.pow(x, 3.0) + this.C6 * Math.pow(this.TD, 4.0) / Math.pow(x, 4.0) + this.C2 * 5.0 / Math.pow(Math.PI, 4.0) * (Math.pow(this.TD, 5.0) / Math.pow(x, 5.0));
            double termADer = 2.0 * this.C2 * this.TD * this.TD / Math.pow(x, 3.0) - -this.C1 * this.TD / Math.pow(x, 2.0);
            double termBDer = -25.0 * this.C2 * Math.pow(this.TD, 5.0) / (Math.pow(Math.PI, 4.0) * Math.pow(x, 6.0)) - 4.0 * this.C6 * Math.pow(this.TD, 4.0) / Math.pow(x, 5.0) - 3.0 * this.C5 * Math.pow(this.TD, 3.0) / Math.pow(x, 4.0) - 2.0 * this.C4 * Math.pow(this.TD, 2.0) / Math.pow(x, 3.0) - this.C3 * this.TD / Math.pow(x, 2.0);
            double Vf = x * this.x1;
            debyeDer = Vf * (termB * termADer - termBDer * termA) / Math.pow(termB, 2.0);
            System.out.println("Debye-Term");
            System.out.println(String.valueOf(debyeDer) + "\n");
            einsteinDer = this.x2 * this.TE * this.TE * Math.exp(this.TE / x) / (Math.pow(-1.0 + Math.exp(this.TE / x), 2.0) * Math.pow(x, 2.0));
            System.out.println("Einstein-Term");
            System.out.println(String.valueOf(einsteinDer) + "\n");
            double termA1 = Math.pow(this.TD, 2.0) * this.x3 * Math.exp(this.TD / x) * (x * Math.exp(3.0 * this.TD / x) + 9.0 * x * Math.exp(2.0 * this.TD / x) - 12.0 * this.TD * Math.exp(2.0 * this.TD / x) - 9.0 * x * Math.exp(this.TD / x) - 12.0 * this.TD * Math.exp(this.TD / x) - x);
            double termB1 = 8.0 * Math.pow(x, 3.0) * Math.pow(Math.exp(this.TD / x) - 1.0, 4.0);
            double termA2 = this.TD * this.x3 * (x * Math.exp(3.0 * this.TD / x) + 9.0 * x * Math.exp(2.0 * this.TD / x) - 12.0 * this.TD * Math.exp(2.0 * this.TD / x) - 9.0 * x * Math.exp(this.TD / x) - 12.0 * this.TD * Math.exp(this.TD / x) - x);
            double termB2 = 24.0 * Math.pow(x, 2.0) * Math.pow(Math.exp(this.TD / x) - 1.0, 3.0);
            double termA3 = this.TD * this.x3 * (-3.0 * this.TD * Math.exp(3.0 * this.TD / x) / x + Math.exp(3.0 * this.TD / x) - 18.0 * this.TD * Math.exp(2.0 * this.TD / x) / x + 24.0 * Math.pow(this.TD, 2.0) * Math.exp(2.0 * this.TD / x) / x * x + 9.0 * Math.exp(2.0 * this.TD / x) + 9.0 * this.TD * Math.exp(this.TD / x) / x + 12.0 * this.TD * this.TD * Math.exp(this.TD / x) / x * x - 9.0 * Math.exp(this.TD / x) - 1.0);
            double termB3 = 24.0 * x * Math.pow(Math.exp(this.TD / x) - 1.0, 3.0);
            double quot1 = termA1 / termB1;
            double quot2 = termA2 / termB2;
            double quot3 = termA3 / termB3;
            AnharmDer = quot1 - quot2 + quot3;
            System.out.println("Anharmonischer-Term");
            System.out.println(String.valueOf(AnharmDer) + "\n");
            ableitung = debyeDer + einsteinDer + AnharmDer;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return ableitung;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public String getESU() {
        return null;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        double debye = 0.0;
        double einstein = 0.0;
        double anharmonic = 0.0;
        try {
            debye = x * (1.0 + this.C1 * (this.TD / x) + this.C2 * (this.TD * this.TD / x * x)) / (1.0 + this.C3 * (this.TD / x) + this.C4 * (this.TD * this.TD / x * x) + this.C5 * (Math.pow(this.TD, 3.0) / Math.pow(x, 3.0)) + this.C6 * (Math.pow(this.TD, 4.0) / Math.pow(x, 4.0)) + 5.0 * this.C2 / Math.pow(Math.PI, 4.0) * (Math.pow(this.TD, 5.0) / Math.pow(x, 5.0)));
            einstein = this.TE / (Math.exp(this.TE / x) - 1.0);
            double AnTerm = Math.exp(this.TD / x) - 1.0;
            anharmonic = this.TD / x * (x * Math.exp(3.0 * this.TD / x) + 9.0 * x * Math.exp(2.0 * this.TD / x) - 12.0 * this.TD * Math.exp(this.TD / x) - 9.0 * x * Math.exp(this.TD / x) - 12.0 * this.TD * Math.exp(this.TD / x) - x) / Math.pow(AnTerm, 3.0);
            funktionsWert = this.a0 + this.x1 * debye + this.x2 * einstein + this.x3 * anharmonic;
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "f(T)=" + Double.toString(this.a0) + "+(" + Double.toString(this.TE) + "/(exp(" + Double.toString(this.TE) + "/T)-1))";
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 50.0;
        DebyeEinsteinAnharmFct DebEinAnhFct = new DebyeEinsteinAnharmFct(7.25497, 7.25497, -6.94748, 10.3235, 862.676, 120.973, eLatticeName.a);
        System.out.println("Funktionswert Debye-Einstein-Anharmonic-Funktion an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + DebEinAnhFct.getValue(x));
        System.out.println("Ableitung:");
        System.out.println("Funktionswert der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f'(" + x + ")=" + DebEinAnhFct.getDerivative(x));
        System.out.println();
    }
}

