/*
 * Decompiled with CFR 0.152.
 */
package myObjects.functions;

import myObjects.eLatticeName;
import myObjects.functions.EinsteinFct;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class CosFct
implements IFunctions {
    public double angle0 = 117.0;
    public double A = 0.01;
    public double B = 110.0;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(EinsteinFct.class);

    public CosFct(double pAngle0, double pA, double pB, eLatticeName _lattName) {
        this.angle0 = pAngle0;
        this.A = pA;
        this.B = pB;
        this.ParamName = _lattName;
    }

    @Override
    public double getDerivative(double x) {
        double ableitung = 0.0;
        try {
            ableitung = -this.A * this.B * Math.sin(this.B * x);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return ableitung;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public int getDegree() {
        return 0;
    }

    @Override
    public String getESU() {
        return null;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        try {
            funktionsWert = this.angle0 + this.A * Math.cos(this.B * x);
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "f(T)=" + Double.toString(this.angle0) + "+(" + Double.toString(this.A) + " * cos(" + Double.toString(this.B) + " * T))";
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 50.0;
        CosFct cosFct = new CosFct(118.5, 0.01, 0.015, eLatticeName.beta);
        System.out.println(cosFct.toString());
        System.out.println("Funktionswert Cosinusfunktion an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + cosFct.getValue(x));
        System.out.println("Ableitung:");
        System.out.println("Funktionswert der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f'(" + x + ")=" + cosFct.getDerivative(x));
        System.out.println();
    }
}

