/*
 * Decompiled with CFR 0.152.
 */
package myObjects;

import java.math.BigDecimal;
import java.math.RoundingMode;
import myObjects.eLatticeName;
import myObjects.functions.IFunctions;
import org.apache.log4j.Logger;

public class Polynom
implements IFunctions {
    public double[] koeffizienten = new double[]{0.0};
    public String sESU = null;
    public eLatticeName ParamName;
    static Logger logger = Logger.getLogger(Polynom.class);

    public Polynom(double[] koeffizienten, eLatticeName _lattName) {
        this.koeffizienten = koeffizienten;
        this.ParamName = _lattName;
    }

    public Polynom(double[] koeffizienten, String sESU, eLatticeName _lattName) {
        this.koeffizienten = koeffizienten;
        this.sESU = sESU;
        this.ParamName = _lattName;
    }

    @Override
    public eLatticeName getParam() {
        return this.ParamName;
    }

    @Override
    public double getDerivative(double x) {
        double rv;
        block4: {
            rv = 0.0;
            try {
                if (this.getDegree() > 0) {
                    double[] koeffizientenDerAbleitung = new double[this.koeffizienten.length - 1];
                    int i = 1;
                    while (i < this.koeffizienten.length) {
                        koeffizientenDerAbleitung[i - 1] = this.koeffizienten[i] * (double)i;
                        ++i;
                    }
                    Polynom ableitung = new Polynom(koeffizientenDerAbleitung, this.ParamName);
                    rv = ableitung.getValue(x);
                    break block4;
                }
                throw new Exception("Derivative not possible!");
            }
            catch (Exception _ex) {
                logger.error((Object)_ex.getMessage());
            }
        }
        return rv;
    }

    @Override
    public double getValue(double x) {
        double funktionsWert = 0.0;
        try {
            int i = this.getDegree();
            while (i >= 0) {
                funktionsWert *= x;
                funktionsWert += this.getKoeffizient(i);
                --i;
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return funktionsWert;
    }

    @Override
    public int getDegree() {
        return this.koeffizienten.length - 1;
    }

    public double getKoeffizient(int stelle) {
        return this.koeffizienten[stelle];
    }

    @Override
    public String toString() {
        String s = null;
        try {
            s = "f(T)=";
            if (this.getDegree() < 0) {
                s = "ERROR: Grad negativ!";
            }
            if (this.getDegree() == 0) {
                s = String.valueOf(s) + String.valueOf(this.koeffizienten[0]);
            }
            if (this.getDegree() > 0) {
                int i = 0;
                while (i <= this.getDegree()) {
                    if (this.koeffizienten[i] != 0.0) {
                        if (i > 0) {
                            if (this.koeffizienten[i] > 0.0) {
                                s = String.valueOf(s) + " + ";
                            }
                            if (this.koeffizienten[i] < 0.0) {
                                s = String.valueOf(s) + " ";
                            }
                        }
                        s = String.valueOf(s) + Polynom.round(this.koeffizienten[i], 4, RoundingMode.HALF_DOWN);
                        if (i > 1) {
                            s = String.valueOf(s) + "*T^" + String.valueOf(i);
                        } else if (i == 1) {
                            s = String.valueOf(s) + "*T";
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception _ex) {
            logger.error((Object)_ex.getMessage());
        }
        return s;
    }

    public static void main(String[] args) {
        double x = 260.0;
        double[] test1 = new double[]{6.8003, -6.1987E-5, 1.2117E-7, -1.6016E-10};
        Polynom poly1 = new Polynom(test1, eLatticeName.a);
        System.out.println("Polynom " + poly1.getDegree() + ". Grades");
        System.out.println(poly1);
        System.out.println("Funktionswert an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + poly1.getValue(x));
        System.out.println("Ableitung:");
        System.out.println();
        System.out.println("Funktionswert NEU der Ableitung an der Stelle: " + x + " betr\u00e4gt: \n" + "f(" + x + ")=" + poly1.getDerivative(x));
        System.out.println();
    }

    public static double round(double d, int scale, RoundingMode mode) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d;
        }
        scale = Math.max(scale, 0);
        BigDecimal bd = BigDecimal.valueOf(d);
        BigDecimal bc = new BigDecimal(bd.unscaledValue(), bd.precision() - 1);
        return bc.setScale(scale, mode).scaleByPowerOfTen(bc.scale() - bd.scale()).doubleValue();
    }

    @Override
    public String getESU() {
        return this.sESU;
    }

    public void setsESU(String pESU) {
        this.sESU = pESU;
    }
}

