
%% ************* Functions when loading interface *************
function varargout = PrincipalMovementAnalyzer(varargin)
% PRINCIPALMOVEMENTANALYZER MATLAB code for PrincipalMovementAnalyzer.fig
%      PRINCIPALMOVEMENTANALYZER, by itself, creates a new PRINCIPALMOVEMENTANALYZER or raises the existing
%      singleton*.
%
%      H = PRINCIPALMOVEMENTANALYZER returns the handle to a new PRINCIPALMOVEMENTANALYZER or the handle to
%      the existing singleton*.
%
%      PRINCIPALMOVEMENTANALYZER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in PRINCIPALMOVEMENTANALYZER.M with the given input arguments.
%
%      PRINCIPALMOVEMENTANALYZER('Property','Value',...) creates a new PRINCIPALMOVEMENTANALYZER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before PrincipalMovementAnalyzer_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to PrincipalMovementAnalyzer_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help PrincipalMovementAnalyzer

% Last Modified by GUIDE v2.5 08-Mar-2018 17:36:46

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @PrincipalMovementAnalyzer_OpeningFcn, ...
    'gui_OutputFcn',  @PrincipalMovementAnalyzer_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before PrincipalMovementAnalyzer is made visible.
function PrincipalMovementAnalyzer_OpeningFcn(hObject, ~, handles, varargin)
% hObject    handle to figure
% varargin   command line arguments to PrincipalMovementAnalyzer (see VARARGIN)

% Add "core" and "extra" functions to the Matlab path
folder_containing_GUI = pwd;
addpath(genpath(folder_containing_GUI))

% Strings that must be set to have no spaces or second lines!
set(handles.editSettingsName,   'String', 'NoSpaceNames')
set(handles.editSaveData,       'String', 'DataReadin')
set(handles.editSavePcaData,    'String', 'DataPCA')
set(handles.editSavePCAvars,    'String', 'ComputedVariables')
% Load pre-processing, normalization, weight and coloring options
[~, ~, AvailablePreProcessings] = optionsPreProcessing();
[~,~,  AvailableNormalizations] = optionsNormalization();
[~,~,   AvailableWeightOptions] = optionsWeights();
[~,   AvailableColoringOptions] = optionsColoringVids();
[~,  AvailableTransformOptions] = optionsTransformData();

set(handles.pupmenPreProcessing,'String', AvailablePreProcessings)
set(handles.pupmenNORMALIZATION,'String', AvailableNormalizations)
set(handles.pupmenWEIGHTS,      'String', AvailableWeightOptions)
set(handles.pupmenCOLORINGvideo,'String', AvailableColoringOptions)
set(handles.pupmenKERNEL,       'String', AvailableTransformOptions)

[~, PersonalizedPlotNames] = personalizedPlots();

for persPl = 1:10
    set(handles.(['chbPlotPersonalized', num2str(persPl)]),'String', PersonalizedPlotNames(persPl,:))
end





% Check if settings are ok
settings_check_Callback(0, 0, handles)
pupmenPLOTlimits_Callback(0, 0, handles)


handles.output = hObject;
% Update handles structure
guidata(hObject, handles);


% --- Outputs from this function are returned to the command line.
function varargout = PrincipalMovementAnalyzer_OutputFcn(~, ~, handles)
varargout{1} = handles.output;






% ************* Functions that regulate interface settings *************
% Main Popupmenus
function pupmenREADIN_Callback(~, ~, handles)
if get(handles.pupmenREADIN, 'Value') == 1
    if get(handles.pupmenPCAcomp, 'Value') == 2
        set(handles.pupmenPCAcomp, 'Value', 3)
    end
elseif get(handles.pupmenREADIN, 'Value') == 2
    if get(handles.pupmenPCAcomp, 'Value') == 3
        set(handles.pupmenPCAcomp, 'Value', 2)
    end
elseif get(handles.pupmenREADIN, 'Value') == 3
    if sum(get(handles.pupmenPCAcomp, 'Value') == [1,3]) == 1
        set(handles.pupmenPCAcomp, 'Value', 2)
        if get(handles.pupmenVARIABLESCOMP, 'Value') == 3
            set(handles.pupmenVARIABLESCOMP, 'Value', 2)
        end
    end
else
    set(handles.pupmenREADIN, 'Value', 1)
    msgbox('There is no other readin option! Selection set to "No Readin"!')
end
% Call main five popupmenus to check settings
settings_check_Callback(0, 0, handles)



function pupmenPCAcomp_Callback(~, ~, handles)
if get(handles.pupmenPCAcomp, 'Value') == 1
    set(handles.pupmenREADIN, 'Value', 1)
    if get(handles.pupmenVARIABLESCOMP, 'Value')== 2
        set(handles.pupmenVARIABLESCOMP, 'Value', 3)
    end
elseif get(handles.pupmenPCAcomp, 'Value') == 2
    if get(handles.pupmenREADIN, 'Value') == 1
        set(handles.pupmenREADIN, 'Value', 3)
    end
    if get(handles.pupmenVARIABLESCOMP, 'Value') == 3
        set(handles.pupmenVARIABLESCOMP, 'Value', 2)
    end
elseif get(handles.pupmenPCAcomp, 'Value') == 3
    if sum(get(handles.pupmenREADIN, 'Value') == [2,3]) == 1
        set(handles.pupmenREADIN, 'Value', 1)
    end
    if get(handles.pupmenVARIABLESCOMP, 'Value') == 3
        set(handles.pupmenVARIABLESCOMP, 'Value', 2)
    end
else
    set(handles.pupmenPCAcomp, 'Value', 1)
    msgbox('There is no other PCA-computation option! Selection set to "No PCA-computation"!')
end
% Call main five popupmenus to check settings
settings_check_Callback(0, 0, handles)


function pupmenVARIABLESCOMP_Callback(~, ~, handles)
if get(handles.pupmenVARIABLESCOMP, 'Value') == 1
    set(handles.pupmenPLOTS, 'Value', 1)
    set(handles.pupmenVIDEOmake, 'Value', 1)
    if get(handles.pupmenPCAcomp, 'Value') == 3
        set(handles.pupmenPCAcomp, 'Value', 1)
    end
elseif get(handles.pupmenVARIABLESCOMP, 'Value') == 2
    if get(handles.pupmenPCAcomp, 'Value') == 1
        set(handles.pupmenPCAcomp, 'Value', 3)
    end
elseif get(handles.pupmenVARIABLESCOMP, 'Value') == 3
    if sum(get(handles.pupmenPCAcomp, 'Value') == [2,3]) == 1
        set(handles.pupmenPCAcomp, 'Value', 1)
        set(handles.pupmenREADIN, 'Value', 1)
    end
else
    set(handles.pupmenPCAcomp, 'Value', 1)
    msgbox('There is no other PCA-variables option! Selection set to "No PCA-variables computation"!')
end
% Call main five popupmenus to check settings
settings_check_Callback(0, 0, handles)



function pupmenPLOTS_Callback(~, ~, handles)
if get(handles.pupmenPLOTS, 'Value') == 1
elseif get(handles.pupmenPLOTS, 'Value') == 2
    if get(handles.pupmenVARIABLESCOMP, 'Value') == 1
        if get(handles.pupmenPCAcomp, 'Value') == 1
            if get(handles.pupmenREADIN, 'Value') == 1
                set(handles.pupmenVARIABLESCOMP, 'Value', 3)
            elseif get(handles.pupmenREADIN, 'Value') == 2
                set(handles.pupmenPCAcomp, 'Value', 2)
                set(handles.pupmenVARIABLESCOMP, 'Value', 2)
            end
        elseif get(handles.pupmenPCAcomp, 'Value') == 2
            set(handles.pupmenVARIABLESCOMP, 'Value', 2)
        elseif get(handles.pupmenPCAcomp, 'Value') == 3
            set(handles.pupmenVARIABLESCOMP, 'Value', 2)
        end
    end
else
    set(handles.pupmenPLOTS, 'Value', 1)
    msgbox('There is no other plot option! Selection set to "No Plots made"!')
end
% Call main five popupmenus to check settings
settings_check_Callback(0, 0, handles)


function pupmenVIDEOmake_Callback(~, ~, handles)
if get(handles.pupmenVIDEOmake, 'Value') == 1
elseif sum(get(handles.pupmenVIDEOmake, 'Value') == [2,3]) == 1
    if get(handles.pupmenVARIABLESCOMP, 'Value') == 1
        if get(handles.pupmenPCAcomp, 'Value') == 1
            if get(handles.pupmenREADIN, 'Value') == 1
                set(handles.pupmenVARIABLESCOMP, 'Value', 3)
            elseif get(handles.pupmenREADIN, 'Value') == 2
                set(handles.pupmenPCAcomp, 'Value', 2)
                set(handles.pupmenVARIABLESCOMP, 'Value', 2)
            end
        elseif get(handles.pupmenPCAcomp, 'Value') == 2
            set(handles.pupmenVARIABLESCOMP, 'Value', 2)
        elseif get(handles.pupmenPCAcomp, 'Value') == 3
            set(handles.pupmenVARIABLESCOMP, 'Value', 2)
        end
    end
else
    set(handles.pupmenVIDEOmake, 'Value', 1)
    msgbox('There is no other video option! Selection set to "No videos made"!')
end
% Call main five popupmenus to check settings
settings_check_Callback(0, 0, handles)



% Function that calls the other five main popups to regulate settings
function settings_check_Callback(~, ~, handles)
%% Settings that depend on readin popupmenu
if sum(get(handles.pupmenREADIN, 'Value') == [1,3]) == 1
    OnOff = 'off';
    set(handles.chbSaveData, 'String', 'Load read in data:')
elseif get(handles.pupmenREADIN, 'Value') == 2
    OnOff = 'on';
    set(handles.chbSaveData, 'String', 'Save read in data as:')
end

% Enable/Disable the whole input data panel according to readin popupmenu
PanReadinChildren = get(handles.panelINPUT, 'Children');
for pan = 1:size(PanReadinChildren,1)
    SubPanChildren = get(PanReadinChildren(pan,1), 'Children');
    for subpan = 1:size(SubPanChildren,1)
        set(SubPanChildren(subpan,1), 'enable', OnOff)
    end
end


% Always enable these items in the input data panel
set(handles.pupmenREADIN, 'enable', 'on')
set(handles.pushbutHelpReadin, 'enable', 'on')
set(handles.txtPATHFolderData, 'enable', 'on')
set(handles.editPATHFolderData, 'enable', 'on')

% Call checkboxes that influence enabling of edit boxes
if get(handles.pupmenREADIN, 'Value') == 2
    chbDeleteMarkers_Callback(0, 0, handles)
    chbDeleteColumns_Callback(0, 0, handles)
    chbDeleteRows_Callback(0, 0, handles)
    chbSpecificDataTreatment_Callback(0, 0, handles)
    chbSaveData_Callback(0, 0, handles)
end


%% Settings that depend on PCA computation-popupmenu
if sum(get(handles.pupmenPCAcomp, 'Value') == [1,3]) == 1
    OnOff = 'off';
    set(handles.chbSavePcaData, 'String', 'Load read in data:')
elseif get(handles.pupmenPCAcomp, 'Value') == 2
    OnOff = 'on';
    set(handles.chbSavePcaData, 'String', 'Save PCA - data as:')
else
end

% Enable/Disable PCA panel items according to selected
subPanPCAChildren = get(handles.pan21PCA, 'Children');
for subpan = 1:size(subPanPCAChildren,1)
    set(subPanPCAChildren(subpan,1), 'enable', OnOff)
end

% Enable/Disable computation and output panel items according to selected
if get(handles.pupmenPCAcomp, 'Value') == 2
    chbSavePcaData_Callback(0,0,handles)
end


%% Settings that depend on PCA-variables computation popupmenu
if get(handles.pupmenVARIABLESCOMP, 'Value') == 1
    OnOff = 'off';
    set(handles.chbSavePCAvars, 'String', 'Load Variable/Video data:')
    set(handles.chbComputeSelfdefinedVariables, 'enable', OnOff)
elseif get(handles.pupmenVARIABLESCOMP, 'Value') == 2
    OnOff = 'on';
    set(handles.chbSavePCAvars, 'String', 'Save Variable/Video data:')
    set(handles.chbComputeSelfdefinedVariables, 'enable', OnOff)
elseif get(handles.pupmenVARIABLESCOMP, 'Value') == 3
    OnOff = 'on';  
    set(handles.chbSavePCAvars, 'String', 'Load Variable/Video data:')
    set(handles.chbComputeSelfdefinedVariables, 'enable', 'off')
end

chbComputeSelfdefinedVariables_Callback(0,0,handles)


set(handles.chbExcelOutput, 'enable', OnOff)
set(handles.chbSavePCAvars, 'enable', OnOff)
set(handles.editSavePCAvars, 'enable', OnOff)
if get(handles.pupmenPCAcomp, 'Value') == 2
    chbSavePCAvars_Callback(0,0,handles)
end


%% Settings that depend on Plots-popupmenu
if get(handles.pupmenPLOTS, 'Value') == 1
    OnOff = 'off';
elseif get(handles.pupmenPLOTS, 'Value') == 2
    OnOff = 'on';
else
end
subPanPCAplotsChildren = get(handles.subpanelPCAplots, 'Children');
for subpan = 1:size(subPanPCAplotsChildren,1)
    set(subPanPCAplotsChildren(subpan,1), 'enable', OnOff)
end
subPanPCApersplotsChildren = get(handles.panelPersplots, 'Children');
for subpan = 1:size(subPanPCApersplotsChildren,1)
    set(subPanPCApersplotsChildren(subpan,1), 'enable', OnOff)
end

if get(handles.pupmenPLOTS, 'Value') == 2
    chbPlotScoreplots_Callback(0,0,handles)
    chbPlotEVsubjectSpecific_Callback(0, 0, handles)
end

%% Settings that depend on Video-popupmenu
if get(handles.pupmenVIDEOmake, 'Value') == 1
    OnOff = 'off';
elseif sum(get(handles.pupmenVIDEOmake, 'Value') == [2, 3]) == 1
    OnOff = 'on';
else
end
subPanSubTrialVidChildren = get(handles.subpanSubTrialVidSel, 'Children');
for subpan = 1:size(subPanSubTrialVidChildren,1)
    set(subPanSubTrialVidChildren(subpan,1), 'enable', OnOff)
end
subpanVidTypeChildren = get(handles.subpanVidType, 'Children');
for subpan = 1:size(subpanVidTypeChildren,1)
    set(subpanVidTypeChildren(subpan,1), 'enable', OnOff)
end
subPanVidSettingsChildren = get(handles.subpanVidSettings, 'Children');
for subpan = 1:size(subPanVidSettingsChildren,1)
    set(subPanVidSettingsChildren(subpan,1), 'enable', OnOff)
end
if sum(get(handles.pupmenVIDEOmake, 'Value') == [2, 3]) == 1
    % If not PC videos are computed also no amplification factors are needed
    if  get(handles.chbPMVidVis, 'Value') == 0 && get(handles.chbVidMakePCvid, 'Value') == 0 && get(handles.chbVidMakePMcombination, 'Value') == 0
        OnOff = 'off'; % Disable the "amplification panel"
        set(handles.pupmenAXESsettings, 'HandleVisibility', 'off')
        set(handles.pupmenCOLORINGvideo, 'HandleVisibility', 'off')
        subPanVidSettingsChildren = get(handles.subpanVidSettings, 'Children');
        for subpan = 1:size(subPanVidSettingsChildren,1)
            set(subPanVidSettingsChildren(subpan,1), 'enable', OnOff)
        end
        set(handles.pupmenAXESsettings, 'HandleVisibility', 'on')
        set(handles.pupmenCOLORINGvideo, 'HandleVisibility', 'on') 
        set(handles.editVidPMampFactorsVisualization, 'enable', 'off') % Changed to one amp fac
        set(handles.txtVidPMampFactorsVisualization, 'enable', 'off') % was deleted
        set(handles.txtVideoPCs, 'enable', 'off')
        set(handles.editVideoPCs, 'enable', 'off')
        set(handles.txtVideoPCperFigure, 'enable', 'off')
        set(handles.editVideoPCperFigure, 'enable', 'off')

    else
        set(handles.editVidPMampFactorsVisualization, 'enable', 'on') % Changed to one amp fac
        set(handles.txtVidPMampFactorsVisualization, 'enable', 'on') % was deleted
        if get(handles.chbPMVidVis, 'Value') == 0 && get(handles.chbVidMakePMcombination, 'Value') == 0
            VisOnOff = 'off';
        else 
            VisOnOff = 'on';
        end
        set(handles.editVidMotionRange, 'enable', VisOnOff)
        set(handles.txtVidMotionRange, 'enable', VisOnOff)
        set(handles.editVidRunthroughsVisualization, 'enable', VisOnOff)
        set(handles.txtVidRunthroughsVisualization, 'enable', VisOnOff)
        set(handles.editVidNrPositionsVisualized, 'enable', VisOnOff)
        set(handles.txtVidNrPositionsVisualized, 'enable', VisOnOff)
        set(handles.txtVidPMampFactorsVisualization, 'enable', VisOnOff)% was deleted % Changed to one amp fac
        set(handles.txtVideoPCs, 'enable', 'on')
        set(handles.editVideoPCs, 'enable', 'on')
        set(handles.txtVideoPCperFigure, 'enable', 'on')
        set(handles.editVideoPCperFigure, 'enable', 'on')

        if get(handles.chbVidMakePCvid, 'Value') == 0 && get(handles.chbVidMakePMcombination, 'Value') == 0
            SubTrOnOff = 'off';
            if get(handles.chbVidMakeOriginalVid, 'Value') == 0
                set(handles.txtVideoSubjects, 'enable', SubTrOnOff)
                set(handles.editVideoSubjects, 'enable', SubTrOnOff)
                set(handles.txtVideoTrials, 'enable', SubTrOnOff)
                set(handles.editVideoTrials, 'enable', SubTrOnOff)
            end
        else
            SubTrOnOff = 'on';
        end
    end
    
    if get(handles.chbVidMakeOriginalVid, 'Value') == 1
        set(handles.txtVideoSubjects, 'enable', 'on')
        set(handles.editVideoSubjects, 'enable', 'on')
        set(handles.txtVideoTrials, 'enable', 'on')
        set(handles.editVideoTrials, 'enable', 'on')
    end
    
    if get(handles.chbVidMakePMcombination, 'Value') == 0
        set(handles.editVidMakePMcombination, 'enable', 'off')
    elseif get(handles.chbVidMakePMcombination, 'Value') == 1
        set(handles.editVidMakePMcombination, 'enable', 'on')
    end
    
 
    if get(handles.chbVidMakeOriginalVid, 'Value') == 0 && get(handles.chbVidMakePCvid, 'Value') == 0 && get(handles.chbVidMakePMcombination, 'Value') == 0
        set(handles.chbVidSkipFrames, 'Enable', 'off')
        set(handles.chbVidSkipFrames, 'Value', 0)
        set(handles.editVidSkipFrames, 'Enable', 'off')
    else
        set(handles.chbVidSkipFrames, 'Enable', 'on')
        set(handles.editVidSkipFrames, 'Enable', 'on')
    end
    
    if get(handles.chbVidSkipFrames, 'Value') == 0
        set(handles.editVidSkipFrames, 'enable', 'off')
    elseif get(handles.chbVidSkipFrames, 'Value') == 1
        set(handles.editVidSkipFrames, 'enable', 'on')
    end


end




% Checkboxes that regulate enabling/disabling of respective edit boxes
function chbDeleteMarkers_Callback(~, ~, handles)
if get(handles.chbDeleteMarkers, 'Value') == 0
    set(handles.editDeleteMarkers, 'enable', 'off')
elseif get(handles.chbDeleteMarkers, 'Value') == 1
    set(handles.editDeleteMarkers, 'enable', 'on')
end

function chbDeleteColumns_Callback(~, ~, handles)
if get(handles.chbDeleteColumns, 'Value') == 0
    set(handles.editDeleteColumns, 'enable', 'off')
elseif get(handles.chbDeleteColumns, 'Value') == 1
    set(handles.editDeleteColumns, 'enable', 'on')
end

function chbDeleteRows_Callback(~, ~, handles)
if get(handles.chbDeleteRows, 'Value') == 0
    set(handles.editDeleteRows, 'enable', 'off')
elseif get(handles.chbDeleteRows, 'Value') == 1
    set(handles.editDeleteRows, 'enable', 'on')
end

function chbSpecificDataTreatment_Callback(~, ~, handles)
if get(handles.chbSpecificDataTreatment, 'Value') == 0
    set(handles.pupmenPreProcessing, 'enable', 'off')
elseif get(handles.chbSpecificDataTreatment, 'Value') == 1
    set(handles.pupmenPreProcessing, 'enable', 'on')
end

function chbSaveData_Callback(~, ~, handles)
if get(handles.chbSaveData, 'Value') == 0
    if get(handles.pupmenREADIN, 'Value') == 2
       set(handles.editSaveData, 'enable', 'off')
    else
        set(handles.chbSaveData, 'Value', 1)
    end
elseif get(handles.chbSaveData, 'Value') == 1
    set(handles.editSaveData, 'enable', 'on')
end

function chbSavePcaData_Callback(~, ~, handles)
if get(handles.chbSavePcaData, 'Value') == 0 
    if get(handles.pupmenPCAcomp, 'Value') == 2
       set(handles.editSavePcaData, 'enable', 'off')
    else
        set(handles.chbSavePcaData, 'Value', 1)
    end
elseif get(handles.chbSavePcaData, 'Value') == 1
    set(handles.editSavePcaData, 'enable', 'on')
end

function chbSavePCAvars_Callback(~, ~, handles)
if get(handles.chbSavePCAvars, 'Value') == 0
    if get(handles.pupmenVARIABLESCOMP, 'Value') == 2
       set(handles.editSavePCAvars, 'enable', 'off')
    else
        set(handles.chbSavePCAvars, 'Value', 1)
    end
elseif get(handles.chbSavePCAvars, 'Value') == 1
    set(handles.editSavePCAvars, 'enable', 'on')
end

function chbPlotEVsubjectSpecific_Callback(~, ~, handles)
if get(handles.chbPlotEVsubjectSpecific, 'Value') == 0
    set(handles.editNumGroups, 'enable', 'off')
    set(handles.txtNumGroups, 'enable', 'off')
elseif get(handles.chbPlotEVsubjectSpecific, 'Value') == 1
    set(handles.editNumGroups, 'enable', 'on')
    set(handles.txtNumGroups, 'enable', 'on')
end

function chbPlotScoreplots_Callback(~, ~, handles)
if get(handles.chbPlotScoreplots, 'Value') == 0
    OnOff = 'off';
elseif get(handles.chbPlotScoreplots, 'Value') == 1
    OnOff = 'on';
end
set(handles.pupmenSavePlotAs, 'HandleVisibility', 'off')
set(handles.chbPlotEVoverall, 'HandleVisibility', 'off')
set(handles.chbPlotEVsubjectSpecific, 'HandleVisibility', 'off')
set(handles.editNumGroups, 'HandleVisibility', 'off')
set(handles.txtNumGroups, 'HandleVisibility', 'off')
set(handles.chbPlotScoreplots, 'HandleVisibility', 'off')
subPanPCAplotsChildren = get(handles.subpanelPCAplots, 'Children');
for subpan = 1:size(subPanPCAplotsChildren,1)
    set(subPanPCAplotsChildren(subpan,1), 'enable', OnOff)
end
set(handles.pupmenSavePlotAs, 'HandleVisibility', 'on')
set(handles.chbPlotEVoverall, 'HandleVisibility', 'on')
set(handles.chbPlotEVsubjectSpecific, 'HandleVisibility', 'on')
set(handles.editNumGroups, 'HandleVisibility', 'on')
set(handles.txtNumGroups, 'HandleVisibility', 'on')
set(handles.chbPlotScoreplots, 'HandleVisibility', 'on')

% Checkboxes for video computations
function chbVidMakeOriginalVid_Callback(~, ~, handles)
if get(handles.chbVidMakeOriginalVid, 'Value') == 0
    if get(handles.chbPMVidVis, 'Value') == 0 && get(handles.chbVidMakePCvid, 'Value') == 0 && get(handles.chbVidMakePMcombination, 'Value') == 0
        set(handles.chbPMVidVis, 'Value', 1)
    end
end
settings_check_Callback(0, 0, handles)

function chbPMVidVis_Callback(~, ~, handles)
if get(handles.chbPMVidVis, 'Value') == 0
    if  get(handles.chbVidMakeOriginalVid, 'Value') == 0 && get(handles.chbVidMakePCvid, 'Value') == 0 && get(handles.chbVidMakePMcombination, 'Value') == 0
        set(handles.chbVidMakePCvid, 'Value', 1)
    end
end
settings_check_Callback(0, 0, handles)

function chbVidMakePCvid_Callback(~, ~, handles)
if get(handles.chbVidMakePCvid, 'Value') == 0
    if get(handles.chbVidMakeOriginalVid, 'Value') == 0 && get(handles.chbPMVidVis, 'Value') == 0 && get(handles.chbVidMakePMcombination, 'Value') == 0
        set(handles.chbPMVidVis, 'Value', 1)
    end
end
settings_check_Callback(0, 0, handles)

function chbVidMakePMcombination_Callback(~, ~, handles)
if get(handles.chbVidMakePMcombination, 'Value') == 0
    if  get(handles.chbVidMakeOriginalVid, 'Value') == 0 && get(handles.chbPMVidVis, 'Value') == 0 &&get(handles.chbVidMakePCvid, 'Value') == 0
        set(handles.chbPMVidVis, 'Value', 1)
    end
    set(handles.editVidMakePMcombination, 'enable', 'off')
elseif get(handles.chbVidMakePMcombination, 'Value') == 1
    set(handles.editVidMakePMcombination, 'enable', 'on')
end
settings_check_Callback(0,0, handles)

function chbVidSkipFrames_Callback(~, ~, handles)
if get(handles.chbVidSkipFrames, 'Value') == 0
    set(handles.editVidSkipFrames, 'enable', 'off')
elseif get(handles.chbVidSkipFrames, 'Value') == 1
    set(handles.editVidSkipFrames, 'enable', 'on')
end
settings_check_Callback(0,0, handles)





% Sliders
function sliderUIPosition_Callback(~, ~, ~)

% Popupmenu for settings of plotting limits
function pupmenPLOTlimits_Callback(~, ~, handles)
if get(handles.pupmenPLOTlimits, 'Value')== 1
    set(handles.editPlotLimitPp, 'String', '4')
    set(handles.editPlotLimitPa, 'String', '8')
    set(handles.txtPlotLimitPp, 'String', '(PP - y limit)')
    set(handles.txtPlotLimitPa, 'String', '(PA - y limit)')
    
    set(handles.editPlotLimitPa, 'Visible', 'on')
    set(handles.txtPlotLimitPa,  'Visible', 'on')
elseif get(handles.pupmenPLOTlimits, 'Value') == 2
    set(handles.editPlotLimitPp, 'String', '.9')
    set(handles.txtPlotLimitPp, 'String', '(Part PM-max by)')
    
    set(handles.editPlotLimitPa, 'Visible', 'off')
    set(handles.txtPlotLimitPa,  'Visible', 'off')
elseif get(handles.pupmenPLOTlimits, 'Value') ==3
    set(handles.editPlotLimitPp, 'String', '.9')
    set(handles.txtPlotLimitPp, 'String', '(Part overall max by)')
    
    set(handles.editPlotLimitPa, 'Visible', 'off')
    set(handles.txtPlotLimitPa,  'Visible', 'off')
end



% ************* Functions for the UI pushbuttons *************
% *** Help buttons***
function pushbutHelpReadin_Callback(~, ~, ~)
helpdlg({'1. Select Path containing data (avoid spaces and dots at beginning or end of input)','', ...
    '2. Specify your data', '', ...
    '3. Select pre-processing', '', ...
    '(Coordinate transformations can be modified in function "optionsTransformData.m" in folder "FunctionsToEdit". Note: Videos need 3D Cartesian coordinates. The rest of the options are not coordinate specific)'})
% function pushbutHelpPCAComp_Callback(~, ~, ~)
% helpdlg({'1','', '',''})
function pushbutHelpComputation_Callback(~, ~, ~)
helpdlg({'1. Specify PCA parameters (normalization, weights -> Options must be specified in respective functions ("optionsNormalization.m" and "optionsWeights.m") in folder "FunctionsToEdit"!)','', ...
    '2. Choose low pass filter and cut-off(s) (a vector of cut-off frequencies will compute the entire computation for each cut-off)', '', ...
    '3. Cross validation validates the PC-basis`ability to represent the group as a whole','', ...
    '4. Welch`s PDS can be helpful to determine plausible cut-off frequency'})
function pushbutHelpVarComp_Callback(~, ~, ~)
helpdlg({'1. Choose to save/load and specify names (see Quick starter guide for loading)','', ...
    '2. Standard PCA-variables (rVAR, rSTD, CUM_rVAR, CUM_rSTD) are always computed -> others must be activated (modify in function "optionsVariablesComp.m" in folder "FunctionsToEdit")', '', ...
    '3. All selected variables can be exported to Excel file'})
function pushbutHelpPlotOps_Callback(~, ~, ~)
helpdlg({'1. Enable/disable all plots','', ...
    '2. Choose to save as .fig, .jpeg or both', '', ...
    '3. Choose plots: No. figures defines how many figures PER TRIAL are made (Example 3: The subjects of each trial will be divided in 3 groups and each group plotted in one figure)','', ...
    '4. Dynamic limits will determine maximum over selected PP/PA time-series (PV will be between the mean of PP and PA limits) and divide that number by integer defined in "part overall max by"''',...
    '5. Personalized plots can be edited in function "personalizedPlots.m" in folder "FunctionsToEdit"'})
function pushbutHelpVids_Callback(~, ~, ~)
helpdlg({'1. Select disable/2D/3D option','', ...
    '2. Specify name of folder containing videos and subjects/trials/pcs', '', ...
    '3. Input data makes video of input data post processing (no PCA)','', ...
    '4. PM visualization shows an oszillating movement from minimal to maximal amplitude of first available trial (visualizes the PM itself, not the PM of a certain trial)', '', ...
    '5. PM trials/subjects: Visualized PM movements of selected trials/subjects', '', ...
    '6. Any PM-combinations can be selected (Example: [1:4; 2,6; 3:5,7] will display 3 movement combinations (separated by semicolon) of selected trials/subjects: 1. PM1-4; 2. PM2 and PM6, 3. PM3-5 and PM7)', '', ...
    '7. Axes settings: all 6 x-y-z permutations are implemented (choose depending on x-y-z in data)', '', ...
    '8. COLORING:  Define new coloring options in function "optionsColoringVids.m" by following description and templates!', '', ...
    '9. Other video settings: skipframes will skip frames and speed up video! PM amplicifaciton factors can be chosen for each PM (input vector), for all PMs (input skalar). Two numbers will amplyfy the first half with first number, the second half with the second, 3 numbers, ...', '', ...
    '10. Visualization only options select the number of oszillations (No. Runthrouhgs) and movement resolution (No. differentiable positions per oszillation). AUTO selects min/max of first trial -> alternative strategies may be modified in code', '', ...
    '11. Saving: Interface options will be saved in "PManalyzer_settings_struct.mat" (automatically created in folder containing input data when not available). To load from such a struct simply copy it into the folder containing the input data and press "Load" -> options will appear!', ...
    })


% *** Action buttons ***
function pushbutSettingsDeleteSelection_Callback(~, ~, handles)
current_list            = get(handles.listboxSettingsLoadable, 'String');
number_selected_setting = get(handles.listboxSettingsLoadable, 'Value');
settings_field_chosen_delete = current_list{number_selected_setting}(4:end); %remove spaces!

PathSettingStruct = get(handles.editPATHFolderData, 'String');
a = load([PathSettingStruct,'\PManalyzer_settings_struct']);
available_settings = a.available_settings; % Struct inside struct!
available_settings = rmfield(available_settings, settings_field_chosen_delete);

names_of_available_settings = fieldnames(available_settings);
for i = 1:size(names_of_available_settings,1)
    names_of_available_settings{i} = [num2str(i), '. ',names_of_available_settings{i}];
end

set(handles.listboxSettingsLoadable, 'Value', 1);
set(handles.listboxSettingsLoadable, 'String', names_of_available_settings);
save([PathSettingStruct,'\PManalyzer_settings_struct'],'available_settings')
msgbox(['Setting ' ,settings_field_chosen_delete,' was deleted and list of settings updated!'])


function pushbutSettingsLoad_Callback(~, ~, handles)
PathLoadSettings = get(handles.editPATHFolderData, 'String');
A = exist(PathLoadSettings, 'dir');
if A == 7 && strcmp(PathLoadSettings, '...') ~= 1
    B = exist([PathLoadSettings,'\PManalyzer_settings_struct.mat'], 'file');
    if B == 2
        a = load([PathLoadSettings,'\PManalyzer_settings_struct']);
        available_settings = a.available_settings;
    else
        warndlg('No "PManalyzer_settings_struct" found in folder with Data --> Loading not possible!')
        available_settings = struct;
    end
    
    % Load the list nothing else
    names_of_available_settings = fieldnames(available_settings);
    for i = 1:size(names_of_available_settings,1)
        names_of_available_settings{i} = [num2str(i), '. ',names_of_available_settings{i}];
    end
    set(handles.listboxSettingsLoadable, 'String', names_of_available_settings);
else
    warndlg('Folder does not exist! It could have happened that there was an unwanted space in the input of the GUI.', '!! Warning !!')
end


function pushbutSettingsSave_Callback(~, ~, handles)
PManalyzer_current_settings = cell(40,4);
PManalyzer_current_settings{1,1} = 'Pupupmenus';
PManalyzer_current_settings{1,2} = 'Edits';
PManalyzer_current_settings{1,3} = 'Checkboxes';
PManalyzer_current_settings{1,4} = 'Listboxes';


%% Pupupmenu fields - Main five
PManalyzer_current_settings{2,1}  = get(handles.pupmenREADIN,          'Value');
PManalyzer_current_settings{3,1}  = get(handles.pupmenPCAcomp,         'Value');
PManalyzer_current_settings{4,1}  = get(handles.pupmenVARIABLESCOMP,   'Value');
PManalyzer_current_settings{5,1}  = get(handles.pupmenPLOTS,           'Value');
PManalyzer_current_settings{6,1}  = get(handles.pupmenVIDEOmake,       'Value');
% Input and computation panels
PManalyzer_current_settings{7,1}  = get(handles.pupmenGAPfilling,      'Value');
PManalyzer_current_settings{8,1}  = get(handles.pupmenKERNEL,          'Value');
PManalyzer_current_settings{9,1}  = get(handles.pupmenFILTreadin,      'Value');
PManalyzer_current_settings{10,1} = get(handles.pupmenNORMALIZATION,   'Value');
PManalyzer_current_settings{11,1} = get(handles.pupmenWEIGHTS,         'Value');
PManalyzer_current_settings{12,1} = get(handles.pupmenFILTpp,          'Value');
PManalyzer_current_settings{13,1} = get(handles.pupmenFILTpv,          'Value');
PManalyzer_current_settings{14,1} = get(handles.pupmenFILTpa,          'Value');
PManalyzer_current_settings{15,1} = get(handles.pupmenPreProcessing,   'Value');
% Plot and video panels
PManalyzer_current_settings{16,1} = get(handles.pupmenSavePlotAs,      'Value');
PManalyzer_current_settings{17,1} = get(handles.pupmenPLOTlimits,      'Value');
PManalyzer_current_settings{18,1} = get(handles.pupmenAXESsettings,    'Value');
PManalyzer_current_settings{19,1} = get(handles.pupmenCOLORINGvideo,   'Value');


%% Edit fields - Input panel
PManalyzer_current_settings{2,2}  = get(handles.editPATHFolderData,                'String');
PManalyzer_current_settings{3,2}  = get(handles.editDescribeAnalysis,              'String');
PManalyzer_current_settings{4,2}  = get(handles.editReadinSubj,                    'String');
PManalyzer_current_settings{5,2}  = get(handles.editReadinTrials,                  'String');
PManalyzer_current_settings{6,2}  = get(handles.editPrefixData,                    'String');
PManalyzer_current_settings{7,2}  = get(handles.editFileExtension,                 'String');
PManalyzer_current_settings{8,2}  = get(handles.editHeaderLines,                   'String');
PManalyzer_current_settings{9,2}  = get(handles.editDelimiter,                     'String');
PManalyzer_current_settings{10,2} = get(handles.editSampleFrequency,               'String');
PManalyzer_current_settings{11,2} = get(handles.editNrColsAfterReadin,             'String');
PManalyzer_current_settings{12,2} = get(handles.editNrRowsAfterReadin,             'String');
PManalyzer_current_settings{13,2} = get(handles.editDeleteMarkers,                 'String');
PManalyzer_current_settings{14,2} = get(handles.editDeleteColumns,                 'String');
PManalyzer_current_settings{15,2} = get(handles.editDeleteRows,                    'String');
% Computation and output panel
PManalyzer_current_settings{17,2} = get(handles.editFILTorder,                     'String');
PManalyzer_current_settings{18,2} = get(handles.editFILTcutoff,                    'String');
PManalyzer_current_settings{19,2} = get(handles.editSaveData,                      'String');
PManalyzer_current_settings{20,2} = get(handles.editSavePcaData,                   'String');
% Plots panel
PManalyzer_current_settings{21,2} = get(handles.editNumGroups,                     'String');
PManalyzer_current_settings{22,2} = get(handles.editPlotPcPerFigure,               'String');
PManalyzer_current_settings{23,2} = get(handles.editPlotSubjPerFigure,             'String');
PManalyzer_current_settings{24,2} = get(handles.editPlotTrialsPerFigure,           'String');
PManalyzer_current_settings{25,2} = get(handles.editPlotLimitPp,                   'String');
PManalyzer_current_settings{26,2} = get(handles.editPlotLimitPa,                   'String');
% Videos panel
PManalyzer_current_settings{27,2} = get(handles.editVideoFolderName,               'String');
PManalyzer_current_settings{28,2} = get(handles.editVideoSubjects,                 'String');
PManalyzer_current_settings{29,2} = get(handles.editVideoTrials,                   'String');
PManalyzer_current_settings{30,2} = get(handles.editVideoPCs,                      'String');
PManalyzer_current_settings{31,2} = get(handles.editVideoPCperFigure,              'String');
PManalyzer_current_settings{32,2} = get(handles.editVidMakePMcombination,          'String');
% PManalyzer_current_settings{33,2} = get(handles.editVidPMampFactorsSubject,        'String');
PManalyzer_current_settings{34,2} = get(handles.editVidPMampFactorsVisualization,  'String');
PManalyzer_current_settings{35,2} = get(handles.editVidMotionRange,                'String');
PManalyzer_current_settings{36,2} = get(handles.editVidRunthroughsVisualization,   'String');
PManalyzer_current_settings{37,2} = get(handles.editVidNrPositionsVisualized,      'String');
PManalyzer_current_settings{38,2} = get(handles.editSettingsName,                  'String');
PManalyzer_current_settings{39,2} = get(handles.editVidSkipFrames,                  'String');


%% Checkboxes - Input and computation panels
PManalyzer_current_settings{2,3}  = get(handles.chbDeleteMarkers,               'Value');
PManalyzer_current_settings{3,3}  = get(handles.chbDeleteColumns,               'Value');
PManalyzer_current_settings{4,3}  = get(handles.chbDeleteRows,                  'Value');
PManalyzer_current_settings{5,3}  = get(handles.chbSpecificDataTreatment,       'Value');
PManalyzer_current_settings{6,3}  = get(handles.chbCrossValidation,             'Value');
PManalyzer_current_settings{7,3}  = get(handles.chbWelchPowerSpectrum,          'Value');
PManalyzer_current_settings{8,3}  = get(handles.chbSaveData,                    'Value');
PManalyzer_current_settings{9,3}  = get(handles.chbSavePcaData,                 'Value');
PManalyzer_current_settings{10,3} = get(handles.chbComputeSelfdefinedVariables, 'Value');
PManalyzer_current_settings{11,3} = get(handles.chbExcelOutput,                 'Value');
% Plots panel
PManalyzer_current_settings{12,3} = get(handles.chbPlotEVoverall,               'Value');
PManalyzer_current_settings{13,3} = get(handles.chbPlotEVsubjectSpecific,       'Value');
PManalyzer_current_settings{14,3} = get(handles.chbPlotScoreplots,              'Value');
PManalyzer_current_settings{15,3} = get(handles.chbPlotPersonalized1,           'Value');
PManalyzer_current_settings{16,3} = get(handles.chbPlotPersonalized2,           'Value');
PManalyzer_current_settings{17,3} = get(handles.chbPlotPersonalized3,           'Value');
PManalyzer_current_settings{18,3} = get(handles.chbPlotPersonalized4,           'Value');
PManalyzer_current_settings{19,3} = get(handles.chbPlotPersonalized5,           'Value');
PManalyzer_current_settings{20,3} = get(handles.chbPlotPersonalized6,           'Value');
PManalyzer_current_settings{21,3} = get(handles.chbPlotPersonalized7,           'Value');
PManalyzer_current_settings{22,3} = get(handles.chbPlotPersonalized8,           'Value');
PManalyzer_current_settings{23,3} = get(handles.chbPlotPersonalized9,           'Value');
PManalyzer_current_settings{24,3} = get(handles.chbPlotPersonalized10,          'Value');
% Video panel
PManalyzer_current_settings{25,3} = get(handles.chbVidMakeOriginalVid,          'Value');
PManalyzer_current_settings{26,3} = get(handles.chbVidMakePCvid,                'Value');
PManalyzer_current_settings{27,3} = get(handles.chbVidMakePMcombination,        'Value');
PManalyzer_current_settings{28,3} = get(handles.chbVidPMactivity,               'Value');
PManalyzer_current_settings{29,3} = get(handles.chbPMVidVis,                    'Value');
PManalyzer_current_settings{30,3} = get(handles.chbVidSkipFrames,               'Value');


%% Listboxes - Input and computation panels
% PManalyzer_current_settings{2,4} = get(handles.listboxSettingsLoadable, 'String');



%% Saving of the settings and update of the settings listbox
Path_SaveCurrentSettings = get(handles.editPATHFolderData, 'String');
A = exist(Path_SaveCurrentSettings, 'dir');
if A == 7 && strcmp(Path_SaveCurrentSettings, '...') ~= 1 % '...' is interpreted as folder by matlab!
    B = exist([Path_SaveCurrentSettings,'\PManalyzer_settings_struct.mat'], 'file');
    if B == 2
        a = load([Path_SaveCurrentSettings,'\PManalyzer_settings_struct']);
        available_settings = a.available_settings;
    else
        warndlg('No "PManalyzer_settings_struct" found in folder with Data --> Empty "PManalyzer_settings_struct" was created before saving the new settings!')
        available_settings = struct;
    end
    new_settings_entry = 0;
    name_new_setting = get(handles.editSettingsName, 'String');
    if isfield(available_settings, name_new_setting)
        choice = questdlg('This setting name already exists! Do you wish to overwrite it?', ...
            'Overwrite setting option?', ...
            'Yes','No','No');
        switch choice
            case 'Yes'
                new_settings_entry = 1;
                pause(0.05)
            case 'No'
                msgbox('Current setting was NOT saved!')
        end
    else
        new_settings_entry = 1;
    end
    
    if new_settings_entry == 1
        eval(['available_settings.', name_new_setting, ' = PManalyzer_current_settings;']) % Saves current settings in struct
        save([Path_SaveCurrentSettings,'\PManalyzer_settings_struct'],'available_settings')% Saves settings struct in folder
        
        names_of_available_settings = fieldnames(available_settings);
        for i = 1:size(names_of_available_settings,1)
            names_of_available_settings{i} = [num2str(i), '. ',names_of_available_settings{i}];
        end
        set(handles.listboxSettingsLoadable, 'String', names_of_available_settings);
        msgbox('New setting saved and list of settings updated!')
    end
else
    warndlg('Folder does not exist! The path selected for input does not exist! It could have happened that there was an unwanted space in the input.', '!! Warning !!')
end




function pushbutSettingsChangeToSelection_Callback(~, ~, handles)
current_list          = get(handles.listboxSettingsLoadable, 'String');
number_start_setting  = get(handles.listboxSettingsLoadable, 'Value');
settings_field_chosen = current_list{number_start_setting}(4:end); %remove numbering (needed without number for comparison when loaded) and space("space" is a problem...)!

a = load(fullfile(get(handles.editPATHFolderData, 'String'),'PManalyzer_settings_struct'));
available_settings = a.available_settings; % Struct inside struct!
eval(['loaded_settings = available_settings.',settings_field_chosen, ';'])

PManalyzer_start_settings = loaded_settings;




%% Pupupmenu fields - Main five
set(handles.pupmenREADIN,           'Value', PManalyzer_start_settings{2,1}); % First row of every column is a string with the "type" of column (example: edit, checkbox, text, ...)
set(handles.pupmenPCAcomp,          'Value', PManalyzer_start_settings{3,1});
set(handles.pupmenVARIABLESCOMP,    'Value', PManalyzer_start_settings{4,1});
set(handles.pupmenPLOTS,            'Value', PManalyzer_start_settings{5,1});
set(handles.pupmenVIDEOmake,        'Value', PManalyzer_start_settings{6,1});
% Input and computation panels
set(handles.pupmenGAPfilling,       'Value', PManalyzer_start_settings{7,1});
set(handles.pupmenKERNEL,           'Value', PManalyzer_start_settings{8,1});
set(handles.pupmenFILTreadin,       'Value', PManalyzer_start_settings{9,1});
set(handles.pupmenNORMALIZATION,    'Value', PManalyzer_start_settings{10,1});
set(handles.pupmenWEIGHTS,          'Value', PManalyzer_start_settings{11,1});
set(handles.pupmenFILTpp,           'Value', PManalyzer_start_settings{12,1});
set(handles.pupmenFILTpv,           'Value', PManalyzer_start_settings{13,1});
set(handles.pupmenFILTpa,           'Value', PManalyzer_start_settings{14,1});
set(handles.pupmenPreProcessing,    'Value', PManalyzer_start_settings{15,1});
% Plot and video panels
set(handles.pupmenSavePlotAs,       'Value', PManalyzer_start_settings{16,1});
set(handles.pupmenPLOTlimits,       'Value', PManalyzer_start_settings{17,1});
set(handles.pupmenAXESsettings,     'Value', PManalyzer_start_settings{18,1});
set(handles.pupmenCOLORINGvideo,    'Value', PManalyzer_start_settings{19,1});


%% Edit fields - Input panel
% set(handles.editPATHFolderData,                 'String', PManalyzer_start_settings{2,2}); % First row of every column is a string with the "type" of column (example: edit, checkbox, text, ...)
set(handles.editDescribeAnalysis,               'String', PManalyzer_start_settings{3,2});
set(handles.editReadinSubj,                     'String', PManalyzer_start_settings{4,2});
set(handles.editReadinTrials,                   'String', PManalyzer_start_settings{5,2});
set(handles.editPrefixData,                     'String', PManalyzer_start_settings{6,2});
set(handles.editFileExtension,                  'String', PManalyzer_start_settings{7,2});
set(handles.editHeaderLines,                    'String', PManalyzer_start_settings{8,2});
set(handles.editDelimiter,                      'String', PManalyzer_start_settings{9,2});
set(handles.editSampleFrequency,                'String', PManalyzer_start_settings{10,2});
set(handles.editNrColsAfterReadin,              'String', PManalyzer_start_settings{11,2});
set(handles.editNrRowsAfterReadin,              'String', PManalyzer_start_settings{12,2});
set(handles.editDeleteMarkers,                  'String', PManalyzer_start_settings{13,2});
set(handles.editDeleteColumns,                  'String', PManalyzer_start_settings{14,2});
set(handles.editDeleteRows,                     'String', PManalyzer_start_settings{15,2});
% % set(handles. ... ,                          'String', PManalyzer_start_settings{16,2});
% Computation and output panel
set(handles.editFILTorder,                      'String', PManalyzer_start_settings{17,2});
set(handles.editFILTcutoff,                     'String', PManalyzer_start_settings{18,2});
set(handles.editSaveData,                       'String', PManalyzer_start_settings{19,2});
set(handles.editSavePcaData,                    'String', PManalyzer_start_settings{20,2});
% Plots panel
set(handles.editNumGroups,                      'String', PManalyzer_start_settings{21,2});
set(handles.editPlotPcPerFigure,                'String', PManalyzer_start_settings{22,2});
set(handles.editPlotSubjPerFigure,              'String', PManalyzer_start_settings{23,2});
set(handles.editPlotTrialsPerFigure,            'String', PManalyzer_start_settings{24,2});
set(handles.editPlotLimitPp,                    'String', PManalyzer_start_settings{25,2});
set(handles.editPlotLimitPa,                    'String', PManalyzer_start_settings{26,2});
% Videos panel
set(handles.editVideoFolderName,                'String', PManalyzer_start_settings{27,2});
set(handles.editVideoSubjects,                  'String', PManalyzer_start_settings{28,2});
set(handles.editVideoTrials,                    'String', PManalyzer_start_settings{29,2});
set(handles.editVideoPCs,                       'String', PManalyzer_start_settings{30,2});
set(handles.editVideoPCperFigure,               'String', PManalyzer_start_settings{31,2});
set(handles.editVidMakePMcombination,           'String', PManalyzer_start_settings{32,2});
% set(handles.editVidPMampFactorsSubject,         'String', PManalyzer_start_settings{33,2});
set(handles.editVidPMampFactorsVisualization,   'String', PManalyzer_start_settings{34,2});
set(handles.editVidMotionRange,                 'String', PManalyzer_start_settings{35,2});
set(handles.editVidRunthroughsVisualization,    'String', PManalyzer_start_settings{36,2});
set(handles.editVidNrPositionsVisualized,       'String', PManalyzer_start_settings{37,2});
set(handles.editSettingsName,                   'String', PManalyzer_start_settings{38,2});
set(handles.editVidSkipFrames,                  'String', PManalyzer_start_settings{39,2});


%% Checkboxes - Input and computation panels
set(handles.chbDeleteMarkers,               'Value', PManalyzer_start_settings{2,3}); % First row of every column is a string with the "type" of column (example: edit, checkbox, text, ...)
set(handles.chbDeleteColumns,               'Value', PManalyzer_start_settings{3,3});
set(handles.chbDeleteRows,                  'Value', PManalyzer_start_settings{4,3});
set(handles.chbSpecificDataTreatment,       'Value', PManalyzer_start_settings{5,3});
set(handles.chbCrossValidation,             'Value', PManalyzer_start_settings{6,3});
set(handles.chbWelchPowerSpectrum,          'Value', PManalyzer_start_settings{7,3});
set(handles.chbSaveData,                    'Value', PManalyzer_start_settings{8,3});
set(handles.chbSavePcaData,                 'Value', PManalyzer_start_settings{9,3});
set(handles.chbComputeSelfdefinedVariables, 'Value', PManalyzer_start_settings{10,3});
set(handles.chbExcelOutput,                 'Value', PManalyzer_start_settings{11,3});
% Plots panel
set(handles.chbPlotEVoverall,               'Value', PManalyzer_start_settings{12,3});
set(handles.chbPlotEVsubjectSpecific,       'Value', PManalyzer_start_settings{13,3});
set(handles.chbPlotScoreplots,              'Value', PManalyzer_start_settings{14,3});
set(handles.chbPlotPersonalized1,           'Value', PManalyzer_start_settings{15,3});
set(handles.chbPlotPersonalized2,           'Value', PManalyzer_start_settings{16,3});
set(handles.chbPlotPersonalized3,           'Value', PManalyzer_start_settings{17,3});
set(handles.chbPlotPersonalized4,           'Value', PManalyzer_start_settings{18,3});
set(handles.chbPlotPersonalized5,           'Value', PManalyzer_start_settings{19,3});
set(handles.chbPlotPersonalized6,           'Value', PManalyzer_start_settings{20,3});
set(handles.chbPlotPersonalized7,           'Value', PManalyzer_start_settings{21,3});
set(handles.chbPlotPersonalized8,           'Value', PManalyzer_start_settings{22,3});
set(handles.chbPlotPersonalized9,           'Value', PManalyzer_start_settings{23,3});
set(handles.chbPlotPersonalized10,          'Value', PManalyzer_start_settings{24,3});
% Video panel
set(handles.chbVidMakeOriginalVid,          'Value', PManalyzer_start_settings{25,3});
set(handles.chbVidMakePCvid,                'Value', PManalyzer_start_settings{26,3});
set(handles.chbVidMakePMcombination,        'Value', PManalyzer_start_settings{27,3});
set(handles.chbVidPMactivity,               'Value', PManalyzer_start_settings{28,3});
set(handles.chbPMVidVis,                    'Value', PManalyzer_start_settings{29,3});
set(handles.chbVidSkipFrames,               'Value', PManalyzer_start_settings{30,3});


%% Listboxes - Input and computation panels


% Call main five popupmenus to check settings
settings_check_Callback(0, 0, handles)




function pushbutExtras_Callback(~, ~, handles)
% Insert future extra options here!




function pushbutStartComputation_Callback(~, ~, handles)
% Include folders with functions - Subfolders are already included!
folder_containing_GUI = pwd;
addpath(genpath(folder_containing_GUI))

fprintf('\n\n\n              ******************************************************************  ')
fprintf('\n              ***************** Motion-PCA computation started *****************  ')
fprintf('\n              ******************************************************************  ')



%% Load GUI Settings/Input
read_in = get(handles.pupmenREADIN, 'Value'); %     choose "trial_of_subject" in line 256

if read_in == 2
    flip_data_yes_no = get(handles.chbSpecificDataTreatment, 'Value');
    save_data_matrix = get(handles.chbSaveData, 'Value');
elseif read_in == 3 || read_in == 1
    flip_data_yes_no = 0;
    save_data_matrix = 0;
    read_in = 0;
else
    disp('\nCheck input\n')
end

save_pc_data = get(handles.chbSavePcaData, 'Value');
name_data_matrix = get(handles.editSaveData, 'String');
name_pc_data_matrix = get(handles.editSavePcaData, 'String');



%% Scoreplot options
yLimitsScoreplots = get(handles.pupmenPLOTlimits, 'Value');
part = str2num(get(handles.editPlotLimitPp, 'String')); %limit will be Maximum devided by part (mostly one value is too high anyway!)
ylim_PPfixed = str2num(get(handles.editPlotLimitPp, 'String'));
ylim_PAfixed = str2num(get(handles.editPlotLimitPa, 'String'));




save_jpg = 1;
save_fig = 1;
if get(handles.pupmenSavePlotAs, 'Value') == 1
    save_jpg = 0; % must be set to 0 if compute_not_plot_active
elseif get(handles.pupmenSavePlotAs, 'Value') == 2
    save_fig = 0;
end



if get(handles.pupmenKERNEL, 'Value') == 1
    TransformOption{1,1} = 0; % No transformtaion
    TransformOption{1,2} = 1; % Option 1: No transformation
    TransformOption{1,3} = 1; % Transform into
elseif get(handles.pupmenKERNEL, 'Value') ~= 1
    TransformOption{1,1} = 1; % Perform transformtaion
    TransformOption{1,2} = get(handles.pupmenKERNEL, 'Value'); % Option #: See function "optionsTransformData()"
    TransformOption{1,3} = 1;  % Transform into
end






% Components to plot options:
PC_components_to_plot = 1:20; % select the actual number of the PC components you want to visualize
PC_per_figure     = str2double(get(handles.editPlotPcPerFigure, 'String')); % Nr of PC components visualized per plot
subj_per_figure   = str2double(get(handles.editPlotSubjPerFigure, 'String')); %How many subjects shall be plottet per figure
trials_per_figure = str2double(get(handles.editPlotTrialsPerFigure, 'String'));

% Filtering options
filter_readin = get(handles.pupmenFILTreadin, 'Value');
filter_scores = get(handles.pupmenFILTpp, 'Value');
filter_vel    = get(handles.pupmenFILTpv, 'Value');
filter_acel   = get(handles.pupmenFILTpa, 'Value');

sample_frequency = str2num(get(handles.editSampleFrequency, 'String'));
cut_off = str2num(get(handles.editFILTcutoff, 'String'));
handles.sample_frequency        = sample_frequency;

for cut_off_now = cut_off
    fprintf('\n\n\n ******************** COMPUTATION WITH Cut-off: %dHz ********************', cut_off_now)
    cut_off_norm = cut_off_now/(sample_frequency/2);
    order = str2num(get(handles.editFILTorder, 'String'));
    
    
    %% Video options
    folder_with_data = get(handles.editPATHFolderData, 'String');
    if size(str2num(get(handles.editReadinTrials, 'String')),2) == 1
        trials_per_subject = str2num(get(handles.editReadinTrials, 'String'));
    else
        trials_per_subject = size(str2num(get(handles.editReadinTrials, 'String')),2);
    end
    
    if size(str2num(get(handles.editReadinSubj, 'String')),2) == 1
        nr_subj_readin = str2num(get(handles.editReadinSubj, 'String'));
    else
        nr_subj_readin = size(str2num(get(handles.editReadinSubj, 'String')),2);
    end
    
    file_type_ending = get(handles.editFileExtension, 'String');
    D = dir([folder_with_data, '\*', file_type_ending]);
    Num = length(D(not([D.isdir])));
    
    if isempty(trials_per_subject) == 1
        trials_per_subject = 0;
    end
    if isempty(nr_subj_readin) == 1
        nr_subj_readin = 0;
    end
    
    visualization_leapsize = str2num(get(handles.editVidNrPositionsVisualized, 'String'));
    Video_of_subject       = str2num(get(handles.editVideoSubjects, 'String'));
    Video_of_trial         = str2num(get(handles.editVideoTrials, 'String'));
    
    
    
    make_videos = 0;
    make_original_video = get(handles.chbVidMakeOriginalVid,  'Value');
    make_Pc_subj_videos      = get(handles.chbVidMakePCvid,  'Value');
    make_Pc_vis_videos      = get(handles.chbPMVidVis,  'Value');
    make_comb_vid      = get(handles.chbVidMakePMcombination,  'Value');
    
    
    Video_Popupmenu_selection = get(handles.pupmenVIDEOmake, 'Value');
    if Video_Popupmenu_selection == 1
    else
        make_videos = 1;
        if make_Pc_subj_videos == 0 && make_original_video == 0 &&  make_comb_vid == 0 && make_Pc_vis_videos == 0
            msgbox('You chose to make videos, but no video is selected')
        end
        if isempty(Video_of_subject) || isempty(Video_of_trial)
            msgbox('You must select a Subject and a Trial for this video option!', 'Error','error')
            error('Subject of Trial has not been selected!')
        end
        vid_dim = Video_Popupmenu_selection; %
    end
    
    
    
    
    PC_components_movie = str2num(get(handles.editVideoPCs, 'String')); % PC components to make movie of;
    PC_per_figure_movie = str2num(get(handles.editVideoPCperFigure, 'String')); % Nr of PC components per movie/plot
    comb_PC_str     = get(handles.editVidMakePMcombination, 'String');
    
    % Correct comb_PC_str for unequal pc combinations
    nr_combPCmov     = sum(comb_PC_str == ';')+1;
    sepPos = zeros(1,nr_combPCmov+1);
    sepPos(end) = length(comb_PC_str);
    
    [~,sepPos(2:end-1)] = find(comb_PC_str == ';');
    
    comb_PC_cell = cell(nr_combPCmov,1);
    lenMaxComb = 1;
    for comb = 1:nr_combPCmov
        comb_PC_cell{comb} = comb_PC_str(sepPos(comb)+1:sepPos(comb+1));
        if comb_PC_cell{comb}(1) == '['
            comb_PC_cell{comb}(1) = [];
        elseif comb_PC_cell{comb}(end) == ']'
            comb_PC_cell{comb}(end) = [];
        end
        comb_PC_cell{comb} = str2num(comb_PC_cell{comb});
        lenMaxComb = max(lenMaxComb, length(comb_PC_cell{comb}));
    end
    
    comb_PC_matrix = zeros(nr_combPCmov,lenMaxComb);
    for comb = 1:nr_combPCmov
        pcComb = length(comb_PC_cell{comb});
        comb_PC_matrix(comb,1:pcComb) = comb_PC_cell{comb};
    end
    



    amp_facs = str2num(get(handles.editVidPMampFactorsVisualization, 'String'));% amplification factors for the PC(one for each or otherwise the factors will be distributed depending on how many there are)
    amplification_factors = ones(1, max([PC_components_movie,comb_PC_matrix(:)']));
    for i=1:length(amp_facs)
        amplification_factors( 1 ,(i-1)*ceil(length(amplification_factors)/length(amp_facs))+1 : i*ceil(length(amplification_factors)/length(amp_facs))) = amp_facs(i);
    end
    amp_facs_vis = str2num(get(handles.editVidPMampFactorsVisualization, 'String'));
    amplification_factors_vis = ones(1,max([PC_components_movie,comb_PC_matrix(:)']));
    for i=1:length(amp_facs_vis)
        amplification_factors_vis( 1 ,(i-1)*ceil(length(amplification_factors_vis)/length(amp_facs_vis))+1 : i*ceil(length(amplification_factors_vis)/length(amp_facs_vis))) = amp_facs_vis(i);
    end
    
    if  max(max(comb_PC_matrix)) > max(PC_components_to_plot)
        msgbox('At least one frankenmovement is higher than computed PCs and cannot be computed!', 'Error', 'Error')
        error('At least one frankenmovement is higher than PC to make movie of and cannot be computed!')
    end
    
    
    %% Safety if only video is selected!
    if get(handles.pupmenREADIN, 'Value')== 1 && get(handles.pupmenPCAcomp, 'Value') == 1 &&  get(handles.pupmenVARIABLESCOMP, 'Value') == 1 && get(handles.pupmenVIDEOmake, 'Value') == 1
        msgbox({'Neither plots nor videos selected!';'Nothing is supposed to be calculated. Check your options!'}, 'Error','error')
        error('No computation options selected!')
    elseif get(handles.pupmenVARIABLESCOMP, 'Value') == 1 && get(handles.pupmenVIDEOmake, 'Value') ~= 1
        msgbox({'No computation or loading of results chosen. Video cannot be made --> Video option set to "Do not make videos"', '"Readin" and "PCA-computation" might still be running!'}, 'Error','error')
        set(handles.pupmenVIDEOmake, 'Value', 1)
    end
    
    
    
    
    
    %% ****** Error and Help messages for Files/subjects/trials ****** %%
    if trials_per_subject == 0 && nr_subj_readin == 0
        if Num == 0
            msgbox(['No files found! Path of folder wrong, or no files in folder',10,'Check path and if there are really files that match your description!'], 'Error','error')
            error('Path of folder wrong, or no files in folder')
        else
            trials_per_subject = 1;
            nr_subj_readin = Num;
            msgbox(['Is there really only one subject to be distinguished?', 10, 'Check selection or names of files in folder.'])
        end
    elseif Num < trials_per_subject*nr_subj_readin
        if get(handles.pupmenREADIN, 'Value') == 3
            msgbox('You are loading data or not making any readin. In any case: Make sure that the read in options coincide with this data (No readin files found in folder!)!');
        else
            msgbox('You chose more subjects and trials than files in folder! If you are not only loading data check Folder and files in folder', 'Error','error');
            %         error('There are more selections than files in folder!!!');
        end
    elseif trials_per_subject ~= 0 && nr_subj_readin == 0 && mod(Num,trials_per_subject) == 0
        if mod(Num,trials_per_subject) == 0
            nr_subj_readin = Num/trials_per_subject;
        else
            msgbox('Not every Subject seems to have an equal amount of trials!', 'Error','error')
            error('Not every Subject seems to have an equal amount of trials!')
        end
    elseif trials_per_subject ~= 0 && nr_subj_readin ~= 0 && mod(trials_per_subject,1) == 0 && mod(nr_subj_readin,1) == 0
        fprintf('\n\n\nInput of "Nr. of subjects" and "trials per subject" seem to be ok\n')
        if Num < nr_subj_readin
            msgbox(['More files are selected than there are in the selected folder!',10, 'Check if you are in the right folder!'], 'Error','error')
            error('Too many files selected')
        elseif Num > nr_subj_readin
            enable_safety_readin = 0;
            if enable_safety_readin == 1
                fprintf('\n            Waiting for you to respond to the message box!\n')
                %           questdlg('Careful! Not all files in folder selected! Do you wish to proceed?')
                choice = questdlg('Careful! Not all files in folder selected! Do you wish to proceed?', ...
                    'Selection looks ok but might be inconsistent', ...
                    'Yes','No','No');
                % Handle response
                switch choice
                    case 'Yes'
                        
                    case 'No'
                        disp('\n\nComputation stopped\n\n')
                        error('You chose to check input before continuing!')
                end
            else
                %                 msgbox('Not all files in Folder used for computation! IGNORE THIS if you are sure that you chose correctly.')
            end
        end
    else
        h = msgbox('Check Input! (Nr. of subjects to be read in and trials made do not coincide)!!!', 'Error','error');
        error('Check Input! (Nr. of subjects to be read in and trials made do not coincide)!!!');
    end
    
    
    if get(handles.pupmenVARIABLESCOMP, 'Value') == 2 && get(handles.pupmenPCAcomp, 'Value') == 1
        msgbox('To compute variables PCA-data is required! You chose otherwise! Check Popupmenu of PCA or load variables directly if PC-data is not required!', 'Error', 'error')
        error('To compute variables PCA-data is required! You chose otherwise! Check Popupmenu of PCA or load variables directly if PC-data is not required!')
    end
    
    
    
    
    
    
    
    
    trials_readin   = str2num(get(handles.editReadinTrials, 'String'));
    subjects_readin = str2num(get(handles.editReadinSubj, 'String'));
    
    handles.subjects_readin = subjects_readin;
    handles.trials_readin   = trials_readin;
    
    nr_subj_readin = length(subjects_readin);
    nr_trials_readin = length(trials_readin);
    nr_files_readin = nr_trials_readin*nr_subj_readin;
    nr_PC_components = length(PC_components_to_plot);
    handles.nr_PC_components        = nr_PC_components;
    
    describe_analysis = [get(handles.editDescribeAnalysis, 'String'),'_',num2str(cut_off_now), 'CO_', num2str(nr_PC_components), 'PC'];
    
    if max(trials_readin) < nr_trials_readin
        msgbox('The trials input is missing a few entries (the sequence is not complete from 1 to nr_trials_readin)! Make sure that you compensate this in the rest of the input!')
    end
    
    
    
    data_save_directory = [folder_with_data, '\PCA - Analysis ', describe_analysis];
    
    fprintf('\n\nFolder containing read in data: %s', folder_with_data)
    fprintf(  '\nFolder containing saved items: %s\n', data_save_directory)
    
    fprintf('\nNr. of subjects being read in: %d\n', nr_subj_readin)
    fprintf('Nr. of trials per subject: %d\n', nr_trials_readin)
    fprintf('Nr. of files with selected ending in selected folder: %d\n', Num)
    
    
    

    
    %% Check Directories to save data, plots and videos!
    fig_directory = fullfile(data_save_directory, '\All Plots\');
    A = exist(fig_directory, 'dir');
    if A == 7
    else
        mkdir(fig_directory)
    end
    
    path_save_data = fullfile(folder_with_data, ['\PCA - Analysis ', describe_analysis],'\Computed data');
    A = exist(path_save_data, 'dir');
    if A == 7
    else
        mkdir(path_save_data);
    end
    
    if make_videos
        path_save_vid = fullfile(data_save_directory, get(handles.editVideoFolderName,'String'), '\');
        A = exist(path_save_vid, 'dir');
        if A == 7
        else
            mkdir(path_save_vid);
        end
    end
    
    
    
    
    fprintf('\n\n\n\n\n               ******************** Part 1: Input/Read-in ********************  \n')
    
    
    %% Readinoptions
    if get(handles.pupmenREADIN,'Value') == 2
%         fprintf(printTextKernel)
        % Data needed for readinfunction
        readin_inputcell{1}  = nr_files_readin;
        readin_inputcell{2}  = trials_readin;
        readin_inputcell{3}  = subjects_readin;
        readin_inputcell{4}  = get(handles.editPrefixData, 'String'); % prefix in function
        readin_inputcell{5}  = folder_with_data;
        readin_inputcell{6}  = file_type_ending;
        readin_inputcell{7}  = get(handles.editDelimiter, 'String'); %delimiterIn;
        readin_inputcell{8}  = str2num(get(handles.editHeaderLines, 'String')); %headerlinesIn;
        readin_inputcell{9}  = get(handles.chbDeleteColumns, 'Value');% chbdel_specific_col
        readin_inputcell{10} = get(handles.chbDeleteMarkers, 'Value'); % chbdel_specific_marker
        readin_inputcell{11} = 3*str2double(get(handles.editNrColsAfterReadin, 'String')); % _should_have
        readin_inputcell{12} = str2double(get(handles.editNrRowsAfterReadin, 'String')); %  rows_should_have
        readin_inputcell{13} = str2num(get(handles.editDeleteColumns, 'String'));% editdel_specific_col
        readin_inputcell{14} = str2num(get(handles.editDeleteMarkers, 'String'));% edotdel_specific_marker
        readin_inputcell{15} = save_data_matrix;% save or not option
        readin_inputcell{16} = name_data_matrix;
        readin_inputcell{17} = get(handles.pupmenGAPfilling, 'Value');
        %         readin_inputcell{18} = cycle_analysis;
        readin_inputcell{19} = order; % Butterworth for cycle analysis
        readin_inputcell{20} = cut_off_norm; % % Butterworth for cycle analysis
        readin_inputcell{21} = filter_readin; % Filter option 6 if filtered
        readin_inputcell{22} = path_save_data;
        readin_inputcell{23} = cut_off_now;
        readin_inputcell{24} = get(handles.chbDeleteRows, 'Value');
        readin_inputcell{25} = str2num(get(handles.editDeleteRows, 'String'));
        readin_inputcell{26} = TransformOption;
        readin_inputcell{27} = sample_frequency;
        
        % varargin_for_Readin function
        a = flip_data_yes_no;% Only availablefor tommy data
        b = get(handles.pupmenPreProcessing, 'Value');% leave_out_option
        
        
        %% Readin data with function "readin_PMAnalyzer"
        fprintf('\nReadin chosen! No gender differentiation in readin yet!\n') %d trial %d is being read in (File: "%s")!\n', l, k, file1)
        [Data_Readin_TrialSubj, gender_matrix, size_matrix, subjects_after_readin] = readin_PMAnalyzer(readin_inputcell, a,b);
        % FUNCTION INFO: reads in all subjects of one trial then
        % of the next trial, ... --> "Data_Readin_TrialSubj" is a cell, each cell
        % containing the data of one subjects and one trial
        %
        % Function uses matlab-function: "importdata"
        % Function needs the 16 entries of "readin_inputcell", a,b,c,d are
        % optional.
        
        
        if strcmp(b, 'Cycle Analysis')
            trials_readin = 1;
            nr_trials_readin = 1;
            nr_files_readin = nr_subj_readin;
            fprintf('\n\nCycle-Analysis chosen! All trials of one subject have been gathered and put one after another!\nTrials and Nr. of files readin were redefined! (Trials = 1, Nr.Files read in = Nr.Subjects read in)\n\n')
            pause(0.5)
        end
        subj_to_plot =  subjects_after_readin;
        
        % Load data
    elseif get(handles.pupmenREADIN,'Value') == 1  || get(handles.pupmenREADIN,'Value') == 3 % load
        fprintf('Loading "read-in file": "%s.mat" from Path: \n   %s\\ \n\n', name_data_matrix,folder_with_data)
        load_path_file = [folder_with_data,'\',name_data_matrix];
        loaded_struct = load(load_path_file);
        
        % Needed data for rest of GUI
        Data_Readin_TrialSubj = loaded_struct.Data_Readin_TrialSubj;
        size_matrix = loaded_struct.size_matrix;
        gender_matrix = loaded_struct.gender_matrix;
        
        %% Make sure that enough PMs are available for options - otherwise PC_components to plot is limited
        [nonEmptyRows, nonEmptyCols] = find(~cellfun(@isempty,Data_Readin_TrialSubj));
        if size(Data_Readin_TrialSubj{nonEmptyRows(1), nonEmptyCols(1)},2) < length(PC_components_to_plot)
            PC_components_to_plot        = 1:size(Data_Readin_TrialSubj{nonEmptyRows(1), nonEmptyCols(1)},2);
            nr_PC_components             = length(PC_components_to_plot);
            handles.nr_PC_components     = nr_PC_components;
            [PC_components_movie, ia, ~] = intersect(PC_components_movie, PC_components_to_plot);
            amplification_factors = amplification_factors(ia);
            amplification_factors_vis = amplification_factors(ia);
        else
        end
        
        if nr_files_readin > size(Data_Readin_TrialSubj, 1)*size(Data_Readin_TrialSubj, 2);
            msgbox('Nr. files readin does not coincide with loaded data! If you are making a wavelet cycle analysis, make sure to set the "trials made by each subject" to "1"!','Error', 'Error')
            error('Nr. files readin does not coincide with loaded data! If you are making a wavelet cycle analysis, make sure to set the "trials made by each subject" to "1"!')
        end
        subj_to_plot =  subjects_readin;
% % %     elseif get(handles.pupmenREADIN,'Value') == 1 % No loadingload
% % %         fprintf('\n\nNo readin data and no loading of input data\n\n')
% % %         subj_to_plot =  subjects_readin; %% Could be altered to only a few shall be plottet! as in input...
    end
    % Fehlt noch wenn kein video!
    

    
    
    fprintf('\n\n\n\n\n               ******************** Part 2: PCA computation ********************  \n')
    
    
    %% ***** PCA - Analysis *****
    
    if get(handles.pupmenPCAcomp, 'Value') == 2
        norm_assignment = get(handles.pupmenNORMALIZATION, 'Value');
        weight_assignment = get(handles.pupmenWEIGHTS, 'Value');
        
        data_processing_options_cell = {norm_assignment, weight_assignment, gender_matrix, size_matrix, 0, 0};
        compare_angles = get(handles.chbCrossValidation, 'Value');
        if compare_angles
            nr_pcs_performed = nr_files_readin+1;
            msgbox('Performing "leave-one-out" cross-validation (PC-angle comparison)!')
            fprintf('\n\nPerforming "leave-one-out" cross-validation (PC-angle comparison):\n')
        else
            fprintf('\n\nNo "leave-one-out" cross-validation (PC-angle comparison) performed!\n\n')
            nr_pcs_performed = 1;
        end
        
        PCs_cell = cell(1,nr_pcs_performed);
        Data_for_pca = Data_Readin_TrialSubj;
        data_processing_options_cell_leftout = data_processing_options_cell; % Copy input -> subjects may be cut out later for angle comparison
        if compare_angles
            ctrTrialSubjNow = 0;
            for trial_left_out = trials_readin
                for subj_left_out = subjects_readin % The last one will be all together! this data is then saved!
                    ctrTrialSubjNow = ctrTrialSubjNow + 1;
                    fprintf('\n    Angle comparison: PCA without trial %d - subject %d in progress ... \n', trial_left_out, subj_left_out)

                    data_processing_options_cell_leftout{5} = trial_left_out;
                    data_processing_options_cell_leftout{6} = subj_left_out;
                    
                    %% The PCA
                    [PCs_cell{ctrTrialSubjNow}, ~, ~,~, ~, ~] = pca_PMAnalyzer(Data_for_pca,trials_readin, subjects_readin, data_processing_options_cell_leftout);

                    
                    fprintf('\n')
                end % Subj left out
            end % Trial left out
        else
        end
        fprintf('\n    PCA with all subjects in progress ... \n')
        
        % The PCA computation
        [PCs, PP_TrialSubj, EV,mean_matrices, norm_matrix, weights_inverse] = pca_PMAnalyzer(Data_for_pca,trials_readin, subjects_readin, data_processing_options_cell);
        PCs_cell{nr_pcs_performed} = PCs;
        if compare_angles
            fprintf('\n\nPlotting figure with cross-validation (angle comparison)! ... ')
            angles_fig = figure('units','normalized','outerposition',[0 0 1 1]);
            angles = zeros(size(PCs_cell,2)-1, size(PCs,1));
            for j = 1:size(PCs,1)
                for i = 1:size(PCs_cell,2)-1 % Angles in degrees!
                    angles(i,j) = (180/pi)*acos(abs(dot(PCs_cell{i}(:,j),PCs(:,j)))/(norm(PCs_cell{i}(:,j))*norm(PCs(:,j))));
                    %                 if angles(i,j) > 90
                    %                     angles(i,j) = 180 - angles(i,j);
                    %                 end
                end
                if j <= 20
                    subplot(4,5, j)
                    plot(angles(:,j))
                    ylim([0 90])
                    xlabel('Subject Nr.')
                    ylabel('Angle []')
                    title(['EV ', num2str(j)])
                end
            end
            saveas(angles_fig,[fig_directory,'Angles_comparison.fig']);
            save([fig_directory,'Angles_comparison_cell'], 'PCs_cell')
            fprintf('done (figure saved and closed)')
            close(angles_fig)
            pause(0.2)
        else
            angles = 0;
        end
        
        fprintf('\n\n\n')
        if save_pc_data
            path_and_name = [path_save_data, '\',num2str(cut_off_now),'CO_',num2str(length(EV)),'PC___', name_pc_data_matrix];
            
            fprintf('\nBasic PC-Data (EV, PCs, PP_TrialSubj_unfiltered) is being saved as: \n     %s_Basic\n', path_and_name)
            save([path_and_name,'_Basic'],'EV','PCs','PP_TrialSubj')
                        
            fprintf('\nExpanded PC-Data (mean matrices, norm matrix, weights inverse, angles) is being saved as: \n     %s_Expanded\n', path_and_name)
            save([path_and_name,'_Expanded'],'mean_matrices', 'size_matrix','norm_matrix', 'weights_inverse', 'angles')
        end
        
    elseif get(handles.pupmenPCAcomp, 'Value') == 3 % load PCA data
        load_from_path = get(handles.editPATHFolderData, 'String');
        fprintf('Loading PC file: %s.mat from Path: \n   %s\\ \n\n', name_pc_data_matrix,load_from_path)
        loaded_struct1 = load([load_from_path,'\',name_pc_data_matrix, '_Basic'])
        loaded_struct2 = load([load_from_path,'\',name_pc_data_matrix, '_TimeSeries'])
        loaded_struct3 = load([load_from_path,'\',name_pc_data_matrix, '_Expanded'])
        
        
        EV              = loaded_struct1.EV;
        PCs             = loaded_struct1.PCs;
        
        PP_TrialSubj    = loaded_struct2.PP_TrialSubj;
        size_matrix     = loaded_struct3.size_matrix;
        mean_matrices   = loaded_struct3.mean_matrices;
        norm_matrix     = loaded_struct3.norm_matrix;
        weights_inverse = loaded_struct3.weights_inverse;
        
    elseif get(handles.pupmenPCAcomp, 'Value') == 1 % No PCA data required
        fprintf('\n\nNo PCA data computed and no loading of PCA-data\n\n')
    end
    
    
    
    
    
    
    %      ****************************************************************
    %%     **************** Computation of variables starts here **********
    %      ****************************************************************
    fprintf('\n\n\n\n\n               ******************** Part 3: Variables computation ********************  \n')
    
    comp_selfdef_vars = get(handles.chbComputeSelfdefinedVariables, 'Value');
    NameVarsData = get(handles.editSavePCAvars, 'String');
    if get(handles.pupmenVARIABLESCOMP, 'Value') == 2
        if length(PC_components_to_plot) < length(PC_components_movie)
            msgbox('Check input! Nr. PC-movies cannot be greater than Nr. of PC computed with!', 'Error', 'Error')
            error('Check input! Nr. PC-movies cannot be greater than Nr. of PC computed with!')
        end
        
        
        % Preparing function "data_retrieve_PMAnalyzer.m"
        data_retrieve_inputcell_pc{1} = PP_TrialSubj;
        data_retrieve_inputcell_pc{2} = EV;
        
        % Subj, Trial, PC, Video - information
        data_retrieve_inputcell_info{1} = PC_components_to_plot;
        data_retrieve_inputcell_info{2} = trials_readin;
        data_retrieve_inputcell_info{3} = subjects_readin;
        data_retrieve_inputcell_info{4} = comp_selfdef_vars;
        
        %Filtering information
        data_retrieve_inputcell_filt{1} = order; % butterworth
        data_retrieve_inputcell_filt{2} = cut_off_norm; % butterworth
        data_retrieve_inputcell_filt{3} = sample_frequency;
        data_retrieve_inputcell_filt{4} = get(handles.chbWelchPowerSpectrum, 'Value'); % look_at_pwelch powerspektrum
        data_retrieve_inputcell_filt{5} = filter_scores; % filteringoption
        data_retrieve_inputcell_filt{6} = filter_vel; % filteringoption
        data_retrieve_inputcell_filt{7} = filter_acel; % filteringoption
        
        
        
        %% ***** Retrieving data from PCA results! *****
        [data_retrieve_outputcell] = data_retrieve_PMAnalyzer(data_retrieve_inputcell_pc, data_retrieve_inputcell_info, data_retrieve_inputcell_filt, handles);
        fprintf('\n\n\nData computation finished!')
        
        handles                 = data_retrieve_outputcell{1};
        TimeSeries              = data_retrieve_outputcell{2};
        VariablesEigenvalues    = data_retrieve_outputcell{3};
        VariablesSelfdefined    = data_retrieve_outputcell{4};
        InfoVarsComputed        = data_retrieve_outputcell{5};

        
        % Score time-series
        PP_TrialSubj  = TimeSeries.PP_TrialSubj;
        PV_TrialSubj  = TimeSeries.PV_TrialSubj;
        PA_TrialSubj  = TimeSeries.PA_TrialSubj;
        
        % Video Data
        PC_vidparts_means       = mean_matrices;
        
        
        
        save_pc_variables = get(handles.chbSavePCAvars, 'Value');
        %% Save data
        if save_pc_variables
            fprintf('\n\n\nTime-series (PP, PV, PA) are being saved as: \n     %s', [path_save_data,'\',num2str(cut_off_now),'CO_',num2str(nr_PC_components),'PC___',name_pc_data_matrix,'_TimeSeries'])
            save([path_save_data,'\',num2str(cut_off_now),'CO_',num2str(nr_PC_components),'PC___',name_pc_data_matrix,'_TimeSeries'],'PP_TrialSubj','PV_TrialSubj', 'PA_TrialSubj')
            
            fprintf('\n\nVariables are being saved as: \n     %s', [path_save_data,'\',num2str(cut_off_now),'CO_',num2str(nr_PC_components),'PC___',NameVarsData])
            save([path_save_data,'\',num2str(cut_off_now),'CO_',num2str(nr_PC_components),'PC___',NameVarsData],'VariablesEigenvalues','VariablesSelfdefined','InfoVarsComputed')
        else
        end        
    elseif get(handles.pupmenVARIABLESCOMP, 'Value') == 3
        path_LoadPCAdat = get(handles.editPATHFolderData, 'String');
         
        fprintf('\n\n\nLoading PP, PV and PA time-series (%s.mat) from Path: \n   %s\\', [name_pc_data_matrix, '_TimeSeries'], path_LoadPCAdat)
        loaded_struct1 = load([path_LoadPCAdat,'\',name_pc_data_matrix, '_TimeSeries']);
        
        fprintf('\n\nLoading PC-variables (%s.mat) from Path: \n   %s\\', NameVarsData, path_LoadPCAdat)
        loaded_struct2 = load([path_LoadPCAdat,'\',NameVarsData]);

        fprintf('\n\nLoading basic and expanded PC-data (%s.mat, %s.mat) from Path: \n   %s\\ \n', [name_pc_data_matrix, '_Basic'], [name_pc_data_matrix, '_Expanded'], path_LoadPCAdat)
        loaded_struct3 = load([path_LoadPCAdat,'\',name_pc_data_matrix, '_Basic']);
        loaded_struct4 = load([path_LoadPCAdat,'\',name_pc_data_matrix, '_Expanded']);
        
        
        PP_TrialSubj = loaded_struct1.PP_TrialSubj;
        PV_TrialSubj = loaded_struct1.PV_TrialSubj;
        PA_TrialSubj = loaded_struct1.PA_TrialSubj;
        
        VariablesSelfdefined    = loaded_struct2.VariablesSelfdefined;
        VariablesEigenvalues    = loaded_struct2.VariablesEigenvalues;
        InfoVarsComputed        = loaded_struct2.InfoVarsComputed;
        
        EV  = loaded_struct3.EV;
        PCs = loaded_struct3.PCs;
        
        size_matrix     = loaded_struct4.size_matrix;
        mean_matrices   = loaded_struct4.mean_matrices;
        norm_matrix     = loaded_struct4.norm_matrix;
        weights_inverse = loaded_struct4.weights_inverse;

        if nr_files_readin > size(PP_TrialSubj,1)*size(PP_TrialSubj,2);
            msgbox('Nr. files readin does not coincide with loaded data! If you are making a wavelet cycle analysis, make sure to set the "trials made by each subject" to "1"!','Error', 'Error')
        end
        
        
        subj_to_plot =  subjects_readin;
    else % Do not make anything
        fprintf('\n\nNo variable computation features seleted!\n\n')
    end % make scoreplots or not
    
    
    
    
    %% Excel filesheet with results of variables"
    if get(handles.chbExcelOutput, 'Value')
        nr_PC_excel = 15;
        fprintf('\n\nNr. PC written to excel is limited to %d at the moment! Change in code if more are needed!\n\n', nr_PC_excel)
        msgbox(sprintf('Nr. PC written to excel is limited to %d at the moment! Change in code if more are needed!', nr_PC_excel))
        
        excel_directory = [data_save_directory, '\Computed data\'];
        
        exceloutput_inputcell{1} = subjects_readin;
        exceloutput_inputcell{2} = trials_readin;
        exceloutput_inputcell{3} = describe_analysis;
        exceloutput_inputcell{4} = excel_directory;
        exceloutput_inputcell{5} = nr_PC_excel;
        exceloutput_inputcell{6} = EV;
        exceloutput_inputcell{7} = VariablesEigenvalues;
        exceloutput_inputcell{8} = VariablesSelfdefined;
        exceloutput_inputcell{9} = InfoVarsComputed;


        if ~isfield(VariablesSelfdefined.PA_variables_TrialSubjPC(1,1,1), 'NoSelfdefinedVariablesComputed') && comp_selfdef_vars % 1. PP, 2. PV, 3. PA - Check if variables were computed
            exceloutput_inputcell{10} = 1; % 1: Selfdefined variables also in Excel file
        else
            exceloutput_inputcell{10} = 0; % 0: Only eigenvalue variables in Excel file
            if comp_selfdef_vars
                warndlg('Careful! You chose to include variables (Nr.Zeros, STD-TZ). It seems that your are loading data that does not contain these variables computation.', 'Warning: No Excel output produced')
                fprintf('Excel file: No variables (Nr.Zeros, STD-TZ) available. Variables will only contain "0" in Excel file')
            else
                fprintf('Excel file: No variables (Nr.Zeros, STD-TZ) available. Variables will only contain "0" in Excel file')
            end
            exceloutput_inputcell{9} = 0; % 0: variables not available (=0) in Excel file
        end
        
        % The function that writes PC data of subjects information cell to excel
        excel_output_PMAnalyzer(exceloutput_inputcell) 
    end
    
    
    
    fprintf('\n\n\n\n\n               ******************** Part 4: Plots ********************  \n')
    
    
    %% Check if any plots were active and print this information
    if  get(handles.pupmenPLOTS, 'Value') == 2 % All Plots
        nr_subj_plot = length(subj_to_plot);
        nr_figsRelPlot = str2double(get(handles.editNumGroups, 'String'));
        nr_PC_components = length(PC_components_to_plot);
        
        
        % Saving convenient handles for functions "standardPCAPlots.m" and "personalizedPlots.m"
        handles.folder_with_data        = folder_with_data;
        handles.data_save_directory     = data_save_directory;  
        handles.fig_directory           = fig_directory;
        handles.describe_analysis       = describe_analysis;
        handles.save_fig                = save_fig;
        handles.save_jpg                = save_jpg;
        
        handles.subjects_readin         = subjects_readin;
        handles.trials_readin           = trials_readin;
        handles.PC_components_to_plot   = PC_components_to_plot;
        handles.nr_PC_components        = nr_PC_components;
        handles.PC_per_figure           = PC_per_figure;
        handles.subj_to_plot            = subj_to_plot;
        handles.subj_per_figure         = subj_per_figure;
        handles.trials_per_figure       = trials_per_figure;
        handles.nr_trials_readin        = nr_trials_readin;
        handles.nr_subj_plot            = nr_subj_plot;
        handles.nr_figsRelPlot          = nr_figsRelPlot;
        handles.yLimitsScoreplots       = yLimitsScoreplots;
        handles.ylim_PPfixed            = ylim_PPfixed;
        handles.ylim_PAfixed            = ylim_PAfixed;
        handles.part                    = part;
        handles.sample_frequency        = sample_frequency;
        handles.cut_off_frequ           = cut_off_now;
        
        handles.Data_Readin_TrialSubj   = Data_Readin_TrialSubj;
        handles.VariablesEigenvalues    = VariablesEigenvalues;
        handles.VariablesSelfdefined    = VariablesSelfdefined;
        handles.PP_TrialSubj            = PP_TrialSubj;
        handles.PV_TrialSubj            = PV_TrialSubj;
        handles.PA_TrialSubj            = PA_TrialSubj;
        handles.EV                      = EV;
        
        
        % Check if any plot is chosen
        nrActivePlots = sum([get(handles.chbPlotEVoverall, 'Value'),get(handles.chbPlotEVsubjectSpecific, 'Value'),get(handles.chbPlotScoreplots, 'Value'), ...
            get(handles.chbPlotPersonalized1, 'Value'),get(handles.chbPlotPersonalized2, 'Value'), ...
            get(handles.chbPlotPersonalized3, 'Value'),get(handles.chbPlotPersonalized4, 'Value'), ...
            get(handles.chbPlotPersonalized5, 'Value'),get(handles.chbPlotPersonalized6, 'Value'), ...
            get(handles.chbPlotPersonalized7, 'Value'),get(handles.chbPlotPersonalized8, 'Value'), ...
            get(handles.chbPlotPersonalized9, 'Value'),get(handles.chbPlotPersonalized10, 'Value')]);
        if nrActivePlots == 0
            fprintf('\n\nNo plotting features seleted!\n\n')
        else
            fprintf('\n\nNumber of selected plotting options: %d\n\n', nrActivePlots)
        end
        %%  Plot selected standard PC plots (rEV, rVAR, rSTD, CUM_rVAR, CUM_rSTD, PP, PV, PA). Function contained in folder "Corefunctions"
            handles      = standardPCAPlots( handles );
        %% Personalized plots can be custumized in function "personalizedPlots.m" in folder "FunctionsToEdit"
            [handles, ~] = personalizedPlots( handles );
    else% Make plots
        fprintf('\n\nPlots deactivated!\n\n')
    end  % All plots  get(handles.pupmenPLOTS, 'Value') ==  2
    
    
    
    
    
    
    
    
    
    
    
    
    fprintf('\n\n\n\n\n              ******************** Part 5: Videos ********************  \n')    %%
    if make_videos      
        if get(handles.pupmenVARIABLESCOMP, 'Value') == 3
            load_from_path = get(handles.editPATHFolderData, 'String');
            fprintf('\nLoading data for videos (%s, %s and %s) from path:\n %s\n', [name_pc_data_matrix, '_Basic'], [name_pc_data_matrix, '_TimeSeries'], [name_pc_data_matrix,'_ExpandedPC'], load_from_path)
            loaded_struct1  = load([load_from_path,'\',name_pc_data_matrix, '_Basic']);
            loaded_struct2  = load([load_from_path,'\',name_pc_data_matrix, '_TimeSeries']);
            loaded_struct3  = load([load_from_path,'\',name_pc_data_matrix, '_Expanded']);
            
            PCs                 = loaded_struct1.PCs;
            PP_TrialSubj        = loaded_struct2.PP_TrialSubj;

            PC_vidparts_means   = loaded_struct3.mean_matrices;
            norm_matrix         = loaded_struct3.norm_matrix;
            weights_inverse     = loaded_struct3.weights_inverse;

        elseif get(handles.pupmenVARIABLESCOMP, 'Value') == 1
            msgbox('You need to load or compute data to make video', 'Error', 'Error')
            error('You need to load or compute data to make video')
        end
        [nonEmptyRowsPlot, nonEmptyColsPlot] = find(~cellfun(@isempty,PP_TrialSubj));

        
        PCsT             = PCs';
        
        
        %% ********** Computation of video data out of computed or loaded video data ************ %%
        
        % Video data that is initialized!
        if ~isempty(setdiff(Video_of_subject,subjects_readin))
            subjNotReadIn = setdiff(Video_of_subject,[subjects_readin]);
            warndlg(sprintf('The video of subject(s): %s not possible -> subjects not read in! Specific videos not made ', num2str(setdiff(subjNotReadIn,0))));
            Video_of_subject = setdiff(Video_of_subject, subjNotReadIn);
        end
        
        if ~isempty(setdiff(Video_of_trial,trials_readin))
            trialNotReadIn = setdiff(Video_of_trial,trials_readin);
            warndlg(sprintf('The video of trial(s): %s not possible -> trials not read in! Specific videos not made ', num2str(trialNotReadIn)));
            Video_of_trial = setdiff(Video_of_trial, trialNotReadIn);
        end
        
        PC_components_movie_compute = setdiff(union(PC_components_movie,comb_PC_matrix(:)'),0); % Component zero can not be computed, but inputtet in combined pc
        
        max_trials_vid  = max(Video_of_trial);
        max_subj_vid    = max(Video_of_subject);
        maxPc_comp_vid  = max(PC_components_movie_compute);

        
        PC_vidparts_pc          = cell(max_trials_vid, max_subj_vid,maxPc_comp_vid);
        
        PC_TrialSubjPC_vid        = cell(max_trials_vid, max_subj_vid,maxPc_comp_vid);
        PC_comb_TrialSubj_vid   = cell(max_trials_vid, max_subj_vid,maxPc_comp_vid);
        
        PC_visualization_vid    = cell(1,1,maxPc_comp_vid);
        PC_comb_visualization   = cell(1,1,nr_combPCmov);
        
        fprintf('\n\nVideo data is being computed. This can take a minute if data is rather long...\n')
        scaling_vid = 1;
        if scaling_vid ~= 1
            fprintf('\nAll video data is scaled (multiplied) by a factor %d\n', scaling_vid)
            msgbox(sprintf('\nAll video data is scaled (multiplied) by a factor %d\n', scaling_vid))
        end
        
        % Video data of subjects
        fprintf('        Computing subject PC-videos. (PC + Combined PC)\n')
        for trial = Video_of_trial
            for subj = Video_of_subject
                % PC video-data that is needed for PC AND combined PC videos
                for pcPart = setdiff(union(PC_components_movie,comb_PC_matrix(:)'),0)
                        PMGerenated = PP_TrialSubj{trial,subj}(:,pcPart)*PCsT(pcPart,:);
                        NormalizationFaktorsCombined = amplification_factors(pcPart)*norm_matrix(trial,subj)*weights_inverse{trial,subj};
                        PC_vidparts_pc{trial,subj,pcPart} = PMGerenated*NormalizationFaktorsCombined; % must be multiplied from the right due to matrix mult!
                end
                % PC video-data computed only for selected PC videos
                for pcMov = PC_components_movie
                    PC_TrialSubjPC_vid{trial,subj,pcMov} = PC_vidparts_means{trial,subj} + PC_vidparts_pc{trial,subj,pcMov};
                end
                % PC video-data computed only for combined PC videos
                for nrpcComb = 1:nr_combPCmov% Each row containes one Frankensteincombination!
                    PC_comb_TrialSubj_vid{trial,subj,nrpcComb} = PC_vidparts_means{trial,subj};
                    for pcComb = comb_PC_matrix(nrpcComb,:) %% PC_data for the videos, Scores_Data for the score plots
                        if pcComb ~= 0
                            PC_comb_TrialSubj_vid{trial,subj,nrpcComb} = (PC_comb_TrialSubj_vid{trial,subj,nrpcComb}  + PC_vidparts_pc{trial,subj,pcComb})*scaling_vid;
                        end
                    end
                end
            end
        end
        
        
        
        
        
        %% **********   Video data of visualization   **************     
        fprintf('\nSetting visualization limits (movie) -> Setting: ')
        if strcmp(get(handles.editVidMotionRange, 'String'), 'Auto')
            fprintf('Auto\n\n')
            minvi = ones(1,maxPc_comp_vid);
            maxvi = ones(1,maxPc_comp_vid);
            for pc=1:maxPc_comp_vid
                minvi(pc) = min(PP_TrialSubj{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)}(:,pc));
                maxvi(pc) = max(PP_TrialSubj{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)}(:,pc));
            end
        elseif strcmp(get(handles.editVidMotionRange, 'String'), 'PrevDef')
            minvi = ones(1,maxPc_comp_vid)*(-1);
            maxvi = ones(1,maxPc_comp_vid);
            fprintf('PrevDef with range [-1,1]\n\n')
        else
            rangeinput = str2num(get(handles.editVidMotionRange, 'String'));
            if size(rangeinput,1) == 1 && size(rangeinput,1) == 2
                minvi = ones(1,maxPc_comp_vid)*rangeinput(1);
                maxvi = ones(1,maxPc_comp_vid)*rangeinput(2);
                fprintf('Defined Range for all PC:[%d,%d]', minvi, maxvi)
            else
                fprintf('Your Amplitude-Range input for the visualization was wrong: Setting changed to default: "Auto"\n\n')
                warndlg('Your Amplitude-Range input for the visualization was wrong: Setting changed to default: "Auto"')
                set(handles.editVidMotionRange, 'String', 'Auto')
                for pc=1:maxPc_comp_vid
                    minvi(pc) = min(PP_TrialSubj{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)}(:,pc));
                    maxvi(pc) = max(PP_TrialSubj{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)}(:,pc));
                end
            end
        end
        
        visualization_scorematrix = zeros(2*visualization_leapsize-2, maxPc_comp_vid );
        for pc = PC_components_movie_compute 
            Intlen = (maxvi(pc)-minvi(pc))/visualization_leapsize;
            visualization_vector = [linspace(minvi(pc), maxvi(pc), visualization_leapsize), linspace(maxvi(pc)-Intlen, minvi(pc)+Intlen, visualization_leapsize-2)];
            visualization_scorematrix(:,pc) = visualization_vector';
        end
        
        
        fprintf('\nComputing visualization PC-videos. (PC + Combined PC)\n')
        
        % Visualization: PC and cumulative PC
        PC_vidparts_pc_vis = cell(1,maxPc_comp_vid);
        for pc = PC_components_movie_compute 
            PC_vidparts_mean_vis{1,1} = PC_vidparts_means{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)}(1:size(visualization_scorematrix,1),:);
            PC_vidparts_pc_vis{pc}    = amplification_factors_vis(pc)*mean(mean(norm_matrix))*visualization_scorematrix(:,pc)*PCsT(pc,:)*weights_inverse{nonEmptyRowsPlot(1),nonEmptyColsPlot(1)};
        end
        for pc = PC_components_movie
            PC_visualization_vid{pc}  = (PC_vidparts_mean_vis{1,1} + PC_vidparts_pc_vis{pc})*scaling_vid;
        end
        % Visualization: Franken - PC
        for pcCombvis = 1:nr_combPCmov% Each row containes one Combination!
            PC_comb_visualization{pcCombvis} = PC_vidparts_mean_vis{1,1};
            for k = comb_PC_matrix(pcCombvis,:)
                if k ~= 0
                    PC_comb_visualization{pcCombvis} = (PC_comb_visualization{pcCombvis}  + PC_vidparts_pc_vis{k})*scaling_vid;
                end
            end
        end
        
        
        
        %% ****** Computing eigenvalue data for movie ******
        eigs_vid = get(handles.chbVidPMactivity, 'Value');
        EVactivity_TrialSubj_PC_vid = [];
        if eigs_vid
            EVactivity_TrialSubj_PC_vid = PP_TrialSubj;
            relativeToMaxActivity = 1; % 100% Reference: 1 = Highest value of maximum PP; 2 = Maximum activity of all PP at same timepoint; 3 = Overall activity at each timepoint
            fprintf('        Computing eigenvalues-data for PC-videos. (PC + Combined PC)')
            total_eigs_subj = cell(size(PP_TrialSubj,1),size(PP_TrialSubj,2));
            for trialEV = 1:size(PP_TrialSubj,1)
                for subjEV = 1:size(PP_TrialSubj,2)
                    if relativeToMaxActivity == 1
                        total_eigs_subj{trialEV,subjEV} = max(max(abs(PP_TrialSubj{trialEV,subjEV})))*ones(size(PP_TrialSubj{trialEV,subjEV},1),1); % maximum activity of max pc
                    elseif relativeToMaxActivity == 2 
                        total_eigs_subj{trialEV,subjEV} = max(sum(abs(PP_TrialSubj{trialEV,subjEV})))*ones(size(PP_TrialSubj{trialEV,subjEV},1),1); % maximum activity of max pc
                    elseif relativeToMaxActivity == 3
                        total_eigs_subj{trialEV,subjEV} = sum(abs(PP_TrialSubj{trialEV,subjEV}),2); % Activity at each timepoint
                    end
                end
            end
            for trialEV = 1:size(PP_TrialSubj,1)
                for subjEV = 1:size(PP_TrialSubj,2)
                    for pc = 1:size(PP_TrialSubj{trialEV,subjEV},2)
                        for timeEV = 1:size(PP_TrialSubj{trialEV,subjEV,1},1)
                            EVactivity_TrialSubj_PC_vid{trialEV,subjEV}(timeEV,pc) = EVactivity_TrialSubj_PC_vid{trialEV,subjEV}(timeEV,pc)/total_eigs_subj{trialEV,subjEV}(timeEV,1)*100;
                        end
                    end
                end
            end
        else
            fprintf('\n')
        end
        
        %% Putting visualization data to the right length
        run_throughs = str2double(get(handles.editVidRunthroughsVisualization, 'String')); % Nr. Runthroughs, PC-video
        for pc = PC_components_movie
            PC_visualization_vid{pc}    = repmat(PC_visualization_vid{pc}, run_throughs, 1);
        end
        for pc = 1:size(PC_comb_visualization,3)
            PC_comb_visualization{pc}   = repmat(PC_comb_visualization{pc}, run_throughs, 1);
        end
        
        %% ****** Preparing movie input data ******
        fprintf('\nVideo settings are being prepared\n')
        
        coloring_option = get(handles.pupmenCOLORINGvideo, 'Value'); %% selected coloring option
        x_y_z_setting = get(handles.pupmenAXESsettings, 'Value'); %% Koordinate system setting
        skipFramYN = get(handles.chbVidSkipFrames, 'Value');
        if skipFramYN
            skipFrames = str2double(get(handles.editVidSkipFrames, 'String'));
        else
            skipFrames = 1;
        end
        
        setting_cell{1}  = eigs_vid; % Eigenvalue movie option
        setting_cell{2}  = x_y_z_setting;
        setting_cell{3}  = coloring_option;
        setting_cell{4}  = PC_components_movie;
        setting_cell{5}  = PC_per_figure_movie;
        setting_cell{6}  = path_save_vid;
        setting_cell{7}  = vid_dim; % Dimension of video!
        setting_cell{8}  = run_throughs;
        setting_cell{9}  = amplification_factors_vis;
        setting_cell{10} = skipFrames;
        setting_cell{11} = TransformOption;
        
        
        %% ****** Computation of normal motion movies ******
        
        if make_original_video
            if get(handles.pupmenREADIN,'Value') == 1
                fprintf('\nOriginal video needs to load original data because it was not loaded or read in earlier!\n')
                load_path_file = [folder_with_data,'\',name_data_matrix];
                loaded_struct = load(load_path_file)
                
                % Needed data for rest of GUI
                Data_Readin_TrialSubj = loaded_struct.Data_Readin_TrialSubj;
            end
            %% Calculation of the center of mass can be selected
            COM_OM_comp = 0;
            COM_PC_comp = 0;
            COM_trialsubj = cell(max(trials_readin),max(subjects_readin));
            COM_TrialSubjPC = cell(max(trials_readin),max(subjects_readin), max(PC_components_movie));
            if COM_OM_comp == 1
                fprintf('\n\nCOM (center of mass) is computed for the read in data. Enable in movie_selmade, if it shall be included in video!')
                % COM for original data
                for trial = trials_readin
                    for subj = subjects_readin
                        [COM_trialsubj{trial, subj}] = COM_computation(Data_Readin_TrialSubj{trial, subj}, weights_inverse{trial,subj});
                    end
                end
                save(fullfile(path_save_data, 'COM_TrialSubj'), 'COM_trialsubj')
            end
            if COM_PC_comp == 1
                % PC COM (COM for each PC)
                for vid_trial = Video_of_trial
                    for vid_subj = Video_of_subject
                        for vid_pc = PC_components_movie
                            [COM_TrialSubjPC{vid_trial, vid_subj, vid_pc}] = COM_computation(PC_TrialSubjPC_vid{vid_trial, vid_subj, vid_pc}, weights_inverse{vid_trial,vid_subj});
                        end
                    end
                end
                save(fullfile(path_save_data, 'COM_TrialSubjPC'), 'COM_TrialSubjPC')
            end

                    
            for vid_trial = Video_of_trial
                for vid_subj = Video_of_subject
                    Title_movie = ['OM Subject ',num2str(vid_subj), ' - Trial ',num2str(vid_trial)];
                    fprintf('\n\nVideo - option for original subject - trial - videos (not PC) was chosen')
                    fprintf('\n     --> Original Movement video without PCA-Components in progress');
                    if scaling_vid ~= 1
                        fprintf('\n     --> Original Movement Data scaled with factor %d!\n', scaling_vid);
                    end
                    
                    size(Data_Readin_TrialSubj{vid_trial,vid_subj})
                    movie_selfmade(Data_Readin_TrialSubj{vid_trial, vid_subj}*scaling_vid, Title_movie,  COM_trialsubj{vid_trial, vid_subj}, setting_cell); % varargin possible!
                end % vid_subj
            end % vid_trial
        end % if make_original movie
        
        
        
        %% ****** Computation of PC movies ******
        Title_movie_describe_analysis = describe_analysis;
        if make_Pc_vis_videos
                Title_movie = [Title_movie_describe_analysis,' - AmpFak1_', num2str(amplification_factors_vis(1)),' visualization '];
                fprintf('\n\nVisualization video-option was chosen: %d runthroughs', run_throughs)
                fprintf('\n     --> Videos with PCA-Components in progress\n');
                movie_selfmade_pca(PC_visualization_vid,EVactivity_TrialSubj_PC_vid,0,0,Title_movie,setting_cell);
        end
       if make_Pc_subj_videos 
            for vid_trial = Video_of_trial
                for vid_subj = Video_of_subject
                    Title_movie = [Title_movie_describe_analysis,' - AmpFak1_',num2str(amplification_factors_vis(1)),' - Subject ', num2str(vid_subj), ' - Trial ', num2str(vid_trial)];
                    fprintf('\n\nSubject specific video-option was chosen')
                    fprintf('\n     --> Videos with PCA-Components in progress\n');
                    movie_selfmade_pca(PC_TrialSubjPC_vid,EVactivity_TrialSubj_PC_vid,vid_trial,vid_subj,Title_movie,setting_cell);
                end
            end
        end %Make PC Video
        
        
        %% ****** Computation of combined PC movies ******
        if make_comb_vid == 1
            if setting_cell{1} == 1; % Eigenvalue movie option
                warndlg('Eigenvalue setting is not available for Combined-PC-videos')
                setting_cell{1} = 0; % Eigenvalue movie option
            end
            
            fmstr = num2str(comb_PC_matrix);% Name of the pc combinations
            if isempty(comb_PC_matrix);
                msgbox('Choose which Frankenstein movements you want to create, when selecting this feature!','Error', 'Error')
            else
                setting_cell{4} = 1:nr_combPCmov; % Enables to make all franken-vids
%                 if get(handles.chbPMVidVis, 'Value') == 1
                    Title_movie = [Title_movie_describe_analysis,'  PC-combinations '];
                    for j = 1:nr_combPCmov
                        Title_movie = [Title_movie,'   PC',num2str(j), ' = ', fmstr(j,:), '    '];
                    end
                    fprintf('\n\nVisualization video-option was chosen: %d runthroughs', run_throughs)
                    fprintf('\n     --> Videos with combined PCA-Components-visualization in progress\n');
                    movie_selfmade_pca( PC_comb_visualization,EVactivity_TrialSubj_PC_vid,0,0,Title_movie,setting_cell);
%                 else
%                 end
                for vid_trial = Video_of_trial
                    for vid_subj = Video_of_subject
                        Title_movie = [Title_movie_describe_analysis,' Subject ', num2str(vid_subj),' - Trial ', num2str(vid_trial), '  Frank_mov '];
                        for j = 1:nr_combPCmov
                            Title_movie = [Title_movie,' PC',num2str(j), ' = ', fmstr(j,:), '    '];
                        end
                        fprintf('\n\nSubject specific video-option was chosen')
                        fprintf('\n     --> Video with combined PCA-Components in progress\n');
                        movie_selfmade_pca( PC_comb_TrialSubj_vid,EVactivity_TrialSubj_PC_vid,vid_trial,vid_subj,Title_movie,setting_cell);
                    end% for vid_subj
                end % for vid_trial
            end
        end% Frank video
    else% Make Video
        fprintf('\n\nNo video features seleted!\n\n')
    end % Make Video
    
    
 
    
    
    
end %Cut off frequency!
fprintf('\n\n\n              ******************** GUI COMPUTATION FINISHED SUCCESSFULLY! ********************  \n\n\n')
msgbox('GUI computation finished successfully!')




%%  ************* Unused Callback functions *************
%  *** Unused Edit callbacks ***
function editPATHFolderData_Callback(~, ~, ~)
function editDescribeAnalysis_Callback(~, ~, ~)
function editReadinTrials_Callback(~, ~, ~)
function editReadinSubj_Callback(~, ~, ~)
function editDeleteMarkers_Callback(~, ~, ~)
function editPrefixData_Callback(~, ~, ~)
function editFileExtension_Callback(~, ~, ~)
function editHeaderLines_Callback(~, ~, ~)
function editDelimiter_Callback(~, ~, ~)
function editSampleFrequency_Callback(~, ~, ~)
function editDeleteColumns_Callback(~, ~, ~)
function editDeleteRows_Callback(~, ~, ~)
function editNrColsAfterReadin_Callback(~, ~, ~)
function editNrRowsAfterReadin_Callback(~, ~, ~)
function editPlotLimitPp_Callback(~, ~, ~)
function editPlotLimitPa_Callback(~, ~, ~)
function editNumGroups_Callback(~, ~, ~)
function editVideoFolderName_Callback(~, ~, ~)
function editVideoSubjects_Callback(~, ~, ~)
function editVideoTrials_Callback(~, ~, ~)
function editVideoPCs_Callback(~, ~, ~)
function editVideoPCperFigure_Callback(~, ~, ~)
% function editVidPMampFactorsSubject_Callback(~, ~, ~)
function editVidMakePMcombination_Callback(~, ~, ~)
function editVidPMampFactorsVisualization_Callback(~, ~, ~)
function editFILTcutoff_Callback(~, ~, ~)
function editFILTorder_Callback(~, ~, ~)
function editSaveData_Callback(~, ~, ~)
function editSavePcaData_Callback(~, ~, ~)
function editSavePCAvars_Callback(~, ~, ~)
function editPlotPcPerFigure_Callback(~, ~, ~)
function editPlotSubjPerFigure_Callback(~, ~, ~)
function editPlotTrialsPerFigure_Callback(~, ~, ~)
function editSettingsName_Callback(~, ~, ~)
function editVidRunthroughsVisualization_Callback(~, ~, ~)
function editVidMotionRange_Callback(~, ~, ~)
function editVidNrPositionsVisualized_Callback(~, ~, ~)
function editVidSkipFrames_Callback(~, ~, ~)
%  *** Unused Popupmenu callbacks ***
function pupmenGAPfilling_Callback(~, ~, ~)
function pupmenKERNEL_Callback(~, ~, ~)
function pupmenFILTreadin_Callback(~, ~, ~)
function pupmenPreProcessing_Callback(~, ~, ~)
function pupmenNORMALIZATION_Callback(~, ~, ~)
function pupmenWEIGHTS_Callback(~, ~, ~)
function pupmenFILTpp_Callback(~, ~, ~)
function pupmenFILTpv_Callback(~, ~, ~)
function pupmenFILTpa_Callback(~, ~, ~)
function pupmenSavePlotAs_Callback(~, ~, ~)
function pupmenCOLORINGvideo_Callback(~, ~, ~)
% *** Unused Checkbox callbacks ***
function chbCrossValidation_Callback(~, ~, ~)
function chbWelchPowerSpectrum_Callback(~, ~, ~)
function chbComputeSelfdefinedVariables_Callback(~, ~, ~)
function chbExcelOutput_Callback(~, ~, ~)
function chbPlotEVoverall_Callback(~, ~, ~)
function chbPlotPersonalized1_Callback(~, ~, ~)
function chbPlotPersonalized2_Callback(~, ~, ~)
function chbPlotPersonalized3_Callback(~, ~, ~)
function chbPlotPersonalized4_Callback(~, ~, ~)
function chbPlotPersonalized5_Callback(~, ~, ~)
function chbPlotPersonalized6_Callback(~, ~, ~)
function chbPlotPersonalized7_Callback(~, ~, ~)
function chbPlotPersonalized8_Callback(~, ~, ~)
function chbPlotPersonalized9_Callback(~, ~, ~)
function chbPlotPersonalized10_Callback(~, ~, ~)


% *** Unused Slider callbacks ***
function listboxSettingsLoadable_Callback(~, ~, ~)



%%  ************* Unused create functions *************
%  *** Unused Edit Create functions ***
function editPATHFolderData_CreateFcn(~, ~, ~)
function editDescribeAnalysis_CreateFcn(~, ~, ~)
function editReadinSubj_CreateFcn(~, ~, ~)
function editReadinTrials_CreateFcn(~, ~, ~)
function editDeleteMarkers_CreateFcn(~, ~, ~)
function editPrefixData_CreateFcn(~, ~, ~)
function editFileExtension_CreateFcn(~, ~, ~)
function editHeaderLines_CreateFcn(~, ~, ~)
function editDelimiter_CreateFcn(~, ~, ~)
function editSampleFrequency_CreateFcn(~, ~, ~)
function editDeleteColumns_CreateFcn(~, ~, ~)
function editDeleteRows_CreateFcn(~, ~, ~)
function editNrColsAfterReadin_CreateFcn(~, ~, ~)
function editNrRowsAfterReadin_CreateFcn(~, ~, ~)
function editFILTcutoff_CreateFcn(~, ~, ~)
function editFILTorder_CreateFcn(~, ~, ~)
function editSaveData_CreateFcn(~, ~, ~)
function editSavePcaData_CreateFcn(~, ~, ~)
function editSavePCAvars_CreateFcn(~, ~, ~)
function editPlotPcPerFigure_CreateFcn(~, ~, ~)
function editPlotSubjPerFigure_CreateFcn(~, ~, ~)
function editPlotTrialsPerFigure_CreateFcn(~, ~, ~)
function editPlotLimitPp_CreateFcn(~, ~, ~)
function editPlotLimitPa_CreateFcn(~, ~, ~)
function editNumGroups_CreateFcn(~, ~, ~)
function editVideoFolderName_CreateFcn(~, ~, ~)
function editVideoSubjects_CreateFcn(~, ~, ~)
function editVideoTrials_CreateFcn(~, ~, ~)
function editVideoPCs_CreateFcn(~, ~, ~)
function editVideoPCperFigure_CreateFcn(~, ~, ~)
% function editVidPMampFactorsSubject_CreateFcn(~, ~, ~)
function editVidMakePMcombination_CreateFcn(~, ~, ~)
function editVidPMampFactorsVisualization_CreateFcn(~, ~, ~)
function editVidRunthroughsVisualization_CreateFcn(~, ~, ~)
function editVidMotionRange_CreateFcn(~, ~, ~)
function editVidNrPositionsVisualized_CreateFcn(~, ~, ~)
function editSettingsName_CreateFcn(~, ~, ~)
function editVidSkipFrames_CreateFcn(~, ~, ~)
%  *** Unused popup Create functions ***
function pupmenVIDEOmake_CreateFcn(~, ~, ~)
function pupmenPCAcomp_CreateFcn(~, ~, ~)
function pupmenVARIABLESCOMP_CreateFcn(~, ~, ~)
function pupmenREADIN_CreateFcn(~, ~, ~)
function pupmenGAPfilling_CreateFcn(~, ~, ~)
function pupmenKERNEL_CreateFcn(~, ~, ~)
function pupmenFILTreadin_CreateFcn(~, ~, ~)
function pupmenPreProcessing_CreateFcn(~, ~, ~)
function pupmenNORMALIZATION_CreateFcn(~, ~, ~)
function pupmenWEIGHTS_CreateFcn(~, ~, ~)
function pupmenFILTpp_CreateFcn(~, ~, ~)
function pupmenFILTpv_CreateFcn(~, ~, ~)
function pupmenFILTpa_CreateFcn(~, ~, ~)
function pupmenPLOTS_CreateFcn(~, ~, ~)
function pupmenPLOTlimits_CreateFcn(~, ~, ~)
function pupmenCOLORINGvideo_CreateFcn(~, ~, ~)
%  *** Unused list Create functions ***
function listboxSettingsLoadable_CreateFcn(~, ~, ~)
%  *** Unused slider Create functions ***
function sliderUIPosition_CreateFcn(~, ~, ~)
