function [ updatedHandles,  available_peronalizedPlot_option_names ] = personalizedPlots( handles )
% =====================
% FUNCTION DESCRIPTION:
% =====================
% The function "personalizedPlots.m" contains  direct links to checkboxes in the subpanel
% "Personalized plots" of the PManalyzer. To implement plot options follow
% these two steps:
% 
%
% 1. NAME PLOT:
% =============
%       - Insert the name of you plot option by replacing one of the ten
%         "Plot-option #:" strings. (Names contained in cell 
%         "available_peronalizedPlot_option_names")
%
%       (HINT: 
%           - Names will appear in respective personalized plot checkboxes after restarting interface)
%
%
% 2. CREATE PLOT:
% ===============
%       - Include your plot option in the respective if statement. The "chbPlotPersonalized#"
%         number must coincide with the number of plot option in the name.
%
%       (HINT: ALL variables used throughout the computation are available
%       in the struct "handles". Many examples with selfexplanatory names and
%       short descriptions can be found below, right before the if statements)


if nargin == 0
    available_peronalizedPlot_option_names = char('Plot-option 1:', ... % Change string containing name for plot option 1
        'Plot-option 2:', ... % Change string 'Plot-option 2:'  to name of plot option 2
        'Plot-option 3:', ... % Change string 'Plot-option 3:'  to name of plot option 3
        'Plot-option 4:', ... % Change string 'Plot-option 4:'  to name of plot option 4
        'Plot-option 5:', ... % Change string 'Plot-option 5:'  to name of plot option 5
        'Plot-option 6:', ... % Change string 'Plot-option 6:'  to name of plot option 6
        'Plot-option 7:', ... % Change string 'Plot-option 7:'  to name of plot option 7
        'Plot-option 8:', ... % Change string 'Plot-option 8:'  to name of plot option 8
        'Plot-option 9:', ... % Change string 'Plot-option 9:'  to name of plot option 9
        'Plot-option 10:' ... % Change string 'Plot-option 10:' to name of plot option 10
        );
    
    updatedHandles = 0;
else
    available_peronalizedPlot_option_names = 0;
    updatedHandles  = handles;
    
    % Create folder named "Personalized plots" (subfolder of folder containing standard plots). Path storen in variable "persFigDir"
    fig_directory = handles.fig_directory;        % Path of folder containing all computed figures (this is a subfolder of the "data_save_directory")
    persFigDir = fullfile(fig_directory, 'Personalized plots');
    A = exist(persFigDir, 'dir');
    if A == 7
    else
        mkdir(persFigDir)
    end
    
    
    

    
    
    
    %% Desctiption and definition of computation related variables
    folder_with_data                = handles.folder_with_data;     % Path of folder containing original input data
    data_save_directory             = handles.data_save_directory;  % Path of folder containing subfolders with all computed and saved files (this is a subfolder of "folder_with_data")
    describe_analysis               = handles.describe_analysis;    % The description of the analysis of the GUI subpanel "Subjects/Trials"
    save_fig                        = handles.save_fig;             % 0 or 1: GUI selection to save figures as ".fig"
    save_jpg                        = handles.save_jpg;             % 0 or 1: GUI selection to save figures as ".jpeg"
    
    subjects_readin                 = handles.subjects_readin;      % Vector containing subjects that were read in
    trials_readin                   = handles.trials_readin;        % Vector containing trials that were read in
    PC_components_to_plot           = handles.PC_components_to_plot;% PC components that are selected to be plotted: Usually 20 if enough PCs available
    nr_PC_components                = handles.nr_PC_components;     % Usually 20, if enough PCs available
    PC_per_figure                   = handles.PC_per_figure;        % Number of PC components that will be plottet in one figure of the scoreplots
    subj_to_plot                    = handles.subj_to_plot;         % Subjects selected to be plottet: All read in subjects if not changed in main-code
    subj_per_figure                 = handles.subj_per_figure;      % Number of subjects in one figure of the scoreplots
    trials_per_figure               = handles.trials_per_figure;    % Number of trials in one figure of the scoreplots
    nr_trials_readin                = handles.nr_trials_readin;     % Number of trials read in
    nr_subj_plot                    = handles.nr_subj_plot;         % Number of subjects selected to be plotted
    nr_figsRelPlot                  = handles.nr_figsRelPlot;       % Number of figures amongst which all subjects of one trial will be distributed for trial specific relative eigenvalue plots
    yLimitsScoreplots               = handles.yLimitsScoreplots;    % Defines type of plot limits: 1-> manual limits, 2. Dynamic (for each component separately), 3. Dynamic (for all components)
    ylim_PPfixed                    = handles.ylim_PPfixed;         % Value of manual PP limit
    ylim_PAfixed                    = handles.ylim_PAfixed;         % Value of manual PA limit (not visible in interface if Dynamic option chosen!!)
    part                            = handles.part;                 % Same interface field as "manual PP limmit". Purpose: For dynamic min/max determination -> devides the dynamic limit
    sample_frequency                = handles.sample_frequency;     % Sample frequency taken from interface input
    cut_off_now                     = handles.cut_off_frequ;        % Selected cut_off_frequency
    
    Data_Readin_TrialSubj           = handles.Data_Readin_TrialSubj;    % The data after preprocessing
    VariablesEigenvalues            = handles.VariablesEigenvalues;     % Eigenvalue variables (PP_rSTD, PP_rVAR, PP_CUM_rVAR, PP_CUM_rSTD)
    VariablesSelfdefined            = handles.VariablesSelfdefined;     % All selfdefined variables (see function "optionsVariablesComp.m" in folder "FunctionsToEdit")
    PP_TrialSubj                    = handles.PP_TrialSubj;             % All PP_k(t) time series
    PV_TrialSubj                    = handles.PV_TrialSubj;             % All PV_k(t) time series
    PA_TrialSubj                    = handles.PA_TrialSubj;             % All PA_k(t) time series
    EV                              = handles.EV;                       % Vector containing Eigenvalues from PCA
    
    PP_rSTD_TrialSubjPC             = VariablesEigenvalues.PP_rSTD_TrialSubjPC;         % Trial specific relative standard deviation (on PP)
    PP_rVAR_TrialSubjPC             = VariablesEigenvalues.PP_rVAR_TrialSubjPC;         % Trial specific relative standard deviation (on PP)
    PP_CUM_rSTD_TrialSubjPC         = VariablesEigenvalues.PP_CUM_rSTD_TrialSubjPC;     % Trial specific cumulative relative standard deviation (on PP)
    PP_CUM_rVAR_TrialSubjPC         = VariablesEigenvalues.PP_CUM_rVAR_TrialSubjPC;     % Trial specific cumulativ relative standard deviation (on PP)

    PV_rSTD_TrialSubjPC             = VariablesEigenvalues.PV_rSTD_TrialSubjPC;         % Trial specific relative standard deviation (on PV)
    PV_rVAR_TrialSubjPC             = VariablesEigenvalues.PV_rVAR_TrialSubjPC;         % Trial specific relative standard deviation (on PV)
    PV_CUM_rSTD_TrialSubjPC         = VariablesEigenvalues.PV_CUM_rSTD_TrialSubjPC;     % Trial specific cumulative relative standard deviation (on PV)
    PV_CUM_rVAR_TrialSubjPC         = VariablesEigenvalues.PV_CUM_rVAR_TrialSubjPC;     % Trial specific cumulativ relative standard deviation (on PV)

    PA_rSTD_TrialSubjPC             = VariablesEigenvalues.PA_rSTD_TrialSubjPC;         % Trial specific relative standard deviation (on PA)
    PA_rVAR_TrialSubjPC             = VariablesEigenvalues.PA_rVAR_TrialSubjPC;         % Trial specific relative standard deviation (on PA)
    PA_CUM_rSTD_TrialSubjPC         = VariablesEigenvalues.PA_CUM_rSTD_TrialSubjPC;     % Trial specific cumulative relative standard deviation (on PA)
    PA_CUM_rVAR_TrialSubjPC         = VariablesEigenvalues.PA_CUM_rVAR_TrialSubjPC;     % Trial specific cumulativ relative standard deviation (on PA)

    PP_variables_TrialSubjPC        = VariablesSelfdefined.PP_variables_TrialSubjPC;    % All self-defined variables computed on the PP
    PV_variables_TrialSubjPC        = VariablesSelfdefined.PV_variables_TrialSubjPC;    % All self-defined variables computed on the PP
    PA_variables_TrialSubjPC        = VariablesSelfdefined.PA_variables_TrialSubjPC;    % All self-defined variables computed on the PP

    
        
    % %     Hint: 
    % %     =====
    % %         1.Access time-series PP, PV, PA: 
    % %                 - PP_TrialSubj{trialNr,subjNr}(timeFrame, pcNr)
    % %                 - PV_TrialSubj{trialNr,subjNr}(timeFrame, pcNr)
    % %                 - PA_TrialSubj{trialNr,subjNr}(timeFrame, pcNr)
    % %     
    % %         2. Access eigenvalue variables: analogously for PV and PA (see function "data_retrieve_PMAnalyzer.m" in folder "CoreFunctions" for computation details)
    % %                 - PP_rSTD_TrialSubjPC(trialNr,subjNr,pcNr)
    % %                 - PP_rVAR_TrialSubjPC(trialNr,subjNr,pcNr)
    % %                 - PP_CUM_rSTD_TrialSubjPC(trialNr,subjNr,pcNr)
    % %                 - PP_CUM_rVAR_TrialSubjPC(trialNr,subjNr,pcNr)
    % %
    % %         3. Access self-defined variables: (see function "optionsVariablesComp.m in folder "FunctionsToEdit" to enable/disable or define variables on PP, PV and PA)
    % %                 - PP_variables_TrialSubjPC(trialPM,subjPM,pcPM).VarName
    % %                 - PV_variables_TrialSubjPC(trialNr,subjNr,pcNr).VarName
    % %                 - PA_variables_TrialSubjPC(trialNr,subjNr,pcNr).VarName


    % % % % Plot template plotting 7 random numbers. (Optional: limit, label, title, legend, save)
    % ==============================================================================================
    % %             NameToSaveFig = 'EmptyTestFig'; % Name under which the figure will be saved
    % %             emptyTestFig = figure;  % Create new figure and store figure handle
    % %             x_vals = 1:7;           % numbers 1 to 7
    % %             y_vals = rand(1,7);     % 7 random numbers
    % %             plot(x_vals, y_vals)    % plot the random numbers
    % %             xlim([0,8])             % set x-limits
    % %             ylim([-.5, 2])          % set y-limits
    % %             xlabel('Timepoints [Random units]')     % Define x-label
    % %             ylabel('Random numbers [Random units]') % Define y-label
    % %             title('Test plot')                      % Define Title
    % %             legend({'Random Curve'})                % Define Curve description for legend
    % %             savefig(emptyTestFig, fullfile(persFigDir, NameToSaveFig)) % Save figure in "persFigDir" (subfolder of folder "figure_directory")

    
%% "If statements" to insert plot options
    if get(handles.chbPlotPersonalized1, 'Value') == 1 % Define plot 1 in this if statement
        % Insert yout personalized plot option 1 here
    end
    
    if get(handles.chbPlotPersonalized2, 'Value') == 1 % Define plot 2 in this if statement
        % Insert yout personalized plot option 2 here
    end
    
    if get(handles.chbPlotPersonalized3, 'Value') == 1 % Define plot 3 in this if statement
        % Insert yout personalized plot option 3 here
    end
    
    if get(handles.chbPlotPersonalized4, 'Value') == 1 % Define plot 4 in this if statement
        % Insert yout personalized plot option 4 here
    end
    
    if get(handles.chbPlotPersonalized5, 'Value') == 1 % Define plot 5 in this if statement
        % Insert yout personalized plot option 5 here
    end
    
    if get(handles.chbPlotPersonalized6, 'Value') == 1 % Define plot 6 in this if statement
        % Insert yout personalized plot option 6 here
    end
    
    if get(handles.chbPlotPersonalized7, 'Value') == 1 % Define plot 7 in this if statement
        % Insert yout personalized plot option 7 here
    end
    
    if get(handles.chbPlotPersonalized8, 'Value') == 1 % Define plot 8 in this if statement
        % Insert yout personalized plot option 8 here
    end
    
    if get(handles.chbPlotPersonalized9, 'Value') == 1 % Define plot 9 in this if statement
        % Insert yout personalized plot option 9 here
    end
    
    if get(handles.chbPlotPersonalized10, 'Value') == 1 % Define plot 10 in this if statement
        % Insert yout personalized plot option 10 here
    end
    
    
end