function [data, weight_inverse, available_weight_option_names] = optionsWeights(varargin)
% =====================
% FUNCTION DESCRIPTION:
% =====================
% The function "optionsWeights.m" contains all PCA weighting options. The
% options are selectable in the "Weights popup menu" in the subpanel
% "Principal Component Analysis" of the PManalyzer interface. To edit
% options follow these two steps:
% 
%
% 1. NAME NEW WEIGHT OPTION:
% ==========================
%       - Insert the name of you weight option by replacing one of the 
%       "#. Weights: EDITABLE" strings of the cell "available_transformation_option_names")
%
%       (HINT: 
%           - Name will appear in weighting popupmenu after restarting interface)
%
%
% 2. CREATE NEW WEIGHT OPTION:
% ============================
%       Implement your weight option in the respective "elseif weight_assignement == #" statement. 
%       number must coincide with the number of edited weight option name.
%
%       (HINT: The result of the weight option must result in a vector called "weight_vector" containing
%       one entry (=weight) for each coordinate (column) of the data. Usually x-y-z
%       of each marker have the same weight.)




if nargin == 0 
    available_weight_option_names = char('1.   Weights: No weights', ...                      
'2.   Weights: Manual weight vector', ...            
'3.   Weights: Standard plug-in (39 markers)', ...   
'4.   Weights: Standard plug-in (37 Markers - no fingers)', ...      
'5.   Weights: Specialized - Tandem (unsymmetric markers deleted and mirrored)', ...                        
'6. Weights: EDITABLE', ...   % EDIT NEW OPTION NAME FOR "weight_assignement == 6"
'7. Weights: EDITABLE', ...   % EDIT NEW OPTION NAME FOR "weight_assignement == 7"
'8. Weights: EDITABLE', ...   % EDIT NEW OPTION NAME FOR "weight_assignement == 8"
'9. Weights: EDITABLE', ...   % EDIT NEW OPTION NAME FOR "weight_assignement == 9"
        '  ', ...
        '	*** Future options ***');
    data = 0;
    weight_inverse = 0;
else
    data = varargin{1};
    available_weight_option_names = 0;



%%  Anthropometry and Mass Distribution for Human Analogues
%                           Volume I: Military Male Aviators
%     small s = 63.3kg (63.4 hier)
%     medium m = 81.5kg (81.4 hier)
%     large l = 97.7kg (97.6 hier)
head_s = 4;         head_m = 4.2;       head_l = 4.4;       % Head
neck_s = 0.9;       neck_m = 1.1;       neck_l = 1.2;       % Neck
thorax_s = 18.6;    thorax_m = 24.9;    thorax_l = 30.5;    % Thorax
abdomen_s = 1.9;    abdomen_m = 2.4;    abdomen_l = 2.9;    % Abdomen
pelvis_s = 8.6;     pelvis_m = 11.8;    pelvis_l = 14.6;    % Pelvis
upperarm_s = 1.5;   upperarm_m = 2.0;   upperarm_l = 2.4;   % Upper Arm
forarm_s = 1.1;     forarm_m = 1.4;     forarm_l = 1.6;     % Forarm
hand_s = 0.5;       hand_m = 0.5;       hand_l = 0.6;       % Hand
tigh_s = 7.7;       tigh_m = 9.8;       tigh_l = 11.8;      % Thigh
calf_s = 3.1;       calf_m = 3.8;       calf_l = 4.5;       % Calf
foot_s = 0.8;       foot_m = 1.0;       foot_l = 1.1;       % Foot

weight_assignement = varargin{2}; %% This line is due to codeupdate
sex_subject = varargin{3};
ctr_weights = varargin{4};
if 0 % enable default "no weights" manually in code
    weight_assignement = 1; %'No weights';
    fprintf('Weights disabled in "weight_options" code. Follow this message to enable')
    msg1 = msgbox('Weights disabled in "weight_options" code. Follow this message to enable')
end

%% Marker setup/distribution. Both if with or without weights_assignment! (nargin==2 and nargin==3)
if  sex_subject == 'f' || sex_subject == 'F'
    x='s';
elseif sex_subject == 'm'  || sex_subject == 'M'
    x='m';
elseif sex_subject == 'l'  || sex_subject == 'L'
    x='l';
else
    x = 'm'; % Medium as default, if not specified
end

%% Calculate marker weights for standard 37 plug in gait according to selected "gender_matrix" in function "readin_PMAnalyzer.m" in directory "CoreFunctions/1. Readin"
% (Default: 'f'or'F'=female-small, 'm'or'M'=male-medium, 'l'or'L'=large)

% Left foot
eval(['    LTOE   = foot_',x,'/3;'                       ]); eval(['    LANK   = foot_',x,'/3     + calf_',x,'/3;'    ]); eval(['    LHEE   = foot_',x,'/3;'                       ]);
eval(['    LTIB   = calf_',x,'/3;'                       ]); eval(['    LKNE   = calf_',x,'/3     + tigh_',x,'/3;'    ]); eval(['    LTHI   = tigh_',x,'/3;'                       ]);
% Right foot
eval(['    RTOE   = foot_',x,'/3;'                       ]); eval(['    RANK   = foot_',x,'/3     + calf_',x,'/3;'    ]); eval(['    RHEE   = foot_',x,'/3;'                       ]); 
eval(['    RTIB   = calf_',x,'/3;'                       ]); eval(['    RKNE   = calf_',x,'/3     + tigh_',x,'/3;'    ]); eval(['    RTHI   = tigh_',x,'/3;'                       ]);
% Thorax
eval(['    RASIS  = tigh_',x,'/3     + pelvis_',x,'/4;'  ]); eval(['    LASIS  = tigh_',x,'/3     + pelvis_',x,'/4;'  ]); eval(['    RPSI   = pelvis_',x,'/4   + abdomen_',x,'/3;' ]);
eval(['    LPSI   = pelvis_',x,'/4   + abdomen_',x,'/3;' ]); eval(['    STRN   = thorax_',x,'/8;'                     ]); eval(['    CLAV   = thorax_',x,'/8   + neck_',x,'/2;'    ]);
eval(['    C7     = thorax_',x,'/8   + neck_',x,'/2;'    ]); eval(['    T10    = abdomen_',x,'/3  + thorax_',x,'/8;'  ]); eval(['    RBAK   = thorax_',x,'/8;'                     ]);
eval(['    RSHO   = thorax_',x,'/8   + upperarm_',x,'/3;']); eval(['    RUPA   = upperarm_',x,'/3;'                   ]);
% Right and left arm
eval(['    RELB   = upperarm_',x,'/3 + forarm_',x,'/3;'  ]); eval(['    RFRA   = forarm_',x,'/3;'                     ]); eval(['    LSHO   = 2*thorax_',x,'/8 + upperarm_',x,'/3;']);
eval(['    LUPA   = upperarm_',x,'/3;'                   ]); eval(['    LELB   = upperarm_',x,'/3 + forarm_',x,'/3;'  ]); eval(['    LFRA   = forarm_',x,'/3;'                     ]);
% Head
eval(['    LFHEAD = head_',x,'/4;'                       ]); eval(['    RFHEAD = head_',x,'/4;'                       ]); eval(['    LBHEAD = head_',x,'/4;'                       ]);
eval(['    RBHEAD = head_',x,'/4;'                       ]);

% The missing Hand (FIN) markers of the standard 37 are changed to standard 39 marker setup
if weight_assignement == 3 % Standard 39 -> distributes weight to fingers from original 37
    eval(['    LWRA   = forarm_',x,'/3/2 + hand_',x,'/8;'    ])
    eval(['    LWRB   = forarm_',x,'/3/2 + hand_',x,'/8;'    ])
    eval(['    LFIN   = hand_',x,'*3/4;'                     ])
    
    eval(['    RWRA   = forarm_',x,'/3/2 + hand_',x,'/8;'    ])
    eval(['    RWRB   = forarm_',x,'/3/2 + hand_',x,'/8;'    ])
    eval(['    RFIN   = hand_',x,'*3/4;'                     ])
else
    eval(['    LWRA   = forarm_',x,'/3/2 + hand_',x,'/2;'    ])
    eval(['    LWRB   = forarm_',x,'/3/2 + hand_',x,'/2;'    ])
    
    eval(['    RWRA   = forarm_',x,'/3/2 + hand_',x,'/2;'    ])
    eval(['    RWRB   = forarm_',x,'/3/2 + hand_',x,'/2;'    ])
end

% Unsymmetric weights are distributed amongst symmetric markers!
if weight_assignement == 5 
    LANK = LANK+LTIB/2;
    LKNE = LKNE+LTIB/2+LTHI/2;
    RANK = RANK+RTIB/2;
    RKNE = RKNE+RTIB/2+RTHI/2;
    RASIS = RASIS+RTHI/2;
    LASIS = LASIS+LTHI/2;
    RSHO = RSHO+RBAK+RUPA/2;
    RELB = RELB+RUPA/2+RFRA/2;
    RWRA = RWRA+RFRA/4;
    RWRB = RWRB+RFRA/4;
    LSHO = LSHO+LUPA/2;
    LELB = LELB+LUPA/2+LFRA/2;
    LWRA = LWRA+LFRA/4;
    LWRB = LWRB+LFRA/4;
else
end







%% Weight options: Editable options can be found after the pre-implemented ones
if weight_assignement == 1 % 'No weights'
    weight_vector = ones(1,size(data,2));%/size(data,2); % no weights assigned
    fprintf('"No weights"')
    
elseif weight_assignement == 2
    weight_vector = [];
    ctr = 0;
    if ctr_weights == 1
        while size(data, 2)~= size(weight_vector, 2)
            ctr = ctr + 1;
            if ctr > 1
                warndlg('Input weights do not match data')
            end
            weight_vector = manualWeightsUI();
            weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);   
        end
        save('tmpManuallyChosenWeightVector', 'weight_vector')
    else
        weight_vector_struct = load('tmpManuallyChosenWeightVector.mat');
        weight_vector = weight_vector_struct.weight_vector;
    end
    
    fprintf('manual weight vector %d', weight_vector)
    
elseif weight_assignement == 3 % 39 Standard plug-in
        weight_vector = [LFHEAD, RFHEAD, LBHEAD, RBHEAD,...
        C7,T10, CLAV, STRN, ...
        RBAK, ...
        LSHO, LUPA, LELB, LFRA, ...
        LWRA, LWRB, LFIN,...
        RSHO, RUPA, RELB, RFRA, ...
        RWRA, RWRB, RFIN, ...
        LASIS, RASIS, LPSI, RPSI, ...
        LTHI, LKNE, LTIB, LANK, LHEE, LTOE, ...
        RTHI, RKNE, RTIB, RANK, RHEE, RTOE, ...
        ];
    % Normalized for medium weight! weight of each is one!
    fprintf('"Standard plug-in 39 marker"')
    weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);
    
elseif weight_assignement == 4 % Standard 37 - No finger markers
    weight_vector = [   LTOE, LANK, LHEE, LTIB, ...
        LKNE, LTHI, RTOE, RANK, ...
        RHEE, RTIB, RKNE, RTHI, ...
        RASIS,LASIS,RPSI, LPSI ...
        STRN, CLAV, C7,   T10, ...
        RBAK, RSHO, RUPA, RELB, ...
        RFRA, RWRA, RWRB, LSHO, ...
        LUPA, LELB, LFRA, LWRA, ...
        LWRB, LFHEAD, RFHEAD, LBHEAD, ...
        RBHEAD,...
        ];
    fprintf('"Standard 37 marker" (no Markers on hands)')
    weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);
    
elseif weight_assignement == 5 %'Tandem 28' = without unsymmetric markers! (Original data: Tandem stance 37)
    weight_vector = [LTOE, LANK, LHEE, ... %3
        LKNE,    RTOE,    RANK, ... %3
        RHEE,  RKNE,   ... %2
        RASIS,  LASIS,   RPSI,  LPSI ...%4
        STRN,  CLAV, C7,  T10, ... %4
        RSHO,   RELB, ... %2
        RWRA,  RWRB,   LSHO,  ...%3
        LELB,  LWRA, ...%2
        LWRB,   LFHEAD,   RFHEAD,   LBHEAD, ... %4
        RBHEAD ...%1
        ];
    fprintf('"Tommyuso" (unsymmetric markers cut out)')
    weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);
    
elseif weight_assignement == 6 % EDIT weights for option number 12
%     ==================================================
%      Example template: one number for each marker (x-y-z coordinates will have same number)
%     ==================================================
%     weight_vector = ones(1,size(data,2)/3);
%     weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);   

%     ==================================================
% 	   Alternative template: one number for each coordinate
%     ==================================================
%     weight_vector = ones(1,size(data,2));

elseif weight_assignement == 7 % EDIT weights for option number 13
%     ==================================================
%      Example template: one number for each marker (x-y-z coordinates will have same number)
%     ==================================================
%     weight_vector = ones(1,size(data,2)/3);
%     weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);   

%     ==================================================
% 	   Alternative template: one number for each coordinate
%     ==================================================
%     weight_vector = ones(1,size(data,2));

elseif weight_assignement == 8 % EDIT weights for option number 14
%     ==================================================
%      Example template: one number for each marker (x-y-z coordinates will have same number)
%     ==================================================
%     weight_vector = ones(1,size(data,2)/3);
%     weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);   

%     ==================================================
% 	   Alternative template: one number for each coordinate
%     ==================================================
%     weight_vector = ones(1,size(data,2));

elseif weight_assignement == 9 % EDIT weights for option number 15
%     ==================================================
%      Example template: one number for each marker (x-y-z coordinates will have same number)
%     ==================================================
%     weight_vector = ones(1,size(data,2)/3);
%     weight_vector = reshape([weight_vector; weight_vector; weight_vector], 1, []);   

%     ==================================================
% 	   Alternative template: one number for each coordinate
%     ==================================================
%     weight_vector = ones(1,size(data,2));
else 
    msgbox('Please check weights! Something wrong!', 'Error', 'error')
    error('Error in weight_options. Selection  "weight_assignement" does not match!')
end


if length(weight_vector)~= size(data,2)
    msgbox(sprintf('Please check weights! Length of weight_vector = %d. Nr. columns = %d', length(weight_vector), size(data,2)), 'Error', 'error')
    error('Error in weight_options. Selection  "weight_assignement" does not match!')
end


weight_matrix = diag(weight_vector); % Creates a diagonal matrix using the chosen weight vector! (This way each column will be multiplied by the respective weight chosen! Matrix multiplication)
weight_inverse = diag(weight_vector.^(-1)); % Computes the inverse weight_matrix for later video-computation (This matrix is also saved throughout the code)


data = data*weight_matrix; % Matrix multiplication: Data is weighted according to selected weight_vector (1.VectorEntry * 1.DataColumn, 2.VectorEntry * 2.DataColumn, etc.)
% fprintf('\n')

end
end


