function [DT, available_transformation_option_names] = optionsTransformData(Data, TransformOption, FrontBack)
% =====================
% FUNCTION DESCRIPTION:
% =====================
% The function "optionsTransformData.m" contains the definition of all 
% available coordinate transformations. To implement new transformations
% follow these two steps:
% 
%
% 1. Name coordinate transformation:
% ==================================
%       - Specify the transformation following the examples. (Names contained 
%           in cell "available_transformation_option_names")
% 
%       (HINT: 
%           - See function template at end of function.
%           - Name will appear in coordinate transformation popupmenu after restarting interface)
% 
% 
% 2. Create transformation (and back transformation - for video option!):
% =======================================================================
%       - Four templates are pre-implemented, reachable under
%         TansformOptions == 4, 5, 6 or 7.
%       - In the "if FrontBack == 1" statement the handle to the 
%         transformation must be specified. 
%                 -> One function must be created for the transformation
%       - In the "if FrontBack == 2" statement
%         the handle to a transformation must be specified.
%                 -> Another function must be created to transform back
% 
%       (HINT: The function must transform 3 coordinates to other 3 coordinates. 
%       See line 128)
% 
% 
% Available Options: 
% Carthesian to Polar or Spherical coordinates
%
% Ideas:
% Thorus, Mixture, log, log-polar, bipolar, cesaro, 2 centerbipolar, arc-length,
% curvature and torsion, elliptic, geografic, kernel methods (gaussian kernel, regular kernels, etc.)


if nargin == 0
    available_transformation_option_names = char('1.   Coordinate transformation: none', ...
        '2.   Coordinate transformation: Cartesian -> Spherical (3D)', ...
        '3.   Coordinate transformation: Cartesian -> Zylindrical (3D)', ...
        '4.   Coordinate transformation: "to edit"', ... % Specify transformation Nr. 4 (will appear in transformation popupmenu)
        '5.   Coordinate transformation: "to edit"', ... % Specify transformation Nr. 4 (will appear in transformation popupmenu)
        '6.   Coordinate transformation: "to edit"', ... % Specify transformation Nr. 4 (will appear in transformation popupmenu)
        '7.   Coordinate transformation: "to edit"', ... % Specify transformation Nr. 4 (will appear in transformation popupmenu)
        '  ', ...
        '	*** Future options ***');
    DT = 0;
    
else
    available_transformation_option_names = 0;
    
    
    
    %% Specify function to transform coordinate system with
    UsedFunction = 0; % initialize
    if TransformOption == 1 % No transformation
         if FrontBack == 1
            PrintText = '\nData was not transformed!';
         elseif FrontBack == 2
            PrintText = '\nData was not transformed!';
         end
    elseif TransformOption == 2 % Cartesian->Spherical->Cartesian
        if FrontBack == 1
            UsedFunction = @cart2sph;
            PrintText = '\nData was transformed with function: "cart2sph" (cartesian to spherical coordinates)!';
        elseif FrontBack == 2
            UsedFunction = @sph2cart;
            PrintText = '\nData was transformed to Cartesian coordinates for movies with function: "sph2cart" (spherical to cartesian coordinates)!';
        end
    elseif TransformOption == 3 % Carthesian->Cylindrical->Carthesian
        if FrontBack == 1
            UsedFunction = @cart2pol;
            PrintText = '\nData was transformed with function: "cart2pol" (Cartesian to cylindrical coordinates)!';
        elseif FrontBack == 2
            UsedFunction = @pol2cart;
            PrintText = '\nData was transformed to Cartesian coordinates for movies with function: "pol2cart" (cylindrical to Cartesian coordinates)!';
        end
%     elseif TransformOption == 4 % Enable by removing the "%" or by selecting code and pressing Ctrl+T
%         if FrontBack == 1
%            UsedFunction = @addFunTransform;
%            PrintText = '\nData was transformed with function: "addFunTransform" (... to ... coordinates)!';
%         elseif FrontBack == 2
%            UsedFunction = @addFunTransToCart; % movies need cartesian!
%            PrintText = '\nData was transformed to Cartesian coordinates for movies with function: "addFunTransToCart" (... to Cartesian coordinates)!';
%         end % enable until here
%     elseif TransformOption == 5 % Enable by removing the "%" or by Ctrl+T
%         if FrontBack == 1
%            UsedFunction = @addFunTransform;
%            PrintText = '\nData was transformed with function: "addFunTransform" (... to ... coordinates)!';
%         elseif FrontBack == 2
%            UsedFunction = @addFunTransToCart; % movies need cartesian!
%            PrintText = '\nData was transformed to Cartesian coordinates for movies with function: "addFunTransToCart" (... to Cartesian coordinates)!';
%         end % enable until here
%     elseif TransformOption == 6 % Enable by removing the "%" or by Ctrl+T
%         if FrontBack == 1
%            UsedFunction = @addFunTransform;
%            PrintText = '\nData was transformed with function: "addFunTransform" (... to ... coordinates)!';
%         elseif FrontBack == 2
%            UsedFunction = @addFunTransToCart;% movies need cartesian!
%            PrintText = '\nData was transformed to Cartesian coordinates for movies with function: "addFunTransToCart" (... to Cartesian coordinates)!';
%         end % enable until here
%     elseif TransformOption == 7 % Enable by removing the "%" or by Ctrl+T
%         if FrontBack == 1
%            UsedFunction = @addFunTransform;
%            PrintText = '\nData was transformed with function: "addFunTransform" (... to ... coordinates)!';
%         elseif FrontBack == 2
%            UsedFunction = @addFunTransToCart;% movies need cartesian!
%            PrintText = '\nData was transformed to Cartesian coordinates for movies with function: "addFunTransToCart" (... to Cartesian coordinates)!';
%         end % enable until here
    else
        fprintf('This coordinate Transformation has not been implemented yet!')
    end
    
    
    % The actual transformation with function specified above
    NrRows = size(Data, 1);
    NrCols = size(Data, 2);
    DT = zeros(NrRows, NrCols);
    if isa(UsedFunction, 'function_handle')
        for time = 1:NrRows
            for marker =3:3:NrCols
                [DT(time,marker-2), DT(time, marker-1), DT(time,marker-0)] = UsedFunction(Data(time,marker-2),Data(time,marker-1), Data(time,marker-0));
            end
        end
    else
        DT = Data;
    end
    fprintf(PrintText)
end


%% These example functions can be copied and used
% %     function [xNewCoord, yNewCoord, zNewCoord] = addFunTransform(xOldCoord, yOldCoord, zOldCoord)
% %           % include Coordinate transformation here
% %     end
% %     function [xCart, yCart, zCart] = addFunTransToCart(xNewCoord, yNewCoord, zNewCoord)
% %           % include transformation to Carthesian Coordinates here
% %     end

end
